/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.model.invoice.InvoiceVO;
import org.apache.commons.lang3.StringUtils;

public class PubReimburseBeforeImportInvoiceServiceImpl
extends BeforeImportInvoiceService {
    public PubReimburseBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext) {
        super(invoiceContext);
    }

    public PubReimburseBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext, IFormView view) {
        this(invoiceContext);
        this.view = view;
    }

    @Override
    public void process() {
        IDataModel model;
        if (StringUtils.equals((CharSequence)"er_publicreimbursebill", (CharSequence)this.view.getEntityId()) && !((Boolean)(model = this.view.getModel()).getValue("isredoffset")).booleanValue()) {
            this.BeforeMatchSupplier(this.invoiceContext.getInvoiceVOs());
        }
    }

    private void BeforeMatchSupplier(List<InvoiceVO> invoiceVOs) {
        IDataModel model = this.view.getModel();
        Long company = ErCommonUtils.getPk(this.view.getModel().getValue("company"));
        Boolean isFilterSup = SystemParamterUtil.getIsPublicUpFilterBySupplier(company);
        if (model.getProperty("detailtype") == null) {
            return;
        }
        if (isFilterSup.booleanValue() && !"biztype_other".equals(model.getValue("detailtype"))) {
            return;
        }
        if (!StringUtils.equals((CharSequence)"bd_supplier", (CharSequence)model.getValue("billpayertype").toString())) {
            return;
        }
        HashSet<String> insertCompnames = new HashSet<String>();
        for (InvoiceVO invoiceVO : invoiceVOs) {
            if (invoiceVO.getSalerName() == null) continue;
            insertCompnames.add(invoiceVO.getSalerName());
        }
        if (insertCompnames.size() != 1) {
            return;
        }
        String insertCompname = (String)insertCompnames.iterator().next();
        DynamicObject supplier = PublicBillUtil.getSupplier(model, insertCompname);
        if (supplier == null) {
            return;
        }
        DynamicObject billpayerid = (DynamicObject)model.getValue("billpayerid");
        if (billpayerid == null) {
            model.setValue("billpayerid", supplier.get("id"));
            return;
        }
        if (this.view instanceof IMobileView) {
            return;
        }
        String billpayerName = billpayerid.getLocaleString("name").toString();
        if (StringUtils.equals((CharSequence)billpayerName, (CharSequence)insertCompname)) {
            return;
        }
        this.view.getPageCache().put("insertcompnameid", supplier.get("id").toString());
    }
}

