/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateEntryService;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;

public class CreateExpensePoolByItemEntryServiceImpl
extends CreateEntryService {
    private IDataModel model;

    public CreateExpensePoolByItemEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.model = dataModel;
    }

    @Override
    public void process() {
        List<ExpenseEntryBO> expenseEntryBOs = this.invoiceContext.getExpenseEntryBOs();
        if (expenseEntryBOs.size() < 1) {
            return;
        }
        ExpenseEntryBO newExpItem = expenseEntryBOs.get(0);
        Map<String, Object> itemMap = this.genItemMap();
        ExpenseEntryBO oldExpItem = this.changeItemVOToBO(itemMap);
        this.excuteMerge(newExpItem, oldExpItem);
    }

    @Override
    protected void createExpenseItemEntry(ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
    }

    protected Map<String, Object> genItemMap() {
        DynamicObjectCollection collection = this.model.getEntryEntity("invoiceentry");
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        if (!collection.isEmpty()) {
            itemMap.put("expenseitemedit", this.model.getValue("expenseitemedit"));
            itemMap.put("expenseamount", this.model.getValue("expenseamount"));
            itemMap.put("taxrate", this.model.getValue("taxrate"));
            itemMap.put("taxamount", this.model.getValue("taxamount"));
            itemMap.put("orientryamount", this.model.getValue("orientryamount"));
            itemMap.put("happendate", this.model.getValue("happendate"));
            return itemMap;
        }
        return itemMap;
    }

    private ExpenseEntryBO changeItemVOToBO(Map<String, Object> oldItem) {
        if (!oldItem.isEmpty()) {
            ExpenseEntryBO expenseEntry = new ExpenseEntryBO();
            if (oldItem.get("happendate") != null) {
                expenseEntry.setHappenDate((Date)oldItem.get("happendate"));
            } else {
                expenseEntry.setHappenDate(new Date());
            }
            if (oldItem.get("expenseamount") != null) {
                expenseEntry.setTotalAmount(new BigDecimal(this.model.getValue("expenseamount").toString()));
            }
            if (oldItem.get("expenseitemedit") != null) {
                DynamicObject expenseitemedit = (DynamicObject)oldItem.get("expenseitemedit");
                expenseEntry.setExpenseItemId((Long)expenseitemedit.getPkValue());
            }
            expenseEntry.setTaxRate(new BigDecimal(this.model.getValue("taxrate").toString()).divide(BigDecimal.valueOf(100L)));
            expenseEntry.setTaxAmount(new BigDecimal(this.model.getValue("taxamount").toString()));
            return expenseEntry;
        }
        return null;
    }

    private void excuteMerge(ExpenseEntryBO newExpItem, ExpenseEntryBO oldExpItem) {
        if (oldExpItem != null) {
            BigDecimal oldTotalAmount;
            BigDecimal newTaxAmount;
            BigDecimal newTaxRate;
            BigDecimal oldTaxRate = oldExpItem.getTaxRate();
            if (oldTaxRate != null && (newTaxRate = newExpItem.getTaxRate()) != null && newTaxRate.compareTo(oldTaxRate) != 0) {
                newExpItem.setTaxRate(BigDecimal.ZERO);
            }
            BigDecimal oldTaxAmount = oldExpItem.getTaxAmount();
            BigDecimal newTaxRate2 = newExpItem.getTaxRate();
            if (oldTaxAmount != null && (newTaxAmount = newExpItem.getTaxAmount()) != null) {
                if (newTaxRate2.compareTo(BigDecimal.ZERO) == 0) {
                    newExpItem.setTaxAmount(BigDecimal.ZERO);
                } else {
                    newExpItem.setTaxAmount(newTaxAmount.add(oldTaxAmount));
                }
            }
            if ((oldTotalAmount = oldExpItem.getTotalAmount()) != null) {
                BigDecimal newTotalAmount = newExpItem.getTotalAmount();
                if (newTotalAmount != null) {
                    newExpItem.setTotalAmount(newTotalAmount.add(oldTotalAmount));
                } else {
                    newExpItem.setTotalAmount(oldTotalAmount);
                }
            }
            newExpItem.setNotIncludeTaxAmount(newExpItem.getTotalAmount().subtract(newExpItem.getTaxAmount()));
            Date oldDate = oldExpItem.getHappenDate();
            if (oldDate != null) {
                newExpItem.setHappenDate(oldExpItem.getHappenDate());
            }
            newExpItem.setExpenseItemId(oldExpItem.getExpenseItemId());
        }
    }
}

