/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.provider.service.IAfterCreateExpenseItemEntryService;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateEntryService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.servicehelper.AdminDivisionServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import kd.fi.er.formplugin.web.tripstandard.util.PlaneSeatUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CreateExpensePoolItemEntryServiceImpl
extends CreateEntryService {
    private static final Log log = LogFactory.getLog(CreateExpensePoolItemEntryServiceImpl.class);
    private IDataModel dataModel;

    public CreateExpensePoolItemEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel, boolean isOegOffset) {
        super(invoiceContext);
        this.dataModel = dataModel;
        this.isOrgOffset = isOegOffset;
    }

    @Override
    public void process() {
        List<ExpenseEntryBO> expenseEntryBOs = this.invoiceContext.getExpenseEntryBOs();
        if (expenseEntryBOs.size() <= 0) {
            log.info("\u672a\u5bfc\u5165\u4efb\u4f55\u6709\u6548\u53d1\u7968");
            return;
        }
        MappingItemWithOrgInvoiceServiceImp mappingExpenseOrExpenseItemInvoiceService = new MappingItemWithOrgInvoiceServiceImp(this.invoiceContext, MappingItemWithOrgInvoiceServiceImp.BillType.TripItem, this.dataModel.getDataEntity(true));
        mappingExpenseOrExpenseItemInvoiceService.process();
        List<ExpenseEntryBO> expenseTripEntryBO = this.invoiceContext.getExpenseEntryBOs();
        List expenseEntryTripExcludeZeroBOs = expenseTripEntryBO.stream().filter(entry -> entry.getTotalAmount().abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0).collect(Collectors.toList());
        expenseEntryTripExcludeZeroBOs.sort((entry1, entry2) -> ((Date)ObjectUtils.defaultIfNull((Object)entry1.getHappenDate(), (Object)ErCommonUtils.getDateFromLocalDate(LocalDate.now()))).compareTo(entry2.getHappenDate()));
        DynamicObject expenseItemDO = (DynamicObject)this.dataModel.getValue("expenseitem");
        if (expenseItemDO == null) {
            for (ExpenseEntryBO expenseEntryBO : expenseEntryTripExcludeZeroBOs) {
                List invoiceItemEntryVOs = expenseEntryBO.getInvoiceItemEntryVOs();
                for (InvoiceItemEntryBO tripItem : invoiceItemEntryVOs) {
                    this.dataModel.setValue("expenseitem", (Object)tripItem.getExpenseItemId());
                }
            }
        }
        List expenseEntryExcludeZeroBOs = expenseEntryBOs.stream().filter(entry -> entry.getTotalAmount().abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0).collect(Collectors.toList());
        expenseEntryExcludeZeroBOs.sort((entry1, entry2) -> ((Date)ObjectUtils.defaultIfNull((Object)entry1.getHappenDate(), (Object)ErCommonUtils.getDateFromLocalDate(LocalDate.now()))).compareTo(entry2.getHappenDate()));
        for (ExpenseEntryBO expenseEntryBO : expenseEntryExcludeZeroBOs) {
            List<DynamicObject> wayToCities;
            this.dataModel.setValue("startdate", (Object)expenseEntryBO.getStartDate());
            List<DynamicObject> startCityDOs = AdminDivisionServiceHelper.getCityByName(expenseEntryBO.getStartCity());
            List<DynamicObject> endCityDOs = AdminDivisionServiceHelper.getCityByName(expenseEntryBO.getEndCity());
            if (startCityDOs.size() == 1) {
                this.dataModel.setValue("tripfrom", startCityDOs.get(0).getPkValue());
            }
            if (endCityDOs.size() == 1) {
                this.dataModel.setValue("tripto", endCityDOs.get(0).getPkValue());
                this.dataModel.setValue("tripcityfield", endCityDOs.get(0).getPkValue());
            }
            if (!(wayToCities = AdminDivisionServiceHelper.getCityByNames(expenseEntryBO.getWayToCities())).isEmpty()) {
                DynamicObjectCollection wayToCityDOs = new DynamicObjectCollection();
                wayToCities.forEach(c -> wayToCityDOs.add(c));
                this.dataModel.setValue("trip2mulwayto", (Object)wayToCityDOs);
            }
            this.genSeatGrade(expenseEntryBO);
            this.dataModel.setValue("trippassenger", (Object)expenseEntryBO.getPassengers());
            this.dataModel.setValue("airportconstructionfee", (Object)expenseEntryBO.getAirportConstructionFee());
            this.dataModel.setValue("currency", (Object)expenseEntryBO.getEntryCurrencyId());
            this.dataModel.setValue("expenseamount", (Object)expenseEntryBO.getTotalAmount());
            this.dataModel.setValue("taxrate", (Object)expenseEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)));
            this.dataModel.setValue("taxamount", (Object)expenseEntryBO.getTaxAmount());
            this.dataModel.setValue("orientryamount", (Object)expenseEntryBO.getNotIncludeTaxAmount());
            this.dataModel.setValue("happendate", (Object)expenseEntryBO.getHappenDate());
            this.dataModel.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedLenStr(expenseEntryBO.getInvoiceNoUnion(), 129));
            this.dataModel.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode(expenseEntryBO.getInvoiceCodeUnion()));
            this.dataModel.setValue("expensegoodsname", (Object)expenseEntryBO.getGoodName());
            this.dataModel.setValue("taxclasscode", (Object)expenseEntryBO.getTaxClassCodeId());
            DynamicObject expenseItemeditDO = (DynamicObject)this.dataModel.getValue("expenseitemedit");
            if (expenseItemeditDO == null) {
                this.dataModel.setValue("expenseitemedit", (Object)expenseEntryBO.getExpenseItemId());
            }
            int invoiceCount = (Integer)this.dataModel.getValue("invoicetotalcount");
            this.dataModel.setValue("invoicetotalcount", (Object)(invoiceCount + this.invoiceContext.getInvoiceEntryBOs().size()));
            try {
                IAfterCreateExpenseItemEntryService afterCreateExpenseItemEntryService = InvoiceServiceFactory.getSingletonService(IAfterCreateExpenseItemEntryService.class);
                if (afterCreateExpenseItemEntryService != null) {
                    afterCreateExpenseItemEntryService.afterCreateExpenseItemEntryForExpensePool(this.dataModel, expenseEntryBO);
                }
            }
            catch (Exception e) {
                log.error("third service fiald:", (Throwable)e);
            }
            if (!this.isOrgOffset) {
                this.dataModel.setValue("taxrate", (Object)BigDecimal.ZERO);
                this.dataModel.setValue("taxamount", (Object)BigDecimal.ZERO);
                continue;
            }
            this.dataModel.setValue("taxrate", (Object)expenseEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)));
            this.dataModel.setValue("taxamount", (Object)expenseEntryBO.getTaxAmount());
        }
    }

    private void genSeatGrade(ExpenseEntryBO expenseEntryBO) {
        DynamicObject expenseItemDO = (DynamicObject)this.dataModel.getValue("expenseitem");
        if (expenseItemDO == null) {
            return;
        }
        String attribute = expenseItemDO.getString("attribute");
        Set seatGrade = null;
        Map seatGradeBO = expenseEntryBO.getSeatGrades();
        if (seatGradeBO == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)attribute, (CharSequence)"2")) {
            seatGrade = (Set)seatGradeBO.get("2");
        } else if (StringUtils.equals((CharSequence)attribute, (CharSequence)"4")) {
            seatGrade = (Set)seatGradeBO.get("4");
        } else if (StringUtils.equals((CharSequence)attribute, (CharSequence)"7")) {
            seatGrade = (Set)seatGradeBO.get("7");
        }
        if (seatGrade != null) {
            DynamicObject[] seatGradeArr = PlaneSeatUtil.findSeatByAttribute(attribute, seatGrade);
            if (seatGradeArr != null && seatGradeArr.length > 0) {
                Object[] seats = Arrays.stream(seatGradeArr).map(seat -> seat.getPkValue()).toArray();
                this.dataModel.setValue("tripmulseatgrade", (Object)seats);
            } else {
                this.dataModel.setValue("tripmulseatgrade", null);
            }
        }
    }
}

