/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateEntryService;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.servicehelper.AdminDivisionServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.UserServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.common.constant.StdConfigConstant;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.formplugin.web.tripstandard.util.PlaneSeatUtil;
import org.apache.commons.lang3.StringUtils;

public class CreateTripItemEntryServiceImpl
extends CreateEntryService {
    private static final Log log = LogFactory.getLog(CreateTripItemEntryServiceImpl.class);

    public CreateTripItemEntryServiceImpl(InvoiceContext invoiceContext) {
        super(invoiceContext);
        this.dataModel = invoiceContext.getView().getModel();
        this.isOrgOffset = invoiceContext.getInvoiceConfig().isOrgOffset();
    }

    public CreateTripItemEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
        this.isOrgOffset = invoiceContext.getInvoiceConfig().isOrgOffset();
    }

    public CreateTripItemEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel, boolean isOrgOffset) {
        this(invoiceContext, dataModel);
        this.isOrgOffset = isOrgOffset;
    }

    @Override
    public void process() {
        int i;
        int tripEntryCount = this.dataModel.getEntryRowCount("tripentry");
        if (tripEntryCount < 1) {
            log.info("\u5dee\u65c5\u62a5\u9500\u5355\u7684\u884c\u7a0b\u5206\u5f55\u6570\u91cf\u4e3a0, \u4e0d\u80fd\u5bfc\u53d1\u7968");
            return;
        }
        int tripRowIndex = this.dataModel.getEntryCurrentRowIndex("tripentry");
        log.info("\u5bfc\u5165\u53d1\u7968CreateTripItemEntryServiceImpl \u5f53\u524d\u884c\u7a0b\u884c\uff1a" + tripRowIndex);
        DynamicObject tripEntryDO = (DynamicObject)this.dataModel.getEntryEntity("tripentry").get(tripRowIndex);
        List<Object> expenseEntryBOs = this.invoiceContext.getExpenseEntryBOs();
        String zeroCreate = ErStdConfig.getInvoiceZeroAmountCreateItem();
        if (StringUtils.equals((CharSequence)zeroCreate, (CharSequence)"0")) {
            expenseEntryBOs = expenseEntryBOs.stream().filter(entry -> entry.getTotalAmount().abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0).collect(Collectors.toList());
        }
        if (expenseEntryBOs.size() <= 0) {
            log.info("\u672a\u5bfc\u5165\u4efb\u4f55\u6709\u6548\u53d1\u7968");
            return;
        }
        this.setEntryIdInFirst(expenseEntryBOs);
        DynamicObjectCollection tripItemEntry = tripEntryDO.getDynamicObjectCollection("entryentity");
        HashMap rowIndexByEntryId = Maps.newHashMapWithExpectedSize((int)tripItemEntry.size());
        for (i = 0; i < tripItemEntry.size(); ++i) {
            rowIndexByEntryId.put(((DynamicObject)tripItemEntry.get(i)).getLong("id"), i);
        }
        for (i = 0; i < expenseEntryBOs.size(); ++i) {
            int curTripItemRowIndex = rowIndexByEntryId.containsKey(((ExpenseEntryBO)expenseEntryBOs.get(i)).getEntryId()) ? ((Integer)rowIndexByEntryId.get(((ExpenseEntryBO)expenseEntryBOs.get(i)).getEntryId())).intValue() : this.dataModel.createNewEntryRow("entryentity");
            this.genExpenseItemEntry(this.invoiceContext, (ExpenseEntryBO)expenseEntryBOs.get(i), curTripItemRowIndex, tripRowIndex);
        }
    }

    @Override
    protected void createExpenseItemEntry(ExpenseEntryBO expenseEntryBO, int tripItemRowIndex, int tripIndex) {
        log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011CreateTripItemEntryServiceImpl \u5dee\u65c5\u660e\u7ec6\u4fe1\u606f: " + expenseEntryBO + "\uff0c \u884c\u7a0b\uff1a" + tripIndex + ", \u660e\u7ec6\uff1a" + tripItemRowIndex);
        String itemFrom = expenseEntryBO.getItemFrom();
        if (ItemFrom.TripBusiness.equalsFrom(itemFrom)) {
            this.createTripBusinessExpense(expenseEntryBO, tripItemRowIndex, tripIndex);
        } else {
            this.createNormalExpense(expenseEntryBO, tripItemRowIndex, tripIndex);
        }
    }

    private void createTripBusinessExpense(ExpenseEntryBO expenseEntryBO, int tripItemRowIndex, int tripIndex) {
        DynamicObject tripEntryDO = (DynamicObject)this.dataModel.getEntryEntity("tripentry").get(tripIndex);
        DynamicObject tripItemEntryDO = (DynamicObject)tripEntryDO.getDynamicObjectCollection("entryentity").get(tripItemRowIndex);
        tripItemEntryDO.set("id", (Object)expenseEntryBO.getEntryId());
        this.dataModel.setValue("itemfrom", (Object)ItemFrom.TripBusiness.getValue(), tripItemRowIndex, tripIndex);
        this.dataModel.setValue("invoicelink", (Object)StringUtils.abbreviate((String)expenseEntryBO.getInvoiceCodeUnion(), (int)129), tripItemRowIndex, tripIndex);
        this.dataModel.setValue("invoiceno_entry", (Object)StringUtils.abbreviate((String)expenseEntryBO.getInvoiceNoUnion(), (int)129), tripItemRowIndex, tripIndex);
    }

    private void createNormalExpense(ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
        DynamicObject selectExpenseitem;
        DynamicObject tripEntryDO = (DynamicObject)this.dataModel.getEntryEntity("tripentry").get(parentIndex);
        DynamicObject tripItemEntryDO = (DynamicObject)tripEntryDO.getDynamicObjectCollection("entryentity").get(rowIndex);
        tripItemEntryDO.set("id", (Object)expenseEntryBO.getEntryId());
        this.setValueIfExist("itemfrom", ItemFrom.InvoiceCloud.getValue(), rowIndex, parentIndex);
        IDataEntityProperty invoiceTypeProp = this.dataModel.getProperty("invoicetypeitem");
        if (invoiceTypeProp instanceof ComboProp) {
            this.setValueIfExist("invoicetypeitem", expenseEntryBO.getInvoiceType(), rowIndex, parentIndex);
        } else {
            this.setValueIfExist("invoicetypeitem", expenseEntryBO.getInvoiceTypeId(), rowIndex, parentIndex);
        }
        this.setValueIfExist("expenseitem", expenseEntryBO.getExpenseItemId(), rowIndex, parentIndex);
        if (this.dataModel.getProperty("entrycurrency") != null) {
            boolean isCurrencyShowInTripEntry = SystemParamterUtil.getIsCurrencyShowinTripentry(ErCommonUtils.getPk(this.dataModel.getValue("company")));
            if (isCurrencyShowInTripEntry) {
                this.dataModel.setValue("tripcurrency", (Object)expenseEntryBO.getEntryCurrencyId(), parentIndex);
            }
            if (this.dataModel.getProperty("currency") != null) {
                DynamicObject currency = (DynamicObject)this.dataModel.getValue("currency");
                this.dataModel.beginInit();
                this.setValueIfExist("entrycurrency", currency, rowIndex, parentIndex);
                this.dataModel.endInit();
            }
            this.setValueIfExist("entrycurrency", expenseEntryBO.getEntryCurrencyId(), rowIndex, parentIndex);
        }
        this.dataModel.beginInit();
        this.setValueIfExist("offset", expenseEntryBO.getIsOffset() == false, rowIndex, parentIndex);
        this.dataModel.endInit();
        this.setValueIfExist("offset", expenseEntryBO.getIsOffset(), rowIndex, parentIndex);
        if (expenseEntryBO.getExpenseItemId() != null && !expenseEntryBO.getExpenseItemId().equals(0L) && (selectExpenseitem = CommonServiceHelper.getObjById("er_tripexpenseitem", expenseEntryBO.getExpenseItemId())) != null) {
            this.setValueIfExist("pic", selectExpenseitem.getString("expenseitemicon"), rowIndex, parentIndex);
        }
        this.setValueIfExist("orientryamount", expenseEntryBO.getTotalAmount(), rowIndex, parentIndex);
        this.setValueIfExist("airportconstructionfee", expenseEntryBO.getAirportConstructionFee(), rowIndex, parentIndex);
        if (this.isOrgOffset) {
            this.setValueIfExist("taxrate", expenseEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)), rowIndex, parentIndex);
            this.setValueIfExist("taxamount", expenseEntryBO.getTaxAmount(), rowIndex, parentIndex);
            this.setValueIfExist("notaxamount", expenseEntryBO.getNotIncludeTaxAmount(), rowIndex, parentIndex);
            this.setValueIfExist("deductibletax", expenseEntryBO.getOffsetAmount(), rowIndex, parentIndex);
            this.setValueIfExist("iteminoutamount", expenseEntryBO.getItemInOutAmount(), rowIndex, parentIndex);
        } else {
            this.setValueIfExist("taxrate", BigDecimal.ZERO, rowIndex, parentIndex);
            this.setValueIfExist("taxamount", BigDecimal.ZERO, rowIndex, parentIndex);
            this.setValueIfExist("notaxamount", expenseEntryBO.getTotalAmount(), rowIndex, parentIndex);
            this.setValueIfExist("deductibletax", BigDecimal.ZERO, rowIndex, parentIndex);
            this.setValueIfExist("iteminoutamount", BigDecimal.ZERO, rowIndex, parentIndex);
        }
        String billKind = (String)this.dataModel.getValue("billkind");
        if (StringUtils.equals((CharSequence)billKind, (CharSequence)"1")) {
            List<DynamicObject> wayToCities;
            String destCity;
            List<DynamicObject> endCityDOs;
            String startCity;
            List<DynamicObject> startCityDOs;
            Set<String> vehicleInvoiceTypes = InvoiceTypeUtils.loadVehicleInvoiceTypes();
            List invoiceItemEntryVOs = expenseEntryBO.getInvoiceItemEntryVOs();
            List invoiceEntryBOs = invoiceItemEntryVOs.stream().map(invoiceItem -> invoiceItem.getInvoiceEntryBO()).collect(Collectors.toList());
            List vehicleInvoice = invoiceEntryBOs.stream().filter(invoice -> vehicleInvoiceTypes.contains(invoice.getInvoiceType())).collect(Collectors.toList());
            Optional<InvoiceEntryBO> minDateInvoiceBo = vehicleInvoice.stream().min(Comparator.comparing(InvoiceEntryBO::getCarrierDate));
            Optional<InvoiceEntryBO> maxDateInvoiceBo = vehicleInvoice.stream().max(Comparator.comparing(InvoiceEntryBO::getCarrierDate));
            InvoiceEntryBO minDateInvoice = null;
            if (minDateInvoiceBo.isPresent()) {
                minDateInvoice = minDateInvoiceBo.get();
            }
            InvoiceEntryBO maxDateInvoice = null;
            if (maxDateInvoiceBo.isPresent()) {
                maxDateInvoice = maxDateInvoiceBo.get();
            }
            if (Objects.equals(this.invoiceContext.getInvoiceConfig().getExpenseDateValue(), StdConfigConstant.EXPENSE_DATE_VALUE_INVOICE)) {
                if (this.getValueIfExist("trip2startdate", rowIndex, parentIndex) == null && minDateInvoice != null) {
                    this.setValueIfExist("trip2startdate", minDateInvoice.getCarrierDate(), rowIndex, parentIndex);
                }
                if (this.getValueIfExist("trip2enddate", rowIndex, parentIndex) == null && maxDateInvoice != null) {
                    this.setValueIfExist("trip2enddate", maxDateInvoice.getCarrierDate(), rowIndex, parentIndex);
                }
            }
            if (this.getValueIfExist("trip2from", rowIndex, parentIndex) == null && minDateInvoice != null && (startCityDOs = AdminDivisionServiceHelper.getCityByName(startCity = this.subStringCity(minDateInvoice.getStartCity()))).size() == 1) {
                this.setValueIfExist("trip2from", startCityDOs.get(0).getPkValue(), rowIndex, parentIndex);
            }
            if (this.getValueIfExist("trip2to", rowIndex, parentIndex) == null && maxDateInvoice != null && (endCityDOs = AdminDivisionServiceHelper.getCityByName(destCity = this.subStringCity(maxDateInvoice.getDestCity()))).size() == 1) {
                this.setValueIfExist("trip2to", endCityDOs.get(0).getPkValue(), rowIndex, parentIndex);
            }
            if (!(wayToCities = AdminDivisionServiceHelper.getCityByNames(expenseEntryBO.getWayToCities())).isEmpty()) {
                DynamicObjectCollection wayToCityDOs = new DynamicObjectCollection();
                wayToCities.forEach(c -> wayToCityDOs.add(c));
                this.setValueIfExist("trip2mulwayto", wayToCityDOs, rowIndex, parentIndex);
            }
            QFilter travelerQFilter = TripBillTravelerUtils.getTravelerF7QFilter((DynamicObject)this.dataModel.getValue("company"), (DynamicObject)this.dataModel.getValue("org"));
            List<DynamicObject> userDOs = UserServiceHelper.getUserByNames(expenseEntryBO.getPassengers(), travelerQFilter);
            if (!userDOs.isEmpty()) {
                Long applierId = ErCommonUtils.getPk(this.dataModel.getValue("applier"));
                boolean isMultiReimburser = userDOs.stream().anyMatch(userDO -> !userDO.getPkValue().equals(applierId));
                if (isMultiReimburser) {
                    this.setValueIfExist("istravelers", true);
                }
                DynamicObjectCollection userDOCollection = new DynamicObjectCollection();
                userDOs.forEach(u -> userDOCollection.add(u));
                this.setValueIfExist("trip2travelers", userDOCollection, rowIndex, parentIndex);
            }
        }
        this.setValueIfExist("isvactax", expenseEntryBO.getIsSpecialInvoice(), rowIndex, parentIndex);
        this.setValueIfExist("taxclasscode", expenseEntryBO.getTaxClassCodeId(), rowIndex, parentIndex);
        this.setValueIfExist("invoiceno_entry", StringUtils.abbreviate((String)expenseEntryBO.getInvoiceNoUnion(), (int)129), rowIndex, parentIndex);
        this.setValueIfExist("invoicelink", StringUtils.abbreviate((String)expenseEntryBO.getInvoiceCodeUnion(), (int)129), rowIndex, parentIndex);
        this.setValueIfExist("comment", expenseEntryBO.getRemark(), rowIndex, parentIndex);
        if (expenseEntryBO.getSeatGrades() != null) {
            log.info("\u5ea7\u4f4d\u7b49\u7ea7\uff1a {}", (Object)SerializationUtils.toJsonString((Object)expenseEntryBO.getSeatGrades()));
        }
        if (this.dataModel.getProperty("mulseatgrade") != null) {
            this.genSeatGrade(expenseEntryBO, rowIndex, parentIndex);
        }
        DynamicObject tripEntryCostcompany = tripEntryDO.getDynamicObject("entrycostcompany");
        if (tripItemEntryDO.getDynamicObject("travelcostcompany") == null) {
            tripItemEntryDO.set("travelcostcompany", (Object)tripEntryCostcompany);
        }
        DynamicObject tripEntryCostdept = tripEntryDO.getDynamicObject("entrycostdept");
        if (tripItemEntryDO.getDynamicObject("travelcostdept") == null) {
            tripItemEntryDO.set("travelcostdept", (Object)tripEntryCostdept);
        }
        Date tripEntryHappendate = tripEntryDO.getDate("triphappendate");
        if (tripItemEntryDO.getDate("travelhappendate") == null) {
            tripItemEntryDO.set("travelhappendate", (Object)tripEntryHappendate);
        }
        DynamicObject tripEntryExpenseitem = tripEntryDO.getDynamicObject("tripexpenseitem");
        if (tripItemEntryDO.getDynamicObject("travelexpenseitem") == null) {
            tripItemEntryDO.set("travelexpenseitem", (Object)tripEntryExpenseitem);
        }
        if (tripItemEntryDO.getDynamicObject("travelquotactldept") == null) {
            Long quotaCtrlDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId(tripEntryExpenseitem, tripEntryCostdept, this.dataModel);
            tripItemEntryDO.set("travelquotactldept_id", (Object)quotaCtrlDeptId);
        }
        this.copyItem(rowIndex, parentIndex);
    }

    private void genSeatGrade(ExpenseEntryBO expenseEntryBO, int tripItemRowIndex, int tripRowIndex) {
        DynamicObject expenseItemDO = (DynamicObject)this.dataModel.getValue("expenseitem", tripItemRowIndex, tripRowIndex);
        RefObject attrRef = new RefObject();
        Set seatGrade = this.getSeatGradle(expenseEntryBO, expenseItemDO, (RefObject<String>)attrRef);
        log.info("lxc==============222: {}", (Object)SerializationUtils.toJsonString((Object)seatGrade));
        if (!seatGrade.isEmpty() && StringUtils.isNotEmpty((CharSequence)((CharSequence)attrRef.getValue()))) {
            DynamicObject[] seatGradeArr = PlaneSeatUtil.findSeatByAttribute((String)attrRef.getValue(), seatGrade);
            log.info("lxc==============000: {}", (Object)seatGradeArr.length);
            if (seatGradeArr != null && seatGradeArr.length > 0) {
                DynamicObjectCollection mulseatgrades = ((DynamicObject)((DynamicObject)this.dataModel.getEntryEntity("tripentry").get(tripRowIndex)).getDynamicObjectCollection("entryentity").get(tripItemRowIndex)).getDynamicObjectCollection("mulseatgrade");
                if (null != mulseatgrades) {
                    mulseatgrades.clear();
                    for (DynamicObject dynamicObject : seatGradeArr) {
                        DynamicObject mulseatgrade = mulseatgrades.addNew();
                        mulseatgrade.set("fbasedataid", (Object)dynamicObject);
                        mulseatgrade.set("fbasedataid_id", dynamicObject.getPkValue());
                    }
                }
            } else {
                this.setValueIfExist("mulseatgrade", null, tripItemRowIndex, tripRowIndex);
            }
        }
    }

    private void copyItem(int tripItemRowIndex, int tripRowIndex) {
        if (this.curSelectedItem != null) {
            this.setValueIfExist("entrycurrency", ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("entrycurrency")), tripItemRowIndex, tripRowIndex);
            this.setValueIfExist("exchangerate", this.curSelectedItem.getBigDecimal("exchangerate"), tripItemRowIndex, tripRowIndex);
            this.dataModel.beginInit();
            this.setValueIfExist("travelcostcompany", ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("travelcostcompany")), tripItemRowIndex, tripRowIndex);
            this.setValueIfExist("travelcostdept", ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("travelcostdept")), tripItemRowIndex, tripRowIndex);
            this.setValueIfExist("travelhappendate", this.curSelectedItem.getDate("travelhappendate"), tripItemRowIndex, tripRowIndex);
            this.setValueIfExist("travelexpenseitem", ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("travelexpenseitem")), tripItemRowIndex, tripRowIndex);
            this.setValueIfExist("travelquotactldept", ErCommonUtils.getPk(this.curSelectedItem.getDynamicObject("travelquotactldept")), tripItemRowIndex, tripRowIndex);
            this.dataModel.endInit();
        }
    }

    public void setEntryIdInFirst(List<ExpenseEntryBO> expenseEntryExcludeZeroBOs) {
        if (this.curSelectedItem != null) {
            expenseEntryExcludeZeroBOs.get(0).setEntryId(ErCommonUtils.getPk(this.curSelectedItem));
        }
    }
}

