/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalServiceI;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import org.apache.commons.lang3.StringUtils;

public class IncrementalMergeExpenseOrTripItemInvoiceServiceImp
extends IncrementalServiceI {
    private static final Log logger = LogFactory.getLog(IncrementalMergeExpenseOrTripItemInvoiceServiceImp.class);

    @Deprecated
    public IncrementalMergeExpenseOrTripItemInvoiceServiceImp(InvoiceContext invoiceContext, IDataModel model, boolean isTripItem) {
        super(invoiceContext);
        this.setModel(model);
        this.setTripItem(isTripItem);
        this.setInvoiceCurrencyId(invoiceContext.getInvoiceConfig().getInvoiceCurrencyId());
    }

    public IncrementalMergeExpenseOrTripItemInvoiceServiceImp(InvoiceContext invoiceContext, IDataModel model) {
        super(invoiceContext);
        this.setModel(model);
        this.setInvoiceCurrencyId(invoiceContext.getInvoiceConfig().getInvoiceCurrencyId());
    }

    @Override
    public void process() {
        String itermFrom;
        List<ExpenseEntryBO> expenseEntryBOs = this.invoiceContext.getExpenseEntryBOs();
        if (expenseEntryBOs.size() < 1) {
            return;
        }
        ExpenseEntryBO newExpEntryBo = expenseEntryBOs.get(0);
        List<DynamicObject> selectItem = this.invoiceContext.getSelectItem();
        if (selectItem == null || selectItem.isEmpty()) {
            return;
        }
        DynamicObject oldExpenseEntry = selectItem.get(0);
        if (oldExpenseEntry == null) {
            return;
        }
        ExpenseEntryBO oldExpEntryBo = this.changeVOToBO(oldExpenseEntry);
        if (newExpEntryBo.getSeatGrades() != null) {
            logger.info("\u5ea7\u4f4d\u7b49\u7ea7\uff1a {}", (Object)SerializationUtils.toJsonString((Object)newExpEntryBo.getSeatGrades()));
        }
        if (ItemFrom.InvoiceCloud.equalsFrom(itermFrom = oldExpenseEntry.getString("itemfrom"))) {
            this.executeMerge(newExpEntryBo, oldExpEntryBo);
        } else {
            this.executeMergeNull(newExpEntryBo, oldExpenseEntry);
        }
    }

    public ExpenseEntryBO changeVOToBO(DynamicObject oldItem) {
        ExpenseEntryBO expenseEntry = new ExpenseEntryBO();
        expenseEntry.setEntryId(Long.valueOf(oldItem.getLong("id")));
        expenseEntry.setInvoiceType(oldItem.getString("invoicetypeitem"));
        Boolean oldItemOffset = oldItem.getBoolean("offset");
        expenseEntry.setIsOffset(oldItemOffset);
        DynamicObject expenseItem = oldItem.getDynamicObject("expenseitem");
        if (expenseItem != null) {
            Boolean expenseItemOffset = this.getItemOffset(expenseItem);
            if (expenseItemOffset != null) {
                expenseEntry.setExpenseItemIsOffset(expenseItemOffset);
            }
        } else {
            expenseEntry.setExpenseItemIsOffset(Boolean.valueOf(false));
        }
        Set<Long> invoiceHeadIds = InvoiceUtils.mapInvoiceSet(this.getModel().getDataEntity(true), (Long)oldItem.getPkValue());
        Boolean isInvoiceOffset = CollectionUtils.isEmpty(invoiceHeadIds) ? null : Boolean.valueOf(InvoiceOffsetUtils.isInvoiceOffset(this.getModel(), invoiceHeadIds));
        expenseEntry.setInvoiceIsOffset(isInvoiceOffset);
        expenseEntry.setIsSpecialInvoice(Boolean.valueOf(oldItem.getBoolean(this.isTripItem() ? "isvactax" : "is_special_invoice")));
        expenseEntry.setOffsetAmount(oldItem.getBigDecimal("deductibletax"));
        expenseEntry.setItemInOutAmount(oldItem.getBigDecimal("iteminoutamount"));
        if (oldItem.getDynamicObjectType().getProperty("happendate") != null) {
            expenseEntry.setHappenDate(oldItem.getDate("happendate"));
        } else {
            expenseEntry.setHappenDate(new Date());
        }
        if (oldItem.getDynamicObjectType().getProperty("expenseamount") != null) {
            expenseEntry.setTotalAmount(oldItem.getBigDecimal("expenseamount"));
        } else if (oldItem.getDynamicObjectType().getProperty("orientryamount") != null) {
            expenseEntry.setTotalAmount(oldItem.getBigDecimal("orientryamount"));
        }
        expenseEntry.setAirportConstructionFee(oldItem.getBigDecimal("airportconstructionfee"));
        expenseEntry.setTaxRate(oldItem.getBigDecimal("taxrate").divide(BigDecimal.valueOf(100L)));
        expenseEntry.setTaxAmount(oldItem.getBigDecimal("taxamount"));
        DynamicObject taxClassCode = oldItem.getDynamicObject("taxclasscode");
        if (taxClassCode != null) {
            expenseEntry.setTaxClassCodeId((Long)taxClassCode.getPkValue());
        }
        expenseEntry.setInvoiceCodeUnion(oldItem.getString("invoicelink"));
        expenseEntry.setInvoiceNoUnion(oldItem.getString("invoiceno_entry"));
        if (oldItem.getDynamicObjectType().getProperty("expensegoodsname") != null) {
            expenseEntry.setGoodName(oldItem.getString("expensegoodsname"));
        }
        if (oldItem.getDynamicObjectType().getProperty("comment") != null) {
            expenseEntry.setRemark(oldItem.getString("comment"));
        } else if (oldItem.getDynamicObjectType().getProperty("remark") != null) {
            expenseEntry.setRemark(oldItem.getString("remark"));
        }
        if (oldItem.getDynamicObjectType().getProperty("expenseitem") != null) {
            DynamicObject item = oldItem.getDynamicObject("expenseitem");
            if (item != null) {
                DynamicProperty attributeProp = item.getDynamicObjectType().getProperty("attribute");
                if (attributeProp != null) {
                    String attribute = item.getString("attribute");
                    DynamicObjectCollection seatGradeDC = oldItem.getDynamicObjectCollection("mulseatgrade");
                    Set seat = seatGradeDC.stream().map(seatGrade -> seatGrade.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toSet());
                    HashMap seatGrades = Maps.newHashMapWithExpectedSize((int)2);
                    if (StringUtils.equals((CharSequence)attribute, (CharSequence)"2")) {
                        seatGrades.put("2", seat);
                    } else if (StringUtils.equals((CharSequence)attribute, (CharSequence)"4")) {
                        seatGrades.put("4", seat);
                    }
                    expenseEntry.setSeatGrades((Map)seatGrades);
                }
                expenseEntry.setExpenseItemId((Long)item.getPkValue());
            } else {
                logger.info("expenseitem is null");
            }
        }
        return expenseEntry;
    }

    public void executeMerge(ExpenseEntryBO newEntryBo, ExpenseEntryBO oldEntryBo) {
        Boolean isOffset;
        BigDecimal oldTotalAmount;
        BigDecimal oldTaxAmount;
        BigDecimal newTaxRate;
        BigDecimal oldTaxRate;
        String oldInvoiceNo;
        String oldInvocieLink;
        BigDecimal oldAirPort;
        newEntryBo.setEntryId(oldEntryBo.getEntryId());
        newEntryBo.setEntryCurrencyId(this.getInvoiceCurrencyId());
        Date oldDate = oldEntryBo.getHappenDate();
        if (oldDate != null) {
            newEntryBo.setHappenDate(oldEntryBo.getHappenDate());
        }
        if (oldEntryBo.getExpenseItemId() != null) {
            newEntryBo.setExpenseItemId(oldEntryBo.getExpenseItemId());
        }
        newEntryBo.setTaxClassCodeId(oldEntryBo.getTaxClassCodeId());
        String oldGoodName = oldEntryBo.getGoodName();
        if (oldGoodName != null) {
            newEntryBo.setGoodName(oldEntryBo.getGoodName());
        }
        String oldRemark = oldEntryBo.getRemark();
        String newRemark = newEntryBo.getRemark();
        if (StringUtils.isNotBlank((CharSequence)oldRemark)) {
            if (StringUtils.isNotBlank((CharSequence)newRemark)) {
                newEntryBo.setRemark(oldRemark + "," + newRemark);
            } else {
                newEntryBo.setRemark(oldRemark);
            }
        }
        if ((oldAirPort = oldEntryBo.getAirportConstructionFee()) != null) {
            BigDecimal newAirPort = newEntryBo.getAirportConstructionFee();
            if (newAirPort != null) {
                newEntryBo.setAirportConstructionFee(newAirPort.add(oldAirPort));
            } else {
                newEntryBo.setAirportConstructionFee(oldAirPort);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(oldInvocieLink = oldEntryBo.getInvoiceCodeUnion()))) {
            String newInvocieLink = newEntryBo.getInvoiceCodeUnion();
            if (StringUtils.isNotBlank((CharSequence)newInvocieLink)) {
                newEntryBo.setInvoiceCodeUnion(oldInvocieLink + "," + newInvocieLink);
            } else {
                newEntryBo.setInvoiceCodeUnion(oldInvocieLink);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(oldInvoiceNo = oldEntryBo.getInvoiceNoUnion()))) {
            String newInvoiceNo = newEntryBo.getInvoiceNoUnion();
            if (StringUtils.isNotBlank((CharSequence)newInvoiceNo)) {
                newEntryBo.setInvoiceNoUnion(oldInvoiceNo + "," + newInvoiceNo);
            } else {
                newEntryBo.setInvoiceNoUnion(oldInvoiceNo);
            }
        }
        if ((oldTaxRate = oldEntryBo.getTaxRate()) != null && (newTaxRate = newEntryBo.getTaxRate()) != null && newTaxRate.compareTo(oldTaxRate) != 0) {
            newEntryBo.setTaxRate(BigDecimal.ZERO);
        }
        if ((oldTaxAmount = oldEntryBo.getTaxAmount()) != null) {
            BigDecimal newTaxAmount = newEntryBo.getTaxAmount();
            if (newTaxAmount != null) {
                newEntryBo.setTaxAmount(newTaxAmount.add(oldTaxAmount));
            } else {
                newEntryBo.setTaxAmount(oldTaxAmount);
            }
        }
        if ((oldTotalAmount = oldEntryBo.getTotalAmount()) != null) {
            BigDecimal newTotalAmount = newEntryBo.getTotalAmount();
            if (newTotalAmount != null) {
                newEntryBo.setTotalAmount(newTotalAmount.add(oldTotalAmount));
            } else {
                newEntryBo.setTotalAmount(oldTotalAmount);
            }
        }
        newEntryBo.setNotIncludeTaxAmount(newEntryBo.getTotalAmount().subtract(newEntryBo.getTaxAmount()));
        String oldInvoiceType = oldEntryBo.getInvoiceType();
        String newInvoiceType = newEntryBo.getInvoiceType();
        if (!StringUtils.equals((CharSequence)oldInvoiceType, (CharSequence)newInvoiceType)) {
            newEntryBo.setInvoiceType(InvoiceTypeEnum.NULL.getValue());
        }
        if ((isOffset = oldEntryBo.getInvoiceIsOffset() == null ? Boolean.valueOf(oldEntryBo.getIsOffset() != false && newEntryBo.getInvoiceIsOffset() != false) : Boolean.valueOf(oldEntryBo.getExpenseItemIsOffset() != false && (oldEntryBo.getInvoiceIsOffset() != false || newEntryBo.getInvoiceIsOffset() != false))) != null) {
            boolean orgOffset = this.invoiceContext.getInvoiceConfig().isOrgOffset();
            newEntryBo.setIsOffset(Boolean.valueOf(isOffset != false && orgOffset));
        }
        BigDecimal offsetAmount = BigDecimal.ZERO;
        if (isOffset != null && isOffset.booleanValue()) {
            offsetAmount = newEntryBo.getOffsetAmount().add(oldEntryBo.getOffsetAmount());
        }
        newEntryBo.setOffsetAmount(offsetAmount);
        BigDecimal inOutAmount = newEntryBo.getTaxAmount().subtract(offsetAmount);
        newEntryBo.setItemInOutAmount(inOutAmount);
        Boolean oldIsSpecial = oldEntryBo.getIsSpecialInvoice();
        Boolean newIsSpecial = newEntryBo.getIsSpecialInvoice();
        Boolean isSpecial = false;
        if (oldIsSpecial != null && newIsSpecial != null) {
            isSpecial = oldIsSpecial != false && newIsSpecial != false;
        }
        newEntryBo.setIsSpecialInvoice(isSpecial);
        Map oldSeatGrades = oldEntryBo.getSeatGrades();
        if (oldSeatGrades != null && !oldSeatGrades.isEmpty()) {
            Map newSeatGrades = newEntryBo.getSeatGrades();
            Set air = (Set)oldSeatGrades.get("2");
            Set train = (Set)oldSeatGrades.get("4");
            if (newSeatGrades != null && !newSeatGrades.isEmpty()) {
                if (air != null) {
                    ((Set)newSeatGrades.get("2")).addAll(air);
                }
                if (train != null) {
                    ((Set)newSeatGrades.get("4")).addAll(train);
                }
            } else {
                newEntryBo.setSeatGrades(oldSeatGrades);
            }
        }
    }

    private void executeMergeNull(ExpenseEntryBO newEntryBo, DynamicObject oldEntry) {
        if (newEntryBo.getSeatGrades() != null) {
            logger.info("\u5ea7\u4f4d\u7b49\u7ea7\uff1a {}", (Object)SerializationUtils.toJsonString((Object)newEntryBo.getSeatGrades()));
        }
        if (oldEntry.getDynamicObjectType().getProperty("expenseitem") != null) {
            List invoiceItemEntryVOs;
            Optional<BigDecimal> reduce;
            DynamicProperty attributeProp;
            DynamicObject item = oldEntry.getDynamicObject("expenseitem");
            if (item != null && (attributeProp = item.getDynamicObjectType().getProperty("attribute")) != null) {
                String attribute = item.getString("attribute");
                DynamicObjectCollection seatGradeDC = oldEntry.getDynamicObjectCollection("mulseatgrade");
                Set seat = seatGradeDC.stream().map(seatGrade -> seatGrade.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toSet());
                Map seatGrades = newEntryBo.getSeatGrades();
                if (seatGrades == null) {
                    seatGrades = Maps.newHashMapWithExpectedSize((int)2);
                }
                if (StringUtils.equals((CharSequence)attribute, (CharSequence)"2") || StringUtils.equals((CharSequence)attribute, (CharSequence)"4")) {
                    Set seatSet = seatGrades.get(attribute) == null ? new HashSet(4) : (Set)seatGrades.get(attribute);
                    seatSet.addAll(seat);
                    seatGrades.put(attribute, seatSet);
                }
                logger.info("\u5ea7\u4f4d\u7b49\u7ea7\uff1a {}", (Object)SerializationUtils.toJsonString((Object)seatGrades));
                newEntryBo.setSeatGrades(seatGrades);
            }
            if (item != null) {
                newEntryBo.setExpenseItemId((Long)item.getPkValue());
            }
            if (item != null) {
                boolean itemOffset = this.getItemOffset(item);
                Boolean invoiceIsOffset = newEntryBo.getInvoiceIsOffset();
                newEntryBo.setIsOffset(Boolean.valueOf(itemOffset && invoiceIsOffset != false && this.invoiceContext.getInvoiceConfig().isOrgOffset()));
            }
            BigDecimal offsetAmount = BigDecimal.ZERO;
            if (newEntryBo.getIsOffset().booleanValue() && (reduce = (invoiceItemEntryVOs = newEntryBo.getInvoiceItemEntryVOs()).stream().map(invoiceItem -> invoiceItem.getOffsetAmount()).reduce(BigDecimal::add)).isPresent()) {
                offsetAmount = reduce.get();
            }
            newEntryBo.setOffsetAmount(offsetAmount);
            newEntryBo.setItemInOutAmount(newEntryBo.getTaxAmount().subtract(offsetAmount));
        }
    }

    boolean getItemOffset(DynamicObject item) {
        if (item == null) {
            return false;
        }
        DynamicProperty attributeProp = item.getDynamicObjectType().getProperty("attribute");
        if (attributeProp != null) {
            return item.getBoolean("isoffset");
        }
        return item.getBoolean("offset");
    }
}

