/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.expenserange.MappingItemUtils;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemServiceI;
import kd.fi.er.business.pool.reim.util.ReimBotpUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import kd.fi.er.common.model.invoice.bo.RelationBO;
import kd.fi.er.common.model.invoice.merge.ItemEnum;

public class MappingItemWithOrgInvoiceServiceImp
extends MappingItemServiceI {
    private static final Log log = LogFactory.getLog(MappingItemWithOrgInvoiceServiceImp.class);
    private BillType billType;
    private DynamicObject dataEntity;
    private Map<Object, Object> expIdMap = new HashMap<Object, Object>();
    private HashMap<Object, Object> tripItemIdMap = new HashMap();
    private List<String> standardBillFactors = Lists.newArrayList((Object[])new String[]{"bill_org", "bill_applier", "bill_description", "bill_bizitem", "bill_projecttype", "bill_reimbursetype"});
    private List<String> standardInvoiceFactors = Lists.newArrayList((Object[])new String[]{"inv_invoicetype", "inv_ratetype"});
    private List<String> standardOtherInvoiceFactors = Lists.newArrayList((Object[])new String[]{"inv_ext_goodnames", "inv_ext_buyerorgname", "inv_ext_startcity", "inv_ext_destcity"});
    private List<String> billFactors;
    private List<String> invoiceFactors;
    private List<String> otherInvoiceFactors;
    private List<String> itemFieldNameList = Arrays.stream(InvoiceItemEntryBO.class.getDeclaredFields()).map(field -> field.getName().toLowerCase()).collect(Collectors.toList());
    private List<String> headFieldNameList = Arrays.stream(InvoiceEntryBO.class.getDeclaredFields()).map(field -> field.getName().toLowerCase()).collect(Collectors.toList());
    private Map<String, Method> getHeadMethodMap = Arrays.stream(InvoiceEntryBO.class.getDeclaredMethods()).filter(method -> method.getName().contains("get")).collect(Collectors.toMap(method -> method.getName().toLowerCase(), method -> method));
    private Map<String, Method> getItemMethodMap = Arrays.stream(InvoiceItemEntryBO.class.getDeclaredMethods()).filter(method -> method.getName().contains("get")).collect(Collectors.toMap(method -> method.getName().toLowerCase(), method -> method));
    private static final String ALGO_KEY = MappingItemWithOrgInvoiceServiceImp.class.getName();

    public MappingItemWithOrgInvoiceServiceImp(InvoiceContext invoiceContext, BillType billType, DynamicObject dataEntity) {
        super(invoiceContext);
        this.billType = billType;
        this.dataEntity = dataEntity;
        this.initFactor();
    }

    @Override
    public void process() {
        long startTime = System.currentTimeMillis();
        DynamicObject org = this.dataEntity.getDynamicObject(this.billType.getOrgClumn());
        if (org == null) {
            return;
        }
        List<String> priorityList = this.getFactorAndPriority();
        String selectFields = this.getSelectFields();
        Long orgId = (Long)org.getPkValue();
        QFilter filter = null;
        String entityName = this.dataEntity.getDataEntityType().getName();
        if ("er_dailyreimbursebill".equals(entityName) || "er_publicreimbursebill".equals(entityName)) {
            String billType = "er_dailyreimbursebill".equals(entityName) ? "1" : "3";
            filter = new QFilter("relbilltype", "=", (Object)billType).or(new QFilter("relbilltype", "is null", null)).or(QFilter.of((String)"relbilltype = ?", (Object[])new Object[]{""}));
        }
        List<DynamicObject> mappings = MappingItemUtils.getAvailableMapping(this.billType, orgId, selectFields, filter);
        Set<Object> itemIds = mappings.stream().map(v -> {
            DynamicObject item = v.getDynamicObject(this.billType.getItem());
            return item == null ? null : item.getPkValue();
        }).collect(Collectors.toSet());
        this.filterOrgUse(itemIds);
        this.tripFilter(itemIds);
        StringBuilder logSb = new StringBuilder(2048);
        ArrayList mappingItemBo = Lists.newArrayListWithExpectedSize((int)mappings.size());
        for (DynamicObject mappingItem : mappings) {
            DynamicObject item = mappingItem.getDynamicObject(this.billType.getItem());
            if (item == null || !itemIds.contains(item.getPkValue())) continue;
            mappingItemBo.add(this.rowExchangeBO(mappingItem, priorityList));
        }
        try {
            this.factorMapItem(mappingItemBo, priorityList, logSb);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getCause(), new ErrorCode("0", e.getMessage()), new Object[]{e});
        }
        if (logSb.length() >= 0 && !this.invoiceContext.getInvoiceConfig().isOutLog()) {
            log.info(logSb.toString());
        }
        log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f>>>>>> \u5173\u8054" + this.invoiceContext.getInvoiceItemEntryBOs().size() + "\u5f20\u53d1\u7968\u9700\u8981" + (System.currentTimeMillis() - startTime) + "ms");
    }

    private Set inBizItemRange() {
        DynamicObjectCollection expenseItemRange;
        DynamicObject bizItem;
        DynamicObject setting;
        boolean hasProperty;
        boolean bl = hasProperty = this.dataEntity.getDynamicObjectType().getProperty("bizitem") != null;
        if (hasProperty && this.dataEntity.getDynamicObject("bizitem") != null && (setting = FeeStandardHelper.queryBizItem((bizItem = this.dataEntity.getDynamicObject("bizitem")).getString("number"))) != null && !(expenseItemRange = setting.getDynamicObjectCollection("entryentity")).isEmpty()) {
            return expenseItemRange.stream().map(e -> e.get("expenseitem.id")).collect(Collectors.toSet());
        }
        return new HashSet(0);
    }

    private Long getTripDefaultItem(Long orgId) {
        Long defaultItem = 0L;
        if (BillType.TripItem == this.billType) {
            QFilter qf = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)orgId);
            Long defaultId = ErStdConfig.getInvoiceCloudOtherCharges(this.billType.getItemEnum());
            if (defaultId != null) {
                qf.and(new QFilter("id", "=", (Object)defaultId));
                DynamicObject d = BusinessDataServiceHelper.loadSingleFromCache((String)"er_tripexpenseitem", (QFilter[])new QFilter[]{qf});
                if (d != null) {
                    defaultItem = defaultId;
                }
            }
        }
        return defaultItem;
    }

    private boolean mapFactors(Object invoiceInfo, Object relationFactor, String key) {
        if (relationFactor instanceof String) {
            if (StringUtils.isBlank((Object)relationFactor)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)"bill_description", (CharSequence)key)) {
                return StringUtils.contains((CharSequence)((String)invoiceInfo), (CharSequence)((String)relationFactor));
            }
            return Objects.equals(invoiceInfo, relationFactor);
        }
        if (relationFactor instanceof DynamicObject) {
            if (StringUtils.equals((CharSequence)"inv_ratetype", (CharSequence)key)) {
                String mergeCode = ((DynamicObject)relationFactor).getString("mergecode");
                return Objects.equals(invoiceInfo, mergeCode);
            }
            if (invoiceInfo == null || relationFactor == null) {
                return false;
            }
            return Objects.equals(ErCommonUtils.getPk(invoiceInfo), ErCommonUtils.getPk(relationFactor));
        }
        if (relationFactor instanceof BigDecimal && invoiceInfo instanceof BigDecimal) {
            return ((BigDecimal)relationFactor).compareTo((BigDecimal)invoiceInfo) == 0;
        }
        if (relationFactor == null) {
            return false;
        }
        return Objects.equals(invoiceInfo, relationFactor);
    }

    private void mapInvoiceFactor(String factorKey, String factorValue, RelationBO relationBO, StringBuilder logBuilder) {
        String partMatchStr = ResManager.loadKDString((String)"\u6620\u5c04\u547d\u4e2d_\u6a21\u7cca\u5339\u914d\uff1a%s, ", (String)"MappingItemWithOrgInvoiceServiceImp_3", (String)"fi-er-business", (Object[])new Object[0]);
        String allMatchStr = ResManager.loadKDString((String)"\u6620\u5c04\u547d\u4e2d_\u5b8c\u5168\u5339\u914d\uff1a%s; ", (String)"MappingItemWithOrgInvoiceServiceImp_4", (String)"fi-er-business", (Object[])new Object[0]);
        List factors = relationBO.getInvoiceOtherMapFactorList();
        List factorsOfKey = factors.stream().filter(v -> StringUtils.equals((CharSequence)v.getInvoiceFactor(), (CharSequence)factorKey)).collect(Collectors.toList());
        if (factorsOfKey.size() <= 0) {
            String partMatchLogStr = String.format(partMatchStr, "null");
            String allMatchLogStr = String.format(allMatchStr, "null");
            logBuilder.append(partMatchLogStr);
            logBuilder.append(allMatchLogStr).append("\r\n");
            return;
        }
        boolean allMatch = false;
        boolean partMatch = false;
        for (RelationBO.InvoiceOtherMapFactor factor : factorsOfKey) {
            if (StringUtils.equals((CharSequence)factor.getMappingType(), (CharSequence)"0")) {
                if (!factor.getMapFactor().stream().anyMatch(v -> StringUtils.equals((CharSequence)InvoiceUtils.repeatSign(factorValue), (CharSequence)InvoiceUtils.repeatSign(v)))) continue;
                allMatch = true;
                continue;
            }
            if (!StringUtils.equals((CharSequence)factor.getMappingType(), (CharSequence)"1") || !factor.getMapFactor().stream().anyMatch(v -> StringUtils.contains((CharSequence)InvoiceUtils.repeatSign(factorValue), (CharSequence)InvoiceUtils.repeatSign(v)))) continue;
            partMatch = true;
        }
        int rightCount = relationBO.getRightCount();
        relationBO.setMapResult(allMatch, factorKey, "0");
        relationBO.setMapResult(partMatch, factorKey, "1");
        String partMatchLogStr = String.format(partMatchStr, partMatch);
        String allMatchLogStr = String.format(allMatchStr, allMatch);
        logBuilder.append(partMatchLogStr);
        logBuilder.append(allMatchLogStr).append("\r\n");
        if ("2".equalsIgnoreCase(relationBO.getAutoMapFormula()) && relationBO.getRightCount() - rightCount < factorsOfKey.size()) {
            relationBO.setRightCount(-1);
        }
    }

    protected List<String> getFactorAndPriority() {
        List<String> priorityList;
        String factors = ErStdConfig.getInvoiceRelationItemFactor();
        if (StringUtils.isBlank((CharSequence)factors)) {
            ArrayList<String> factor = new ArrayList<String>(16);
            factor.addAll(this.standardOtherInvoiceFactors);
            factor.addAll(this.otherInvoiceFactors);
            factor.addAll(this.standardInvoiceFactors);
            factor.addAll(this.invoiceFactors);
            factor.addAll(this.standardBillFactors);
            factor.addAll(this.billFactors);
            priorityList = factor;
        } else {
            priorityList = Arrays.asList(factors.split(",")).stream().filter(column -> column != null).map(String::trim).collect(Collectors.toList());
        }
        log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u4f18\u5148\u7ea7\u987a\u5e8f\uff1a" + priorityList);
        return priorityList;
    }

    protected String getSelectFields() {
        Set<String> invoiceFactorEntry;
        String invoiceFactorSqlStr;
        String billFactorSqlStr;
        String itemStr = this.billType.getItem();
        String mustSelectFields = itemStr + ".id, ctrlstrategy, id, number, modifytime, createorg, relbilltype";
        StringBuilder sb = new StringBuilder();
        sb.append(mustSelectFields);
        if (this.standardBillFactors != null && !this.standardBillFactors.isEmpty()) {
            billFactorSqlStr = this.standardBillFactors.stream().collect(Collectors.joining(","));
            sb.append(",");
            sb.append(billFactorSqlStr);
        }
        if (this.standardInvoiceFactors != null && !this.standardInvoiceFactors.isEmpty()) {
            billFactorSqlStr = this.standardInvoiceFactors.stream().collect(Collectors.joining(","));
            sb.append(",");
            sb.append(billFactorSqlStr);
        }
        if (this.billFactors != null && !this.billFactors.isEmpty()) {
            invoiceFactorSqlStr = this.billFactors.stream().collect(Collectors.joining(","));
            sb.append(",");
            sb.append(invoiceFactorSqlStr);
        }
        if (this.invoiceFactors != null && !this.invoiceFactors.isEmpty()) {
            invoiceFactorSqlStr = this.invoiceFactors.stream().collect(Collectors.joining(","));
            sb.append(",");
            sb.append(invoiceFactorSqlStr);
        }
        if ((invoiceFactorEntry = this.loadOtherInvoiceFactorEntry()) != null && !invoiceFactorEntry.isEmpty()) {
            String otherFactorSqlStr = invoiceFactorEntry.stream().map(factor -> "entryentity." + factor).collect(Collectors.joining(","));
            sb.append(",");
            sb.append(otherFactorSqlStr);
        }
        return sb.toString();
    }

    protected RelationBO rowExchangeBO(DynamicObject mappingConfigDynObj, List<String> priorityList) {
        Object id;
        Object itemId = mappingConfigDynObj.get(this.billType.getItem() + ".id");
        if (BillType.ExpenseItem == this.billType && this.expIdMap != null) {
            id = this.expIdMap.get(itemId);
            if (id != null) {
                itemId = id;
            }
        } else if (this.tripItemIdMap != null && (id = this.tripItemIdMap.get(itemId)) != null) {
            itemId = id;
        }
        RelationBO relationBO = new RelationBO((Long)itemId, priorityList);
        relationBO.setNumber(mappingConfigDynObj.getString("number"));
        relationBO.setAutoMapFormula(this.invoiceContext.getInvoiceConfig().isPreciseMatch() ? "2" : "1");
        relationBO.setModifyTime(mappingConfigDynObj.getDate("modifytime"));
        relationBO.setCreateOrgId(((Long)mappingConfigDynObj.getDynamicObject("createorg").getPkValue()).longValue());
        relationBO.setRelbilltype(mappingConfigDynObj.getString("relbilltype"));
        DataEntityPropertyCollection typColl = mappingConfigDynObj.getDynamicObjectType().getProperties();
        for (String column : priorityList) {
            Object value;
            Object obj = typColl.get((Object)column);
            if (obj == null || (!((value = mappingConfigDynObj.get(column)) instanceof String) || !StringUtils.isNotBlank((Object)value)) && (!(value instanceof DynamicObject) || value == null)) continue;
            relationBO.putFactorInfo(column, value);
        }
        DynamicObjectCollection otherInvoiceFactorsEntry = mappingConfigDynObj.getDynamicObjectCollection("entryentity");
        if (!otherInvoiceFactorsEntry.isEmpty()) {
            Map groupByFactorAndMappingType = otherInvoiceFactorsEntry.stream().collect(Collectors.groupingBy(factor -> factor.getString("invoicefactor"), Collectors.groupingBy(factor -> factor.getString("inv_mappingtype"), Collectors.mapping(factor -> factor.getString("mapfactor"), Collectors.toSet()))));
            for (Map.Entry next : groupByFactorAndMappingType.entrySet()) {
                String invoiceFactor = next.getKey();
                Map mappingTypeMap = next.getValue();
                for (Map.Entry mappingTypeNext : mappingTypeMap.entrySet()) {
                    String mappingType = mappingTypeNext.getKey();
                    Set mapFactorSet = mappingTypeNext.getValue();
                    RelationBO.InvoiceOtherMapFactor invoiceOtherMapFactor = new RelationBO.InvoiceOtherMapFactor();
                    invoiceOtherMapFactor.setInvoiceFactor(invoiceFactor);
                    invoiceOtherMapFactor.setMappingType(mappingType);
                    invoiceOtherMapFactor.setMapFactor(mapFactorSet);
                    relationBO.getInvoiceOtherMapFactorList().add(invoiceOtherMapFactor);
                }
            }
        }
        return relationBO;
    }

    protected Map<String, Object> billFactors(List<String> priorityList) {
        HashMap billFactor = Maps.newHashMap();
        DynamicObjectType dynamicObjectType = this.dataEntity.getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        for (String billKey : priorityList) {
            String key;
            boolean hasProperty;
            if (!billKey.contains("bill_") || !(hasProperty = properties.get((Object)(key = billKey.split("_")[1])) != null)) continue;
            billFactor.put(billKey, this.dataEntity.get(key));
        }
        return billFactor;
    }

    private void tripFilter(Set<Object> itemIds) {
        Object mid;
        if (BillType.TripItem != this.billType) {
            return;
        }
        DynamicObject org = this.dataEntity.getDynamicObject(this.billType.getOrgClumn());
        Long orgId = (Long)org.getPkValue();
        QFilter baseDataIdInFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"er_tripexpenseitem", (Long)orgId);
        HashSet tripItemIds_inOrg = new HashSet((Collection)baseDataIdInFilter.getValue());
        HashSet<Object> allItemIds = new HashSet<Object>(tripItemIds_inOrg.size());
        allItemIds.addAll(itemIds);
        allItemIds.addAll(tripItemIds_inOrg);
        HashMap id_masterid = Maps.newHashMapWithExpectedSize((int)allItemIds.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"er_tripexpenseitem", (String)"id,masterid,enable", (QFilter[])new QFilter("id", "in", allItemIds).toArray(), null);){
            for (Row row : ds) {
                Object id = row.get("id");
                Object masterid = row.get("masterid");
                Object enable = row.get("enable");
                if (tripItemIds_inOrg.contains(id) && !"1".equals(enable)) continue;
                id_masterid.put(id, masterid);
            }
        }
        Set tripItemIds_inOrg_mid = tripItemIds_inOrg.stream().map(v -> id_masterid.get(v)).collect(Collectors.toSet());
        itemIds.removeIf(v -> !tripItemIds_inOrg_mid.contains(id_masterid.get(v)));
        HashMap tripItemMasterid_ids = Maps.newHashMapWithExpectedSize((int)tripItemIds_inOrg.size());
        for (Object e : tripItemIds_inOrg) {
            mid = id_masterid.get(e);
            if (mid == null) continue;
            HashSet ids = (HashSet)tripItemMasterid_ids.get(mid);
            if (ids == null) {
                ids = new HashSet(1);
                tripItemMasterid_ids.put(mid, ids);
            }
            ids.add(e);
        }
        this.tripItemIdMap = new HashMap(itemIds.size());
        for (Object object : itemIds) {
            mid = id_masterid.get(object);
            Set set = (Set)tripItemMasterid_ids.get(mid);
            if (set == null || set.isEmpty()) continue;
            this.tripItemIdMap.put(object, set.iterator().next());
        }
    }

    private void filterOrgUse(Set<Object> itemIds) {
        Object mid;
        if (BillType.TripItem == this.billType) {
            return;
        }
        String entryName = this.dataEntity.getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"er_expense_recordbill") || StringUtils.equals((CharSequence)entryName, (CharSequence)"er_trip_recordbill")) {
            return;
        }
        DynamicObject billtype = BusinessDataServiceHelper.loadSingle((String)"er_billtype", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"number = ?", (Object[])new Object[]{entryName})});
        if (billtype == null) {
            itemIds.clear();
            return;
        }
        DynamicObject org = this.dataEntity.getDynamicObject(this.billType.getOrgClumn());
        Long orgId = (Long)org.getPkValue();
        DynamicObject costDept = this.dataEntity.getDynamicObject("costdept");
        Long costDeptId = 0L;
        if (costDept != null) {
            costDeptId = (Long)costDept.getPkValue();
        }
        Set<Object> itemIdOfbillType = ReimBotpUtils.getAllowUseItemsId(entryName, costDeptId, orgId);
        HashSet<Object> allItemIds = new HashSet<Object>(itemIdOfbillType.size());
        allItemIds.addAll(itemIds);
        allItemIds.addAll(itemIdOfbillType);
        HashMap<Object, Object> id_masterid = new HashMap<Object, Object>(allItemIds.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"er_expenseitemedit", (String)"id,masterid", (QFilter[])new QFilter("id", "in", allItemIds).toArray(), null);){
            for (Row row : ds) {
                Object id = row.get("id");
                Object masterid = row.get("masterid");
                id_masterid.put(id, masterid);
            }
        }
        Set itemIdOfbillType_mid = itemIdOfbillType.stream().map(v -> id_masterid.get(v)).collect(Collectors.toSet());
        itemIds.removeIf(v -> !itemIdOfbillType_mid.contains(id_masterid.get(v)));
        log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u8fc7\u6ee4\u540e\u5f97\u5230\u7684\u8d39\u7528\u9879\u76ee\uff1a" + itemIds);
        HashMap expMasterid_ids = Maps.newHashMapWithExpectedSize((int)itemIdOfbillType.size());
        for (Object id : itemIdOfbillType) {
            mid = id_masterid.get(id);
            HashSet<Object> ids = (HashSet<Object>)expMasterid_ids.get(mid);
            if (ids == null) {
                ids = new HashSet<Object>(1);
                expMasterid_ids.put(mid, ids);
            }
            ids.add(id);
        }
        this.expIdMap = Maps.newHashMapWithExpectedSize((int)itemIds.size());
        for (Object id : itemIds) {
            mid = id_masterid.get(id);
            Set set = (Set)expMasterid_ids.get(mid);
            if (set == null || set.isEmpty()) continue;
            this.expIdMap.put(id, set.iterator().next());
        }
    }

    protected String changerEnum() {
        String formid;
        String reBillType = "";
        String string = formid = this.dataEntity.getDynamicObjectType().getProperty("formid") != null ? this.dataEntity.getString("formid") : "";
        reBillType = ErEntityTypeUtils.isDailyReimburseBill(formid) ? "1" : (ErEntityTypeUtils.isPublicReimburseBill(formid) ? "3" : (ErEntityTypeUtils.isTripReimburseBill(formid) ? "2" : formid));
        return reBillType;
    }

    protected Long mapping(List<RelationBO> maxList, List<String> priorityList, Long orgId) {
        if (maxList.isEmpty()) {
            log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u672a\u5339\u914d\u5230\u8d39\u7528/\u5dee\u65c5\u9879\u76ee\uff01");
            return 0L;
        }
        if (maxList.size() == 1) {
            log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u5355\u9879\u5339\u914d\u5339\u914d\u6210\u529f\u7684\u6620\u5c04\u4fe1\u606f\uff1a" + maxList);
            return maxList.get(0).getItemId();
        }
        List<Object> allList = maxList;
        if (!this.invoiceContext.getInvoiceConfig().isPreciseMatch() && (allList = maxList.stream().filter(bo -> bo.realMapResult()).collect(Collectors.toList())).isEmpty()) {
            log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u7cbe\u51c6\u5339\u914d\u672a\u5339\u914d\u5230\u8d39\u7528/\u5dee\u65c5\u9879\u76ee\uff01");
            return 0L;
        }
        log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u7cbe\u51c6\u5339\u914d\u5339\u914d\u5230\u7684\u6620\u5c04\u4fe1\u606f\uff1a" + allList);
        int accordWith = allList.stream().max(Comparator.comparingInt(RelationBO::getAccordWith)).get().getAccordWith();
        List finalList = allList.stream().filter(bo -> bo.getAccordWith() == accordWith).collect(Collectors.toList());
        if (finalList.isEmpty()) {
            log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u591a\u7ef4\u5339\u914d\u672a\u5339\u914d\u5230\u8d39\u7528/\u5dee\u65c5\u9879\u76ee\uff01");
            return 0L;
        }
        log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u6700\u7ec8\u5f97\u5230\u7684\u6620\u5c04\u4fe1\u606f\uff1a" + finalList);
        if (finalList.size() == 1) {
            return ((RelationBO)finalList.get(0)).getItemId();
        }
        List createOrgList = finalList.stream().filter(bo -> bo.getCreateOrgId() == orgId.longValue()).collect(Collectors.toList());
        if (!createOrgList.isEmpty() && createOrgList.size() == 1) {
            log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u8fc7\u6ee4\u521b\u5efa\u7ec4\u7ec7\u5f97\u5230\u7684\u6620\u5c04\u4fe1\u606f\uff1a" + createOrgList);
            return ((RelationBO)createOrgList.get(0)).getItemId();
        }
        String reBillType = this.changerEnum();
        List reBillTypeList = finalList.stream().filter(bo -> StringUtils.equals((CharSequence)reBillType, (CharSequence)bo.getRelbilltype())).collect(Collectors.toList());
        if (!reBillTypeList.isEmpty() && reBillTypeList.size() == 1) {
            log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u8fc7\u6ee4\u5355\u636e\u7c7b\u578b\u5f97\u5230\u7684\u6620\u5c04\u4fe1\u606f\uff1a" + reBillTypeList);
            return ((RelationBO)reBillTypeList.get(0)).getItemId();
        }
        List modifyTimeList = finalList.stream().sorted((thisbo, otherbo) -> otherbo.getModifyTime().compareTo(thisbo.getModifyTime())).collect(Collectors.toList());
        log.info("\u6620\u5c04\u53d1\u7968\u4fe1\u606f\uff0c\u8fc7\u6ee4\u4fee\u6539\u65f6\u95f4\u5f97\u5230\u7684\u6620\u5c04\u4fe1\u606f\uff1a" + reBillTypeList);
        return ((RelationBO)modifyTimeList.get(0)).getItemId();
    }

    private List<String> loadBillFactor(DynamicObjectType type) {
        DataEntityPropertyCollection properties = type.getProperties();
        List<String> billFactors = properties.stream().filter(prop -> prop.getName().startsWith("bill_") && !prop.getName().endsWith("_id") && !this.standardBillFactors.contains(prop.getName())).map(prop -> prop.getName()).collect(Collectors.toList());
        return billFactors;
    }

    private List<String> loadInvoiceFactor(DynamicObjectType type) {
        DataEntityPropertyCollection properties = type.getProperties();
        List<String> invoiceFactors = properties.stream().filter(prop -> prop.getName().startsWith("inv_") && !prop.getName().endsWith("_id") && !this.standardInvoiceFactors.contains(prop.getName())).map(prop -> prop.getName()).collect(Collectors.toList());
        return invoiceFactors;
    }

    private Set<String> loadOtherInvoiceFactorEntry() {
        return Sets.newHashSet((Object[])new String[]{"invoicefactor", "mapfactor", "inv_mappingtype"});
    }

    private List<String> loadOtherInvoiceFactor(DynamicObjectType type) {
        List<String> entityColumn = new ArrayList<String>(16);
        EntryProp entryentity = (EntryProp)type.getProperty("entryentity");
        DynamicObjectType entryProp = entryentity.getDynamicCollectionItemPropertyType();
        if (entryProp == null) {
            return entityColumn;
        }
        DynamicProperty invoiceFactor = entryProp.getProperty("invoicefactor");
        List comboItems = ((ComboProp)invoiceFactor).getComboItems();
        if (comboItems != null && !comboItems.isEmpty()) {
            entityColumn = comboItems.stream().map(combo -> combo.getValue()).filter(propName -> !this.standardOtherInvoiceFactors.contains(propName)).collect(Collectors.toList());
        }
        return entityColumn;
    }

    private final void initFactor() {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.billType.getEntityId());
        if (type == null) {
            this.billFactors = new ArrayList<String>(16);
            this.invoiceFactors = new ArrayList<String>(16);
            this.otherInvoiceFactors = new ArrayList<String>(16);
            return;
        }
        this.billFactors = this.loadBillFactor((DynamicObjectType)type);
        this.invoiceFactors = this.loadInvoiceFactor((DynamicObjectType)type);
        this.otherInvoiceFactors = this.loadOtherInvoiceFactor((DynamicObjectType)type);
    }

    private Map<String, Object> buildInvoiceFactorBo(Set<String> invoiceFactors, InvoiceItemEntryBO invoiceItemEntryBO) throws Exception {
        HashMap<String, Object> invoiceFactorMap = new HashMap<String, Object>(invoiceFactors.size());
        invoiceFactorMap.put("inv_ext_goodnames", invoiceItemEntryBO.getGoodsName());
        invoiceFactorMap.put("inv_ext_buyerorgname", invoiceItemEntryBO.getInvoiceEntryBO().getBuyerOrgName());
        invoiceFactorMap.put("inv_ext_startcity", invoiceItemEntryBO.getInvoiceEntryBO().getStartCity());
        invoiceFactorMap.put("inv_ext_destcity", invoiceItemEntryBO.getInvoiceEntryBO().getDestCity());
        invoiceFactorMap.put("inv_invoicetype", invoiceItemEntryBO.getInvoiceEntryBO().getInvoiceType());
        invoiceFactorMap.put("inv_ratetype", invoiceItemEntryBO.getGoodsCode());
        InvoiceEntryBO invoiceEntryBO = invoiceItemEntryBO.getInvoiceEntryBO();
        Map headCustomFields = invoiceEntryBO.getCustomFields();
        Map itemCustomFields = invoiceItemEntryBO.getCustomFields();
        for (String invoiceFactor : invoiceFactors) {
            Method method;
            String field = invoiceFactor.replaceFirst("inv_", "").replaceFirst("ext_", "").toLowerCase();
            String getMethodName = "get" + field;
            Object value = null;
            if (this.itemFieldNameList.contains(field) && this.getItemMethodMap.containsKey(getMethodName)) {
                method = this.getItemMethodMap.get(getMethodName);
                value = method.invoke((Object)invoiceItemEntryBO, new Object[0]);
            } else if (this.headFieldNameList.contains(field) && this.getHeadMethodMap.containsKey(getMethodName)) {
                method = this.getHeadMethodMap.get(getMethodName);
                value = method.invoke((Object)invoiceEntryBO, new Object[0]);
            } else if (itemCustomFields != null && itemCustomFields.containsKey(field)) {
                value = itemCustomFields.get(field);
            } else if (headCustomFields != null && headCustomFields.containsKey(field)) {
                value = headCustomFields.get(field);
            }
            if (value != null) {
                invoiceFactorMap.put(invoiceFactor, value);
                continue;
            }
            log.error("not find this field " + invoiceFactor + ", please check model.");
        }
        return invoiceFactorMap;
    }

    private void factorMapItem(List<RelationBO> mappingItemBo, List<String> priorityList, StringBuilder logBuilder) throws Exception {
        Long orgId = ErCommonUtils.getPk(this.dataEntity.getDynamicObject(this.billType.getOrgClumn()));
        HashMap mapItemCache = Maps.newHashMapWithExpectedSize((int)1);
        Set itemIdsByBizItem = this.inBizItemRange();
        Long defaultItem = this.getTripDefaultItem(orgId);
        Map<String, Object> billFactor = this.billFactors(priorityList);
        HashSet<String> allInvoiceFactors = new HashSet<String>(this.invoiceFactors.size() + this.otherInvoiceFactors.size());
        allInvoiceFactors.addAll(this.invoiceFactors);
        allInvoiceFactors.addAll(this.otherInvoiceFactors);
        List<InvoiceItemEntryBO> invoiceItemEntryBOs = this.invoiceContext.getInvoiceItemEntryBOs();
        for (InvoiceItemEntryBO invoiceItemEntryBO : invoiceItemEntryBOs) {
            Long itemId;
            StringBuilder sb = new StringBuilder();
            sb.append(invoiceItemEntryBO.getGoodsName());
            sb.append(invoiceItemEntryBO.getInvoiceEntryBO().getBuyerOrgName());
            sb.append(invoiceItemEntryBO.getInvoiceEntryBO().getStartCity());
            sb.append(invoiceItemEntryBO.getInvoiceEntryBO().getDestCity());
            sb.append(invoiceItemEntryBO.getInvoiceEntryBO().getInvoiceType());
            sb.append(invoiceItemEntryBO.getGoodsCode());
            String cacheKey = sb.toString();
            Long cacheItemId = (Long)mapItemCache.get(cacheKey);
            if (cacheItemId != null) {
                log.debug("cache item cacheKey: " + cacheKey + ", cacheItemId: " + cacheItemId);
                invoiceItemEntryBO.setExpenseItemId(cacheItemId);
                invoiceItemEntryBO.setItemEnum(this.billType.getItemEnum());
                continue;
            }
            ArrayList maxList = Lists.newArrayList();
            Map<String, Object> invoiceFactor = this.buildInvoiceFactorBo(allInvoiceFactors, invoiceItemEntryBO);
            String invoiceItemFactors = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u660e\u7ec6\u56e0\u7d20map\uff1a%s", (String)"MappingItemWithOrgInvoiceServiceImp_0", (String)"fi-er-business", (Object[])new Object[0]), SerializationUtils.toJsonString(invoiceFactor));
            logBuilder.append(invoiceItemFactors).append("\r\n");
            String mappingModelStr = ResManager.loadKDString((String)"\u6620\u5c04\u914d\u7f6e\u6a21\u578b\uff1a%s; ", (String)"MappingItemWithOrgInvoiceServiceImp_5", (String)"fi-er-business", (Object[])new Object[0]);
            String mappingPriority = ResManager.loadKDString((String)"\u6620\u5c04\u56e0\u7d20\uff1a%s, ", (String)"MappingItemWithOrgInvoiceServiceImp_1", (String)"fi-er-business", (Object[])new Object[0]);
            String mappingResultStr = ResManager.loadKDString((String)"\u6620\u5c04\u547d\u4e2d\uff1a%s; ", (String)"MappingItemWithOrgInvoiceServiceImp_2", (String)"fi-er-business", (Object[])new Object[0]);
            String mappingConfigResultStr = ResManager.loadKDString((String)"\u6700\u7ec8\u6620\u5c04\u914d\u7f6e\u7ed3\u679c\uff1a%s; ", (String)"MappingItemWithOrgInvoiceServiceImp_6", (String)"fi-er-business", (Object[])new Object[0]);
            String mappingAccordStr = ResManager.loadKDString((String)"\u6620\u5c04\u5339\u914d\u547d\u4e2d\u6b21\u6570\uff1a%s; ", (String)"MappingItemWithOrgInvoiceServiceImp_7", (String)"fi-er-business", (Object[])new Object[0]);
            for (RelationBO relationBO : mappingItemBo) {
                Object reBillType;
                relationBO.init();
                String mappingModelLogStr = String.format(mappingModelStr, SerializationUtils.toJsonString((Object)relationBO.getNumber()));
                logBuilder.append(mappingModelLogStr).append("\r\n");
                String autoMapFormula = relationBO.getAutoMapFormula();
                if ("2".equals(autoMapFormula) && StringUtils.equals((CharSequence)(reBillType = this.changerEnum()), (CharSequence)relationBO.getRelbilltype())) {
                    relationBO.setRightCount(1);
                }
                reBillType = priorityList.iterator();
                while (reBillType.hasNext()) {
                    String mappingResult;
                    boolean isHit;
                    Object relationFactor;
                    String key = (String)reBillType.next();
                    String priorityKey = String.format(mappingPriority, key);
                    logBuilder.append(priorityKey);
                    if (StringUtils.contains((CharSequence)key, (CharSequence)"inv_ext_")) {
                        this.mapInvoiceFactor(key, String.valueOf(invoiceFactor.get(key)), relationBO, logBuilder);
                    } else if (StringUtils.contains((CharSequence)key, (CharSequence)"inv_")) {
                        relationFactor = relationBO.getFactorInfo(key);
                        if (this.invoiceContext.getInvoiceConfig().isPreciseMatch() && relationFactor == null) continue;
                        isHit = this.mapFactors(invoiceFactor.get(key), relationFactor, key);
                        mappingResult = String.format(mappingResultStr, isHit);
                        logBuilder.append(mappingResult).append("\r\n");
                        relationBO.setMapResult(isHit, key);
                    } else {
                        relationFactor = relationBO.getFactorInfo(key);
                        if (this.invoiceContext.getInvoiceConfig().isPreciseMatch() && relationFactor == null) continue;
                        isHit = this.mapFactors(billFactor.get(key), relationFactor, key);
                        mappingResult = String.format(mappingResultStr, isHit);
                        logBuilder.append(mappingResult).append("\r\n");
                        relationBO.setMapResult(isHit, key);
                    }
                    if (!this.invoiceContext.getInvoiceConfig().isPreciseMatch() || relationBO.getRightCount() >= 0) continue;
                    break;
                }
                logBuilder.append(String.format(mappingAccordStr, relationBO.getAccordWith())).append("\r\n").append("\r\n");
                if (relationBO.getAccordWith() <= 0) continue;
                if (maxList.isEmpty()) {
                    maxList.add(relationBO);
                    continue;
                }
                RelationBO oldRelationBo = (RelationBO)maxList.get(0);
                int result = oldRelationBo.compareTo(relationBO);
                switch (result) {
                    case -1: {
                        maxList.clear();
                        maxList.add(relationBO);
                        break;
                    }
                    case 0: {
                        maxList.add(relationBO);
                    }
                }
            }
            if (this.invoiceContext.getInvoiceConfig().isOutLog()) {
                log.info(logBuilder.toString());
                logBuilder.setLength(0);
                String mappingConfigResult = String.format(mappingConfigResultStr, SerializationUtils.toJsonString((Object)maxList));
                log.info(mappingConfigResult);
            }
            if (Objects.equals(itemId = this.mapping(maxList, priorityList, orgId), 0L) && BillType.TripItem == this.billType) {
                itemId = defaultItem;
            }
            if (itemIdsByBizItem.size() > 0 && !itemIdsByBizItem.contains(itemId)) {
                itemId = 0L;
            }
            mapItemCache.put(cacheKey, itemId);
            invoiceItemEntryBO.setExpenseItemId(itemId);
            invoiceItemEntryBO.setItemEnum(this.billType.getItemEnum());
        }
    }

    public static enum BillType {
        ExpenseItem("1", "expenseitem", ItemEnum.EXPENSE_ITEM, "costcompany", "er_rel_expense_ratetype"),
        TripItem("2", "tripitem", ItemEnum.TRIP_ITEM, "company", "er_rel_tripitem_ratetype");

        private String type;
        private String item;
        private ItemEnum itemEnum;
        private String orgClumn;
        private String entityId;

        private BillType(String type, String item, ItemEnum itemEnum, String orgClumn, String entityId) {
            this.type = type;
            this.item = item;
            this.itemEnum = itemEnum;
            this.orgClumn = orgClumn;
            this.entityId = entityId;
        }

        public String getType() {
            return this.type;
        }

        public String getItem() {
            return this.item;
        }

        public ItemEnum getItemEnum() {
            return this.itemEnum;
        }

        public String getOrgClumn() {
            return this.orgClumn;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }
    }
}

