/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.GroupKey;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceService;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.constant.StdConfigConstant;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import kd.fi.er.common.model.invoice.merge.ItemEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class NoMergeInvoiceServiceImpl
extends MergeInvoiceService {
    private String entityName;

    public NoMergeInvoiceServiceImpl(InvoiceContext invoiceContext, String entityNameForExpenseItem, IDataModel model) {
        super(invoiceContext);
        this.entityName = entityNameForExpenseItem;
        this.setModel(model);
        this.setUseExpenseDate(invoiceContext.getInvoiceConfig().isUseExpenseDate());
    }

    @Deprecated
    public NoMergeInvoiceServiceImpl(InvoiceContext invoiceContext, String entityNameForExpenseItem, IDataModel model, boolean useExpenseDate) {
        super(invoiceContext);
        this.entityName = entityNameForExpenseItem;
        this.setModel(model);
        this.setUseExpenseDate(useExpenseDate);
    }

    @Override
    public void process() {
        List<InvoiceItemEntryBO> invoiceItemEntryBOs = this.invoiceContext.getInvoiceItemEntryBOs();
        Set goodCodeSet = invoiceItemEntryBOs.stream().map(invoiceItemEntry -> invoiceItemEntry.getGoodsCode()).collect(Collectors.toSet());
        Map taxClassCodeDOs = BusinessDataServiceHelper.loadFromCache((String)"er_taxclasscode", (String)"id, mergecode", (QFilter[])new QFilter[]{new QFilter("mergecode", "in", goodCodeSet)});
        HashMap mergeCodeToIds = new HashMap();
        taxClassCodeDOs.forEach((k, v) -> mergeCodeToIds.put(v.getString("mergecode"), Long.valueOf(k.toString())));
        Set negtiveInvoiceItemKeys = invoiceItemEntryBOs.stream().filter(invoiceItemBO -> ErStdConfig.isMergeNegtiveInvoiceItem() && invoiceItemBO.getExcludeAmount().compareTo(BigDecimal.ZERO) <= 0).map(invoiceItemBO -> this.genNegtiveGroupBy((InvoiceItemEntryBO)invoiceItemBO)).collect(Collectors.toSet());
        ArrayList negtiveInvoiceItemEntryBO = Lists.newArrayList();
        for (InvoiceItemEntryBO invoiceItemBO2 : invoiceItemEntryBOs) {
            NegtiveInvoiceItemKey groupKey2 = this.genNegtiveGroupBy(invoiceItemBO2);
            if (negtiveInvoiceItemKeys.contains(groupKey2)) {
                negtiveInvoiceItemEntryBO.add(invoiceItemBO2);
                continue;
            }
            Long taxCodeId = mergeCodeToIds.getOrDefault(groupKey2.getGoodCode(), 0L);
            ExpenseEntryBO expenseEntryBO = this.genExpenseEntryBOByInvoiceItemBO(groupKey2, Collections.singletonList(invoiceItemBO2), taxCodeId);
            invoiceItemBO2.setExpenseEntryBO(expenseEntryBO);
            this.invoiceContext.getExpenseEntryBOs().add(expenseEntryBO);
        }
        if (!negtiveInvoiceItemEntryBO.isEmpty()) {
            Map<NegtiveInvoiceItemKey, List<InvoiceItemEntryBO>> keyToInvoiceItemEntryBOs = negtiveInvoiceItemEntryBO.stream().collect(Collectors.groupingBy(invoiceItemBO -> this.genNegtiveGroupBy((InvoiceItemEntryBO)invoiceItemBO)));
            keyToInvoiceItemEntryBOs.forEach((groupKey, invoiceItems) -> {
                Long taxCodeId = mergeCodeToIds.getOrDefault(groupKey.getGoodCode(), 0L);
                ExpenseEntryBO expenseEntryBO = this.genExpenseEntryBOByInvoiceItemBO((GroupKey)groupKey, (List<InvoiceItemEntryBO>)invoiceItems, taxCodeId);
                invoiceItems.forEach(invoiceItem -> invoiceItem.setExpenseEntryBO(expenseEntryBO));
                this.invoiceContext.getExpenseEntryBOs().add(expenseEntryBO);
            });
        }
        this.updateLinkDetail();
    }

    private NegtiveInvoiceItemKey genNegtiveGroupBy(InvoiceItemEntryBO invoiceItemBO) {
        NegtiveInvoiceItemKey groupKey = new NegtiveInvoiceItemKey();
        InvoiceEntryBO invoiceHeadBO = invoiceItemBO.getInvoiceEntryBO();
        groupKey.setGoodCode(invoiceItemBO.getGoodsCode());
        groupKey.setInvoiceType(invoiceHeadBO.getInvoiceType());
        groupKey.setItemId(invoiceItemBO.getExpenseItemId());
        groupKey.setTaxRate(invoiceItemBO.getInvoiceItemTaxRate());
        groupKey.setSerialNo(invoiceHeadBO.getSerialNo());
        return groupKey;
    }

    private ExpenseEntryBO genExpenseEntryBOByInvoiceItemBO(GroupKey groupKey, List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs, Long taxClassCodeId) {
        boolean invoicesCredits = this.invoiceContext.getInvoiceConfig().isInvoicesCredits();
        long entryId = ORM.create().genLongId(this.entityName);
        ExpenseEntryBO expenseEntryBO = new ExpenseEntryBO();
        expenseEntryBO.setEntryId(Long.valueOf(entryId));
        expenseEntryBO.setExpenseItemId(groupKey.getItemId());
        if (Objects.equals(this.invoiceContext.getInvoiceConfig().getExpenseDateValue(), StdConfigConstant.EXPENSE_DATE_VALUE_HEAD) && this.getUseExpenseDate()) {
            expenseEntryBO.setHappenDate((Date)this.getModel().getValue("bizdate"));
        } else {
            expenseEntryBO.setHappenDate(groupedInvoiceItemEntryBOs.get(0).getInvoiceEntryBO().getInvoiceDate());
        }
        BigDecimal airportConstructionFeeAmount = groupedInvoiceItemEntryBOs.stream().map(itemBo -> (BigDecimal)ObjectUtils.defaultIfNull((Object)itemBo.getInvoiceEntryBO().getAirportConstructionFee(), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        expenseEntryBO.setAirportConstructionFee(airportConstructionFeeAmount);
        Boolean isOffset = invoicesCredits ? Boolean.valueOf(groupedInvoiceItemEntryBOs.stream().anyMatch(invoiceItem -> invoiceItem.getInvoiceItemOffset())) : Boolean.valueOf(groupedInvoiceItemEntryBOs.stream().anyMatch(invoiceItem -> invoiceItem.getInvoiceCloudOffset()));
        expenseEntryBO.setInvoiceIsOffset(isOffset);
        expenseEntryBO.setIsOffset(isOffset);
        Set<String> set = InvoiceTypeUtils.loadSpecialInvoiceTypes();
        boolean isSpecialInvoice = groupedInvoiceItemEntryBOs.stream().allMatch(invoiceItem -> set.contains(invoiceItem.getInvoiceEntryBO().getInvoiceType()));
        expenseEntryBO.setIsSpecialInvoice(Boolean.valueOf(isSpecialInvoice));
        expenseEntryBO.setInvoiceItemEntryVOs(groupedInvoiceItemEntryBOs);
        expenseEntryBO.setTaxClassCodeId(taxClassCodeId);
        Optional<InvoiceItemEntryBO> invoiceItemBOWithGoodNameOP = groupedInvoiceItemEntryBOs.stream().filter(invoiceItemBO -> StringUtils.isNotBlank((CharSequence)invoiceItemBO.getGoodsName())).findFirst();
        if (invoiceItemBOWithGoodNameOP.isPresent()) {
            expenseEntryBO.setGoodName(invoiceItemBOWithGoodNameOP.get().getGoodsName());
        } else {
            expenseEntryBO.setGoodName("");
        }
        Set invoiceNoList = groupedInvoiceItemEntryBOs.stream().map(itemBo -> itemBo.getInvoiceEntryBO().getInvoiceNo()).collect(Collectors.toSet());
        Set invoiceCodeList = groupedInvoiceItemEntryBOs.stream().map(itemBo -> itemBo.getInvoiceEntryBO().getInvoiceCode()).collect(Collectors.toSet());
        expenseEntryBO.setInvoiceNoUnion(StringUtils.join(invoiceNoList, (String)","));
        expenseEntryBO.setInvoiceCodeUnion(StringUtils.join(invoiceCodeList, (String)","));
        expenseEntryBO.setTaxRate(groupKey.getTaxRate());
        BigDecimal taxAmount = groupedInvoiceItemEntryBOs.stream().map(invoiceItem -> invoiceItem.getInvoiceItemTaxAmout()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (!this.invoiceContext.getInvoiceConfig().isImportNonDeductionTaxAmout()) {
            Stream<InvoiceItemEntryBO> entryBOStream = invoicesCredits ? groupedInvoiceItemEntryBOs.stream().filter(v -> v.getInvoiceItemOffset()) : groupedInvoiceItemEntryBOs.stream().filter(v -> v.getInvoiceCloudOffset());
            BigDecimal reComputTaxAmount = entryBOStream.map(invoiceItem -> invoiceItem.getInvoiceItemTaxAmout()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (taxAmount.compareTo(reComputTaxAmount) != 0 || reComputTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                expenseEntryBO.setTaxRate(BigDecimal.ZERO);
            }
            taxAmount = reComputTaxAmount;
        }
        expenseEntryBO.setTaxAmount(taxAmount);
        this.setOffset(groupedInvoiceItemEntryBOs, expenseEntryBO);
        BigDecimal totalAmount = groupedInvoiceItemEntryBOs.stream().map(invoiceItem -> invoiceItem.getTotalAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        expenseEntryBO.setTotalAmount(totalAmount);
        BigDecimal notIncludeTaxAmount = !this.invoiceContext.getInvoiceConfig().isImportNonDeductionTaxAmout() ? totalAmount.subtract(taxAmount) : groupedInvoiceItemEntryBOs.stream().map(invoiceItem -> invoiceItem.getExcludeAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        expenseEntryBO.setNotIncludeTaxAmount(notIncludeTaxAmount);
        expenseEntryBO.setInvoiceType(groupKey.getInvoiceType());
        expenseEntryBO.setEntryCurrencyId(groupedInvoiceItemEntryBOs.get(0).getInvoiceEntryBO().getInvoiceCurrencyId());
        return expenseEntryBO;
    }

    private void setOffset(List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs, ExpenseEntryBO expenseEntryBO) {
        Boolean isItemOffset = false;
        Boolean isInvoiceOffset = this.invoiceContext.getInvoiceConfig().isInvoicesCredits() ? Boolean.valueOf(groupedInvoiceItemEntryBOs.stream().anyMatch(invoiceItem -> invoiceItem.getInvoiceItemOffset())) : Boolean.valueOf(groupedInvoiceItemEntryBOs.stream().anyMatch(invoiceItem -> invoiceItem.getInvoiceCloudOffset()));
        if (expenseEntryBO.getExpenseItemId() != null && expenseEntryBO.getExpenseItemId() != 0L) {
            ItemEnum item = groupedInvoiceItemEntryBOs.get(0).getItemEnum();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)expenseEntryBO.getExpenseItemId(), (String)item.getEntityName());
            isItemOffset = dynamicObject.getBoolean(item.getOffsetName());
        }
        expenseEntryBO.setInvoiceIsOffset(isInvoiceOffset);
        boolean orgOffset = this.invoiceContext.getInvoiceConfig().isOrgOffset();
        expenseEntryBO.setIsOffset(Boolean.valueOf(isInvoiceOffset != false && isItemOffset != false && orgOffset));
        if (expenseEntryBO.getIsOffset().booleanValue()) {
            expenseEntryBO.setOffsetAmount(expenseEntryBO.getTaxAmount());
        } else {
            expenseEntryBO.setOffsetAmount(BigDecimal.ZERO);
        }
        expenseEntryBO.setItemInOutAmount(expenseEntryBO.getTaxAmount().subtract(expenseEntryBO.getOffsetAmount()));
    }

    static class NegtiveInvoiceItemKey
    extends GroupKey {
        private String serialNo;

        NegtiveInvoiceItemKey() {
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.goodCode == null ? 0 : this.goodCode.hashCode());
            result = 31 * result + (this.invoiceType == null ? 0 : this.invoiceType.hashCode());
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + (this.serialNo == null ? 0 : this.serialNo.hashCode());
            result = 31 * result + (this.taxRate == null ? 0 : this.taxRate.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NegtiveInvoiceItemKey other = (NegtiveInvoiceItemKey)obj;
            if (this.goodCode == null ? other.goodCode != null : !this.goodCode.equals(other.goodCode)) {
                return false;
            }
            if (this.invoiceType == null ? other.invoiceType != null : !this.invoiceType.equals(other.invoiceType)) {
                return false;
            }
            if (this.itemId == null ? other.itemId != null : !this.itemId.equals(other.itemId)) {
                return false;
            }
            if (this.serialNo == null ? other.serialNo != null : !this.serialNo.equals(other.serialNo)) {
                return false;
            }
            return !(this.taxRate == null ? other.taxRate != null : this.taxRate.compareTo(other.taxRate) != 0);
        }

        public String getSerialNo() {
            return this.serialNo;
        }

        public void setSerialNo(String serialNo) {
            this.serialNo = serialNo;
        }
    }
}

