/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.InvoiceProcessMessage;
import kd.fi.er.common.model.invoice.InvoiceProcessResult;
import kd.fi.er.common.model.invoice.InvoiceVO;

public class RemoveDuplicateInvoiceServiceImpl
extends RemoveInvoiceService {
    private static final Log logger = LogFactory.getLog(RemoveDuplicateInvoiceServiceImpl.class);
    private static final String INVOICE_ENTRY = "invoiceentry";
    private IDataModel dataModel;
    private IDataModel pDataModel;

    public RemoveDuplicateInvoiceServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
    }

    @Deprecated
    public RemoveDuplicateInvoiceServiceImpl(InvoiceContext invoiceContext, Set<String> serialNos, IDataModel dataModel) {
        this(invoiceContext, serialNos, dataModel, null);
    }

    @Deprecated
    public RemoveDuplicateInvoiceServiceImpl(InvoiceContext invoiceContext, Set<String> serialNos, IDataModel dataModel, IDataModel pDataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
        this.pDataModel = pDataModel;
    }

    @Override
    public void process() {
        InvoiceProcessResult ipr = new InvoiceProcessResult();
        this.invoiceContext.getInvoiceResult().put(this.getClass().getName(), ipr);
        ipr.setServiceName(this.getClass().getName());
        this.removeEmptySerialNosVo();
        List<InvoiceVO> invoiceVOs = this.invoiceContext.getInvoiceVOs();
        HashSet<InvoiceVO> duplicates = new HashSet<InvoiceVO>(1);
        Iterator<InvoiceVO> iterator = invoiceVOs.iterator();
        while (iterator.hasNext()) {
            InvoiceVO vo = iterator.next();
            if (!this.serialNos.contains(vo.getSerialNo())) continue;
            duplicates.add(vo);
            iterator.remove();
        }
        if (duplicates.size() > 0) {
            String dupSerialInfo = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e0a\u5df2\u6709\u53d1\u7968\u5e8f\u5217\u53f7\uff1a%1$s\uff0c\u91cd\u590d\u7684\u53d1\u7968\uff1a%2$s", (String)"RemoveDuplicateInvoiceServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), this.serialNos, duplicates.stream().map(invoice -> invoice.getInvoiceNo()).collect(Collectors.toList()));
            ipr.getProcessResult().add(new InvoiceProcessMessage(dupSerialInfo, "info"));
            Set<String> eTypes = InvoiceTypeUtils.loadEInvoiceTypes();
            Set eInvoiceVos = duplicates.stream().filter(e -> eTypes.contains(e.getInvoiceType())).collect(Collectors.toSet());
            String dupInvoiceInfo = String.format(ResManager.loadKDString((String)"\u7535\u5b50\u53d1\u7968\u7c7b\u578b\uff1a%1$s\uff0c\u91cd\u590d\u7684\u7535\u5b50\u53d1\u7968\uff1a%2$s", (String)"RemoveDuplicateInvoiceServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]), eTypes, eInvoiceVos.stream().map(invoice -> invoice.getInvoiceNo()).collect(Collectors.toList()));
            logger.info(dupSerialInfo + dupInvoiceInfo);
            ipr.getProcessResult().add(new InvoiceProcessMessage(dupInvoiceInfo, "info"));
            if (eInvoiceVos.size() > 0) {
                Map<String, String> validateMap = eInvoiceVos.stream().collect(Collectors.toMap(InvoiceVO::getSerialNo, i -> i.getValidateMessage() == null ? "" : i.getValidateMessage(), (a1, a2) -> a2));
                this.updateValidateMessage(validateMap, this.dataModel);
                this.updateValidateMessage(validateMap, this.pDataModel);
            }
        }
    }

    private void updateValidateMessage(Map<String, String> validateMap, IDataModel dataModel) {
        if (dataModel == null) {
            return;
        }
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        if (dataEntity.getDynamicObjectType().getProperty(INVOICE_ENTRY) == null) {
            return;
        }
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection(INVOICE_ENTRY);
        Set<String> eInvoiceSerialNos = validateMap.keySet();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)collection.get(i);
            String serialNo = entry.getString("serialno");
            if (!eInvoiceSerialNos.contains(serialNo)) continue;
            dataModel.setValue("validatemessage", (Object)InvoiceUtils.getLimitedValidateMessage(validateMap.get(serialNo)), i);
        }
    }
}

