/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.isc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.fileservice.ErFileUtils;
import kd.fi.er.business.isc.DynamicObjConverToMapUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;

public class IscHelper {
    private static final Log logger = LogFactory.getLog(IscHelper.class);
    private static final String TRIGGER_ENTITY = "isc_data_copy_trigger";
    private static final String SERVICEFLOW_ENTITY = "isc_service_flow";
    private static final String DATATRIGGER = "dataTrigger";
    private static final String SERVICEFLOW = "serviceFlow";
    private static final String EXECUTENOW = "executeNow";
    public static final String ACTIONID_ISOVERRIDEIMPORT = "isOverrideImport";
    private static final String TRIPREQBILL = "er_tripreqbill";
    private static final String TRIPREQLOANBILL = "er_triploanbill";
    private static final String TRIPREIMBILL_GRID = "er_tripreimbill_grid";
    private static final String ISC_DB_LINK_NUMBER = "isc_database_link_number";
    private static final String ISC_DB_SOURCE_NUMBER = "isc_data_source_number";
    public static final String IS_QUERY_EAS_BUDGET_NOW = "is_query_eas_budget_now";
    private static final String SYNC_EAS_COMMON_FACADE = "facade://com.kingdee.eas.cp.bc.app.FetchDataFacade:syncData4ng";
    private static final String SYNC_EAS_GETAPPROVE = "facade://com.kingdee.eas.cp.bc.app.FetchDataFacade:getApprove";
    private static final String SYNC_EAS_COMMON_FACADE_METHOD = "method";
    private static final String SYNC_EAS_COMMON_FACADE_DATA = "dataJson";
    public static final String EAS_METHOD_CHECKBUDGET = "checkEASBillBudget";
    public static final String EAS_METHOD_CHECKBUDGETWITHRETURN = "checkEASBillBudgetReturn";
    public static final String EAS_METHOD_CHECKBUDGETAFTERBGRETURN = "checkEASBillBudgetAfterBgReturn";
    public static final String EAS_METHOD_QUERYBUDGET = "queryEASBillBudget";
    public static final String EAS_METHOD_QUERYBUDGET_BTN = "btnQueryEASBillBudget";
    public static String jsonuri = " ";

    public static Map<String, Object> getEasId(String entityName, Object businessKey) {
        String rulenumber = IscHelper.getRuleNumber(entityName, businessKey);
        if (StringUtils.isNotEmpty((CharSequence)rulenumber)) {
            int extendType = 2;
            try {
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"findMappingValue", (Object[])new Object[]{rulenumber, businessKey.toString(), extendType});
                logger.info("\u7ed3\u675f\u8c03\u7528\u96c6\u6210\u670d\u52a1\u4e91findMappingValue");
                if (Boolean.TRUE.equals(result.get("success"))) {
                    return result;
                }
            }
            catch (Exception e) {
                logger.error("EAS\u96c6\u6210,\u62a5\u9519", (Throwable)e);
            }
        }
        return null;
    }

    private static String getRuleNumber(String entityName, Object businessKey) {
        if (TRIPREQBILL.equals(entityName)) {
            DynamicObject reqbill = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)TRIPREQBILL, (String)"isloan");
            entityName = IscHelper.getKeyInISCSetting(reqbill);
        }
        return IscHelper.getISCSettingValue(entityName);
    }

    public static String getKeyInISCSetting(DynamicObject billDo) {
        boolean isTripReqLoan;
        String entityName = billDo.getDynamicObjectType().getName();
        if (TRIPREQBILL.equals(entityName) && (isTripReqLoan = billDo.getBoolean("isloan"))) {
            entityName = TRIPREQLOANBILL;
        }
        return entityName;
    }

    public static String getEasBgIscNumber(DynamicObject billDo) {
        String entityName = IscHelper.getKeyInISCSetting(billDo);
        String easBgIscNumber = IscHelper.getEasShareBgIscNumber(billDo);
        if (easBgIscNumber == null) {
            easBgIscNumber = IscHelper.getISCSettingValue(entityName + "_isc_eas_budget");
        }
        logger.info(String.format("\u5355\u636e%s\u83b7\u53d6\u5230\u7684\u9884\u7b97\u542f\u52a8\u65b9\u6848\u7f16\u7801\u4e3a\uff1a%s", billDo.getDataEntityType().getDisplayName().getLocaleValue(), easBgIscNumber));
        return easBgIscNumber;
    }

    public static boolean isEasShareBudget(String iscNumber) {
        return iscNumber.contains("_share(IERP-EAS)");
    }

    public static String getEasShareBgIscNumber(DynamicObject billDo) {
        String entityName = IscHelper.getKeyInISCSetting(billDo);
        DynamicObjectType billDt = billDo.getDynamicObjectType();
        DataEntityPropertyCollection billProperties = billDt.getProperties();
        if (StringUtils.equalsIgnoreCase((CharSequence)entityName, (CharSequence)"er_tripreimbursebill") && billProperties.get((Object)"billkind") != null && billDo.getString("billkind").equals("1")) {
            entityName = TRIPREIMBILL_GRID;
        }
        String result = null;
        if (billProperties.get((Object)"isbeforeshare") != null && billDo.getBoolean("isbeforeshare")) {
            String shareBgIscNumber = IscHelper.getISCSettingValue(entityName + "_eas_shareBudget");
            if (shareBgIscNumber == null || shareBgIscNumber.isEmpty()) {
                logger.info(String.format("IscHelper>>>[iscSetting key=%s]\u5df2\u542f\u7528\u5206\u644a\u9884\u7b97\u67e5\u8be2\uff0c\u4f46\u672a\u627e\u5230\u76f8\u5e94\u7684\u9884\u7b97\u96c6\u6210\u65b9\u6848\u3002", entityName));
            } else {
                logger.info(String.format("IscHelper>>>[iscSetting key=%s]\u5df2\u542f\u7528\u5206\u644a\u9884\u7b97\u67e5\u8be2\uff0c\u5bf9\u5e94\u7684\u96c6\u6210\u65b9\u6848\u7f16\u7801\u4e3a\uff1a%s", entityName, shareBgIscNumber));
                result = shareBgIscNumber;
            }
        } else {
            logger.info(String.format("IscHelper>>>[iscSetting key=%s]\u672a\u542f\u7528\u5206\u644a\u9884\u7b97\u67e5\u8be2\u3002", entityName));
        }
        return result;
    }

    public static String getISCSettingValue(String key) {
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((String)"er_isc_setting", (String)"id,entryentity.key,entryentity.value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"setting")});
        if (setting != null) {
            DynamicObjectCollection collection = setting.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < collection.size(); ++i) {
                if (!((DynamicObject)collection.get(i)).get("key").equals(key)) continue;
                return ((DynamicObject)collection.get(i)).getString("value");
            }
        }
        return null;
    }

    public static Map<String, Object> getErLinkMap() {
        DynamicObjectCollection coll;
        HashMap map = Maps.newHashMap();
        QFilter qFilter = new QFilter("slnName", "=", (Object)"eas");
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject dbConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"er_config_webservice", (String)"id, f7propery.key, f7propery.val", (QFilter[])filters);
        if (dbConfig != null && (coll = dbConfig.getDynamicObjectCollection("f7propery")) != null && coll.size() > 0) {
            for (DynamicObject obj : coll) {
                map.put(obj.getString("key"), obj.getString("val"));
            }
        }
        return map;
    }

    public static Map<String, Object> getIscLinkMap(String iscNumber) {
        DynamicObject linkInfo = null;
        try {
            linkInfo = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"getConnInfoByTriggerNumber", (Object[])new Object[]{iscNumber, Boolean.FALSE});
        }
        catch (Exception e) {
            logger.error(String.format("EAS\u96c6\u6210,\u6839\u636e\u65b9\u6848\u7f16\u7801%s,\u8c03\u7528\u96c6\u6210\u4e91\u672a\u83b7\u53d6\u5230\u76ee\u6807\u7cfb\u7edf\u8fde\u63a5\u4fe1\u606f,\u5f02\u5e38\u4fe1\u606f:", iscNumber), (Throwable)e);
            return null;
        }
        if (linkInfo == null) {
            logger.info("EAS\u96c6\u6210,\u6839\u636e\u65b9\u6848\u7f16\u7801\u672a\u83b7\u53d6\u5230\u76ee\u6807\u7cfb\u7edf\u8fde\u63a5\u4fe1\u606f");
            return null;
        }
        return IscHelper.buildIscLinkMap(linkInfo);
    }

    public static Map<String, Object> buildIscLinkMap(DynamicObject linkInfo) {
        if (linkInfo == null) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        try {
            String ip_port = linkInfo.getString("server_ip").concat(":").concat(linkInfo.getString("server_port"));
            map.put("ip_port", ip_port);
            map.put("userName", linkInfo.get("user"));
            map.put("password", linkInfo.get("password"));
            map.put("slnName", "eas");
            map.put("dcName", linkInfo.get("data_center"));
            map.put("language", "l2");
            map.put("http_protocal", linkInfo.get("http_protocal"));
        }
        catch (Exception e) {
            logger.error("EAS\u96c6\u6210,\u96c6\u6210\u4e91\u8fde\u63a5\u914d\u7f6e\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5\u8fde\u63a5\u914d\u7f6e\u3002\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            return null;
        }
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((String)"er_isc_setting", (String)"dbtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"setting")});
        if (setting == null || setting.get("dbtype") == null) {
            logger.info("EAS\u96c6\u6210,\u96c6\u6210\u4e91\u8bbe\u7f6e[er_isc_setting]\u529f\u80fd\u672a\u8bbe\u7f6e\u6570\u636e\u5e93\u7c7b\u578b");
            return null;
        }
        map.put("dbType", setting.get("dbtype"));
        return map;
    }

    private static Map<String, Object> buildTargetBillMap(DynamicObject srcBill, String number) {
        logger.info("EAS\u96c6\u6210,\u82cd\u7a79\u6839\u636e\u96c6\u6210\u65b9\u6848\u7f16\u7801\u8f6c\u6362EAS\u5355\u636e\u5b9e\u4f53,\u96c6\u6210\u65b9\u6848\u7f16\u7801:" + number);
        DynamicObject newSrcBill = srcBill;
        logger.info("EAS\u96c6\u6210,\u82cd\u7a79\u5355\u636e\u5b9e\u4f53\u4e3a:" + SerializationUtils.toJsonString((Object)newSrcBill));
        Map<String, Object> srcBillMap = DynamicObjConverToMapUtil.convertDynamicObjToMap(newSrcBill);
        logger.info("EAS\u96c6\u6210,\u82cd\u7a79\u5355\u636e\u7b80\u8981\u5b9e\u4f53\u4e3a:" + SerializationUtils.toJsonString(srcBillMap));
        ArrayList<Map<String, Object>> srcBillList = new ArrayList<Map<String, Object>>();
        srcBillList.add(srcBillMap);
        Map convertBillMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"translate", (Object[])new Object[]{number, srcBillList});
        if (convertBillMap == null || convertBillMap.size() < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u96c6\u6210\u65b9\u6848\u7f16\u7801\u8f6c\u6362EAS\u5355\u636e\u5b9e\u4f53\u5931\u8d25\uff0c\u8f6c\u6362\u540e\u5b9e\u4f53\u4e3a\u7a7a\u3002", (String)"IscHelper_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        if (!Boolean.parseBoolean(String.valueOf(convertBillMap.get("success")))) {
            Object msg = convertBillMap.get("msg");
            String errorMsg = null;
            if (msg != null) {
                errorMsg = String.valueOf(msg);
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u6839\u636e\u96c6\u6210\u65b9\u6848\u7f16\u7801\u8f6c\u6362EAS\u5355\u636e\u5b9e\u4f53\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f:%s", (String)"IscHelper_1", (String)"fi-er-business", (Object[])new Object[0]), errorMsg));
        }
        Map targetBillMap = (Map)((List)convertBillMap.get("data")).get(0);
        logger.info("EAS\u96c6\u6210,\u8f6c\u6362\u540e\u7684EAS\u5355\u636e\u5b9e\u4f53\u4e3a:" + SerializationUtils.toJsonString((Object)targetBillMap));
        return targetBillMap;
    }

    public static String buildTargetBillJson(DynamicObject srcBill, String number) {
        Map<String, Object> targetBillMap = IscHelper.buildTargetBillMap(srcBill, number);
        if (targetBillMap.get("budgetDo") == null) {
            targetBillMap.put("budgetDo", BigDecimal.valueOf(0.0));
        }
        if (targetBillMap.get("entries") != null) {
            List entrys = (List)targetBillMap.get("entries");
            for (Map entry : entrys) {
                if (entry.get("id") != null) {
                    entry.remove("id");
                }
                if (entry.get("budgetDo") == null) {
                    entry.put("budgetDo", BigDecimal.valueOf(0.0));
                }
                if (entry.get("budgetDoOri") != null) continue;
                entry.put("budgetDoOri", BigDecimal.valueOf(0.0));
            }
        }
        return SerializationUtils.toJsonString(targetBillMap);
    }

    public static Object doEASFacade(String method, Object dataJson) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        paramsMap.put(SYNC_EAS_COMMON_FACADE_METHOD, method);
        paramsMap.put(SYNC_EAS_COMMON_FACADE_DATA, dataJson);
        return IscHelper.doEASBudgetFacade(SYNC_EAS_COMMON_FACADE, paramsMap);
    }

    private static Object doEASBudgetFacade(String facade, Map<String, Object> paramsMap) {
        String ds_number = IscHelper.getISCSettingValue(ISC_DB_SOURCE_NUMBER);
        Object responseData = null;
        if (!StringUtils.isBlank((CharSequence)ds_number)) {
            responseData = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscMetaSchemaService", (String)"callService", (Object[])new Object[]{ds_number, facade, paramsMap, null});
            logger.info("EAS\u96c6\u6210,\u6267\u884c\u76ee\u6807\u7cfb\u7edffacade,\u65b0\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a:" + SerializationUtils.toJsonString((Object)responseData));
            return responseData;
        }
        String cn_number = IscHelper.getISCSettingValue(ISC_DB_LINK_NUMBER);
        if (StringUtils.isBlank((CharSequence)cn_number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5728\u201c\u96c6\u6210\u4e91\u8bbe\u7f6e>\u8fde\u63a5\u914d\u7f6e\u201d\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7f16\u7801\u7684\u914d\u7f6e\u9879\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IscHelper_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        responseData = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"callFacadeService", (Object[])new Object[]{cn_number, facade, paramsMap});
        logger.info("EAS\u96c6\u6210,\u6267\u884c\u76ee\u6807\u7cfb\u7edffacade,\u65e7\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a:" + SerializationUtils.toJsonString((Object)responseData));
        return responseData;
    }

    private static Object doEASWorkFlowFacade(String facade, Map<String, Object> paramsMap) {
        Object responseData = null;
        String cn_number = IscHelper.getISCSettingValue(ISC_DB_LINK_NUMBER);
        if (StringUtils.isBlank((CharSequence)cn_number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5728\u201c\u96c6\u6210\u4e91\u8bbe\u7f6e>\u8fde\u63a5\u914d\u7f6e\u201d\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7f16\u7801\u7684\u914d\u7f6e\u9879\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IscHelper_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        responseData = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"callFacadeService", (Object[])new Object[]{cn_number, facade, paramsMap});
        logger.info("EAS\u96c6\u6210,\u6267\u884c\u76ee\u6807\u7cfb\u7edffacade,\u65e7\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a:" + SerializationUtils.toJsonString((Object)responseData));
        return responseData;
    }

    private static String getDataSourceNumber(String cn_number) {
        Map isc_data_source = BusinessDataServiceHelper.loadFromCache((String)"isc_data_source", null);
        Optional<DynamicObject> dataSourceDbLink = isc_data_source.values().stream().filter(d -> {
            DynamicObject dblink = d.getDynamicObject("dblink");
            return dblink != null && cn_number.equals(dblink.getString("number"));
        }).findFirst();
        if (dataSourceDbLink.isPresent()) {
            String ds_number = dataSourceDbLink.get().getString("number");
            DynamicObject er_isc_setting = BusinessDataServiceHelper.loadSingle((String)"er_isc_setting", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"setting")});
            DynamicObjectCollection entryentity = er_isc_setting.getDynamicObjectCollection("entryentity");
            DynamicObject addNew = entryentity.addNew();
            addNew.set("key", (Object)ISC_DB_SOURCE_NUMBER);
            addNew.set("value", (Object)ds_number);
            addNew.set("desc", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u3010\u6570\u636e\u6e90\u7ba1\u7406\u5217\u8868\u3011EAS\u6570\u636e\u6e90\u7684\u7f16\u7801", (String)"IscHelper_14", (String)"fi-er-business", (Object[])new Object[0]));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{er_isc_setting});
            return ds_number;
        }
        return null;
    }

    public static String getEasApproves(String easId) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(1);
        paramsMap.put("billId", easId);
        Object approves = IscHelper.doEASWorkFlowFacade(SYNC_EAS_GETAPPROVE, paramsMap);
        return approves == null ? null : approves.toString();
    }

    public static String getExceptionDescription(String error) {
        if (StringUtils.isBlank((CharSequence)error)) {
            return "";
        }
        int start = error.lastIndexOf("BgControlException:");
        start = start == -1 ? error.lastIndexOf("Exception:") + 10 : (start += 19);
        String substring = error.substring(start);
        int end = substring.indexOf("at");
        if (end == -1 || end > 200) {
            end = substring.length() > 200 ? 200 : substring.length();
        }
        return error.substring(start, start + end);
    }

    public static Object execBudgetService(String flowNumber, String method, String targetJson) {
        String cn_number = IscHelper.getISCSettingValue(ISC_DB_LINK_NUMBER);
        if (StringUtils.isBlank((CharSequence)cn_number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5728\u201c\u96c6\u6210\u4e91\u8bbe\u7f6e>\u8fde\u63a5\u914d\u7f6e\u201d\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7f16\u7801\u7684\u914d\u7f6e\u9879\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IscHelper_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        ArrayList inputs = Lists.newArrayList((Object[])new Object[]{cn_number, method, targetJson});
        Map<String, Object> responseData = IscHelper.doISCFlowService(flowNumber, inputs);
        if (!"false".equals(responseData.get("errorCode"))) {
            Map output = (Map)responseData.get("output");
            return output.get("budgetResult");
        }
        throw new KDException(new ErrorCode("", ""), new Object[]{(String)responseData.get("message")});
    }

    private static Map<String, Object> doISCFlowService(String flowNumber, List<Object> inputs) {
        logger.info(String.format("doISCFlowService :flowNumber:%s,inputs:%s", flowNumber, StringUtils.join((Object[])new List[]{inputs})));
        Map responseData = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"execute", (Object[])new Object[]{flowNumber, inputs});
        logger.info("\u6267\u884ciscflow,\u8fd4\u56de\u4fe1\u606f\u4e3a:" + SerializationUtils.toJsonString((Object)responseData));
        return responseData;
    }

    public static void importConfirmCallBack(MessageBoxClosedEvent evt, IFormView view) throws IOException {
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (StringUtils.equals((CharSequence)ACTIONID_ISOVERRIDEIMPORT, (CharSequence)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            IscHelper.importDTS(view);
        }
    }

    public static String checkISCSelfishConnection() {
        String failureMsg = "";
        String dataBaseLinkEntityId = "isc_database_link";
        Map dataBaseLinksDO = BusinessDataServiceHelper.loadFromCache((String)dataBaseLinkEntityId, (String)"", (QFilter[])new QFilter[]{new QFilter("dum_link", "=", (Object)"0COJ5GJ+UJWT")});
        DynamicObject dataBaseLinkDO = null;
        if (dataBaseLinksDO.size() < 1) {
            MainEntityType dataBaseLinkDT = MetadataServiceHelper.getDataEntityType((String)dataBaseLinkEntityId);
            DynamicObject dataBaseLinkDTO = new DynamicObject((DynamicObjectType)dataBaseLinkDT);
            dataBaseLinkDTO.set("number", (Object)"PREINS_SELF");
            dataBaseLinkDTO.set("name", (Object)ResManager.loadKDString((String)"\u9884\u7f6e\u5f53\u524d\u8d26\u5957\u8fde\u63a5", (String)"IscHelper_10", (String)"fi-er-business", (Object[])new Object[0]));
            dataBaseLinkDTO.set("database_type", (Object)"self");
            dataBaseLinkDTO.set("dum_link", (Object)"0COJ5GJ+UJWT");
            dataBaseLinkDTO.set("isv", (Object)"kingdee.fi.er");
            Object[] dataBaseLinkDOs = SaveServiceHelper.save((IDataEntityType)dataBaseLinkDT, (Object[])new Object[]{dataBaseLinkDTO});
            if (dataBaseLinkDOs.length == 1) {
                dataBaseLinkDO = (DynamicObject)dataBaseLinkDOs[0];
                logger.info("IscHelper>>>checkISCSelfishConnection:\u6ca1\u6709\u627e\u5230\u81ea\u8fde\u63a5\u7c7b\u578b\u7684\u8fde\u63a5\u914d\u7f6e\u3002\u65b0\u521b\u5efa\u7684\u8fde\u63a5\u914d\u7f6epk\uff1a" + ErCommonUtils.getPk(dataBaseLinkDO));
            }
        } else {
            dataBaseLinkDO = dataBaseLinksDO.values().toArray(new DynamicObject[0])[0];
            logger.info("IscHelper>>>checkISCSelfishConnection:\u4f7f\u7528\u5ba2\u6237\u81ea\u5df1\u7684\u81ea\u8fde\u63a5\u7c7b\u578b\u8fde\u63a5\u914d\u7f6e\u3002pk\uff1a" + ErCommonUtils.getPk(dataBaseLinkDO));
        }
        failureMsg = IscHelper.outputFailureMsg(OperationServiceHelper.executeOperate((String)"test", (String)dataBaseLinkEntityId, (Object[])new Object[]{ErCommonUtils.getPk(dataBaseLinkDO)}, (OperateOption)OperateOption.create()), null);
        if (failureMsg.isEmpty()) {
            String dataSourceManageEntityId = "isc_data_source";
            DynamicObject[] dataSourceManageDOs = BusinessDataServiceHelper.load((String)dataSourceManageEntityId, (String)"number,name,dblink,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"KDIERP")});
            if (dataSourceManageDOs == null || dataSourceManageDOs.length == 0) {
                MainEntityType dataSourceManageDT = MetadataServiceHelper.getDataEntityType((String)dataSourceManageEntityId);
                DynamicObject dataSourceManageDO = new DynamicObject((DynamicObjectType)dataSourceManageDT);
                dataSourceManageDO.set("number", (Object)"KDIERP");
                dataSourceManageDO.set("name", (Object)ResManager.loadKDString((String)"\u9884\u7f6e\u5f53\u524d\u82cd\u7a79", (String)"IscHelper_11", (String)"fi-er-business", (Object[])new Object[0]));
                dataSourceManageDO.set("dblink", (Object)dataBaseLinkDO);
                dataSourceManageDO.set("enable", (Object)"1");
                dataSourceManageDOs = new DynamicObject[]{dataSourceManageDO};
            } else {
                DynamicObject finalDataBaseLinkDO = dataBaseLinkDO;
                Arrays.stream(dataSourceManageDOs).forEach(e -> e.set("dblink", (Object)finalDataBaseLinkDO));
            }
            SaveServiceHelper.save((DynamicObject[])dataSourceManageDOs);
        }
        return failureMsg;
    }

    public static Map<String, DynamicObject[]> checkExistBefore(IFormView view, boolean isShowMsg) throws IOException {
        HashMap<String, DynamicObject[]> existDtsMap = new HashMap<String, DynamicObject[]>();
        if ("bos_list".equals(view.getFormShowParameter().getFormId()) && "er_contractbill".equals(((ListShowParameter)view.getFormShowParameter()).getBillFormId())) {
            jsonuri = "bill";
            dtsRegister.dataTrigger.clear();
            dtsRegister.dataTrigger.add((Object)dtsBillRegister.dataTrigger.toJSONString());
            dtsRegister.serviceFlow.add((Object)(dtsBillRegister.serviceFlow == null ? null : dtsBillRegister.serviceFlow.toJSONString()));
            dtsRegister.executeNow = dtsBillRegister.executeNow;
        } else {
            jsonuri = "report";
        }
        String selfishConnectionMsg = IscHelper.checkISCSelfishConnection();
        if (!selfishConnectionMsg.isEmpty()) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u81ea\u8eab\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a\n%1$s", (String)"IscHelper_9", (String)"fi-er-business", (Object[])new Object[0]), selfishConnectionMsg));
            return existDtsMap;
        }
        logger.info("IscHelper#checkExistBefore>>>" + dtsRegister.dataTrigger.toJSONString());
        DynamicObject[] dataTriggerDO = BusinessDataServiceHelper.load((String)TRIGGER_ENTITY, (String)"id,number,enable,trigger_type,expired_time", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)dtsRegister.dataTrigger)});
        if (dataTriggerDO.length != 0) {
            existDtsMap.put(DATATRIGGER, dataTriggerDO);
        }
        logger.info("IscHelper#checkExistBefore>>>" + dtsRegister.serviceFlow.toJSONString());
        DynamicObject[] serviceFlowDO = BusinessDataServiceHelper.load((String)SERVICEFLOW_ENTITY, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)dtsRegister.serviceFlow)});
        if (serviceFlowDO.length != 0) {
            existDtsMap.put(SERVICEFLOW, serviceFlowDO);
        }
        if (dataTriggerDO.length == 0 && serviceFlowDO.length == 0) {
            IscHelper.importDTS(view);
        }
        if (isShowMsg && (dataTriggerDO.length != 0 || serviceFlowDO.length != 0)) {
            view.showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8986\u76d6\u5bfc\u5165\uff1f", (String)"IscHelper_7", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u5b58\u5728\u542f\u52a8\u65b9\u6848\u53ca\u670d\u52a1\u6d41\u7a0b\uff0c\u82e5\u9009\u62e9\u8986\u76d6\u5bfc\u5165\u5219\u4f1a\u5c06\u4ee5\u524d\u6570\u636e\u96c6\u6210\u65b9\u6848\u7684\u4fee\u6539\u6e05\u9664\u6389\u3002\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u5c06\u4f1a\u8986\u76d6\u5bfc\u5165\uff0c\u201c\u53d6\u6d88\u201d\u5219\u4e0d\u5bfc\u5165\u3002", (String)"IscHelper_8", (String)"fi-er-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(ACTIONID_ISOVERRIDEIMPORT));
        }
        return existDtsMap;
    }

    private static void importDTS(IFormView view) throws IOException {
        String uri = "";
        uri = "bos_list".equals(view.getFormShowParameter().getFormId()) && "er_contractbill".equals(((ListShowParameter)view.getFormShowParameter()).getBillFormId()) ? "bill" : "report";
        ErFileUtils.checkFileExists(uri + "/");
        ErFileUtils.impoortDTSFile(uri);
        if (IscHelper.enableDts(view) && IscHelper.executeDtsNow()) {
            view.showMessage(ResManager.loadKDString((String)"\u62a5\u8868\u4e00\u952e\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"IscHelper_5", (String)"fi-er-business", (Object[])new Object[0]));
        }
    }

    private static boolean enableDts(IFormView view) throws IOException {
        String failureMsg;
        Map<String, DynamicObject[]> existDtsMap = IscHelper.checkExistBefore(view, false);
        DynamicObject[] dataTriggerDO = existDtsMap.get(DATATRIGGER);
        OperationResult enableDataTriggerResult = OperationServiceHelper.executeOperate((String)"enable", (String)TRIGGER_ENTITY, (DynamicObject[])dataTriggerDO, (OperateOption)OperateOption.create());
        if (!enableDataTriggerResult.isSuccess() && !(failureMsg = IscHelper.outputFailureMsg(enableDataTriggerResult, errorInfo -> !errorInfo.getErrorCode().equals("errorcode_001"))).isEmpty()) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u542f\u7528\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a\n%1$s", (String)"IscHelper_4", (String)"fi-er-business", (Object[])new Object[0]), failureMsg));
            return false;
        }
        DynamicObject[] serviceFlowDO = existDtsMap.get(SERVICEFLOW);
        OperationResult enableSerivceFlowResult = OperationServiceHelper.executeOperate((String)"release", (String)SERVICEFLOW_ENTITY, (DynamicObject[])serviceFlowDO, (OperateOption)OperateOption.create());
        if (!enableSerivceFlowResult.isSuccess()) {
            String failureMsg2 = IscHelper.outputFailureMsg(enableSerivceFlowResult, null);
            if (!failureMsg2.isEmpty()) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u542f\u7528\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a\n%1$s", (String)"IscHelper_6", (String)"fi-er-business", (Object[])new Object[0]), failureMsg2));
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean executeDtsNow() {
        JSONObject executeNowJSONObject = dtsRegister.executeNow;
        JSONArray dataTriggerNumbers = (JSONArray)executeNowJSONObject.get((Object)DATATRIGGER);
        List dataTriggerExecuteResults = dataTriggerNumbers.stream().map(number -> {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"execute", (Object[])new Object[]{number, null, null});
            if (result != null) {
                return (String)result.get("trigger_number");
            }
            return null;
        }).collect(Collectors.toList());
        JSONArray serviceFlowNumbers = (JSONArray)executeNowJSONObject.get((Object)SERVICEFLOW);
        List serviceFlowExecuteResults = serviceFlowNumbers.stream().map(number -> (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{number})).collect(Collectors.toList());
        return dataTriggerNumbers.size() == dataTriggerExecuteResults.size() && serviceFlowNumbers.size() == serviceFlowExecuteResults.size();
    }

    private static String outputFailureMsg(OperationResult operationResult, Predicate<OperateErrorInfo> predicate) {
        return operationResult.getValidateResult().getValidateErrors().stream().flatMap(e -> e.getAllErrorInfo().stream()).filter(Optional.ofNullable(predicate).orElse(errorInfo -> Boolean.TRUE)).map(OperateInfo::getMessage).collect(Collectors.joining("\n"));
    }

    public static void readDts(Resource[] resources) {
        Arrays.stream(resources).forEach(e -> {
            try {
                IscHelper.readDts(ErFileUtils.readFile(e.getInputStream()));
            }
            catch (IOException ioException) {
                logger.error("IscHelper>>>readDts:\u5bfc\u5165dts\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)ioException);
            }
        });
    }

    public static void readDts(String str) {
        DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResourceWithPattern", (Object[])new Object[]{str, true});
    }

    public static boolean isDtsFile(File file) {
        return Arrays.asList(file.getName().split("\\.")).contains("dts");
    }

    public static boolean isIntegratedWithEAS() {
        return IscHelper.getPresetDataSourceOfEAS() != null;
    }

    public static DynamicObject getPresetDataSourceOfEAS() {
        return IscHelper.getPresetDataSource(646975250281566208L);
    }

    public static boolean isIntegratedWithXK() {
        return IscHelper.getPresetDataSourceOfXK() != null;
    }

    public static DynamicObject getPresetDataSourceOfXK() {
        return IscHelper.getPresetDataSource(772210344872678400L);
    }

    private static DynamicObject getPresetDataSource(long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"isc_data_source", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public static class dtsBillRegister {
        static JSONArray dataTrigger;
        static JSONArray serviceFlow;
        static JSONObject executeNow;

        static {
            String dtsRegisterJSONStr = ErFileUtils.readFile(ErFileUtils.checkFileExists("bill/dtsRegister.json"));
            JSONObject dtsRegster = (JSONObject)JSONObject.parse((String)dtsRegisterJSONStr);
            dataTrigger = (JSONArray)dtsRegster.get((Object)IscHelper.DATATRIGGER);
            serviceFlow = (JSONArray)dtsRegster.get((Object)IscHelper.SERVICEFLOW);
            executeNow = (JSONObject)dtsRegster.get((Object)IscHelper.EXECUTENOW);
        }
    }

    public static class dtsRegister {
        static JSONArray dataTrigger;
        static JSONArray serviceFlow;
        static JSONObject executeNow;

        static {
            String dtsRegisterJSONStr = ErFileUtils.readFile(ErFileUtils.checkFileExists("report/dtsRegister.json"));
            JSONObject dtsRegster = (JSONObject)JSONObject.parse((String)dtsRegisterJSONStr);
            dataTrigger = (JSONArray)dtsRegster.get((Object)IscHelper.DATATRIGGER);
            serviceFlow = (JSONArray)dtsRegster.get((Object)IscHelper.SERVICEFLOW);
            executeNow = (JSONObject)dtsRegster.get((Object)IscHelper.EXECUTENOW);
        }
    }
}

