/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.log;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logorm.LogORM;
import kd.bos.multilang.MultiLangEnumBridge;
import kd.fi.er.common.model.invoice.InvoiceVO;

public class InvoiceLogUtils {
    private static final MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_invoicelog");

    public static void insertLog(InvoiceOpType opType, String billNo, String desc, String logInfo) {
        ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>();
        RequestContext requestContext = RequestContext.get();
        String userName = requestContext.getUserName() + "(" + requestContext.getCurrUserId() + ")";
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
        dynamicObject.getDataEntityType().getPrimaryKey().setValueFast((Object)dynamicObject, (Object)ID.genLongId());
        dynamicObject.set("username", (Object)userName);
        dynamicObject.set("opname", (Object)opType.getType());
        dynamicObject.set("opdesc", (Object)(desc.length() >= 200 ? desc.substring(0, 200) : desc));
        dynamicObject.set("opdate", (Object)new Date());
        dynamicObject.set("optype", (Object)opType.getValue());
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("loginfo", (Object)(logInfo.length() >= 200 ? logInfo.substring(0, 200) : logInfo));
        dynamicObject.set("loginfo_tag", (Object)logInfo);
        dynamicObject.set("traceid", (Object)RequestContext.get().getTraceId());
        logList.add(dynamicObject);
        LogORM logORM = LogORM.create();
        logORM.insert(logList);
    }

    public static void insertLogBatch(InvoiceOpType opType, String desc, Map<String, String> logInfos) {
        if (logInfos == null) {
            return;
        }
        ArrayList logList = new ArrayList(logInfos.size());
        RequestContext requestContext = RequestContext.get();
        String userName = requestContext.getUserName() + "(" + requestContext.getCurrUserId() + ")";
        String traceId = RequestContext.get().getTraceId();
        logInfos.forEach((billNo, log) -> {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
            dynamicObject.getDataEntityType().getPrimaryKey().setValueFast((Object)dynamicObject, (Object)ID.genLongId());
            dynamicObject.set("username", (Object)userName);
            dynamicObject.set("opname", (Object)opType.getType());
            dynamicObject.set("opdesc", (Object)(desc.length() >= 200 ? desc.substring(0, 200) : desc));
            dynamicObject.set("opdate", (Object)new Date());
            dynamicObject.set("optype", (Object)opType.getValue());
            dynamicObject.set("billno", billNo);
            dynamicObject.set("loginfo", (Object)(log.length() >= 200 ? log.substring(0, 200) : log));
            dynamicObject.set("loginfo_tag", log);
            dynamicObject.set("traceid", (Object)traceId);
            logList.add(dynamicObject);
        });
        LogORM logORM = LogORM.create();
        logORM.insert(logList);
    }

    public static void insertLog(InvoiceOpType opType, String billNo, String invoiceNo, String serialNo, String desc, String logInfo) {
        ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>();
        RequestContext requestContext = RequestContext.get();
        String userName = requestContext.getUserName() + "(" + requestContext.getCurrUserId() + ")";
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
        dynamicObject.getDataEntityType().getPrimaryKey().setValueFast((Object)dynamicObject, (Object)ID.genLongId());
        dynamicObject.set("username", (Object)userName);
        dynamicObject.set("opname", (Object)opType.getType());
        dynamicObject.set("opdesc", (Object)(desc.length() >= 200 ? desc.substring(0, 200) : desc));
        dynamicObject.set("opdate", (Object)new Date());
        dynamicObject.set("optype", (Object)opType.getValue());
        dynamicObject.set("billno", (Object)billNo);
        dynamicObject.set("invoiceno", (Object)invoiceNo);
        dynamicObject.set("serialno", (Object)serialNo);
        dynamicObject.set("loginfo", (Object)(logInfo.length() >= 200 ? logInfo.substring(0, 200) : logInfo));
        dynamicObject.set("loginfo_tag", (Object)logInfo);
        dynamicObject.set("traceid", (Object)Thread.currentThread().getId());
        logList.add(dynamicObject);
        LogORM logORM = LogORM.create();
        logORM.insert(logList);
    }

    public static void insertBatchLog(InvoiceOpType opType, String billNo, String desc, List<InvoiceVO> invoiceVo) {
        ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(invoiceVo.size());
        RequestContext requestContext = RequestContext.get();
        String userName = requestContext.getUserName() + "(" + requestContext.getCurrUserId() + ")";
        for (InvoiceVO invoice : invoiceVo) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
            dynamicObject.getDataEntityType().getPrimaryKey().setValueFast((Object)dynamicObject, (Object)ID.genLongId());
            dynamicObject.set("username", (Object)userName);
            dynamicObject.set("opname", (Object)opType.getType());
            dynamicObject.set("opdesc", (Object)(desc.length() >= 200 ? desc.substring(0, 200) : desc));
            dynamicObject.set("opdate", (Object)new Date());
            dynamicObject.set("optype", (Object)opType.getValue());
            dynamicObject.set("billno", (Object)billNo);
            dynamicObject.set("invoiceno", (Object)invoice.getInvoiceNo());
            dynamicObject.set("serialno", (Object)invoice.getSerialNo());
            dynamicObject.set("loginfo", (Object)(invoice.toString().length() >= 200 ? invoice.toString().substring(0, 200) : invoice.toString()));
            dynamicObject.set("loginfo_tag", (Object)invoice.toString());
            dynamicObject.set("traceid", (Object)requestContext.getTraceId());
            logList.add(dynamicObject);
        }
        LogORM logORM = LogORM.create();
        logORM.insert(logList);
    }

    public static enum InvoiceOpType {
        WEB_REQUEST("\u7f51\u7edc\u4ea4\u4e92", "0", new MultiLangEnumBridge("\u7f51\u7edc\u4ea4\u4e92", "InvoiceLogUtils_0", "fi-er-business")),
        INVOICE_ORI_INFO("\u53d1\u7968\u539f\u59cb\u4fe1\u606f", "1", new MultiLangEnumBridge("\u53d1\u7968\u539f\u59cb\u4fe1\u606f", "InvoiceLogUtils_1", "fi-er-business")),
        VOUCHER_WRITE_BACK("\u51ed\u8bc1\u53cd\u5199", "2", new MultiLangEnumBridge("\u51ed\u8bc1\u53cd\u5199", "InvoiceLogUtils_2", "fi-er-business")),
        SECOND_DEV("\u4e8c\u5f00\u8c03\u7528", "3", new MultiLangEnumBridge("\u4e8c\u5f00\u8c03\u7528", "InvoiceLogUtils_3", "fi-er-business")),
        BILLING_POOL_CREATE("\u8d26\u5355\u6c60\u751f\u6210", "4", new MultiLangEnumBridge("\u8d26\u5355\u6c60\u751f\u6210", "InvoiceLogUtils_4", "fi-er-business")),
        NOTIFY_SHARE("\u901a\u77e5\u5171\u4eab", "4", new MultiLangEnumBridge("\u901a\u77e5\u5171\u4eab", "InvoiceLogUtils_5", "fi-er-business"));

        private String type;
        private String value;
        private String desc;

        private InvoiceOpType(String type, String value, MultiLangEnumBridge multiLangEnumBridge) {
            this.type = type;
            this.value = value;
            this.desc = multiLangEnumBridge.loadKDString();
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

