/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.log;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.trace.util.TraceIdUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.opplugin.daily.web.datalogplugin.dataloghandle.ErDataLogHandle;
import kd.fi.er.opplugin.daily.web.datalogplugin.dataloghandle.dataloghandleimpl.LoanBillDataLogHandle;
import kd.fi.er.opplugin.daily.web.datalogplugin.dataloghandle.dataloghandleimpl.PrePayBillDataLogHandle;
import kd.fi.er.opplugin.daily.web.datalogplugin.dataloghandle.dataloghandleimpl.ReimburseBillDataLogHandle;
import kd.fi.er.opplugin.daily.web.datalogplugin.dataloghandle.dataloghandleimpl.TripReimburseBillDataLogHandle;
import org.apache.commons.lang3.StringUtils;

public class LogUtils {
    private static Log logger = LogFactory.getLog(LogUtils.class);
    public static final String FORM_IN_BEFORE = "form plugin in beforeDoOperation";
    public static final String FORM_IN_AFTER = "form plugin in afterDoOperation";
    public static final String OP_IN_BEFORE = "op plugin in beforeExecuteOperationTransaction";
    public static final String OP_IN_BEGIN = "op plugin in beginOperationTransaction";
    public static final String OP_IN_END = "op plugin in endOperationTransaction";
    public static final String OP_IN_AFTER = "op plugin in afterExecuteOperationTransaction";

    public static void insertDataLog(DynamicObject dataEntity, String entityId, String opkey, String opdesc, String formId) {
        String dataLogLevel = LogUtils.getDataLogLevel();
        if (StringUtils.equalsIgnoreCase((CharSequence)dataLogLevel, (CharSequence)"off")) {
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)dataLogLevel, (CharSequence)"debug") && !StringUtils.equalsAny((CharSequence)opdesc, (CharSequence[])new CharSequence[]{FORM_IN_BEFORE, OP_IN_AFTER})) {
            return;
        }
        try {
            if (!(ErEntityTypeUtils.isTripReimburseBill(entityId) || ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId) || ErEntityTypeUtils.isDailyLoanBill(entityId) || ErEntityTypeUtils.isPrePayBill(entityId))) {
                return;
            }
            String userName = RequestContext.get().getUserName();
            String maintraceId = TraceIdUtil.getCurrentTraceIdString();
            ThreadService.execute(() -> {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_datalog");
                DynamicObject dataLog = new DynamicObject((DynamicObjectType)entityType);
                dataLog.set("username", (Object)userName);
                dataLog.set("opname", (Object)opkey);
                dataLog.set("opdesc", (Object)opdesc);
                dataLog.set("billno", dataEntity.get("billno"));
                dataLog.set("billentity", (Object)entityId);
                dataLog.set("formid", (Object)formId);
                dataLog.set("traceid", (Object)maintraceId);
                ErDataLogHandle dataLogHandle = LogUtils.getDataLogHandle(entityId);
                if (dataLogHandle == null) {
                    return;
                }
                JSONObject billJsonObj = dataLogHandle.getbillJsonObj(dataEntity);
                if (billJsonObj != null) {
                    dataLog.set("largedata", (Object)StringUtils.substring((String)billJsonObj.toString(), (int)0, (int)60));
                    dataLog.set("largedata_tag", (Object)billJsonObj.toString());
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                list.add(dataLog);
                LogORM logORM = LogORM.create();
                logORM.insert(list);
            }, (TaskType)TaskType.ER_LOG_TASK, (RequestContext)RequestContext.get());
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165datalog\u5931\u8d25", (Throwable)e);
        }
    }

    public static void insertDataLogBatch(DynamicObject[] dataEntitys, String opkey, String opdesc, String formId) {
        String dataLogLevel = LogUtils.getDataLogLevel();
        if (StringUtils.equalsIgnoreCase((CharSequence)dataLogLevel, (CharSequence)"off")) {
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)dataLogLevel, (CharSequence)"debug")) {
            if (!StringUtils.equalsAny((CharSequence)opdesc, (CharSequence[])new CharSequence[]{FORM_IN_BEFORE, OP_IN_AFTER})) {
                return;
            }
        }
        String userName = RequestContext.get().getUserName();
        String mainTraceid = TraceIdUtil.getCurrentTraceIdString();
        ThreadService.execute(() -> {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dataEntitys.length);
            for (DynamicObject dataEntity : dataEntitys) {
                String entityId = dataEntity.getDataEntityType().getName();
                if (!ErEntityTypeUtils.isTripReimburseBill(entityId) && !ErEntityTypeUtils.isDailyReimburseBill(entityId) && !ErEntityTypeUtils.isPublicReimburseBill(entityId) && !ErEntityTypeUtils.isDailyLoanBill(entityId) && !ErEntityTypeUtils.isPrePayBill(entityId)) continue;
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_datalog");
                DynamicObject dataLog = new DynamicObject((DynamicObjectType)entityType);
                dataLog.set("username", (Object)userName);
                dataLog.set("opname", (Object)opkey);
                dataLog.set("opdesc", (Object)opdesc);
                dataLog.set("billno", dataEntity.get("billno"));
                dataLog.set("billentity", (Object)entityId);
                dataLog.set("formid", (Object)formId);
                dataLog.set("traceid", (Object)mainTraceid);
                ErDataLogHandle dataLogHandle = LogUtils.getDataLogHandle(entityId);
                if (dataLogHandle == null) {
                    return;
                }
                JSONObject billJsonObj = dataLogHandle.getbillJsonObj(dataEntity);
                if (billJsonObj != null) {
                    dataLog.set("largedata", (Object)StringUtils.substring((String)billJsonObj.toString(), (int)0, (int)60));
                    dataLog.set("largedata_tag", (Object)billJsonObj.toString());
                }
                list.add(dataLog);
            }
            if (list.size() > 0) {
                LogORM logORM = LogORM.create();
                logORM.insert(list);
            }
        }, (TaskType)TaskType.ER_LOG_TASK, (RequestContext)RequestContext.get());
    }

    public static ErDataLogHandle getDataLogHandle(String entityId) {
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            return new ReimburseBillDataLogHandle();
        }
        if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            return new TripReimburseBillDataLogHandle();
        }
        if (ErEntityTypeUtils.isDailyLoanBill(entityId)) {
            return new LoanBillDataLogHandle();
        }
        if (ErEntityTypeUtils.isPrePayBill(entityId)) {
            return new PrePayBillDataLogHandle();
        }
        return null;
    }

    public static JSONObject getHeadJsonObj(DynamicObject dataEntity, HashSet<String> headFields) {
        JSONObject headJsonObj = new JSONObject();
        for (String headField : headFields) {
            headJsonObj.put(headField, dataEntity.get(headField));
            LogUtils.setJsonByField(headJsonObj, dataEntity, headField);
        }
        return headJsonObj;
    }

    public static JSONArray getEntryJsonObj(DynamicObject dataEntity, String entryName, HashSet<String> entryFields) {
        JSONArray entryJsonArray = new JSONArray();
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(entryName);
        for (DynamicObject rowObject : entryColl) {
            JSONObject rowJsonObj = new JSONObject();
            for (String entryfield : entryFields) {
                LogUtils.setJsonByField(rowJsonObj, rowObject, entryfield);
            }
            entryJsonArray.add((Object)rowJsonObj);
        }
        return entryJsonArray;
    }

    public static JSONArray getEntryJsonObj(DynamicObject dataEntity, String parentEntryName, HashSet<String> parentEntryFields, String subEntryName, HashSet<String> subEntryFields) {
        JSONArray parentEntryJsonArray = new JSONArray();
        DynamicObjectCollection parentEntryColl = dataEntity.getDynamicObjectCollection(parentEntryName);
        for (DynamicObject parentEntry : parentEntryColl) {
            JSONObject parentJsonObj = new JSONObject();
            for (String parentEntryField : parentEntryFields) {
                LogUtils.setJsonByField(parentJsonObj, parentEntry, parentEntryField);
            }
            JSONArray subEntryJsonArray = LogUtils.getEntryJsonObj(parentEntry, subEntryName, subEntryFields);
            parentJsonObj.put(subEntryName, (Object)subEntryJsonArray);
            parentEntryJsonArray.add((Object)parentJsonObj);
        }
        return parentEntryJsonArray;
    }

    private static void setJsonByField(JSONObject jsonObj, DynamicObject dynamicObject, String field) {
        Object value = dynamicObject.get(field);
        if (value instanceof BigDecimal) {
            jsonObj.put(field, (Object)((BigDecimal)value).stripTrailingZeros().toPlainString());
        } else if (value instanceof DynamicObject) {
            jsonObj.put(field, (Object)("id:" + ((DynamicObject)value).get("id") + ",name:" + ((DynamicObject)value).getString("name")));
        } else if (value == null) {
            jsonObj.put(field, null);
        }
    }

    public static String LogStackTraceStr(StackTraceElement[] stackTraces) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement stackTrace : stackTraces) {
            sb.append(stackTrace).append("\r\n");
        }
        return sb.toString();
    }

    public static String getDataLogLevel() {
        return ErStdConfig.get("datalog.level");
    }
}

