/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.messagepublish;

import java.util.Date;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.messagepublish.ErMqHelper;
import org.apache.commons.lang3.StringUtils;

public class ErrorHandle {
    private static final String LINE_ENDING = "\r\n";
    private static final Log logger = LogFactory.getLog(ErrorHandle.class);

    public static String toEasErrorInfoHandle(Throwable e, MessageAcker ack, ErMqHelper erMqHelper) {
        String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0eEAS\u540c\u6b65\u5f02\u5e38", (String)"ErrorHandle_0", (String)"fi-er-business", (Object[])new Object[0]);
        String bizErrorInfo = "";
        msg = msg + ",";
        try {
            String throwInfo = e.toString();
            bizErrorInfo = throwInfo.indexOf(ResManager.loadKDString((String)"\u4e1a\u52a1\u6743\u9650", (String)"ErrorHandle_1", (String)"fi-er-business", (Object[])new Object[0])) != -1 ? ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\u88ab\u62d2\u7edd\u3002\u82e5\u60a8\u6700\u8fd1\u6709\u53d1\u751f\u804c\u4f4d\u6216\u7ec4\u7ec7\u53d8\u52a8\uff0c\u8bf7\u8054\u7edc\u7ba1\u7406\u5458\u8fdb\u884c\u8d4b\u6743\u64cd\u4f5c\u3002\u8d4b\u6743\u5b8c\u6210\u540e\u7cfb\u7edf\u4f1a\u81ea\u52a8\u4e3a\u60a8\u91cd\u65b0\u540c\u6b65\u5355\u636e\u3002", (String)"ErrorHandle_2", (String)"fi-er-business", (Object[])new Object[0]) : (StringUtils.containsAny((CharSequence)throwInfo, (CharSequence[])new CharSequence[]{"Connection refused", "Read timed out", "java.net.SocketTimeoutException", "(0)null"}) ? ("fileUpload".equals(erMqHelper.getOperate()) ? ResManager.loadKDString((String)"\u7f51\u7edc\u4e0d\u901a\u7545\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\u3002\u82e5\u5ba1\u6838\u4eba\u770b\u4e0d\u5230\u9644\u4ef6\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u3002\u7f51\u7edc\u901a\u7545\u540e\u7cfb\u7edf\u4f1a\u81ea\u52a8\u4e3a\u60a8\u91cd\u65b0\u540c\u6b65\u9644\u4ef6\u3002", (String)"ErrorHandle_3", (String)"fi-er-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7f51\u7edc\u4e0d\u901a\u7545\uff0c\u540c\u6b65\u5355\u636e\u5931\u8d25\u3002\u82e5\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6838\u4eba\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019\u3002\u7f51\u7edc\u901a\u7545\u540e\u7cfb\u7edf\u4f1a\u81ea\u52a8\u4e3a\u60a8\u91cd\u65b0\u540c\u6b65\u5355\u636e\u3002", (String)"ErrorHandle_4", (String)"fi-er-business", (Object[])new Object[0])) : (throwInfo.indexOf("MissingRecord:Attachment") != -1 ? ResManager.loadKDString((String)"\u9644\u4ef6\u540c\u6b65\u53d1\u751f\u610f\u5916\uff0c\u53ef\u80fd\u5bfc\u81f4\u5ba1\u6279\u4eba\u5728\u5ba1\u6838\u5355\u636e\u65f6\u65e0\u6cd5\u67e5\u770b\u9644\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u590d\u3002", (String)"ErrorHandle_5", (String)"fi-er-business", (Object[])new Object[0]) : ("fileUpload".equals(erMqHelper.getOperate()) ? ResManager.loadKDString((String)"\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u5bfc\u81f4\u9644\u4ef6\u540c\u6b65\u5931\u8d25\u3002\u7cfb\u7edf\u6b63\u5728\u5206\u6790\u5904\u7406\u4e2d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002   ", (String)"ErrorHandle_6", (String)"fi-er-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5355\u636e\u540c\u6b65\u5931\u8d25\uff0c\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u4e2d\u3002\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErrorHandle_7", (String)"fi-er-business", (Object[])new Object[0]))));
            ack.discard(erMqHelper.getMqMessageId());
            erMqHelper.setDoAck(true);
            erMqHelper.setBizErrorInfo(bizErrorInfo);
            String formId = erMqHelper.getFormId();
            String businessId = erMqHelper.getBusinessId();
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)businessId, (String)formId, (String)"billno");
            String billno = bill.getString("billno");
            msg = String.format(ResManager.loadKDString((String)"[%1$s]\u4e0eEAS\u540c\u6b65\u5f02\u5e38:[%2$s]", (String)"ErrorHandle_11", (String)"fi-er-business", (Object[])new Object[0]), billno, ErrorHandle.getExceptionDescription(e.toString()));
            logger.info("===\u63d0\u4ea4EAS\u7cfb\u7edf\u5931\u8d25\uff0c\u8be6\u7ec6\u5f02\u5e38\u4fe1\u606f[" + erMqHelper.toString() + "]");
        }
        catch (Exception e1) {
            logger.error("===\u63d0\u4ea4EAS\u7cfb\u7edf\u5931\u8d25\uff0c toEasErrorInfoHandle \u5904\u7406[" + erMqHelper.toString() + "]\u65f6\u629b\u5f02\u5e38:", (Throwable)e1);
        }
        return msg;
    }

    private static String getExceptionDescription(String error) {
        int start = error.lastIndexOf("Exception:") + 10;
        String substring = error.substring(start);
        int end = substring.indexOf("at");
        if (end == -1 || end > 100) {
            end = substring.length() > 100 ? 100 : substring.length();
        }
        return error.substring(start, start + end);
    }

    public static String errorInfoHandle(Throwable e, MessageAcker ack, ErMqHelper erMqHelper) {
        String msg = ResManager.loadKDString((String)"\u8bf7\u6c42\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u662f\uff1a", (String)"ErrorHandle_9", (String)"fi-er-business", (Object[])new Object[0]);
        String throwInfo = e.toString();
        try {
            if (throwInfo.indexOf("Connection refused: connect") != -1) {
                ack.discard(erMqHelper.getMqMessageId());
                erMqHelper.setDoAck(true);
            } else if (throwInfo.indexOf("java.net.SocketTimeoutException") != -1) {
                ack.deny(erMqHelper.getMqMessageId());
                erMqHelper.setDoAck(true);
            }
            msg = msg + "_" + throwInfo.substring(throwInfo.lastIndexOf("Exception:") + 10);
            logger.info(msg + "[ " + erMqHelper.toString() + "]");
        }
        catch (Exception e1) {
            logger.error(msg + "\uff0c errorInfoHandle \u5904\u7406[" + erMqHelper.toString() + "]\u65f6\u629b\u5f02\u5e38:", (Throwable)e1);
        }
        return msg;
    }

    public static void bizErrorHandle(Throwable e, MessageAcker ack, ErMqHelper erMqHelper) {
        String errorMsg = "";
        errorMsg = "push".equals(erMqHelper.getOperate()) ? ErrorHandle.errorInfoHandle(e, ack, erMqHelper) : ErrorHandle.toEasErrorInfoHandle(e, ack, erMqHelper);
        erMqHelper.setMessageInfo(errorMsg);
    }

    public static void finallyHandle(ErMqHelper erMqHelper, MessageAcker ack) {
        if (erMqHelper.isHasException()) {
            if (!erMqHelper.isDoAck()) {
                ack.ack(erMqHelper.getMqMessageId());
                erMqHelper.setDoAck(true);
                erMqHelper.setMessageInfo("finally doAck ! " + erMqHelper.getMessageInfo());
            }
            ErrorHandle.saveExceptionInfo(erMqHelper);
        } else {
            ErrorHandle.deleteExceptionInfo(erMqHelper.getFormId(), erMqHelper.getBusinessId(), erMqHelper.getOperate());
        }
    }

    private static void saveExceptionInfo(ErMqHelper erMqHelper) {
        QFilter existQFilter;
        IErDao erDao = ErDaoFactory.getInstance("er_exceptioninfo");
        DynamicObject exceptionInfo = erDao.queryOne(existQFilter = new QFilter("businesstype", "=", (Object)erMqHelper.getBusinessType()).and(new QFilter("businessid", "=", (Object)erMqHelper.getBusinessId())).and(new QFilter("operate", "=", (Object)erMqHelper.getOperate())));
        if (exceptionInfo == null) {
            exceptionInfo = erDao.getEmptyDynamicObject();
            exceptionInfo.set("createtime", (Object)new Date());
        }
        exceptionInfo.set("businessid", (Object)erMqHelper.getBusinessId());
        exceptionInfo.set("businesstype", (Object)erMqHelper.getBusinessType());
        exceptionInfo.set("operate", (Object)erMqHelper.getOperate());
        exceptionInfo.set("messageinfo", (Object)(erMqHelper.getMessageInfo() + " [" + erMqHelper.toString() + "]"));
        exceptionInfo.set("formid", (Object)erMqHelper.getFormId());
        exceptionInfo.set("status", (Object)"1");
        exceptionInfo.set("modifytime", (Object)new Date());
        exceptionInfo.set("otherinfo", (Object)erMqHelper.getOtherInfo());
        if ("fileUpload".equals(erMqHelper.getOperate())) {
            exceptionInfo.set("status", (Object)"2");
        }
        try {
            erDao.saveOne(exceptionInfo);
        }
        catch (Exception e) {
            logger.info("\u4fdd\u5b58 er_exceptioninfo \u5931\u8d25\uff1a" + erMqHelper.toString() + "msg:" + e.getMessage());
            exceptionInfo.set("messageinfo", (Object)ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be6\u60c5\u67e5\u770bmonitor\u65e5\u5fd7\u3002", (String)"ErrorHandle_10", (String)"fi-er-business", (Object[])new Object[0]));
            erDao.saveOne(exceptionInfo);
        }
    }

    public static void deleteExceptionInfo(String formId, String businessId, String operate) {
        try {
            DynamicObject exceptionInfo;
            QFilter existQFilter = new QFilter("formId", "=", (Object)formId).and(new QFilter("businessid", "=", (Object)businessId));
            if (operate != null) {
                existQFilter = existQFilter.and(new QFilter("operate", "=", (Object)operate));
            }
            if ((exceptionInfo = BusinessDataServiceHelper.loadSingle((String)"er_exceptioninfo", (String)"id", (QFilter[])new QFilter[]{existQFilter})) != null) {
                BusinessDataServiceHelper.delete((IDataEntityType)exceptionInfo.getDataEntityType(), (Object[])new Object[]{exceptionInfo.getPkValue()});
                IErDao billDao = ErDaoFactory.getInstance(formId);
                DynamicObject bill = billDao.queryOne("id,errorinfo", (Object)businessId);
                bill.set("errorinfo", (Object)"");
                BusinessDataServiceHelper.save((IDataEntityType)bill.getDataEntityType(), (Object[])new Object[]{bill});
            }
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664er_exceptioninfo \u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static void undoExceptionInfo(ErMqHelper erMqHelper) {
        try {
            IErDao erDao = ErDaoFactory.getInstance("er_exceptioninfo");
            QFilter existQFilter = new QFilter("businesstype", "=", (Object)erMqHelper.getBusinessType()).and(new QFilter("businessid", "=", (Object)erMqHelper.getBusinessId()));
            DynamicObject[] exceptionInfos = erDao.query(existQFilter);
            if (exceptionInfos != null && exceptionInfos.length > 0) {
                BusinessDataServiceHelper.delete((IDataEntityType)exceptionInfos[0].getDataEntityType(), (Object[])Stream.of(exceptionInfos).map(v -> v.getPkValue()).toArray());
                IErDao billDao = ErDaoFactory.getInstance(erMqHelper.getFormId());
                DynamicObject bill = billDao.queryOne("id,errorinfo", (Object)erMqHelper.getBusinessId());
                bill.set("errorinfo", (Object)"");
                BusinessDataServiceHelper.save((IDataEntityType)bill.getDataEntityType(), (Object[])new Object[]{bill});
            }
        }
        catch (Exception e) {
            logger.error("\u64a4\u9500er_exceptioninfo \u5931\u8d25\uff1a" + erMqHelper.toString(), (Throwable)e);
        }
    }
}

