/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.mytrip;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.mytrip.IOrderBillStrategy;

public class PlaneBillStrategy
implements IOrderBillStrategy {
    @Override
    public List<Map> getData(String tabKey) {
        DynamicObject[] bills = this.queryData(tabKey);
        ArrayList ret = Lists.newArrayListWithExpectedSize((int)bills.length);
        for (DynamicObject bill : bills) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("billId", bill.get("id"));
            m.put("billType", "er_planebill");
            m.put("title", bill.get("fromcityname") + "\uff0d" + bill.get("tocityname"));
            m.put("amount", bill.get("totalAmount"));
            m.put("orderStatus", bill.get("orderStatus"));
            String info = "";
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                SimpleDateFormat df2 = new SimpleDateFormat("MM-dd HH:mm");
                String beginDateFmt = df2.format(df.parse(bill.get("takeoffTime").toString()));
                String endDateFmt = df2.format(df.parse(bill.get("landingTime").toString()));
                StringBuilder sb = new StringBuilder().append(beginDateFmt).append(ResManager.loadKDString((String)"\u81f3", (String)"PlaneBillStrategy_0", (String)"fi-er-business", (Object[])new Object[0])).append(endDateFmt);
                info = sb.toString();
                df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                m.put("orderDate", df.parse(bill.getString("orderDate")));
            }
            catch (ParseException e) {
                throw new KDException(ResManager.loadKDString((String)"\u98de\u673a\u8ba2\u5355\u65e5\u671f\u8f6c\u6362\u51fa\u9519\u3002", (String)"PlaneBillStrategy_1", (String)"fi-er-business", (Object[])new Object[0]));
            }
            m.put("info", info);
            m.put("address", bill.get("flightNo") + "(" + bill.get("takeoffportname") + ")");
            ret.add(m);
        }
        return ret;
    }

    private DynamicObject[] queryData(String tabKey) {
        IErDao erDao = ErDaoFactory.getInstance("er_planebill");
        DynamicObject[] bills = erDao.query(this.getFilter(tabKey));
        return bills;
    }

    private QFilter getFilter(String tabKey) {
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        QFilter fi = new QFilter("sourcetravelerid", "=", (Object)userId);
        HashSet<String> wholeSet = new HashSet<String>(Arrays.asList("10000", "20000", "40100", "40000", "31000", "30000", "50201", "50202", "50301", "50302"));
        HashSet<String> closedSet = new HashSet<String>(Arrays.asList("30000", "50202", "50302"));
        HashSet<String> unusedSet = new HashSet<String>(wholeSet);
        unusedSet.removeAll(closedSet);
        if ("tabpageap".equalsIgnoreCase(tabKey)) {
            return fi.and(new QFilter("orderStatus", "in", unusedSet));
        }
        return fi.and(new QFilter("orderStatus", "in", closedSet).or(new QFilter("ticketStatus", "in", (Object)new String[]{"USED", "UNUSED"})));
    }

    @Override
    public int count(String tabKey) {
        return this.queryData(tabKey).length;
    }
}

