/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.pool.reim.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErConstants;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.utils.Er;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class ReimBotpUtils {
    private static final Log logger = LogFactory.getLog(ReimBotpUtils.class);
    private static final String ALGO = ReimBotpUtils.class.getName();

    public static Set<Object> getAllowUseItemsId(String targetBillName, Long costDeptPkId, Long costCompanyPkId) {
        QFilter billFilter = ExpenseItemServiceHelper.getExpItemFiltersExcludeBizitemAndProjecttype(targetBillName, costCompanyPkId, costDeptPkId, true);
        billFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        Map expenseItems = BusinessDataServiceHelper.loadFromCache((String)"er_expenseitemedit", (String)"id,isreimburseamountctl", (QFilter[])new QFilter[]{billFilter});
        Set<Object> objects = expenseItems.keySet();
        logger.info("\u6700\u7ec8\u663e\u793a\uff1a" + objects);
        return objects;
    }

    public static Map<Long, Set<Object>> getCostAllowUseItemIds(String targetBillName, Map<Long, Set<Long>> costComToDept) {
        HashMap costDeptIdAndItemIdsMap = Maps.newHashMapWithExpectedSize((int)costComToDept.size());
        for (Map.Entry<Long, Set<Long>> entry : costComToDept.entrySet()) {
            Long costCompanyPkId = entry.getKey();
            Set<Long> costDeptPkIds = entry.getValue();
            for (Long costDeptPkId : costDeptPkIds) {
                Set<Object> itemIds = ReimBotpUtils.getAllowUseItemsId(targetBillName, costDeptPkId, costCompanyPkId);
                Set oldItemIds = (Set)costDeptIdAndItemIdsMap.get(costDeptPkId);
                if (oldItemIds == null) {
                    oldItemIds = Sets.newHashSetWithExpectedSize((int)itemIds.size());
                }
                oldItemIds.addAll(itemIds);
                costDeptIdAndItemIdsMap.put(costDeptPkId, oldItemIds);
            }
        }
        return costDeptIdAndItemIdsMap;
    }

    @Deprecated
    public static List<String> exceptRelExpItems(Long costDeptId) {
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(costDeptId);
        List allOrgs = OrgUnitServiceHelper.getAdminOrgRelation(orgList, (boolean)true);
        allOrgs.add(costDeptId);
        allOrgs.removeIf(v -> v == null);
        ArrayList allExpIdsHaveDept = Lists.newArrayList();
        if (!allOrgs.isEmpty()) {
            String sql = "select distinct fexpitemid from t_bd_expitemreldept where 1=1;";
            try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.basedata, (String)sql);){
                for (Row row : ds) {
                    allExpIdsHaveDept.add(row.getString("fexpitemid"));
                }
            }
            sql = "select distinct fexpitemid from t_bd_expitemreldept where frelorgid in (%s)";
            sql = String.format(sql, Er.join((Collection)allOrgs, (String)","));
            ArrayList<String> expIdsHaveThisDept = new ArrayList<String>(allExpIdsHaveDept.size());
            DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.basedata, (String)sql);
            Object object = null;
            try {
                for (Row row : ds) {
                    expIdsHaveThisDept.add(row.getString("fexpitemid"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            allExpIdsHaveDept.removeAll(expIdsHaveThisDept);
        }
        return allExpIdsHaveDept;
    }

    public static List<Long> expenseOfWriteOffApply(DynamicObject expenseEntry) {
        DynamicObject bill;
        DynamicObject company;
        List<Long> result = new ArrayList<Long>();
        Object parent = expenseEntry.getParent();
        if (parent instanceof DynamicObject && (company = (bill = (DynamicObject)parent).getDynamicObject("company")) != null) {
            result = ReimBotpUtils.expenseOfWriteOffApply(bill, ErCommonUtils.getPk(company));
        }
        return result;
    }

    public static List<Long> expenseOfWriteOffApply(DynamicObject targetBill, Long companyId) {
        DataEntityPropertyCollection properties;
        ArrayList<Long> result = new ArrayList<Long>();
        if (SystemParamterUtil.isShowParentbillExpenseitem(companyId) && (properties = targetBill.getDynamicObjectType().getProperties()).get((Object)"writeoffapply") != null && properties.get((Object)"writeoffmoney") != null) {
            DynamicObjectCollection loanEntryCollction = targetBill.getDynamicObjectCollection("writeoffmoney");
            DynamicObjectCollection applyEntryCollction = targetBill.getDynamicObjectCollection("writeoffapply");
            if (loanEntryCollction.size() <= 0 && applyEntryCollction.size() <= 0 && properties.get((Object)"writeoffapply") != null && properties.get((Object)"writeoffmoney") != null) {
                loanEntryCollction = targetBill.getDynamicObjectCollection("writeoffmoney");
                applyEntryCollction = targetBill.getDynamicObjectCollection("writeoffapply");
            }
            if (loanEntryCollction != null && loanEntryCollction.size() > 0) {
                for (Iterator entry : loanEntryCollction) {
                    DynamicObject expenseitem = entry.getDynamicObject("sourceexpenseitem");
                    if (expenseitem == null) continue;
                    result.add((Long)expenseitem.getPkValue());
                }
            }
            if (applyEntryCollction != null && applyEntryCollction.size() > 0) {
                HashSet<Long> sourceEntryId = new HashSet<Long>();
                for (DynamicObject entry : applyEntryCollction) {
                    sourceEntryId.add(entry.getLong("sourceapplyentryid"));
                }
                Long sourceId = Long.valueOf(((DynamicObject)applyEntryCollction.get(0)).getString("sourceapplybillid"));
                result.addAll(ReimBotpUtils.getApplyEntryExpenseItemId(sourceId, sourceEntryId));
            }
        }
        return result;
    }

    private static List<Long> getApplyEntryExpenseItemId(Long sourceId, Set<Long> sourceEntryId) {
        ArrayList<Long> expenseItemIdList = new ArrayList<Long>();
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"er_dailyapplybill");
        DynamicObjectCollection expenseEntryCollction = applyBill.getDynamicObjectCollection("expenseentryentity");
        for (Long entryId : sourceEntryId) {
            for (DynamicObject expenseEntry : expenseEntryCollction) {
                if (!entryId.equals(expenseEntry.getPkValue())) continue;
                expenseItemIdList.add((Long)expenseEntry.getDynamicObject("expenseitem").getPkValue());
            }
        }
        return expenseItemIdList;
    }

    public static void handleHead(Set<String> notNeedChanegFied, ExtendedDataEntity[] extendedDataEntities, Set<String> mapFieldSet) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            DynamicObject targetBill = extendedDataEntities[i].getDataEntity();
            DynamicObject applier = targetBill.getDynamicObject("applier");
            Long applierId = ErCommonUtils.getPk(applier);
            if (!mapFieldSet.contains("applier") || applierId == null) {
                applierId = userId;
            }
            Map<String, Object> billMap = CoreBaseBillServiceHelper.createNewData(applierId);
            for (Map.Entry<String, Object> entry : billMap.entrySet()) {
                String key = entry.getKey();
                if (notNeedChanegFied.contains(key) && mapFieldSet.contains(key)) continue;
                Object value = entry.getValue();
                DynamicProperty propty = targetBill.getDynamicObjectType().getProperty(key);
                if (propty instanceof BasedataProp) {
                    if (mapFieldSet.contains(key)) continue;
                    logger.info("\u5f53\u524d\u8986\u76d6\u7684\u503c\uff1a" + key);
                    if (value instanceof DynamicObject) {
                        targetBill.set(key, value);
                        continue;
                    }
                    DynamicObjectType dt = ((BasedataProp)propty).getDynamicComplexPropertyType();
                    Map mapDyO = BusinessDataReader.loadFromCache((Object[])new Object[]{value}, (DynamicObjectType)dt);
                    targetBill.set(key, mapDyO.get(value));
                    continue;
                }
                targetBill.set(key, value);
            }
        }
    }

    private static String getBillType(String billName) {
        String type = "";
        if (ErEntityTypeUtils.isDailyReimburseBill(billName)) {
            type = "1";
        } else if (ErEntityTypeUtils.isTripReimburseBill(billName)) {
            type = "2";
        }
        return type;
    }

    private static boolean needToFilter(String targetBillName, long costCompanyPkId, String isReimburseAmountCtl) {
        if ("0".equals(targetBillName)) {
            return false;
        }
        String type = ReimBotpUtils.getBillType(targetBillName);
        if ("1".equals(isReimburseAmountCtl)) {
            List<String> empCltBillList = SystemParamterUtil.getEmpCltBillList(costCompanyPkId);
            return !empCltBillList.contains(type);
        }
        if ("2".equals(isReimburseAmountCtl)) {
            List<String> deptCltBillList = SystemParamterUtil.getDeptCltBillList(costCompanyPkId);
            return !deptCltBillList.contains(type);
        }
        return false;
    }

    public static boolean isPush(Long pkValue, String tcTableId) {
        if (pkValue == null) {
            return false;
        }
        boolean hasData = false;
        String sql = String.format("select fid from %s where ftbillid = %s", tcTableId, pkValue);
        try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)ErConstants.FI_DB_ROUTE, (String)sql);){
            hasData = ds.iterator().hasNext();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return hasData;
    }
}

