/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reimamountctl.method;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.er.business.amount.control.impl.AmountFreedImpl;
import kd.fi.er.business.daily.service.model.ReimburseAmountBO;
import kd.fi.er.business.reimamountctl.method.QuotaCtlMethodService;
import kd.fi.er.business.reimamountctl.model.ExpItemAmountBO;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.utils.CollectorsUtil;

public class AccumulativeQuotaCtlMethodServiceImpl
implements QuotaCtlMethodService {
    @Override
    public Map<String, LocalDate> genHappenDatePeriod(QuotaAmountBO quotaAmountBO) {
        if (quotaAmountBO.getHappenDatePeriod() != null && quotaAmountBO.getHappenDatePeriod().size() > 0) {
            return quotaAmountBO.getHappenDatePeriod();
        }
        if (quotaAmountBO.getHappenDate() != null) {
            YearMonth happenDate = quotaAmountBO.getHappenDate();
            LocalDate beginDate = LocalDate.of(happenDate.getYear(), 1, 1);
            LocalDate endDate = LocalDate.now();
            if (happenDate.getYear() != Year.now().getValue()) {
                endDate = LocalDate.of(happenDate.getYear(), 12, 31);
            }
            HashMap<String, LocalDate> datePeriod = new HashMap<String, LocalDate>(2);
            datePeriod.put("start", beginDate);
            datePeriod.put("end", endDate);
            return datePeriod;
        }
        return null;
    }

    @Override
    public Map<YearMonth, BigDecimal> groupAmountDataByHappendate(List<ExpItemAmountBO> expItemAmountBOS) {
        Map<YearMonth, BigDecimal> yearMonthAmount = expItemAmountBOS.stream().collect(Collectors.groupingBy(e -> YearMonth.from(e.getHappenDate()), CollectorsUtil.summingBigDecimal(ExpItemAmountBO::getAmount)));
        List collect = yearMonthAmount.keySet().stream().sorted().collect(Collectors.toList());
        int year = ((YearMonth)collect.get(0)).getYear();
        BigDecimal tempAmount = BigDecimal.ZERO;
        HashMap<YearMonth, BigDecimal> yearMonthBigDecimalHashMap = new HashMap<YearMonth, BigDecimal>();
        for (int i = 0; i < collect.size(); ++i) {
            YearMonth key = (YearMonth)collect.get(i);
            BigDecimal value = yearMonthAmount.get(key);
            if (year == key.getYear()) {
                tempAmount = tempAmount.add(value);
            } else {
                ++year;
                tempAmount = value;
            }
            yearMonthBigDecimalHashMap.put(key, tempAmount);
        }
        return yearMonthBigDecimalHashMap;
    }

    @Override
    public Map<YearMonth, List<ExpItemAmountBO>> groupListDataByHappenDate(List<ExpItemAmountBO> expItemAmountBOS) {
        Map<YearMonth, List<ExpItemAmountBO>> yearMonthAmount = expItemAmountBOS.stream().collect(Collectors.groupingBy(e -> YearMonth.from(e.getHappenDate())));
        List collect = yearMonthAmount.keySet().stream().sorted().collect(Collectors.toList());
        int year = ((YearMonth)collect.get(0)).getYear();
        List<ExpItemAmountBO> tempList = new ArrayList<ExpItemAmountBO>();
        HashMap<YearMonth, List<ExpItemAmountBO>> yearMonthBigDecimalHashMap = new HashMap<YearMonth, List<ExpItemAmountBO>>();
        for (int i = 0; i < collect.size(); ++i) {
            YearMonth key = (YearMonth)collect.get(i);
            List<ExpItemAmountBO> value = yearMonthAmount.get(key);
            if (year == key.getYear()) {
                tempList.addAll(value);
            } else {
                ++year;
                tempList = value;
            }
            yearMonthBigDecimalHashMap.put(key, tempList);
        }
        return yearMonthBigDecimalHashMap;
    }

    public static void main(String[] args) {
        ReimburseAmountBO reimburseAmountBO1 = new ReimburseAmountBO();
        reimburseAmountBO1.setAmount(new BigDecimal("100"));
        reimburseAmountBO1.setHappenDate(LocalDate.of(2021, 1, 1));
        ReimburseAmountBO reimburseAmountBO2 = new ReimburseAmountBO();
        reimburseAmountBO2.setAmount(new BigDecimal("200"));
        reimburseAmountBO2.setHappenDate(LocalDate.of(2021, 6, 12));
        ReimburseAmountBO reimburseAmountBO3 = new ReimburseAmountBO();
        reimburseAmountBO3.setAmount(new BigDecimal("300"));
        reimburseAmountBO3.setHappenDate(LocalDate.of(2022, 5, 1));
        ArrayList<ReimburseAmountBO> reimburseAmountBOs = new ArrayList<ReimburseAmountBO>();
        reimburseAmountBOs.add(reimburseAmountBO1);
        reimburseAmountBOs.add(reimburseAmountBO2);
        reimburseAmountBOs.add(reimburseAmountBO3);
        Map<YearMonth, BigDecimal> collect = reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.of(reimburseAmountBO.getHappenDate().getYear(), 1), CollectorsUtil.summingBigDecimal(ReimburseAmountBO::getAmount)));
        System.out.println(collect);
    }

    @Override
    public BigDecimal getEmpQuotaAmountByCltMethod(DynamicObject quota, QuotaAmountBO reimAmountBO) {
        YearMonth yearMonth = reimAmountBO.getHappenDate();
        int monthValue = LocalDate.now().getMonthValue();
        if (yearMonth.getYear() != Year.now().getValue()) {
            monthValue = 12;
        }
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 1; i < monthValue; ++i) {
            amount = amount.add(quota.getBigDecimal("month" + i));
        }
        BigDecimal currMonthAmount = quota.getBigDecimal("month" + monthValue);
        BigDecimal releaseRatio = BigDecimal.ONE;
        if (reimAmountBO.getIsByFreedRatio() && "1".equals(reimAmountBO.getCtrlMode())) {
            AmountFreedImpl amountFreedService = new AmountFreedImpl();
            releaseRatio = amountFreedService.getHaveFreededAmount(reimAmountBO.getCompanyId(), reimAmountBO.getExpenseItemId());
        }
        currMonthAmount = currMonthAmount.multiply(releaseRatio);
        return amount.add(currMonthAmount);
    }

    @Override
    public BigDecimal getDeptQuotaAmountByCltMethod(DynamicObject quota, QuotaAmountBO reimAmountBO) {
        YearMonth yearMonth = reimAmountBO.getHappenDate();
        int monthValue = LocalDate.now().getMonthValue();
        if (yearMonth.getYear() != Year.now().getValue()) {
            monthValue = 12;
        }
        BigDecimal amount = BigDecimal.ZERO;
        for (int i = 1; i <= monthValue; ++i) {
            amount = amount.add(quota.getBigDecimal("month" + i));
        }
        return amount;
    }
}

