/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.core;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.er.business.reportmb.core.FieldDO;
import kd.fi.er.business.reportmb.core.FieldType;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class CollIndex {
    private List<FieldDO> fields;
    private List<FieldDO> sumField = Lists.newArrayListWithExpectedSize((int)2);
    private List<FieldDO> groupField = Lists.newArrayListWithExpectedSize((int)4);
    private Map<String, Integer> indexMap;

    public CollIndex(List<FieldDO> fields) {
        this.fields = fields;
        this.init();
    }

    private void init() {
        if (this.fields != null && !this.fields.isEmpty()) {
            this.indexMap = Maps.newHashMapWithExpectedSize((int)this.fields.size());
            Iterator<FieldDO> iterator = this.fields.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                FieldDO fieldDO = iterator.next();
                this.indexMap.put(fieldDO.getAlias().toLowerCase(), index);
                if (FieldType.SUM == fieldDO.getType()) {
                    this.sumField.add(fieldDO);
                }
                if (FieldType.GROUP_BY == fieldDO.getType()) {
                    this.groupField.add(fieldDO);
                }
                ++index;
            }
        }
    }

    public Integer getFieldIndex(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            name = name.toLowerCase();
        }
        return this.indexMap.get(name);
    }

    public List<FieldDO> getSumField() {
        return this.sumField;
    }

    public List<FieldDO> getGroupField() {
        return this.groupField;
    }
}

