/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.query;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.query.IRptQueryExecute;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class CommonQueryExecute
implements IRptQueryExecute {
    private AbstractReportContext context;

    public CommonQueryExecute(AbstractReportContext context) {
        this.context = context;
    }

    @Override
    public AbstractReportContext getContext() {
        return this.context;
    }

    @Override
    public Map<TableDO, List<Object[]>> doExecute() {
        List<TableDO> tables = this.context.getTables();
        HashMap map = Maps.newHashMapWithExpectedSize((int)tables.size());
        tables.stream().forEach(table -> {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)table.getTableName(), (String)table.getSelectSQL(), (QFilter[])table.getQFilters().toArray(new QFilter[0]), null);){
                LinkedList list = Lists.newLinkedList();
                RowMeta rowMeta = dataSet.getRowMeta();
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Object[] result = new Object[rowMeta.getFieldCount()];
                    Field[] fields = rowMeta.getFields();
                    for (int i = 0; i < fields.length; ++i) {
                        result[i] = row.get(i);
                    }
                    list.add(result);
                }
                map.put(table, list);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, new ErrorCode(table.getTableName(), e.getMessage()), new Object[0]);
            }
        });
        return map;
    }
}

