/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.reportmb.query;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.reportmb.context.AbstractReportContext;
import kd.fi.er.business.reportmb.core.TableDO;
import kd.fi.er.business.reportmb.query.IRptQueryExecute;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class MultiThreadQueryExecute
implements IRptQueryExecute {
    private AbstractReportContext context;

    public MultiThreadQueryExecute(AbstractReportContext context) {
        this.context = context;
    }

    @Override
    public AbstractReportContext getContext() {
        return this.context;
    }

    @Override
    public Map<TableDO, List<Object[]>> doExecute() {
        List<TableDO> tables = this.context.getTables();
        ConcurrentMap map = Maps.newConcurrentMap();
        RequestContext requestCxt = RequestContext.get();
        ArrayList tasks = Lists.newArrayListWithExpectedSize((int)tables.size());
        tables.stream().forEach(table -> tasks.add(ThreadService.submit((Callable)new Callable<Tuple<TableDO, List<Object[]>>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Tuple<TableDO, List<Object[]>> call() throws Exception {
                LinkedList list = Lists.newLinkedList();
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)table.getTableName(), (String)table.getSelectSQL(), (QFilter[])table.getQFilters().toArray(new QFilter[0]), null);){
                    RowMeta rowMeta = dataSet.getRowMeta();
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        Object[] result = new Object[rowMeta.getFieldCount()];
                        Field[] fields = rowMeta.getFields();
                        for (int i = 0; i < fields.length; ++i) {
                            result[i] = row.get(i);
                        }
                        list.add(result);
                    }
                    Tuple tuple = new Tuple((Object)table, (Object)list);
                    return tuple;
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, new ErrorCode(table.getTableName(), e.getMessage()), new Object[0]);
                }
            }
        }, (TaskType)TaskType.ER_REPORT_QUERY, (RequestContext)requestCxt)));
        for (Future future : tasks) {
            try {
                Tuple tuple = (Tuple)future.get();
                map.put(tuple.item1, tuple.item2);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new KDBizException((Throwable)e, new ErrorCode(e.getMessage(), e.getMessage()), new Object[0]);
            }
        }
        return map;
    }
}

