/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.UrlModel;
import kd.bos.ais.model.ShowBillFormData;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ApiResultProcessor {
    private static final String KEY_CHATBOT_CLIENT = "AI_DEVICE";
    private static final String WEB_CHATBOT_CLIENT = "CQ_CHATBOT";
    private static final String APP_ID_ER = "er";
    private static final Log log = LogFactory.getLog(ApiResultProcessor.class);

    public static void processUrl(AICommandEvent e) {
        log.info(SerializationUtils.toJsonString((Object)e.getCommand()));
        String client = (String)e.getCommand().getParameter().get(KEY_CHATBOT_CLIENT);
        if (client == null) {
            log.error(String.format("\u53c2\u6570%s\u4e3a\u7a7a", KEY_CHATBOT_CLIENT));
            return;
        }
        if (!ApiResultProcessor.isWebClient(client)) {
            return;
        }
        ApiResult apiResult = e.getResult();
        if (!apiResult.getSuccess()) {
            return;
        }
        Object data = apiResult.getData();
        if (!(data instanceof ResponseModel)) {
            return;
        }
        ResponseModel responseModel = (ResponseModel)data;
        if (ResponseModel.Type.URL.toString().equalsIgnoreCase(responseModel.getType())) {
            ApiResultProcessor.replaceUrl(responseModel);
        }
    }

    private static boolean isWebClient(String client) {
        return WEB_CHATBOT_CLIENT.equalsIgnoreCase(client) || "9".equals(client);
    }

    private static void replaceUrl(ResponseModel responseModel) {
        UrlModel urlModel = (UrlModel)responseModel.getContent();
        String url = urlModel.getUrl();
        urlModel.setUrl(ApiResultProcessor.parseOpenBillParam(url));
    }

    private static String parseOpenBillParam(String url) {
        int idxOfForm = url.indexOf("/form/");
        int idxOfFormEnd = url.indexOf("_mob?", idxOfForm += "/form/".length());
        String billFormId = url.substring(idxOfForm, idxOfFormEnd);
        int idxOfPk = url.indexOf("pkId=");
        int idxOfPkEnd = url.indexOf(38, idxOfPk += "pkId=".length());
        String pkId = url.substring(idxOfPk, idxOfPkEnd);
        return ApiResultProcessor.packBizSystemActionUrl(billFormId, pkId);
    }

    private static String packBizSystemActionUrl(String billFormId, String pkId) {
        String data = SerializationUtils.toJsonString((Object)new ShowBillFormData(APP_ID_ER, billFormId, (Object)pkId));
        return String.format("bizAction://%s?%s", "ShowBillForm", data);
    }
}

