/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class BaseCurrencyServiceHelper {
    private static Log logger = LogFactory.getLog(BaseCurrencyServiceHelper.class);

    public static DynamicObject getRMBCurrency() {
        DynamicObject currency = null;
        QFilter qFilter = new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"BaseCurrencyServiceHelper_0", (String)"fi-er-business", (Object[])new Object[0]));
        DynamicObjectCollection currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (currencys.size() > 0) {
            currency = (DynamicObject)currencys.get(0);
        }
        return currency;
    }

    public static DynamicObject getCurrencyObjectById(Long currencyId) {
        if (currencyId == null) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", (Object)currencyId);
        String selectProperties = "id,number,name,amtprecision,priceprecision,sign,isshowsign";
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)selectProperties, (QFilter[])new QFilter[]{filter});
        if (currencyMap.get(currencyId) != null) {
            return (DynamicObject)currencyMap.get(currencyId);
        }
        return null;
    }

    public static DynamicObject getBaseCurrencyObject(Object company, Object costCompany) {
        Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId(company, costCompany);
        return BaseCurrencyServiceHelper.getCurrencyObjectById(baseCurrencyId);
    }

    public static Long getBaseCurrencyId(Object company, Object costCompany) {
        if (company == null) {
            return null;
        }
        String currencySource = SystemParamterUtil.getCurrencySource(company);
        if (StringUtils.equals((CharSequence)"company", (CharSequence)currencySource)) {
            return BaseCurrencyServiceHelper.getBaseCurrencyId(ErCommonUtils.getPk(company));
        }
        if (StringUtils.equals((CharSequence)"costcompany", (CharSequence)currencySource) && costCompany != null) {
            Map currencyAndExrateTable = BaseDataServiceHelper.getBaseAccountingInfo((Long)ErCommonUtils.getPk(costCompany));
            return currencyAndExrateTable == null || currencyAndExrateTable.isEmpty() ? null : (Long)currencyAndExrateTable.get("baseCurrencyID");
        }
        return null;
    }

    public static Long getExrateTableId(Object company, Object costCompany) {
        if (company == null) {
            return null;
        }
        Map<Object, Object> exchangeRateTableMap = new HashMap();
        String currencySource = SystemParamterUtil.getCurrencySource(company);
        if (StringUtils.equals((CharSequence)"company", (CharSequence)currencySource)) {
            exchangeRateTableMap = BaseCurrencyServiceHelper.getBaseCurrencyAndExrateTable(ErCommonUtils.getPk(company));
        } else if (StringUtils.equals((CharSequence)"costcompany", (CharSequence)currencySource) && costCompany != null) {
            exchangeRateTableMap = BaseDataServiceHelper.getBaseAccountingInfo((Long)ErCommonUtils.getPk(costCompany));
        }
        if (exchangeRateTableMap == null || exchangeRateTableMap.isEmpty()) {
            return null;
        }
        return (Long)exchangeRateTableMap.get("exchangeRateTableID");
    }

    public static DynamicObject getBaseCurrencyObject(Long orgId) {
        if (orgId == null) {
            return null;
        }
        Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId(orgId);
        DynamicObject currencyObject = BaseCurrencyServiceHelper.getCurrencyObjectById(currencyId);
        return currencyObject;
    }

    public static Long getBaseCurrencyId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        Map<String, Long> currency = BaseCurrencyServiceHelper.getBaseCurrencyAndExrateTable(orgId);
        if (currency == null || currency.size() < 1 || currency.get("baseCurrencyID") == null) {
            return null;
        }
        Long currencyId = currency.get("baseCurrencyID");
        return currencyId;
    }

    public static Long getExrateTableId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        Map<String, Long> exchangeRateTableMap = BaseCurrencyServiceHelper.getBaseCurrencyAndExrateTable(orgId);
        if (exchangeRateTableMap == null || exchangeRateTableMap.size() < 1 || exchangeRateTableMap.get("exchangeRateTableID") == null) {
            return null;
        }
        Long exchangeRateTableId = exchangeRateTableMap.get("exchangeRateTableID");
        return exchangeRateTableId;
    }

    public static Map<String, Long> getBaseCurrencyAndExrateTable(Long companyId) {
        if (companyId == null) {
            return null;
        }
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(companyId, Boolean.FALSE);
        if (accountOrgId == null || accountOrgId.compareTo(Long.valueOf("0")) == 0) {
            return null;
        }
        Map currencyAndExrateTable = BaseDataServiceHelper.getBaseAccountingInfo((Long)accountOrgId);
        logger.info(" \u83b7\u53d6\u7684\u884c\u653f\u7ec4\u7ec7\u5bf9\u5e94\u7684\u672c\u4f4d\u5e01\u3001\u6c47\u7387\u8868" + SerializationUtils.toJsonString((Object)currencyAndExrateTable));
        if (currencyAndExrateTable == null || currencyAndExrateTable.size() < 1) {
            return null;
        }
        return currencyAndExrateTable;
    }
}

