/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;

public class ErTimeLineServiceHelper {
    private static Log logger = LogFactory.getLog(ErTimeLineServiceHelper.class);

    public static Map getTimeLineInfo(Map<String, Object> paramMap) throws Exception {
        ArrayList dataList = new ArrayList();
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        Long userID = Long.valueOf(paramMap.get("name").toString());
        IErDao erDao = ErDaoFactory.getInstance("er_tripreqbill");
        QFilter[] qFilters = new QFilter[]{new QFilter("applier_Id", "=", (Object)userID), new QFilter("billstatus", "in", (Object)new String[]{"E", "F", "G", "I"})};
        DynamicObject[] dynamicObjects = erDao.query(qFilters, "rstartdate desc");
        DynamicObject[] poemsDo = BusinessDataServiceHelper.load((String)"er_timelinedata", (String)"poem", (QFilter[])new QFilter[0]);
        ArrayList<String> poems = new ArrayList<String>();
        int len = poemsDo.length;
        for (int i = 0; i < len; ++i) {
            String poem = poemsDo[i].getLocaleString("poem").getLocaleValue();
            if (poem == null || poem.equals("")) continue;
            poems.add(poem);
        }
        int poemLength = poems.size();
        SecureRandom rdm = new SecureRandom();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            QFilter filter;
            DynamicObject[] datas;
            DynamicObject dynamicObject = dynamicObjects[i];
            String cityName = dynamicObject.get("rto").toString();
            HashMap<String, String> singleCity = new HashMap<String, String>();
            Object rstartdate = dynamicObject.get("rstartdate");
            if (rstartdate != null) {
                singleCity.put("date", rstartdate.toString().substring(0, 19));
            }
            if ((datas = BusinessDataServiceHelper.load((String)"er_timelinedata", (String)"url,slogon", (QFilter[])new QFilter[]{filter = new QFilter("city", "=", (Object)cityName)})).length == 0) {
                singleCity.put("slogon", ResManager.loadKDString((String)"\u53ea\u770b\u98ce\u666f\uff0c\u4e0d\u95ee\u811a\u4e0b", (String)"ErTimeLineServiceHelper_0", (String)"fi-er-business", (Object[])new Object[0]));
                singleCity.put("poem", ResManager.loadKDString((String)"\u6625\u98ce\u5341\u91cc\uff0c\u4e0d\u5982\u6709\u4f60\u3002", (String)"ErTimeLineServiceHelper_1", (String)"fi-er-business", (Object[])new Object[0]));
                singleCity.put("city", UrlService.getDomainContextUrl() + "/private/timeline/city/default.jpg");
                singleCity.put("cityBg", UrlService.getDomainContextUrl() + "/private/timeline/bgimg/default.png");
            } else {
                singleCity.put("slogon", datas[0].getLocaleString("slogon").getLocaleValue());
                singleCity.put("poem", (String)poems.get(rdm.nextInt(poemLength)));
                singleCity.put("city", UrlService.getDomainContextUrl() + "/private/timeline/" + datas[0].getString("url"));
                singleCity.put("cityBg", UrlService.getDomainContextUrl() + "/private/timeline/" + datas[0].getString("url").replaceAll("city", "bgimg"));
            }
            singleCity.put("cityName", cityName);
            dataList.add(singleCity);
        }
        resultMap.put("data", dataList);
        resultMap.put("cityCount", Integer.valueOf(dynamicObjects.length));
        logger.info("datamap--" + resultMap);
        return resultMap;
    }
}

