/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.utils.Er;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpRetryServiceHelper {
    private static final Charset CHARACTER_UTF_EIGHT = StandardCharsets.UTF_8;
    private static final Integer connectTimeout = 30000;
    private static final Integer socketTimeout = 180000;
    private static final Integer MAX_RETUEN_HTTP = 3;
    private static Log logger = LogFactory.getLog(HttpRetryServiceHelper.class);
    private static final int DEFAULT_OVERTIME = 30000;

    public static Map<String, Object> doPost(String url, List<NameValuePair> reqParams) {
        return HttpRetryServiceHelper.doPost(url, reqParams, 30000);
    }

    public static Map<String, Object> httpPost(String url, List<NameValuePair> reqParams) {
        return HttpRetryServiceHelper.httpPost(url, reqParams, 30000);
    }

    public static <T> T httpPost(String url, List<NameValuePair> reqParams, Class<T> cls) {
        return HttpRetryServiceHelper.httpPost(url, reqParams, 30000, cls);
    }

    public static Map<String, Object> httpPost(String url, List<NameValuePair> reqParams, int overTime) {
        Map<String, Object> resultMap;
        block7: {
            url = HttpRetryServiceHelper.getMockUrl(url);
            resultMap = new HashMap<String, Object>();
            try {
                HttpPost httpPost = new HttpPost(url);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(reqParams, CHARACTER_UTF_EIGHT));
                httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
                httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(30000).setSocketTimeout(socketTimeout.intValue()).build();
                httpPost.setConfig(requestConfig);
                CloseableHttpClient client = HttpRetryServiceHelper.createHttpClient();
                CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
                HttpEntity responseEntity = response.getEntity();
                if (responseEntity != null) {
                    String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                    resultMap = (Map)JSONUtils.cast((String)resultStr, Map.class);
                }
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                String traceid = RequestContext.get().getTraceId();
                String key = CommonServiceHelper.getMD5(traceid + JSON.toJSONString(reqParams));
                if ((e instanceof TimeoutException || e instanceof ConnectTimeoutException || e instanceof SocketTimeoutException) && null == ErCommonUtils.getKeyValueFromAppCache(key, String.class)) {
                    ErCommonUtils.putKeyValueToAppCache(key, "isretry");
                    for (int i = 0; i < MAX_RETUEN_HTTP; ++i) {
                        logger.info("http\u8bf7\u6c42\u8d85\u65f6\uff0c\u91cd\u8bd5 {}", (Object)(i + 1));
                        try {
                            resultMap = HttpRetryServiceHelper.httpPost(url, reqParams, overTime);
                            break;
                        }
                        catch (Exception ex) {
                            logger.info("\u8bf7\u6c42\u5931\u8d252: {}", (Object)ThrowableHelper.toString((Exception)ex));
                            continue;
                        }
                    }
                }
                if (!resultMap.isEmpty()) break block7;
                throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e));
            }
        }
        return resultMap;
    }

    public static String httpPost(String url, JSONObject jsonParams) {
        JSONObject jsonObject = HttpRetryServiceHelper.httpPost(url, jsonParams, 30000);
        return jsonObject == null ? "" : jsonObject.toJSONString();
    }

    public static JSONObject httpPost(String url, JSONObject jsonParams, int overTime) {
        JSONObject resultJson;
        block7: {
            url = HttpRetryServiceHelper.getMockUrl(url);
            resultJson = new JSONObject();
            try {
                HttpPost httpPost = new HttpPost(url);
                httpPost.setEntity((HttpEntity)new StringEntity(jsonParams.toString(), Charset.forName("UTF-8")));
                httpPost.setHeader("Content-type", "application/json; charset=utf-8");
                httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(overTime).setSocketTimeout(socketTimeout.intValue()).build();
                httpPost.setConfig(requestConfig);
                CloseableHttpClient client = HttpRetryServiceHelper.createHttpClient();
                CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
                HttpEntity responseEntity = response.getEntity();
                if (responseEntity != null) {
                    String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                    resultJson = JSONObject.parseObject((String)resultStr);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                String traceid = RequestContext.get().getTraceId();
                String key = CommonServiceHelper.getMD5(traceid + JSON.toJSONString((Object)jsonParams));
                if ((e instanceof TimeoutException || e instanceof ConnectTimeoutException || e instanceof SocketTimeoutException) && null == ErCommonUtils.getKeyValueFromAppCache(key, String.class)) {
                    ErCommonUtils.putKeyValueToAppCache(key, "isretry");
                    for (int i = 0; i < MAX_RETUEN_HTTP; ++i) {
                        logger.info("http\u8bf7\u6c42\u8d85\u65f6\uff0c\u91cd\u8bd5 {}", (Object)(i + 1));
                        try {
                            resultJson = HttpRetryServiceHelper.httpPost(url, jsonParams, overTime);
                            break;
                        }
                        catch (Exception ex) {
                            logger.info("\u8bf7\u6c42\u5931\u8d252: {}", (Object)ThrowableHelper.toString((Exception)ex));
                            continue;
                        }
                    }
                }
                if (!resultJson.isEmpty()) break block7;
                throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e));
            }
        }
        return resultJson;
    }

    public static <T> T httpPost(String url, List<NameValuePair> reqParams, int overTime, Class<T> cls) {
        url = HttpRetryServiceHelper.getMockUrl(url);
        Object resultObj = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(reqParams, CHARACTER_UTF_EIGHT));
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(overTime).setSocketTimeout(socketTimeout.intValue()).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpClient client = HttpRetryServiceHelper.createHttpClient();
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                resultObj = JSONUtils.cast((String)resultStr, cls);
            }
        }
        catch (IOException e) {
            logger.error(ThrowableHelper.toString((Exception)e));
            throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e));
        }
        return (T)resultObj;
    }

    public static Map<String, Object> doPost(String url, List<NameValuePair> reqParams, int overTime) {
        url = HttpRetryServiceHelper.getMockUrl(url);
        Map<String, Object> resultMap = new HashMap<String, Object>();
        try (CloseableHttpClient httpClient = HttpRetryServiceHelper.createHttpClient();){
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(overTime).setSocketTimeout(socketTimeout.intValue()).build();
            UrlEncodedFormEntity reqFromEntity = new UrlEncodedFormEntity(reqParams, CHARACTER_UTF_EIGHT);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)reqFromEntity);
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                logger.info(resultStr);
                resultMap = (Map)JSONUtils.cast((String)resultStr, Map.class);
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e));
        }
        return resultMap;
    }

    public static Map<String, Object> doPost(String url, String params) {
        HashMap resultMap = HttpRetryServiceHelper.doPost(url, params, Map.class);
        if (resultMap == null) {
            resultMap = new HashMap();
        }
        return resultMap;
    }

    public static <T> T doPost(String url, String params, Class<T> cls) {
        Object t = null;
        String resultStr = HttpRetryServiceHelper.doPost_returnOriginResponse(url, params);
        if (resultStr != null) {
            t = Er.jsonToObj((String)resultStr, cls);
        }
        return (T)t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost_returnOriginResponse(String url, String params) {
        url = HttpRetryServiceHelper.getMockUrl(url);
        String fmt = ResManager.loadKDString((String)"\u53d1\u8d77post\u8bf7\u6c42 -- url:%1$s, params:%2$s", (String)"HttpServiceHelper_10", (String)"fi-er-business", (Object[])new Object[0]);
        try (CloseableHttpClient httpClient = HttpRetryServiceHelper.createHttpClient();){
            RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(30000).setSocketTimeout(socketTimeout.intValue());
            RequestConfig requestConfig = builder.build();
            StringEntity reqFromEntity = new StringEntity(params, ContentType.APPLICATION_JSON);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)reqFromEntity);
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null) return null;
            int statusCode = response.getStatusLine().getStatusCode();
            String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
            JSONObject responseJsonObject = JSON.parseObject((String)resultStr);
            responseJsonObject.put("responseCode", (Object)statusCode);
            String string = responseJsonObject.toString();
            return string;
        }
        catch (Exception e) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u8bf7\u6c42\u5931\u8d25\uff1a%s", (String)"HttpServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e.toString()));
        }
    }

    private static String getMockUrl(String url) {
        String mockurl = TripSyncConfigUtil.getTripsyncSettingByKey(url);
        if (mockurl != null) {
            url = mockurl;
        }
        return url;
    }

    public static <T> T doGet(String url, Map paramMap, Class<T> cls) {
        return HttpRetryServiceHelper.doGet(url, paramMap, cls, 30000);
    }

    public static <T> T doGet(String url, Map paramMap, Class<T> cls, int overTime) {
        Object resultObj = null;
        String resultStr = HttpRetryServiceHelper.doGet(url, (Map<String, Object>)paramMap, overTime);
        try {
            resultObj = JSONUtils.cast((String)resultStr, cls);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return (T)resultObj;
    }

    public static <T> T doPost(String url, List<NameValuePair> reqParams, Class<T> cls) {
        return HttpRetryServiceHelper.doPost(url, reqParams, 30000, cls);
    }

    public static <T> T doPost(String url, List<NameValuePair> reqParams, int overTime, Class<T> cls) {
        url = HttpRetryServiceHelper.getMockUrl(url);
        Object resultObj = null;
        try (CloseableHttpClient httpClient = HttpRetryServiceHelper.createHttpClient();){
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(overTime).setSocketTimeout(socketTimeout.intValue()).build();
            UrlEncodedFormEntity reqFromEntity = new UrlEncodedFormEntity(reqParams, CHARACTER_UTF_EIGHT);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)reqFromEntity);
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                logger.info(resultStr);
                resultObj = JSONUtils.cast((String)resultStr, cls);
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e));
        }
        return (T)resultObj;
    }

    public static String doGet(String url, Map paramMap) {
        int weatherOutTime = 3000;
        return HttpRetryServiceHelper.doGet(url, (Map<String, Object>)paramMap, weatherOutTime);
    }

    public static String httpGet(String url, Map paramMap) {
        return HttpRetryServiceHelper.httpGet(url, paramMap, 30000);
    }

    public static String httpGet(String url, Map<String, Object> paramMap, int overTime) {
        String resultStr;
        block21: {
            url = HttpRetryServiceHelper.getMockUrl(url);
            resultStr = null;
            try (CloseableHttpClient httpClient = HttpRetryServiceHelper.createHttpClient();){
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(overTime).setSocketTimeout(socketTimeout.intValue()).build();
                URIBuilder uriBuilder = new URIBuilder(url);
                if (paramMap != null) {
                    for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                        uriBuilder.setParameter(entry.getKey(), entry.getValue().toString());
                    }
                }
                HttpGet httpGet = new HttpGet(uriBuilder.build());
                httpGet.setConfig(requestConfig);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                HttpEntity responseEntity = response.getEntity();
                if (responseEntity != null) {
                    resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                }
            }
            catch (IOException | URISyntaxException e) {
                logger.error((Throwable)e);
                String traceid = RequestContext.get().getTraceId();
                String key = CommonServiceHelper.getMD5(traceid + JSON.toJSONString(paramMap));
                if ((e instanceof TimeoutException || e instanceof ConnectTimeoutException || e instanceof SocketTimeoutException) && null == ErCommonUtils.getKeyValueFromAppCache(key, String.class)) {
                    ErCommonUtils.putKeyValueToAppCache(key, "isretry");
                    for (int i = 0; i < MAX_RETUEN_HTTP; ++i) {
                        logger.info("http\u8bf7\u6c42\u8d85\u65f6\uff0c\u91cd\u8bd5 {}", (Object)(i + 1));
                        try {
                            resultStr = HttpRetryServiceHelper.doGet(url, paramMap, overTime);
                            break;
                        }
                        catch (Exception ex) {
                            logger.info("\u8bf7\u6c42\u5931\u8d252: {}", (Object)ThrowableHelper.toString((Exception)ex));
                            continue;
                        }
                    }
                }
                if (null != resultStr) break block21;
                throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e));
            }
        }
        return resultStr;
    }

    public static String doGet(String url, Map<String, Object> paramMap, int overTime) {
        url = HttpRetryServiceHelper.getMockUrl(url);
        String resultStr = null;
        try (CloseableHttpClient httpClient = HttpRetryServiceHelper.createHttpClient();){
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(overTime).setSocketTimeout(socketTimeout.intValue()).build();
            URIBuilder uriBuilder = new URIBuilder(url);
            if (paramMap != null) {
                for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                    uriBuilder.setParameter(entry.getKey(), entry.getValue().toString());
                }
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                resultStr = EntityUtils.toString((HttpEntity)responseEntity);
            }
        }
        catch (IOException | URISyntaxException e) {
            logger.error((Throwable)e);
            throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e));
        }
        return resultStr;
    }

    public static <T> T doPost(String url, Map<String, String> headerMap, Map<String, Object> bodyMap, Class<T> cls) {
        Object resultObj = null;
        url = HttpRetryServiceHelper.getMockUrl(url);
        try (CloseableHttpClient httpClient = HttpRetryServiceHelper.createHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            if (headerMap != null && headerMap.size() != 0) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    String string = entry.getKey();
                    String value = entry.getValue();
                    httpPost.setHeader(string, value);
                }
            }
            if (bodyMap != null && bodyMap.size() != 0) {
                ArrayList<BasicNameValuePair> reqParams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : bodyMap.entrySet()) {
                    String key = entry.getKey();
                    String reqValue = entry.getValue().toString();
                    reqParams.add(new BasicNameValuePair(key, reqValue));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(reqParams, CHARACTER_UTF_EIGHT);
                httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(connectTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            if (httpEntity != null) {
                String resultStr = EntityUtils.toString((HttpEntity)httpEntity);
                ObjectMapper objectMapper = new ObjectMapper();
                resultObj = objectMapper.readValue(resultStr, cls);
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return (T)resultObj;
    }

    public static String doPost(String url, Map<String, String> headerMap, Map<String, Object> bodyMap) {
        url = HttpRetryServiceHelper.getMockUrl(url);
        String resultStr = null;
        try (CloseableHttpClient httpClient = HttpRetryServiceHelper.createHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            if (headerMap != null && headerMap.size() != 0) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    String string = entry.getKey();
                    String value = entry.getValue();
                    httpPost.setHeader(string, value);
                }
            }
            if (bodyMap != null && bodyMap.size() != 0) {
                ArrayList<BasicNameValuePair> reqParams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : bodyMap.entrySet()) {
                    String key = entry.getKey();
                    String reqValue = entry.getValue().toString();
                    reqParams.add(new BasicNameValuePair(key, reqValue));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(reqParams, CHARACTER_UTF_EIGHT);
                httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(connectTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            if (httpEntity != null) {
                resultStr = EntityUtils.toString((HttpEntity)httpEntity);
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return resultStr;
    }

    public static <T> T doPost(String url, Map<String, String> headerMap, String bodyJson, Class<T> cls) {
        return HttpRetryServiceHelper.doPost(url, headerMap, bodyJson, cls, "text/json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String PostData(String url, String param) {
        String line;
        url = HttpRetryServiceHelper.getMockUrl(url);
        OutputStreamWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        HttpURLConnection conn = null;
        InputStream connInputStrem = null;
        OutputStream connOutputStream = null;
        URL realUrl = new URL(url);
        conn = HttpRetryServiceHelper.getHttpsConnection(url);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("accept", "*/*");
        conn.setRequestProperty("connection", "Keep-Alive");
        conn.setRequestProperty("user-agent", "Mozilla/4.0(compatible;MSIE6.0;WindowsNT5.1;SV1)");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.connect();
        connOutputStream = conn.getOutputStream();
        out = new OutputStreamWriter(connOutputStream, CHARACTER_UTF_EIGHT);
        out.write(param);
        out.flush();
        connInputStrem = conn.getInputStream();
        in = new BufferedReader(new InputStreamReader(connInputStrem, CHARACTER_UTF_EIGHT));
        while ((line = in.readLine()) != null) {
            result.append(line);
        }
        try {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (connInputStrem != null) {
                connInputStrem.close();
            }
            if (connOutputStream != null) {
                connOutputStream.close();
            }
            if (conn == null) return result.toString();
            conn.disconnect();
            return result.toString();
        }
        catch (IOException ex) {
            logger.error("\u5173\u95ed\u8f93\u5165\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38\uff01" + ex);
            throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"HttpServiceHelper_9", (String)"fi-er-business", (Object[])new Object[0]), ex)), new Object[0]);
        }
        catch (Exception e) {
            block27: {
                try {
                    logger.error("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                    String traceid = RequestContext.get().getTraceId();
                    String key = CommonServiceHelper.getMD5(traceid + param);
                    if ((e instanceof TimeoutException || e instanceof ConnectTimeoutException || e instanceof SocketTimeoutException) && null == ErCommonUtils.getKeyValueFromAppCache(key, String.class)) {
                        ErCommonUtils.putKeyValueToAppCache(key, "isretry");
                        for (int i = 0; i < MAX_RETUEN_HTTP; ++i) {
                            logger.info("http\u8bf7\u6c42\u8d85\u65f6\uff0c\u91cd\u8bd5 {}", (Object)(i + 1));
                            try {
                                String re = HttpRetryServiceHelper.PostData(url, param);
                                result = new StringBuilder();
                                result.append(re);
                                break;
                            }
                            catch (Exception ex) {
                                logger.info("\u8bf7\u6c42\u5931\u8d252: {}", (Object)ThrowableHelper.toString((Exception)ex));
                                continue;
                            }
                        }
                    }
                    if (!result.toString().isEmpty()) break block27;
                    throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"HttpServiceHelper_9", (String)"fi-er-business", (Object[])new Object[0]), e)), new Object[0]);
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        if (connInputStrem != null) {
                            connInputStrem.close();
                        }
                        if (connOutputStream != null) {
                            connOutputStream.close();
                        }
                        if (conn == null) throw throwable;
                        conn.disconnect();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        logger.error("\u5173\u95ed\u8f93\u5165\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38\uff01" + ex);
                        throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"HttpServiceHelper_9", (String)"fi-er-business", (Object[])new Object[0]), ex)), new Object[0]);
                    }
                }
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (connInputStrem != null) {
                    connInputStrem.close();
                }
                if (connOutputStream != null) {
                    connOutputStream.close();
                }
                if (conn == null) return result.toString();
                conn.disconnect();
                return result.toString();
            }
            catch (IOException ex) {
                logger.error("\u5173\u95ed\u8f93\u5165\u51fa\u6d41\u51fa\u73b0\u5f02\u5e38\uff01" + ex);
                throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"HttpServiceHelper_9", (String)"fi-er-business", (Object[])new Object[0]), ex)), new Object[0]);
            }
        }
    }

    public static String doPostForm(String url, List<NameValuePair> reqParams, int overTime) {
        url = HttpRetryServiceHelper.getMockUrl(url);
        String resultStr = "";
        try (CloseableHttpClient httpClient = HttpRetryServiceHelper.createHttpClient();){
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(overTime).setSocketTimeout(socketTimeout.intValue()).build();
            UrlEncodedFormEntity reqFromEntity = new UrlEncodedFormEntity(reqParams);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)reqFromEntity);
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                resultStr = EntityUtils.toString((HttpEntity)responseEntity);
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e));
        }
        return resultStr;
    }

    public static Map<String, Object> doGetInputStream(String url) {
        if (StringUtils.isEmpty((CharSequence)(url = HttpRetryServiceHelper.getMockUrl(url)))) {
            logger.info("HttpServiceHelper_doGetInputStream>>> url \u4e3a\u7a7a");
            return null;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        Object in = null;
        try {
            if (url.toLowerCase(Locale.ENGLISH).startsWith("http://")) {
                URL location = new URL(url);
                URLConnection openConnection = location.openConnection();
                openConnection.setConnectTimeout(connectTimeout);
                openConnection.setReadTimeout(socketTimeout);
                returnData.put("in", openConnection.getInputStream());
                returnData.put("size", openConnection.getContentLengthLong());
            } else {
                HttpURLConnection httpsConnection = HttpRetryServiceHelper.getHttpsConnection(url);
                returnData.put("in", httpsConnection.getInputStream());
                returnData.put("size", httpsConnection.getContentLengthLong());
            }
        }
        catch (IOException e) {
            logger.error("HttpServiceHelper_doGetInputStream>>>", (Throwable)e);
        }
        return returnData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost_noVerify(String desc, String url, Map<String, String> headerMap, String bodyJson) {
        String string;
        url = HttpRetryServiceHelper.getMockUrl(url);
        String logfmt = ResManager.loadKDString((String)"%1$s\uff0c\u6267\u884cpost\u8bf7\u6c42 - url: %2$s, body: %3$s", (String)"HttpRetryServiceHelper_2", (String)"fi-er-business", (Object[])new Object[0]);
        String simulateErrMsg = ResManager.loadKDString((String)"\u6a21\u62df\u9519\u8bef\uff0c\u53c2\u6570\uff1ainvoicecloud.simulateException", (String)"HttpRetryServiceHelper_16", (String)"fi-er-business", (Object[])new Object[0]);
        String simulateException = ErStdConfig.get("invoicecloud.simulateException");
        String simulateBizError = ErStdConfig.get("invoicecloud.simulateBizError");
        if (simulateException != null && "true".equals(simulateBizError)) {
            return ResManager.loadKDString((String)"{\"errcode\":\"4444\", \"description\": \"\u6a21\u62df\u4e1a\u52a1\u9519\u8bef\",\"access_token\":\"666\"}", (String)"HttpServiceHelper_17", (String)"fi-er-business", (Object[])new Object[0]);
        }
        if (simulateException != null && "true".equals(simulateException)) {
            throw new RuntimeException(simulateErrMsg);
        }
        if (ErStdConfig.getBoolean("intranet")) {
            return ResManager.loadKDString((String)"{\"errcode\":\"0000\", \"description\": \"\u64cd\u4f5c\u6210\u529f\",\"access_token\":\"666\"}", (String)"HttpServiceHelper_18", (String)"fi-er-business", (Object[])new Object[0]);
        }
        HttpURLConnection con = null;
        BufferedWriter writer = null;
        InputStreamReader in = null;
        BufferedReader bfreader = null;
        InputStream connInputStrem = null;
        OutputStream connOutputStream = null;
        try {
            TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            con = HttpRetryServiceHelper.getHttpsConnection(url);
            con.setRequestProperty("Content-type", "application/json");
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            if (con instanceof HttpsURLConnection) {
                Object sslContext = null;
                Object var16_18 = null;
                sslContext = SSLContext.getInstance("SSL", "SunJSSE");
                ((SSLContext)sslContext).init(null, tm, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = ((SSLContext)sslContext).getSocketFactory();
                ((HttpsURLConnection)con).setSSLSocketFactory(sSLSocketFactory);
            }
            if (headerMap != null) {
                for (Map.Entry entry : headerMap.entrySet()) {
                    con.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            con.connect();
            connOutputStream = con.getOutputStream();
            writer = new BufferedWriter(new OutputStreamWriter(connOutputStream));
            writer.write(bodyJson);
            writer.flush();
            int responseCode = con.getResponseCode();
            connInputStrem = responseCode == 200 ? con.getInputStream() : con.getErrorStream();
            in = new InputStreamReader(connInputStrem, StandardCharsets.UTF_8);
            bfreader = new BufferedReader(in);
            StringBuffer stringBuffer = new StringBuffer();
            String line = "";
            while ((line = bfreader.readLine()) != null) {
                stringBuffer.append(line);
            }
            String response = stringBuffer.toString();
            JSONObject responseJsonObject = JSON.parseObject((String)response);
            responseJsonObject.put("responseCode", (Object)responseCode);
            logfmt = ResManager.loadKDString((String)"%1$s\uff0c\u6267\u884cpost\u8bf7\u6c42 - response: %2$s", (String)"HttpRetryServiceHelper_13", (String)"fi-er-business", (Object[])new Object[0]);
            string = responseJsonObject.toString();
        }
        catch (Exception e) {
            try {
                logger.error((Throwable)e);
                if (e.getMessage() != null && simulateErrMsg.equals(e.getMessage())) {
                    throw new KDBizException(simulateErrMsg);
                }
                throw new KDException((Throwable)e, new ErrorCode("doPost_noVerify", String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a%s\u3002", (String)"HttpServiceHelper_19", (String)"fi-er-business", (Object[])new Object[0]), desc)), new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (bfreader != null) {
                        bfreader.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                    if (connInputStrem != null) {
                        connInputStrem.close();
                    }
                    if (connOutputStream != null) {
                        connOutputStream.close();
                    }
                    if (con == null) throw throwable;
                    con.disconnect();
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, new ErrorCode("doPost_noVerify", String.format(ResManager.loadKDString((String)"%s - \u91ca\u653e\u8d44\u6e90\u7684\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (String)"HttpServiceHelper_5", (String)"fi-er-business", (Object[])new Object[0]), desc)), new Object[0]);
                }
            }
        }
        try {
            if (bfreader != null) {
                bfreader.close();
            }
            if (in != null) {
                in.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (connInputStrem != null) {
                connInputStrem.close();
            }
            if (connOutputStream != null) {
                connOutputStream.close();
            }
            if (con == null) return string;
            con.disconnect();
            return string;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("doPost_noVerify", String.format(ResManager.loadKDString((String)"%s - \u91ca\u653e\u8d44\u6e90\u7684\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (String)"HttpServiceHelper_5", (String)"fi-er-business", (Object[])new Object[0]), desc)), new Object[0]);
        }
    }

    public static String doPost(String url, Map params) {
        if (KingdeeInvoiceCloudConfig.checkHttpsCertificate()) {
            return HttpServiceHelper.doPost_returnOriginResponse(url, Er.objToJson((Object)params));
        }
        return HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u83b7\u53d6", (String)"HttpRetryServiceHelper_14", (String)"fi-er-business", (Object[])new Object[0]), url, null, Er.objToJson((Object)params));
    }

    private static HttpURLConnection getHttpsConnection(String url) throws IOException {
        HttpURLConnection con = null;
        URL u = new URL(url);
        ErStdConfig.ProxyAddr httpProxy = ErStdConfig.getHttpProxy();
        if (httpProxy != null) {
            InetSocketAddress addr = new InetSocketAddress(httpProxy.hostname, httpProxy.port);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
            con = (HttpURLConnection)u.openConnection(proxy);
        } else {
            con = (HttpURLConnection)u.openConnection();
        }
        con.setConnectTimeout(connectTimeout);
        con.setReadTimeout(socketTimeout);
        return con;
    }

    private static CloseableHttpClient createHttpClient() {
        HttpClientBuilder custom = HttpClients.custom();
        ErStdConfig.ProxyAddr proxyAddr = ErStdConfig.getHttpProxy();
        if (proxyAddr != null) {
            HttpHost proxy = new HttpHost(proxyAddr.hostname, proxyAddr.port);
            custom.setProxy(proxy);
        }
        return custom.build();
    }

    private static HttpHost getProxyHttpHost() {
        ErStdConfig.ProxyAddr proxyAddr = ErStdConfig.getHttpProxy();
        if (proxyAddr != null) {
            HttpHost proxy = new HttpHost(proxyAddr.hostname, proxyAddr.port);
            return proxy;
        }
        return null;
    }

    public static Map<String, Object> httpPostRetry(String url, List<NameValuePair> reqParams, int overTime) {
        url = HttpRetryServiceHelper.getMockUrl(url);
        Map<String, Object> resultMap = new HashMap<String, Object>();
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(reqParams, CHARACTER_UTF_EIGHT));
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(30000).setSocketTimeout(socketTimeout.intValue()).build();
            httpPost.setConfig(requestConfig);
            HttpClientBuilder custom = HttpClients.custom();
            ErStdConfig.ProxyAddr proxyAddr = ErStdConfig.getHttpProxy();
            if (proxyAddr != null) {
                HttpHost proxy = new HttpHost(proxyAddr.hostname, proxyAddr.port);
                custom.setProxy(proxy);
            }
            custom.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, true){

                public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                    boolean flag = super.retryRequest(exception, executionCount, context);
                    if (flag) {
                        return true;
                    }
                    return exception instanceof NoHttpResponseException && executionCount <= 1;
                }
            });
            CloseableHttpClient client = custom.build();
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                resultMap = (Map)JSONUtils.cast((String)resultStr, Map.class);
            }
        }
        catch (ClientProtocolException e) {
            logger.error((Throwable)e);
            throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e}));
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s", (String)"HttpRetryServiceHelper_6", (String)"fi-er-business", (Object[])new Object[0]), e));
        }
        return resultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T doPost(String url, Map<String, String> headerMap, String bodyJson, Class<T> cls, String contentType) {
        url = HttpRetryServiceHelper.getMockUrl(url);
        Object resultObj = null;
        try (CloseableHttpClient httpClient = HttpRetryServiceHelper.createHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            if (headerMap != null && headerMap.size() != 0) {
                for (Map.Entry<String, String> map : headerMap.entrySet()) {
                    httpPost.setHeader(map.getKey(), map.getValue());
                }
            }
            StringEntity stringEntity = new StringEntity(bodyJson);
            stringEntity.setContentType(contentType);
            httpPost.setEntity((HttpEntity)stringEntity);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(connectTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null) return (T)resultObj;
            String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
            int statusCode = response.getStatusLine().getStatusCode();
            JSONObject responseJsonObject = JSON.parseObject((String)resultStr);
            responseJsonObject.put("responseCode", (Object)statusCode);
            if (cls.isAssignableFrom(String.class)) {
                String string = responseJsonObject.toString();
                return (T)string;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            resultObj = objectMapper.readValue(responseJsonObject.toString(), cls);
            return (T)resultObj;
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        return (T)resultObj;
    }
}

