/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class IntegralServiceHelper {
    public static final int FIRSTENTER_INTEGRALSCORE = 10;
    public static final int PRIASE_INTEGRALSCORE = 1;
    protected static final char[] INTEGRALTYPE = new char[]{'1', '2', '3', '4'};
    protected static final char[] INTEGRALTYPE_THREE = new char[]{'2', '3', '4'};

    public static String getCurrentMonth() {
        Calendar now = Calendar.getInstance();
        int month = now.get(2) + 1;
        String str = "score" + month;
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject getMyScoreList(Long userid) {
        DynamicObject myScore = null;
        ORM orm = ORM.create();
        QFilter Filter = new QFilter("user", "=", (Object)userid);
        QFilter[] qFilters = new QFilter[]{Filter};
        StringBuilder select = new StringBuilder("user.name name,user.picturefield,rank,praisecount,yearscore");
        try (DataSet ds = orm.queryDataSet("fi.er.IntegralboardPagePlugin", "er_view", select.toString(), qFilters);){
            DynamicObjectCollection dc = orm.toPlainDynamicObjectCollection(ds);
            if (!dc.isEmpty()) {
                myScore = (DynamicObject)dc.get(0);
            }
        }
        return myScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ishaveMyId(Long userId) throws SQLException {
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        int count = 0;
        try (DataSet dataSet = orm.queryDataSet("fi.er.view", "er_view", "id", qFilters);){
            DynamicObjectCollection dc = orm.toPlainDynamicObjectCollection(dataSet);
            count = dc.size();
        }
        return count;
    }

    public static DynamicObject getNowScore(Long userId) {
        QFilter qA = new QFilter("user", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qA};
        ORM orm = ORM.create();
        DynamicObject mySore = orm.queryOne("er_view", qFilters);
        return mySore;
    }

    public static DataSet getIntegralRankDataSet(List<Long> allUserList) {
        ORM orm = ORM.create();
        QFilter qA = new QFilter("user", "in", allUserList);
        QFilter[] qFilters = new QFilter[]{qA};
        String selectFields = "user,user.name name,user.picturefield avatar,yearscore,praisecount,modifytime";
        return orm.queryDataSet("fi.er.view", "er_view", selectFields, qFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObjectCollection getPraiseUserDataSet(List<Long> allUserList, Long userId) {
        DynamicObjectCollection dynamicObjects;
        ORM orm = ORM.create();
        Date startTime = IntegralServiceHelper.getStartTimeOfDay();
        Date endTime = IntegralServiceHelper.getEndTimeOfDay();
        QFilter qA = new QFilter("nowdate", ">=", (Object)startTime);
        QFilter qA1 = new QFilter("nowdate", "<=", (Object)endTime);
        QFilter qB = new QFilter("praiseuse", "=", (Object)userId);
        QFilter[] fFilters = new QFilter[]{qB, qA, qA1};
        DataSet scoreRankDataSet = IntegralServiceHelper.getIntegralRankDataSet(allUserList);
        DataSet praiseDataSet = orm.queryDataSet("fi.er.praiserecord", "er_praiserecord", "user puser,praiseuse,nowdate", fFilters);
        DataSet resultDataSet = scoreRankDataSet.join(praiseDataSet, JoinType.LEFT).on("user", "puser").select(new String[]{"user", "name", "avatar", "yearscore", "praisecount", "modifytime"}, new String[]{"puser", "praiseuse", "cast(case when puser = null then 0 else 1 end as integer) as isPraise"}).finish();
        resultDataSet = resultDataSet.orderBy(new String[]{"yearscore desc ", "modifytime ", "praisecount desc"});
        try {
            dynamicObjects = orm.toPlainDynamicObjectCollection(resultDataSet);
        }
        finally {
            if (resultDataSet != null) {
                resultDataSet.close();
            }
        }
        return dynamicObjects;
    }

    public static void insertExpenseRecord(Date happendate, long integralId, DynamicObject entryentity) {
        ORM orm = ORM.create();
        DynamicObject expenseRecord = orm.newDynamicObject("er_integralrecord");
        expenseRecord.set("happendate", (Object)happendate);
        expenseRecord.set("integral", (Object)integralId);
        DynamicObject expenseitem = (DynamicObject)entryentity.get("expenseitem");
        String expenseitemNumber = expenseitem.getString("number");
        if ("004".equals(expenseitemNumber)) {
            return;
        }
        expenseRecord.set("expenseitem", (Object)expenseitem);
        BigDecimal amountEnrty = entryentity.getBigDecimal("entryamount");
        expenseRecord.set("expenseamount", (Object)amountEnrty);
        orm.insert(expenseRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static DynamicObjectCollection queryIntegralRecord(Long userid) {
        DynamicObjectCollection records;
        ORM orm = ORM.create();
        QFilter Filter = new QFilter("integral", "=", (Object)userid);
        QFilter[] qFilters = new QFilter[]{Filter};
        StringBuilder select = new StringBuilder("expenseitem,expenseitem.number number,expenseitem.expenseitemicon expenseitemicon,expenseamount,score,happendate");
        try (DataSet ds = orm.queryDataSet("fi.er.IntegralboardPagePlugin", "er_integralrecord", select.toString(), qFilters);){
            records = orm.toPlainDynamicObjectCollection(ds);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObjectCollection queryHistoryIntegralRecord(Long userid) {
        DynamicObjectCollection historyRecords;
        ORM orm = ORM.create();
        QFilter aFilter = new QFilter("integral", "=", (Object)userid);
        QFilter bFilter = new QFilter("integraltype", "in", (Object)INTEGRALTYPE_THREE);
        QFilter cFilter = new QFilter("happendate", ">=", (Object)IntegralServiceHelper.getOneMonthBeforeandAfter(true, false));
        QFilter dFilter = new QFilter("happendate", "<=", (Object)IntegralServiceHelper.getOneMonthBeforeandAfter(false, true));
        QFilter[] qFilters = new QFilter[]{aFilter, bFilter, cFilter, dFilter};
        String selectFields = "integraltype,happendate,integralscore";
        try (DataSet ds = orm.queryDataSet("fi.er.MyintegralPagePlugin", "er_integralrecord", selectFields, qFilters, "happendate desc");){
            historyRecords = orm.toPlainDynamicObjectCollection(ds);
        }
        return historyRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getHighestScore(Long userid) {
        Long integralscore = 0L;
        ORM orm = ORM.create();
        QFilter Filter = new QFilter("integral", "=", (Object)userid);
        QFilter[] qFilters = new QFilter[]{Filter};
        try (DataSet ds = orm.queryDataSet("fi.er.IntegralboardPagePlugin", "er_integralrecord", "integralscore", qFilters, "integralscore desc");){
            DynamicObjectCollection scoredc = orm.toPlainDynamicObjectCollection(ds);
            if (!scoredc.isEmpty()) {
                integralscore = ((DynamicObject)scoredc.get(0)).getLong("integralscore");
            }
        }
        return integralscore;
    }

    public static void insertPraiseRecord(long praiseuse, long user) {
        ORM orm = ORM.create();
        DynamicObject praiseRecord = orm.newDynamicObject("er_praiserecord");
        praiseRecord.set("praiseuse", (Object)praiseuse);
        praiseRecord.set("user", (Object)user);
        praiseRecord.set("nowdate", (Object)new Date());
        orm.save(praiseRecord);
    }

    public static void deletePraiseRecord(long praiseuse, long user) {
        ORM orm = ORM.create();
        QFilter rFilter = new QFilter("praiseuse", "=", (Object)praiseuse);
        QFilter uFilter = new QFilter("user", "=", (Object)user);
        QFilter fFilter = new QFilter("nowdate", "<=", (Object)IntegralServiceHelper.getEndTimeOfDay());
        QFilter gFilter = new QFilter("nowdate", ">=", (Object)IntegralServiceHelper.getStartTimeOfDay());
        QFilter[] QFilters = new QFilter[]{rFilter, uFilter, fFilter, gFilter};
        DynamicObjectCollection praiseRecords = orm.query("er_praiserecord", "id", QFilters);
        if (!praiseRecords.isEmpty()) {
            DynamicObject praiseRecord = (DynamicObject)praiseRecords.get(0);
            orm.delete(praiseRecord);
        }
    }

    public static void insertUserScore(Long userId, int increaseScores, boolean isIncreasePrasie, boolean isCancelPrasie) {
        ORM orm = ORM.create();
        DynamicObject view = null;
        QFilter rFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] QFilters = new QFilter[]{rFilter};
        DynamicObjectCollection viewCol = orm.query("er_view", "id,praisecount,yearscore,year", QFilters);
        int praisecountInt = 0;
        int yearscoreInt = 0;
        if (!viewCol.isEmpty()) {
            view = (DynamicObject)viewCol.get(0);
            String praisecount = view.getString("praisecount");
            praisecountInt = Integer.parseInt(praisecount);
            String yearscore = view.getString("yearscore");
            yearscoreInt = Integer.parseInt(yearscore);
            if (isIncreasePrasie) {
                view.set("praisecount", (Object)(++praisecountInt));
                ++yearscoreInt;
            }
            if (isCancelPrasie) {
                view.set("praisecount", (Object)(--praisecountInt));
                --yearscoreInt;
            }
            view.set("yearscore", (Object)(yearscoreInt += increaseScores));
            Calendar calendar = Calendar.getInstance();
            view.set("year", (Object)calendar.get(1));
            view.set("user", (Object)userId);
            view.set("modifytime", (Object)new Date());
            orm.update(view);
        } else {
            view = orm.newDynamicObject("er_view");
            Calendar calendar = Calendar.getInstance();
            view.set("year", (Object)calendar.get(1));
            view.set("praisecount", (Object)praisecountInt);
            view.set("yearscore", (Object)(yearscoreInt + 10));
            view.set("user", (Object)userId);
            view.set("modifytime", (Object)new Date());
            orm.insert(view);
        }
    }

    public static int isHavePraiseUser(Long userId) {
        int count = 0;
        ORM orm = ORM.create();
        QFilter rFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] QFilters = new QFilter[]{rFilter};
        DynamicObjectCollection praiserecords = orm.query("er_praiserecord", "id", QFilters);
        if (!praiserecords.isEmpty()) {
            count = praiserecords.size();
        }
        return count;
    }

    public static int isFirstEnterApp(Long userId) {
        int count = 0;
        ORM orm = ORM.create();
        QFilter aFilter = new QFilter("integral", "=", (Object)userId);
        QFilter bFilter = new QFilter("happendate", "<=", (Object)IntegralServiceHelper.getEndTimeOfDay());
        QFilter cFilter = new QFilter("happendate\t", ">=", (Object)IntegralServiceHelper.getStartTimeOfDay());
        QFilter dFilter = new QFilter("integraltype", "=", (Object)Character.valueOf(INTEGRALTYPE[3]));
        QFilter[] QFilters = new QFilter[]{aFilter, bFilter, cFilter, dFilter};
        DynamicObjectCollection praiserecords = orm.query("er_integralrecord", "id", QFilters);
        if (!praiserecords.isEmpty()) {
            count = praiserecords.size();
        }
        return count;
    }

    public static void insertFirstEnterIntegralRescord(Long userId) {
        ORM orm = ORM.create();
        DynamicObject integralRecord = orm.newDynamicObject("er_integralrecord");
        integralRecord.set("integral", (Object)userId);
        integralRecord.set("integralScore", (Object)10);
        integralRecord.set("happendate", (Object)new Date());
        integralRecord.set("integraltype", (Object)Character.valueOf(INTEGRALTYPE[3]));
        integralRecord.set("isvital", (Object)"1");
        integralRecord.set("isparttime", (Object)"1");
        orm.insert(integralRecord);
    }

    public static void insertPraiseIntegralRercord(Long userId) {
        ORM orm = ORM.create();
        DynamicObject integralRecord = orm.newDynamicObject("er_integralrecord");
        integralRecord.set("integral", (Object)userId);
        integralRecord.set("integralScore", (Object)1);
        integralRecord.set("happendate", (Object)new Date());
        integralRecord.set("integraltype", (Object)Character.valueOf(INTEGRALTYPE[0]));
        integralRecord.set("isvital", (Object)"1");
        integralRecord.set("isparttime", (Object)"1");
        orm.insert(integralRecord);
    }

    public static void deletePraiseIntegralRercord(long user) {
        ORM orm = ORM.create();
        QFilter uFilter = new QFilter("integral", "=", (Object)user);
        QFilter rFilter = new QFilter("integraltype", "=", (Object)Character.valueOf(INTEGRALTYPE[0]));
        QFilter fFilter = new QFilter("happendate", "<=", (Object)IntegralServiceHelper.getEndTimeOfDay());
        QFilter gFilter = new QFilter("happendate", ">=", (Object)IntegralServiceHelper.getStartTimeOfDay());
        QFilter[] QFilters = new QFilter[]{rFilter, uFilter, fFilter, gFilter};
        DynamicObjectCollection praiseRecords = orm.query("er_integralrecord", "id", QFilters);
        if (!praiseRecords.isEmpty()) {
            DynamicObject praiseRecord = (DynamicObject)praiseRecords.get(0);
            orm.delete(praiseRecord);
        }
    }

    public static int refreshCurUserPraiseCount(Long userId) {
        int count = 0;
        ORM orm = ORM.create();
        QFilter aFilter = new QFilter("user", "=", (Object)userId);
        QFilter bFilter = new QFilter("nowdate", "<=", (Object)IntegralServiceHelper.getEndTimeOfDay());
        QFilter cFilter = new QFilter("nowdate", ">=", (Object)IntegralServiceHelper.getStartTimeOfDay());
        QFilter[] QFilters = new QFilter[]{aFilter, bFilter, cFilter};
        DynamicObjectCollection praiserecords = orm.query("er_praiserecord", "id", QFilters);
        if (!praiserecords.isEmpty()) {
            count = praiserecords.size();
        }
        return count;
    }

    public static Map<Long, Integer> getUserCurrentDayPraiseCountMap(String userIdStrings, StringBuilder noteBuffer) {
        final HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        String[] userIds = userIdStrings.split(",");
        Object[] parameters = new Object[userIds.length + 2];
        for (int i = 0; i < userIds.length; ++i) {
            parameters[i] = Long.valueOf(userIds[i]);
        }
        parameters[userIds.length] = IntegralServiceHelper.getStartTimeOfDay();
        parameters[userIds.length + 1] = IntegralServiceHelper.getEndTimeOfDay();
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("SELECT a.FUSERID as userid,count(1) as praisecount ");
        sqlBuffer.append("FROM t_ep_praiserecord a ");
        noteBuffer.insert(0, "where a.FUSERID in (");
        noteBuffer.append(") ");
        sqlBuffer.append((CharSequence)noteBuffer);
        sqlBuffer.append("and a.FNOWDATE >= ? and a.FNOWDATE <= ? ");
        sqlBuffer.append("group by a.FUSERID ");
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)sqlBuffer.toString(), (Object[])parameters, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    resultMap.put(rs.getLong("userid"), Integer.valueOf(rs.getString("praisecount")));
                }
                return null;
            }
        });
        return resultMap;
    }

    public static Date getStartTimeOfDay() {
        Calendar calendarBefor = Calendar.getInstance();
        calendarBefor.setTime(new Date());
        calendarBefor.set(11, 0);
        calendarBefor.set(12, 0);
        calendarBefor.set(13, 0);
        calendarBefor.set(14, 0);
        Date startTime = calendarBefor.getTime();
        return startTime;
    }

    public static Date getEndTimeOfDay() {
        Calendar calendarAfter = Calendar.getInstance();
        calendarAfter.setTime(new Date());
        calendarAfter.set(11, 23);
        calendarAfter.set(12, 59);
        calendarAfter.set(13, 59);
        calendarAfter.set(14, 59);
        Date endTime = calendarAfter.getTime();
        return endTime;
    }

    public static Date getOneMonthBeforeandAfter(boolean isBefore, boolean isAfter) {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        if (isBefore) {
            int before = month - 1;
            calendar.set(2, before);
        }
        if (isAfter) {
            int after = month + 1;
            calendar.set(2, after);
        }
        Date beforeMonth = calendar.getTime();
        return beforeMonth;
    }
}

