/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class TrialOrgServiceHelper {
    private static Log logger = LogFactory.getLog(TrialOrgServiceHelper.class);
    protected static String[] functionTripBusinessComboItems = new String[]{"bee_intair", "bee_domair", "bee_hotel", "bee_train", "bee_car", "corp_intair", "corp_domair", "corp_inthotel", "corp_hotel", "corp_car", "corp_train", "travelnoone_domair", "travelnoone_hotel", "travelnoone_car", "travelnoone_train", "didi_car", "meituan_dinner", "travelnoone_meal", "gaode_car", "didi_home", "dtg_home", "dtg_plane_in", "dtg_plane_out", "dtg_hotel_in", "dtg_hotel_out", "dtg_train", "dtg_car", "ali_home", "ali_plane", "ali_hotel", "ali_train", "ali_car", "qicheng_home", "qicheng_domair", "qicheng_intair", "qicheng_domhotel", "qicheng_car", "qicheng_train", "travelnoone_home", "corp_home", "meiya_home", "meiya_plane", "meiya_hotel", "meiya_train"};

    @Deprecated
    public static boolean isHaveTripBusinessFunction(Long userId, String function) {
        ArrayList<String> functions = new ArrayList<String>();
        functions.add(function);
        QFilter qTripA = new QFilter("enable", "=", (Object)"1");
        QFilter qTripB = new QFilter("function", "in", (Object)functionTripBusinessComboItems);
        QFilter[] qTripFilters = new QFilter[]{qTripA, qTripB};
        DynamicObject[] trialDynamicObject = (DynamicObject[])QueryServiceHelper.query((String)"er_trialorg", (String)"function, trialstyle, entryentity.trialorg", (QFilter[])qTripFilters).toArray((Object[])new DynamicObject[0]);
        if (trialDynamicObject.length < 1) {
            return true;
        }
        Boolean deafaultPermiss = false;
        Map<String, Boolean> permissionMap = TrialOrgServiceHelper.functionPermissionToUse(userId, functions, deafaultPermiss);
        boolean flag = permissionMap.getOrDefault(function, deafaultPermiss);
        return flag;
    }

    public static boolean isHaveFunction(Long userId, String function) {
        ArrayList<String> functions = new ArrayList<String>();
        functions.add(function);
        Boolean deafaultPermiss = true;
        Map<String, Boolean> permissionMap = TrialOrgServiceHelper.functionPermissionToUseNew(userId, functions, deafaultPermiss);
        boolean flag = permissionMap.getOrDefault(function, deafaultPermiss);
        return flag;
    }

    public static Map<String, Boolean> functionPermissionToUseNew(Long userId, Boolean deafaultPermiss) {
        return TrialOrgServiceHelper.functionPermissionToUseNew(userId, Arrays.stream(functionTripBusinessComboItems).collect(Collectors.toList()), deafaultPermiss);
    }

    public static Map<String, Boolean> functionPermissionToUseNew(Long userId, List<String> functions, Boolean deafaultPermiss) {
        HashMap<String, Boolean> functionUseRangeResult = new HashMap<String, Boolean>();
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter qB = new QFilter("function", "in", functions);
        QFilter[] qFilters = new QFilter[]{qA, qB};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_trialorg", (String)"id,function, trialstyle, entryentity.trialorg", (QFilter[])qFilters);
        if (dynamicObjectMap == null || dynamicObjectMap.isEmpty()) {
            for (String function : functions) {
                functionUseRangeResult.put(function, Boolean.TRUE);
            }
            return functionUseRangeResult;
        }
        Long currentUserID = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(currentUserID);
        Map userPositionInfo = (Map)UserServiceHelper.getPosition(userIds).get(0);
        if (null == userPositionInfo || null == userPositionInfo.get("entryentity")) {
            return functionUseRangeResult;
        }
        List userPositions = (List)userPositionInfo.get("entryentity");
        Map<String, List<DynamicObject>> trialGroupByFunction = dynamicObjectMap.values().stream().collect(Collectors.groupingBy(v -> v.getString("function")));
        HashSet<Long> dptIds = new HashSet<Long>(userPositions.size());
        HashMap<Long, Long> deptMapcompany = new HashMap<Long, Long>(userPositions.size());
        for (Map position : userPositions) {
            DynamicObject dept = (DynamicObject)position.get("dpt");
            if (dept == null) continue;
            Long deptId = (Long)dept.getPkValue();
            Map companyInfoMap = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
            Long companyId = (Long)companyInfoMap.get("id");
            deptMapcompany.put(deptId, companyId);
            dptIds.add(deptId);
        }
        Map<Long, Long> parentDeptIdMap = TrialOrgServiceHelper.getParentOrgIds(dptIds);
        for (List<DynamicObject> funtionOfGroup : trialGroupByFunction.values()) {
            DynamicObject fistFuntion = funtionOfGroup.get(0);
            String function = fistFuntion.getString("function");
            String trialStyle = fistFuntion.getString("trialstyle");
            DynamicObject newTrial = new DynamicObject(funtionOfGroup.get(0).getDynamicObjectType());
            if (funtionOfGroup.isEmpty()) {
                functionUseRangeResult.put(function, deafaultPermiss);
                continue;
            }
            DynamicObjectCollection newTrialEntry = newTrial.getDynamicObjectCollection("entryentity");
            for (DynamicObject trial : funtionOfGroup) {
                DynamicObjectCollection trialEntry = trial.getDynamicObjectCollection("entryentity");
                newTrialEntry.addAll((Collection)trialEntry);
            }
            boolean isAllow = false;
            for (Long dptId : dptIds) {
                Long companyId = -1L;
                if (null != deptMapcompany) {
                    companyId = deptMapcompany.getOrDefault(dptId, -1L);
                }
                Long finalParentDeptId = -1L;
                if (null != parentDeptIdMap) {
                    finalParentDeptId = parentDeptIdMap.getOrDefault(dptId, -1L);
                }
                logger.info("\u51fa\u5dee\u7533\u8bf7\u5355\u7533\u8bf7\u4eba:" + userId + ",\u516c\u53f8:" + companyId + ",\u90e8\u95e8:" + dptId + ",\u4e0a\u7ea7\u90e8\u95e8:" + finalParentDeptId);
                boolean orgFlag = newTrialEntry.stream().filter(v -> v.get("trialorg") != null).anyMatch(v -> dptId.equals(((DynamicObject)v.get("trialorg")).getPkValue()));
                Long finalParentDeptId1 = finalParentDeptId;
                boolean parentOrgFlag = newTrialEntry.stream().filter(v -> v.get("trialorg") != null).anyMatch(v -> finalParentDeptId1.equals(((DynamicObject)v.get("trialorg")).getPkValue()));
                Long finalCompanyId = companyId;
                boolean companyFlag = newTrialEntry.stream().filter(v -> v.get("trialorg") != null).anyMatch(v -> ((DynamicObject)v.get("trialorg")).getPkValue().equals(finalCompanyId));
                isAllow = TrialOrgServiceHelper.getTrialFlagByTrialStyle(trialStyle, orgFlag, parentOrgFlag, companyFlag);
                if (!isAllow) continue;
                break;
            }
            functionUseRangeResult.put(function, isAllow);
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
        return functionUseRangeResult;
    }

    public static Map<String, Boolean> functionPermissionToUse(Long userId, List<String> functions, Boolean deafaultPermiss) {
        HashMap<String, Boolean> functionUseRangeResult = new HashMap<String, Boolean>(functions.size());
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter qB = new QFilter("function", "in", functions);
        QFilter[] qFilters = new QFilter[]{qA, qB};
        DynamicObject[] trialDynamicObject = BusinessDataServiceHelper.load((String)"er_trialorg", (String)"function, trialstyle, entryentity.trialorg", (QFilter[])qFilters);
        if (trialDynamicObject == null || trialDynamicObject.length < 1) {
            for (String function : functions) {
                functionUseRangeResult.put(function, deafaultPermiss);
            }
            return functionUseRangeResult;
        }
        Long currentUserID = Long.valueOf(RequestContext.get().getUserId());
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(currentUserID);
        Map userPositionInfo = (Map)UserServiceHelper.getPosition(userIds).get(0);
        List userPositions = (List)userPositionInfo.get("entryentity");
        Map<String, List<DynamicObject>> trialGroupByFunction = Arrays.asList(trialDynamicObject).stream().collect(Collectors.groupingBy(v -> v.getString("function")));
        HashSet<Long> dptIds = new HashSet<Long>(userPositions.size());
        HashMap<Long, Long> deptMapcompany = new HashMap<Long, Long>(userPositions.size());
        for (Map position : userPositions) {
            DynamicObject dept = (DynamicObject)position.get("dpt");
            if (dept == null) continue;
            Long deptId = (Long)dept.getPkValue();
            Map companyInfoMap = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
            Long companyId = (Long)companyInfoMap.get("id");
            deptMapcompany.put(deptId, companyId);
            dptIds.add(deptId);
        }
        Map<Long, Long> parentDeptIdMap = TrialOrgServiceHelper.getParentOrgIds(dptIds);
        for (Map.Entry<String, List<DynamicObject>> functionGroupEntry : trialGroupByFunction.entrySet()) {
            DynamicObject newTrial = new DynamicObject(trialDynamicObject[0].getDynamicObjectType());
            List<DynamicObject> funtionOfGroup = functionGroupEntry.getValue();
            if (funtionOfGroup.isEmpty()) {
                functionUseRangeResult.put(functionGroupEntry.getKey(), deafaultPermiss);
            }
            DynamicObjectCollection newTrialEntry = newTrial.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < funtionOfGroup.size(); ++i) {
                DynamicObject trial = trialDynamicObject[i];
                DynamicObjectCollection trialEntry = trial.getDynamicObjectCollection("entryentity");
                newTrialEntry.addAll((Collection)trialEntry);
            }
            boolean isAllow = false;
            for (Long dptId : dptIds) {
                Long companyId = -1L;
                if (null != deptMapcompany) {
                    companyId = deptMapcompany.getOrDefault(dptId, -1L);
                }
                Long finalParentDeptId = -1L;
                if (null != parentDeptIdMap) {
                    finalParentDeptId = parentDeptIdMap.get(dptId);
                }
                logger.info("\u51fa\u5dee\u7533\u8bf7\u5355\u7533\u8bf7\u4eba:" + userId + ",\u516c\u53f8:" + companyId + ",\u90e8\u95e8:" + dptId + ",\u4e0a\u7ea7\u90e8\u95e8:" + finalParentDeptId);
                boolean orgFlag = newTrialEntry.stream().filter(v -> v.get("trialorg") != null).anyMatch(v -> dptId.equals(((DynamicObject)v.get("trialorg")).getPkValue()));
                Long finalParentDeptId1 = finalParentDeptId;
                boolean parentOrgFlag = newTrialEntry.stream().filter(v -> v.get("trialorg") != null).anyMatch(v -> finalParentDeptId1.equals(((DynamicObject)v.get("trialorg")).getPkValue()));
                Long finalCompanyId = companyId;
                boolean companyFlag = newTrialEntry.stream().filter(v -> v.get("trialorg") != null).anyMatch(v -> ((DynamicObject)v.get("trialorg")).getPkValue().equals(finalCompanyId));
                String trialStyle = trialDynamicObject[0].getString("trialstyle");
                isAllow = TrialOrgServiceHelper.getTrialFlagByTrialStyle(trialStyle, orgFlag, parentOrgFlag, companyFlag);
                if (!isAllow) continue;
                break;
            }
            functionUseRangeResult.put(functionGroupEntry.getKey(), isAllow);
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
        return functionUseRangeResult;
    }

    public static Long getParentOrgId(Long deptId) {
        QFilter orgFilter;
        Long parentDeptId = 0L;
        String selectFields = "org,org.number,org.name,org.orgpattern.patterntype,longnumber,parent";
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"01");
        QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)true);
        QFilter[] filters = new QFilter[]{treeTypeFilter, isDefaultViewFilter, orgFilter = new QFilter("org", "=", (Object)deptId)};
        DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (orgInfo != null && "3".equals(orgInfo.get("org.orgpattern.patterntype"))) {
            parentDeptId = ErCommonUtils.getPk(orgInfo.get("parent"));
        }
        return parentDeptId;
    }

    public static Map<Long, Long> getParentOrgIds(Set<Long> deptIds) {
        QFilter orgFilter;
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(deptIds.size());
        Long parentDeptId = 0L;
        String selectFields = "org,org.number,org.name,org.orgpattern.patterntype,longnumber,parent";
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"01");
        QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)true);
        QFilter[] filters = new QFilter[]{treeTypeFilter, isDefaultViewFilter, orgFilter = new QFilter("org", "in", deptIds)};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (null == dynamicObjectCollection || dynamicObjectCollection.isEmpty()) {
            return idMap;
        }
        for (DynamicObject orgInfo : dynamicObjectCollection) {
            Long parentObj;
            Long org = orgInfo.getLong("org");
            if (orgInfo != null && "3".equals(orgInfo.getString("org.orgpattern.patterntype")) && null != (parentObj = Long.valueOf(orgInfo.getLong("parent")))) {
                parentDeptId = parentObj;
            }
            idMap.put(org, parentDeptId);
        }
        return idMap;
    }

    public static boolean getTrialFlagByTrialStyle(String trialStyle, boolean orgFlag, boolean parentOrgFlag, boolean companyFlag) {
        boolean flag = false;
        switch (trialStyle) {
            case "0": {
                if (orgFlag) {
                    return true;
                }
                if (parentOrgFlag) {
                    return true;
                }
                if (companyFlag) {
                    return true;
                }
                flag = false;
                break;
            }
            case "1": {
                if (orgFlag) {
                    return false;
                }
                if (parentOrgFlag) {
                    return false;
                }
                if (companyFlag) {
                    return false;
                }
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static Boolean trialControl(String function, EventObject evt, Long currentCompanyId, IFormView view) {
        logger.info("\u8bd5\u70b9\u5355\u4f4d\uff0c\u529f\u80fd== {}", (Object)function);
        if ("bos_list".equalsIgnoreCase(function)) {
            return false;
        }
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter qB = new QFilter("function", "=", (Object)function);
        QFilter[] qFilters = new QFilter[]{qA, qB};
        Map trialDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_trialorg", (String)"function, trialstyle, entryentity.trialorg", (QFilter[])qFilters);
        if (trialDynamicObjectMap == null || trialDynamicObjectMap.size() < 1) {
            return false;
        }
        logger.info("\u8bd5\u70b9\u5355\u4f4d\uff0ctrialDynamicObjectMap.size()== {}", (Object)trialDynamicObjectMap.size());
        List DOList = trialDynamicObjectMap.values().stream().collect(Collectors.toList());
        if (DOList == null || DOList.isEmpty()) {
            return false;
        }
        logger.info("\u8bd5\u70b9\u5355\u4f4d\uff0cDOList.size()== {}", (Object)DOList.size());
        DynamicObject newTrial = new DynamicObject(((DynamicObject)DOList.get(0)).getDynamicObjectType());
        DynamicObjectCollection newTrialEntry = newTrial.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < DOList.size(); ++i) {
            DynamicObject trial = (DynamicObject)DOList.get(i);
            DynamicObjectCollection trialEntry = trial.getDynamicObjectCollection("entryentity");
            newTrialEntry.addAll((Collection)trialEntry);
        }
        String trialStyle = ((DynamicObject)DOList.get(0)).getString("trialstyle");
        boolean companyFlag = newTrialEntry.stream().anyMatch(v -> ((DynamicObject)v.get("trialorg")).getPkValue().equals(currentCompanyId));
        if ("0".equals(trialStyle)) {
            boolean bl = companyFlag = !companyFlag;
        }
        if (!StringUtils.equals((CharSequence)"bos_list", (CharSequence)view.getModel().getDataEntityType().getName()) && null != currentCompanyId && companyFlag && null == evt) {
            view.showMessage(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5728\u8bd5\u70b9\u7ec4\u7ec7\u8303\u56f4\u5185\uff0c\u8bf7\u5207\u6362\u7533\u8bf7\u4eba\u516c\u53f8\u3002", (String)"TrialOrgPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return true;
        }
        if ((!StringUtils.equals((CharSequence)"bos_list", (CharSequence)view.getModel().getDataEntityType().getName()) || evt != null) && companyFlag && evt != null) {
            TrialOrgServiceHelper.setViewAndClickCancel(evt, view);
            return true;
        }
        return false;
    }

    public static void listClickOp(EventObject args, List<Long> selectedIds, String function, IFormView view) {
        DynamicObjectCollection dynamicObjects;
        String billFormId = ((ListView)view).getListModel().getEntityId();
        if (null == billFormId || billFormId.isEmpty() || null == selectedIds || selectedIds.isEmpty()) {
            return;
        }
        try {
            dynamicObjects = QueryServiceHelper.query((String)billFormId, (String)"id,company", (QFilter[])new QFilter[]{new QFilter("id", "in", selectedIds)});
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u8868\u5355\u6570\u636e\u5f02\u5e38:{}", (Object)e.getMessage());
            return;
        }
        if (null != dynamicObjects) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                TrialOrgServiceHelper.trialControl(function, args, dynamicObject.getLong("company"), view);
            }
        }
    }

    public static String getFunction(IFormView view) {
        Boolean isloan;
        IDataEntityProperty isLoanProp;
        String function = view.getModel().getDataEntityType().getName();
        if (view instanceof ListView && view.getFormShowParameter() != null && view.getFormShowParameter().getCustomParams() != null && view.getFormShowParameter().getCustomParams().size() > 0 && view.getFormShowParameter().getCustomParams().get("billFormId") != null) {
            function = view.getFormShowParameter().getCustomParams().get("billFormId").toString();
        }
        if ("er_repaymentbill".equalsIgnoreCase(function)) {
            function = "er_dailyloanbill";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"er_tripreqbill", (CharSequence)function) && (isLoanProp = view.getModel().getProperty("isloan")) != null && (isloan = (Boolean)view.getModel().getValue("isloan")).booleanValue()) {
            function = "er_loanbill";
        }
        return function;
    }

    public static void setViewAndClickCancel(EventObject evt, IFormView view) {
        if (evt == null) {
            view.showMessage(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u6240\u5728\u7684\u90e8\u95e8\u4e0d\u5728\u8bd5\u70b9\u8303\u56f4\u5185\uff0c\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"TrialOrgPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else if (evt instanceof BeforeClickEvent) {
            ((BeforeClickEvent)evt).setCancel(true);
            view.showMessage(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u6240\u5728\u7684\u90e8\u95e8\u4e0d\u5728\u8bd5\u70b9\u8303\u56f4\u5185\uff0c\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"TrialOrgPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else if (evt instanceof BeforeItemClickEvent) {
            ((BeforeItemClickEvent)evt).setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u6240\u5728\u7684\u90e8\u95e8\u4e0d\u5728\u8bd5\u70b9\u8303\u56f4\u5185\uff0c\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"TrialOrgPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else if (evt instanceof BeforeDoOperationEventArgs) {
            ((BeforeDoOperationEventArgs)evt).setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u6240\u5728\u7684\u90e8\u95e8\u4e0d\u5728\u8bd5\u70b9\u8303\u56f4\u5185\uff0c\u6682\u65f6\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"TrialOrgPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    public static String getClickFunction(String key) {
        logger.info("\u6839\u636e\u70b9\u51fb\u64cd\u4f5c\u6807\u8bc6\u83b7\u53d6\u8bd5\u70b9\u529f\u80fd\u6807\u8bc6,\u70b9\u51fb\u64cd\u4f5c:" + key);
        String function = null;
        switch (key) {
            case "mnutriprequest": 
            case "mbmenuitem_tripresquest": 
            case "flex_waiting": {
                function = "er_tripreqbill";
                break;
            }
            case "mbmenuitem_loanbill": {
                function = "er_loanbill";
                break;
            }
            case "mnutripreimbur": 
            case "mbmenuitem_reimbursement": 
            case "flex_oustangding": 
            case "bar_pushpay": 
            case "pushdown": 
            case "reimbursebtn": {
                function = "er_tripreimbursebill";
                break;
            }
            case "mcostrequest": 
            case "mblock_dailyapplybill_add": {
                function = "er_dailyapplybill";
                break;
            }
            case "mblock_loan": 
            case "mblock_dailyloanbill_add": 
            case "bar_loan": 
            case "btn_loan": 
            case "loan": {
                function = "er_dailyloanbill";
                break;
            }
            case "mblock_reimburse": 
            case "mblock_dailyreimbill_add": 
            case "flex_receivable": 
            case "bar_push": 
            case "reimburse": 
            case "btn_reimburse": 
            case "bar_reimburse": 
            case "bar_toreimburse": {
                function = "er_dailyreimbursebill";
                break;
            }
            case "mblock_publicreimburse": 
            case "mblock_publicreimburs_add": 
            case "publicreimburse": {
                function = "er_publicreimbursebill";
                break;
            }
            case "mbaritemap_trip": 
            case "book": {
                function = "book";
                break;
            }
            case "printsetting": {
                function = "printsetting";
                break;
            }
            case "mblock_dailyvehicle_add": 
            case "mblock_dailyvehiclebil": {
                function = "er_dailyvehiclebill";
            }
        }
        return function;
    }

    public static Boolean getTrialControl(String function, Long deptId) {
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter qB = new QFilter("function", "=", (Object)function);
        QFilter[] qFilters = new QFilter[]{qA, qB};
        Map trialDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_trialorg", (String)"function, trialstyle, entryentity.trialorg", (QFilter[])qFilters);
        if (trialDynamicObjectMap == null || trialDynamicObjectMap.size() < 1) {
            return false;
        }
        List DOList = trialDynamicObjectMap.values().stream().collect(Collectors.toList());
        if (DOList == null || DOList.isEmpty()) {
            return false;
        }
        logger.info("\u8bd5\u70b9\u5355\u4f4d\uff0cDOList.size()== {}", (Object)DOList.size());
        DynamicObject newTrial = new DynamicObject(((DynamicObject)DOList.get(0)).getDynamicObjectType());
        DynamicObjectCollection newTrialEntry = newTrial.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < DOList.size(); ++i) {
            DynamicObject trial = (DynamicObject)DOList.get(i);
            DynamicObjectCollection trialEntry = trial.getDynamicObjectCollection("entryentity");
            newTrialEntry.addAll((Collection)trialEntry);
        }
        String trialStyle = ((DynamicObject)DOList.get(0)).getString("trialstyle");
        Map companyInfoMap = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
        Long companyId = (Long)companyInfoMap.get("id");
        Long finalParentDeptId = TrialOrgServiceHelper.getParentOrgId(deptId);
        logger.info("\u90e8\u95e8\u8d39\u7528\u6e05\u5355:\u516c\u53f8:" + companyId + ",\u90e8\u95e8:" + deptId + ",\u4e0a\u7ea7\u90e8\u95e8:" + finalParentDeptId);
        boolean orgFlag = newTrialEntry.stream().filter(v -> v.get("trialorg") != null).anyMatch(v -> ((DynamicObject)v.get("trialorg")).getPkValue().equals(deptId));
        boolean parentOrgFlag = newTrialEntry.stream().filter(v -> v.get("trialorg") != null).anyMatch(v -> ((DynamicObject)v.get("trialorg")).getPkValue().equals(finalParentDeptId));
        boolean companyFlag = newTrialEntry.stream().filter(v -> v.get("trialorg") != null).anyMatch(v -> ((DynamicObject)v.get("trialorg")).getPkValue().equals(companyId));
        boolean isAllow = TrialOrgServiceHelper.getTrialFlagByTrialStyle(trialStyle, orgFlag, parentOrgFlag, companyFlag);
        return isAllow;
    }
}

