/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class UserServiceHelper {
    public static List<DynamicObject> getUserByName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return Collections.emptyList();
        }
        return UserServiceHelper.getUserByNames(Lists.newArrayList((Object[])new String[]{userName}));
    }

    public static List<DynamicObject> getUserByNames(List<String> userNames) {
        if (userNames == null || userNames.isEmpty()) {
            return Collections.emptyList();
        }
        QFilter nameQFilter = new QFilter("name", "in", userNames);
        QFilter baseQFilter = QFilter.of((String)"status = ? and enable = ?", (Object[])new Object[]{"C", "1"});
        Map usersMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])new QFilter[]{nameQFilter, baseQFilter});
        return new ArrayList<DynamicObject>(usersMap.values());
    }

    public static List<DynamicObject> getUserByNames(List<String> userNames, QFilter otherQFilter) {
        if (userNames == null || userNames.isEmpty()) {
            return Collections.emptyList();
        }
        QFilter nameQFilter = new QFilter("name", "in", userNames);
        QFilter baseQFilter = QFilter.of((String)"status = ? and enable = ?", (Object[])new Object[]{"C", "1"});
        Map usersMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])new QFilter[]{nameQFilter, baseQFilter, otherQFilter});
        return new ArrayList<DynamicObject>(usersMap.values());
    }

    public static Map<Long, Long> getUserMainOrgId(List<Long> userIds) {
        ORM orgORM = ORM.create();
        QFilter f1 = new QFilter("id", "in", userIds);
        QFilter f2 = new QFilter("entryentity.ispartjob", "=", (Object)"0");
        HashMap<Long, Long> usreOrgMap = new HashMap<Long, Long>(userIds.size());
        try (DataSet ds = orgORM.queryDataSet(UserServiceHelper.class.getName(), "bos_user", "id,entryentity.dpt.id", new QFilter[]{f1, f2});){
            for (Row row : ds) {
                if (row.get(0) == null) continue;
                long iUserId = Long.parseLong(row.get(0).toString());
                long iOrgID = 0L;
                if (row.get(1) != null) {
                    iOrgID = Long.parseLong(row.get(1).toString());
                }
                usreOrgMap.put(iUserId, iOrgID);
            }
        }
        return usreOrgMap;
    }
}

