/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper.invoice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.utils.TXUtils;
import org.apache.commons.lang.StringUtils;

public class GenerateInvoiceAssistantNew {
    protected static Log logger = LogFactory.getLog(GenerateInvoiceAssistantNew.class);
    protected final Map<String, List<DynamicObject>> waitSaveDynamic = new HashMap<String, List<DynamicObject>>();
    protected final OperationResult operationResult = new OperationResult();
    protected final DynamicObject[] settleDynamics;
    protected final JumpInvoiceFilter jumpInvoiceFilter = new JumpInvoiceFilter();
    protected boolean isCancel;
    protected static final String KEY_INVOICE = "invoice";
    protected static final String KEY_INVOICE_REL = "invoice_rel";
    protected static final String KEY_SETTLE = "settle";
    protected static final String KEY_SETTLE_NEW = "settle_new";
    protected int failCount = 0;

    protected GenerateInvoiceAssistantNew(DynamicObject[] settleDynamics) {
        this.settleDynamics = settleDynamics;
        this.isCancel = false;
    }

    public static GenerateInvoiceAssistantNew getInstance(DynamicObject[] settleDynamics) {
        return new GenerateInvoiceAssistantNew(settleDynamics);
    }

    public void doExecute() {
        this.filter();
        if (this.operationResult.isSuccess()) {
            this.groupSettleDynamic();
            if (!this.isCancel) {
                this.waitSaveDynamic.remove(KEY_SETTLE);
                TXUtils.executeWithTX(txHandle -> this.waitSaveDynamic.values().forEach(dynamic -> {
                    if (dynamic != null && dynamic.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])dynamic.toArray(new DynamicObject[dynamic.size()]));
                    }
                }));
            }
        }
    }

    public JumpInvoiceFilter getJumpInvoiceFilter() {
        return this.jumpInvoiceFilter;
    }

    protected void groupSettleDynamic() {
        List<DynamicObject> settles = this.waitSaveDynamic.get(KEY_SETTLE);
        if (settles != null && settles.size() > 0) {
            DynamicObject allOrderBaseOb = settles.get(0).getDynamicObject("allorderbase");
            long companyId = (Long)allOrderBaseOb.getDynamicObject("company").getPkValue();
            String invoicetitle = (String)ErCommonUtils.getEMParameter(companyId, "invoicetitle");
            HashSet<String> servers = new HashSet<String>();
            HashSet<Long> expDept = new HashSet<Long>();
            HashSet<String> operationTypes = new HashSet<String>();
            Map<String, List<DynamicObject>> waitConvert2Invoice = settles.stream().collect(Collectors.groupingBy(key -> {
                servers.add(key.getString("server"));
                DynamicObject allOrderBase = key.getDynamicObject("allorderbase");
                long costCompanyId = 0L;
                long applyCompanyId = 0L;
                if (allOrderBase != null) {
                    DynamicObject company;
                    DynamicObject expcommitcomnum = allOrderBase.getDynamicObject("expcommitcomnum");
                    if (expcommitcomnum != null) {
                        costCompanyId = (Long)expcommitcomnum.getPkValue();
                    }
                    if ((company = allOrderBase.getDynamicObject("company")) != null) {
                        applyCompanyId = (Long)company.getPkValue();
                    }
                    String operationType = key.getString("operationtype");
                    this.jumpInvoiceFilter.opreateType.add(operationType);
                    operationTypes.add(operationType);
                }
                if ("2".equals(invoicetitle)) {
                    expDept.add(applyCompanyId);
                    return key.getString("server") + "&" + key.getString("operationtype") + "&" + key.getString("batchno") + "&" + key.getString("accountid") + "&" + applyCompanyId;
                }
                expDept.add(costCompanyId);
                return key.getString("server") + "&" + key.getString("operationtype") + "&" + key.getString("batchno") + "&" + key.getString("accountid") + "&" + costCompanyId;
            }));
            this.jumpInvoiceFilter.companyIds.addAll(expDept);
            Map<String, List<InvoiceSetting>> invoiceSettings = this.getInvoiceSetting(servers, expDept, operationTypes);
            this.generateInvoiceAndInvoiceRelMap(waitConvert2Invoice, invoiceSettings, this.waitSaveDynamic);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateInvoiceAndInvoiceRelMap(Map<String, List<DynamicObject>> waitConvert2Invoice, Map<String, List<InvoiceSetting>> invoiceSettings, Map<String, List<DynamicObject>> waitSaveDynamic) {
        long[] ids = DBServiceHelper.genLongIds((String)"t_er_invoiceorderbill", (int)(waitConvert2Invoice.size() * 5));
        int index = 0;
        Date createDate = new Date();
        this.jumpInvoiceFilter.date = createDate;
        String userId = RequestContext.get().getUserId();
        IErDao invoiceDao = ErDaoFactory.getInstance("er_invoiceorderbill");
        IErDao invoiceSettleRelDao = ErDaoFactory.getInstance("er_invoicesettle_rel");
        HashMap<String, DynamicObject> invoiceTemp = new HashMap<String, DynamicObject>();
        HashMap invoiceSubTemp = new HashMap();
        for (Map.Entry<String, List<DynamicObject>> entrySet : waitConvert2Invoice.entrySet()) {
            void var26_26;
            Object settle2;
            invoiceTemp.clear();
            invoiceSubTemp.clear();
            String[] keys = entrySet.getKey().split("&");
            String server = keys[0];
            String operationtype = keys[1];
            List<InvoiceSetting> invoiceServiceSetting = invoiceSettings.get(server + operationtype);
            if (invoiceServiceSetting == null) {
                this.operationResult.setSuccess(false);
                String message = this.operationResult.getMessage();
                if (message == null) {
                    message = "";
                }
                this.operationResult.setMessage(String.format(ResManager.loadKDString((String)"%s:\u8bf7\u5148\u7ef4\u62a4\u5f00\u7968\u8bbe\u7f6e\uff0c\u518d\u8fdb\u884c\u5f00\u7968\u64cd\u4f5c\u3002", (String)"GenerateInvoiceAssistantNew_0", (String)"fi-er-business", (Object[])new Object[0]), message + server));
                ++this.failCount;
                continue;
            }
            logger.info("\u5f00\u7968\u8bbe\u7f6e\uff1a" + JSON.toJSONString(invoiceServiceSetting));
            Map invoiceSettingMapping = invoiceServiceSetting.stream().collect(Collectors.toMap(InvoiceSetting::getServiceItem, Function.identity(), (o1, o2) -> o1));
            InvoiceSetting existServiceSetting = (InvoiceSetting)invoiceSettingMapping.get(Serviceitem.SERVICE);
            InvoiceSetting existInsuranceSetting = (InvoiceSetting)invoiceSettingMapping.get(Serviceitem.INSURANCE);
            InvoiceSetting existTicketSetting = (InvoiceSetting)invoiceSettingMapping.get(Serviceitem.TICKET);
            InvoiceSetting existItinerarySetting = (InvoiceSetting)invoiceSettingMapping.get(Serviceitem.ITINERARY);
            InvoiceSetting existItineraryrefundSetting = (InvoiceSetting)invoiceSettingMapping.get(Serviceitem.TICKREFUND);
            Map combineInvoice = invoiceSettingMapping.values().stream().collect(Collectors.groupingBy(v -> v.getBrief() + "_" + v.getInvoiceType() + "_" + v.getDiscountRate(), Collectors.mapping(InvoiceSetting::getServiceItem, Collectors.toList())));
            for (Map.Entry entry : combineInvoice.entrySet()) {
                logger.info("key=" + entry.getKey());
            }
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            for (Object settle2 : entrySet.getValue()) {
                DataEntityPropertyCollection properties;
                Object var28_34 = null;
                BigDecimal settleTotalTax = BigDecimal.ZERO;
                BigDecimal airportprice = BigDecimal.ZERO;
                BigDecimal otheramount = BigDecimal.ZERO;
                if ("er_planecheckingbill".equals(settle2.getString("formid"))) {
                    String string = settle2.getString("ticketstatus");
                    airportprice = settle2.getBigDecimal("airportprice");
                    otheramount = this.ifnull(settle2.getBigDecimal("otheramount"));
                }
                BigDecimal totalAmount = settle2.getBigDecimal("totalamount");
                BigDecimal orderamounttax = this.ifnull(settle2.getBigDecimal("orderamounttax"));
                BigDecimal serviceAmount = BigDecimal.ZERO;
                Object serviceamounttax = BigDecimal.ZERO;
                BigDecimal insuranceAmount = BigDecimal.ZERO;
                if (existServiceSetting != null) {
                    serviceAmount = settle2.getBigDecimal("servicefee");
                    serviceamounttax = this.ifnull(settle2.getBigDecimal("serviceamounttax"));
                }
                if (existInsuranceSetting != null && (properties = settle2.getDataEntityType().getProperties()).containsKey((Object)"assuranceamount")) {
                    insuranceAmount = this.ifnull(settle2.getBigDecimal("assuranceamount"));
                }
                BigDecimal ticketAmount = totalAmount.subtract(serviceAmount).subtract(insuranceAmount);
                block3: for (Map.Entry entry : combineInvoice.entrySet()) {
                    List serviceItems = entry.getValue();
                    String serviceItem = "";
                    BigDecimal total = BigDecimal.ZERO;
                    BigDecimal totaltax = BigDecimal.ZERO;
                    BigDecimal systemTaxRate = BigDecimal.ZERO;
                    String brief = "";
                    String invoiceType = "";
                    logger.info("\u8fdb\u5165\u670d\u52a1\u9879\u76ee\u5faa\u73af serviceItems {}", (Object)JSON.toJSONString(serviceItems));
                    for (Serviceitem item : serviceItems) {
                        void var28_36;
                        if (item == Serviceitem.TICKET && existTicketSetting != null) {
                            total = total.add(ticketAmount);
                            logger.info("\u8fdb\u5165\u670d\u52a1\u9879\u76ee\u5faa\u73af TICKET {}", (Object)total);
                            systemTaxRate = existTicketSetting.getDiscountRate();
                            orderamounttax = ticketAmount.multiply(systemTaxRate.divide(BigDecimal.valueOf(100L))).divide(BigDecimal.ONE.add(systemTaxRate.divide(BigDecimal.valueOf(100L))), 2, RoundingMode.HALF_UP);
                            totaltax = totaltax.add(orderamounttax);
                            brief = existTicketSetting.getBrief();
                            invoiceType = existTicketSetting.getInvoiceType();
                        } else if (item == Serviceitem.SERVICE && existServiceSetting != null) {
                            total = total.add(serviceAmount);
                            logger.info("\u8fdb\u5165\u670d\u52a1\u9879\u76ee\u5faa\u73af SERVICE {}", (Object)total);
                            systemTaxRate = existServiceSetting.getDiscountRate();
                            serviceamounttax = serviceAmount.multiply(systemTaxRate.divide(BigDecimal.valueOf(100L))).divide(BigDecimal.ONE.add(systemTaxRate.divide(BigDecimal.valueOf(100L))), 2, RoundingMode.HALF_UP);
                            totaltax = totaltax.add((BigDecimal)serviceamounttax);
                            brief = existServiceSetting.getBrief();
                            invoiceType = existServiceSetting.getInvoiceType();
                        } else if (item == Serviceitem.INSURANCE && existInsuranceSetting != null) {
                            total = total.add(insuranceAmount);
                            logger.info("\u8fdb\u5165\u670d\u52a1\u9879\u76ee\u5faa\u73af INSURANCE {}", (Object)total);
                            systemTaxRate = existInsuranceSetting.getDiscountRate();
                            totaltax = insuranceAmount.multiply(systemTaxRate.divide(BigDecimal.valueOf(100L))).divide(BigDecimal.ONE.add(systemTaxRate.divide(BigDecimal.valueOf(100L))), 2, RoundingMode.HALF_UP);
                            brief = existInsuranceSetting.getBrief();
                            invoiceType = existInsuranceSetting.getInvoiceType();
                        } else if (item == Serviceitem.ITINERARY && existItinerarySetting != null) {
                            if (!"USED".equals(var28_36) && !"CHANGED".equals(var28_36)) continue block3;
                            total = total.add(ticketAmount.subtract(otheramount));
                            logger.info("\u8fdb\u5165\u670d\u52a1\u9879\u76ee\u5faa\u73af ITINERARY {}", (Object)total);
                            systemTaxRate = existItinerarySetting.getDiscountRate();
                            BigDecimal ticketprice = settle2.getBigDecimal("ticketprice");
                            BigDecimal fuelprice = settle2.getBigDecimal("fuelprice");
                            orderamounttax = ticketprice.add(fuelprice).multiply(systemTaxRate.divide(BigDecimal.valueOf(100L))).divide(BigDecimal.ONE.add(systemTaxRate.divide(BigDecimal.valueOf(100L))), 2, RoundingMode.HALF_UP);
                            totaltax = totaltax.add(orderamounttax);
                            brief = existItinerarySetting.getBrief();
                            invoiceType = existItinerarySetting.getInvoiceType();
                        } else if (item == Serviceitem.TICKREFUND && existItineraryrefundSetting != null) {
                            if (!"REFOUND".equals(var28_36)) continue block3;
                            total = total.add(ticketAmount);
                            logger.info("\u8fdb\u5165\u670d\u52a1\u9879\u76ee\u5faa\u73af ITINERARY {}", (Object)total);
                            systemTaxRate = existItineraryrefundSetting.getDiscountRate();
                            orderamounttax = ticketAmount.multiply(systemTaxRate.divide(BigDecimal.valueOf(100L))).divide(BigDecimal.ONE.add(systemTaxRate.divide(BigDecimal.valueOf(100L))), 2, RoundingMode.HALF_UP);
                            totaltax = totaltax.add(orderamounttax);
                            brief = existItineraryrefundSetting.getBrief();
                            invoiceType = existItineraryrefundSetting.getInvoiceType();
                        }
                        serviceItem = serviceItem + "," + item.getName();
                    }
                    DynamicObject invoiceDynamic = (DynamicObject)invoiceTemp.get(entry.getKey());
                    if (invoiceDynamic == null) {
                        logger.info("\u521b\u5efa\u53d1\u7968\u5bf9\u8c61");
                        invoiceDynamic = invoiceDao.getEmptyDynamicObject();
                        invoiceDynamic.set("id", (Object)ids[index++]);
                        invoiceDynamic.set("server", (Object)keys[0]);
                        invoiceDynamic.set("billstatus", (Object)"A");
                        invoiceDynamic.set("operationType", (Object)keys[1]);
                        if (keys.length > 3) {
                            invoiceDynamic.set("batchno", (Object)keys[2]);
                            invoiceDynamic.set("accountid", (Object)keys[3]);
                        }
                        invoiceDynamic.set("expcommitcomnum", (Object)keys[4]);
                        invoiceDynamic.set("invoicedate", (Object)createDate);
                        invoiceDynamic.set("currency", settle2.get("currency"));
                        invoiceDynamic.set("createtime", (Object)createDate);
                        invoiceDynamic.set("creator", (Object)userId);
                        invoiceDynamic.set("invoicestatus", (Object)"1");
                        invoiceDynamic.set("invoicestatustime", (Object)createDate);
                        invoiceDynamic.set("settleamountwithtax", (Object)total);
                        invoiceDynamic.set("settleamounttax", (Object)totaltax);
                        invoiceDynamic.set("totalamount", (Object)total);
                        invoiceDynamic.set("serviceitem", (Object)serviceItem.replaceFirst(",", ""));
                        invoiceDynamic.set("invoiceType", (Object)invoiceType);
                        invoiceDynamic.set("systemtaxrate", (Object)systemTaxRate);
                        invoiceDynamic.set("invoiceheadnametype", (Object)brief);
                        CodeRuleInfo codeRuleInfo = codeRuleService.getCodeRule(invoiceDynamic.getDataEntityType().getName(), invoiceDynamic, keys[4]);
                        invoiceDynamic.set("billno", (Object)codeRuleService.getNumber(codeRuleInfo, invoiceDynamic));
                        if (StringUtils.endsWithIgnoreCase((String)Supplier.CHAILVYIHAO.name(), (String)server)) {
                            invoiceDynamic.set("trdinvoiceid", (Object)(invoiceDynamic.getString("batchno") + "&" + invoiceDynamic.getString("serviceitem")));
                        } else {
                            invoiceDynamic.set("trdinvoiceid", invoiceDynamic.getPkValue());
                        }
                        this.putInvoiceTemp(invoiceTemp, entry.getKey(), invoiceDynamic, (DynamicObject)settle2);
                    } else {
                        invoiceDynamic.set("totalamount", (Object)invoiceDynamic.getBigDecimal("totalamount").add(total));
                        invoiceDynamic.set("settleamountwithtax", (Object)invoiceDynamic.getBigDecimal("settleamountwithtax").add(total));
                        invoiceDynamic.set("settleamounttax", (Object)invoiceDynamic.getBigDecimal("settleamounttax").add(totaltax));
                    }
                    ArrayList<DynamicObject> subInvoiceList = (ArrayList<DynamicObject>)invoiceSubTemp.get(entry.getKey());
                    if (subInvoiceList == null) {
                        subInvoiceList = new ArrayList<DynamicObject>();
                        invoiceSubTemp.put(entry.getKey(), subInvoiceList);
                    }
                    DynamicObject invoiceRelDyn = invoiceSettleRelDao.getEmptyDynamicObject();
                    invoiceRelDyn.set("invoiceid", invoiceDynamic.get("id"));
                    invoiceRelDyn.set("invoicebillno", invoiceDynamic.get("billno"));
                    invoiceRelDyn.set("settleid", settle2.getPkValue());
                    invoiceRelDyn.set("serviceitem", (Object)serviceItem.replaceFirst(",", ""));
                    invoiceRelDyn.set("totalamount", (Object)total);
                    invoiceRelDyn.set("taxamount", (Object)totaltax);
                    invoiceRelDyn.set("currency", settle2.get("currency"));
                    invoiceRelDyn.set("systemtaxrate", (Object)systemTaxRate);
                    invoiceRelDyn.set("settleformid", (Object)settle2.getDataEntityType().getName());
                    invoiceRelDyn.set("allorderbase", settle2.get("allorderbase"));
                    settleTotalTax = settleTotalTax.add(totaltax);
                    subInvoiceList.add(invoiceRelDyn);
                }
                List<DynamicObject> settleDynList = waitSaveDynamic.get(KEY_SETTLE_NEW);
                if (settleDynList == null) {
                    settleDynList = new ArrayList<DynamicObject>();
                    waitSaveDynamic.put(KEY_SETTLE_NEW, settleDynList);
                }
                settle2.set("hasinvoice", (Object)"2");
                settle2.set("totaltax", (Object)settleTotalTax);
                settleDynList.add((DynamicObject)settle2);
            }
            List<DynamicObject> list = waitSaveDynamic.get(KEY_INVOICE);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                waitSaveDynamic.put(KEY_INVOICE, arrayList);
            }
            logger.info("\u53ef\u5f00\u53d1\u7968\u5355\u636e\u6570\u91cf" + var26_26.size());
            settle2 = invoiceTemp.entrySet().iterator();
            while (settle2.hasNext()) {
                Map.Entry entry = (Map.Entry)settle2.next();
                DynamicObject invoice = (DynamicObject)entry.getValue();
                String key = (String)entry.getKey();
                BigDecimal totoalTemp = invoice.getBigDecimal("totalamount");
                if (totoalTemp.compareTo(BigDecimal.ZERO) < 0) {
                    this.isCancel = true;
                    this.operationResult.setSuccess(false);
                    StringBuilder sb = new StringBuilder();
                    List<DynamicObject> checkingBills = entrySet.getValue();
                    StringBuilder orderNums = new StringBuilder();
                    for (DynamicObject checkingBill : checkingBills) {
                        orderNums.append(',');
                        orderNums.append(checkingBill.getString("ordernum"));
                    }
                    sb.append(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u8bb0\u5f55 [%s] \u751f\u6210\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5f00\u7968\u91d1\u989d\u4e0d\u5927\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"GenerateInvoiceAssistantNew_9", (String)"fi-er-business", (Object[])new Object[0]), orderNums));
                    String ckBillStr = sb.toString().replaceFirst(",", "");
                    this.operationResult.setMessage(ckBillStr);
                    return;
                }
                if (totoalTemp.compareTo(BigDecimal.ZERO) > 0) {
                    var26_26.add(invoice);
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.operationResult.getMessage())) continue;
                    this.operationResult.setMessage(ResManager.loadKDString((String)"\u5f00\u7968\u6210\u529f\u3002", (String)"GenerateInvoiceAssistantNew_2", (String)"fi-er-business", (Object[])new Object[0]));
                    continue;
                }
                if (totoalTemp.compareTo(BigDecimal.ZERO) != 0) continue;
                invoiceSubTemp.remove(key);
                this.operationResult.setMessage(ResManager.loadKDString((String)"\u5f00\u7968\u6210\u529f\uff0c\u5176\u4e2d\u90e8\u5206\u670d\u52a1\u9879\u76ee\u91d1\u989d\u4e3a0\uff0c\u672a\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355\u3002", (String)"GenerateInvoiceAssistantNew_3", (String)"fi-er-business", (Object[])new Object[0]));
            }
            List<DynamicObject> invoiceRelList = waitSaveDynamic.get(KEY_INVOICE_REL);
            if (invoiceRelList == null) {
                invoiceRelList = new ArrayList<DynamicObject>();
                waitSaveDynamic.put(KEY_INVOICE_REL, invoiceRelList);
            }
            if (invoiceSubTemp == null || invoiceSubTemp.size() <= 0) continue;
            for (List invoiceSub : invoiceSubTemp.values()) {
                invoiceRelList.addAll(invoiceSub);
            }
        }
    }

    protected void putInvoiceTemp(Map<String, DynamicObject> invoiceTemp, String key, DynamicObject invoiceDynamic, DynamicObject settle) {
        invoiceTemp.put(key, invoiceDynamic);
    }

    protected BigDecimal ifnull(BigDecimal amount) {
        if (amount == null) {
            return BigDecimal.ZERO;
        }
        return amount;
    }

    protected Map<String, List<InvoiceSetting>> getInvoiceSetting(Set<String> servers, Set<Long> expDept, String operationType) {
        HashMap<String, List<InvoiceSetting>> result = new HashMap<String, List<InvoiceSetting>>();
        DynamicObject[] invoiceSettings = ErDaoFactory.getInstance("er_invoicesetting").query(new QFilter("isp", "in", servers).and(new QFilter("enable", "=", (Object)"1")));
        Stream.of(invoiceSettings).forEach(invoiceSetting -> {
            DynamicObjectCollection collection = invoiceSetting.getDynamicObjectCollection("entryentity");
            collection.forEach(v -> {
                if (operationType.equals(v.getString("operationtype"))) {
                    String key = invoiceSetting.getString("isp");
                    InvoiceSetting temp = new InvoiceSetting();
                    temp.setDiscountRate(v.getBigDecimal("deductrate"));
                    temp.setBrief(v.getString("brief"));
                    temp.setInvoiceType(v.getString("invoicetype"));
                    temp.setServiceItem(Serviceitem.getItem(v.getString("serviceitem")));
                    temp.setOperateType(operationType);
                    ArrayList<InvoiceSetting> InvoiceSettingList = (ArrayList<InvoiceSetting>)result.get(key);
                    if (InvoiceSettingList == null) {
                        InvoiceSettingList = new ArrayList<InvoiceSetting>();
                        InvoiceSettingList.add(temp);
                        result.put(key, InvoiceSettingList);
                    } else {
                        InvoiceSettingList.add(temp);
                    }
                }
            });
        });
        return result;
    }

    protected Map<String, List<InvoiceSetting>> getInvoiceSetting(Set<String> servers, Set<Long> expDept, Set<String> operationTypes) {
        HashMap<String, List<InvoiceSetting>> result = new HashMap<String, List<InvoiceSetting>>();
        DynamicObject[] invoiceSettings = ErDaoFactory.getInstance("er_invoicesetting").query(new QFilter("isp", "in", servers).and(new QFilter("enable", "=", (Object)"1")));
        Stream.of(invoiceSettings).forEach(invoiceSetting -> {
            DynamicObjectCollection collection = invoiceSetting.getDynamicObjectCollection("entryentity");
            collection.forEach(v -> {
                for (String operationType : operationTypes) {
                    if (!operationType.equals(v.getString("operationtype"))) continue;
                    String key = invoiceSetting.getString("isp");
                    InvoiceSetting temp = new InvoiceSetting();
                    temp.setDiscountRate(v.getBigDecimal("deductrate"));
                    temp.setBrief(v.getString("brief"));
                    temp.setInvoiceType(v.getString("invoicetype"));
                    temp.setServiceItem(Serviceitem.getItem(v.getString("serviceitem")));
                    temp.setOperateType(operationType);
                    ArrayList<InvoiceSetting> InvoiceSettingList = (ArrayList<InvoiceSetting>)result.get(key + operationType);
                    if (InvoiceSettingList == null) {
                        InvoiceSettingList = new ArrayList<InvoiceSetting>();
                        InvoiceSettingList.add(temp);
                        result.put(key + operationType, InvoiceSettingList);
                        continue;
                    }
                    InvoiceSettingList.add(temp);
                }
            });
        });
        return result;
    }

    protected void filter() {
        ArrayList<String> balanceCount = new ArrayList<String>();
        ArrayList<String> statusCount = new ArrayList<String>();
        ArrayList<String> varCount = new ArrayList<String>();
        ArrayList hasInvoice = new ArrayList();
        ArrayList<String> unusedCount = new ArrayList<String>();
        for (DynamicObject settle2 : this.settleDynamics) {
            String ticketStatus;
            if (!(settle2.getString("server").equals(Supplier.XIECHENG.getValue()) || settle2.getString("server").equals(Supplier.CHAILVYIHAO.getValue()) || settle2.getString("server").equals(Supplier.DIDI.getValue()) || settle2.getString("server").equals(Supplier.ZHONGXING.getValue()))) {
                balanceCount.add(String.format(String.format(ResManager.loadKDString((String)"%s \u8be5\u8ba2\u5355\u670d\u52a1\u5546\u6570\u636e\u4e0d\u652f\u6301\u5f00\u7968\u7533\u8bf7", (String)"HotelAndPlaneCheckingBillList_22", (String)"fi-er-formplugin", (Object[])new Object[0]), settle2.getString("ordernum")), new Object[0]));
                this.operationResult.setSuccess(false);
                continue;
            }
            if ("3".equals(settle2.getString("isbalance"))) continue;
            if ("2".equals(settle2.getString("isbalance"))) {
                balanceCount.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u53f7%s\uff1a\u672a\u5bf9\u5e73\u3002", (String)"GenerateInvoiceAssistantNew_4", (String)"fi-er-business", (Object[])new Object[0]), settle2.getString("ordernum")));
                this.operationResult.setSuccess(false);
                continue;
            }
            if (!"C".equals(settle2.getString("billstatus"))) {
                statusCount.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u53f7%s\uff1a\u672a\u5ba1\u6838\u3002", (String)"GenerateInvoiceAssistantNew_5", (String)"fi-er-business", (Object[])new Object[0]), settle2.getString("ordernum")));
                this.operationResult.setSuccess(false);
                continue;
            }
            if (null == settle2.get("settlemain")) {
                statusCount.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u53f7%s:\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\u3002", (String)"GenerateInvoiceAssistantNew_13", (String)"fi-er-business", (Object[])new Object[0]), settle2.getString("ordernum")));
                this.operationResult.setSuccess(false);
                continue;
            }
            Long companyId = ErCommonUtils.getPk(settle2.getDynamicObject("settlemain"));
            int enableValue = ErCommonUtils.getEnableInvoiceAfterReimburse(companyId);
            if (enableValue == 1 && !settle2.getBoolean("allorderbase.isapprove")) {
                varCount.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u53f7%s\uff1a\u5dee\u65c5\u62a5\u9500\u5355\u8fd8\u672a\u5ba1\u6279\u901a\u8fc7\u3002", (String)"GenerateInvoiceAssistantNew_6", (String)"fi-er-business", (Object[])new Object[0]), settle2.getString("ordernum")));
                this.operationResult.setSuccess(false);
                continue;
            }
            HashSet<String> serverSet = new HashSet<String>();
            String server = settle2.getString("server");
            String operationType = settle2.getString("operationtype");
            serverSet.add(server);
            Map<String, List<InvoiceSetting>> invoiceSetMap = this.getInvoiceSetting(serverSet, null, operationType);
            if (invoiceSetMap.isEmpty()) continue;
            Map invoiceSettings = invoiceSetMap.get(server).stream().collect(Collectors.toMap(InvoiceSetting::getServiceItem, Function.identity(), (entity1, entity2) -> entity1));
            if (invoiceSettings.get(Serviceitem.ITINERARY) != null && ("UNUSED".equals(ticketStatus = settle2.getString("ticketstatus")) || ticketStatus.isEmpty())) {
                unusedCount.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u53f7%s\uff1a\u673a\u7968\u4f7f\u7528\u72b6\u6001\u672a\u4f7f\u7528\u3002", (String)"GenerateInvoiceAssistantNew_7", (String)"fi-er-business", (Object[])new Object[0]), settle2.getString("ordernum")));
                this.operationResult.setSuccess(false);
                continue;
            }
            List<DynamicObject> settleList = this.waitSaveDynamic.get(KEY_SETTLE);
            if (settleList == null) {
                settleList = new ArrayList<DynamicObject>();
                this.waitSaveDynamic.put(KEY_SETTLE, settleList);
            }
            settleList.add(settle2);
        }
        List<DynamicObject> settlesDyn = this.waitSaveDynamic.get(KEY_SETTLE);
        if (settlesDyn != null) {
            Set settleids = settlesDyn.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] invoiceSettleRel = ErDaoFactory.getInstance("er_invoicesettle_rel").query("id, settleid", new QFilter("settleid", "in", settleids));
            if (invoiceSettleRel != null && invoiceSettleRel.length > 0) {
                Set hasInvoceSettleIds = Stream.of(invoiceSettleRel).map(v -> v.getLong("settleid")).collect(Collectors.toSet());
                settlesDyn.forEach(settle -> {
                    if (hasInvoceSettleIds.contains(settle.getLong("id"))) {
                        hasInvoice.add(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u53f7\u201c%s\u201d\u5df2\u5b8c\u6210\u5f00\u7968\u3002", (String)"GenerateInvoiceAssistantNew_8", (String)"fi-er-business", (Object[])new Object[0]), settle.getString("ordernum")));
                    }
                });
            }
        }
        if (hasInvoice.size() > 0) {
            this.operationResult.setSuccess(false);
        }
        if (!this.operationResult.isSuccess()) {
            this.failCount = balanceCount.size() + statusCount.size() + varCount.size() + hasInvoice.size() + unusedCount.size();
            StringBuilder errMsg = new StringBuilder();
            if (balanceCount.size() > 0) {
                errMsg.append(balanceCount).append(";");
            }
            if (statusCount.size() > 0) {
                errMsg.append(statusCount).append(";");
            }
            if (varCount.size() > 0) {
                errMsg.append(varCount).append(";");
            }
            if (hasInvoice.size() > 0) {
                errMsg.append(hasInvoice);
            }
            if (unusedCount.size() > 0) {
                errMsg.append(unusedCount);
            }
            errMsg.insert(0, ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\u4fe1\u606f", (String)"GenerateInvoiceAssistantNew_11", (String)"fi-er-business", (Object[])new Object[0]));
            logger.info(errMsg.toString());
            this.operationResult.setMessage(errMsg.toString().replaceAll(",", ";").replaceAll("\\[", "").replaceAll("\\]", ""));
        }
    }

    public OperationResult getOperationResult() {
        String msg = "";
        String operationMsg = this.operationResult.getMessage();
        if (operationMsg == null) {
            operationMsg = "";
        }
        this.operationResult.setMessage(msg + operationMsg);
        return this.operationResult;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    protected static class InvoiceSetting {
        protected String brief;
        protected String invoiceType;
        protected BigDecimal discountRate;
        protected Serviceitem serviceItem;
        protected String operateType;

        protected InvoiceSetting() {
        }

        public BigDecimal getDiscountRate() {
            return this.discountRate;
        }

        public void setDiscountRate(BigDecimal discountRate) {
            this.discountRate = discountRate;
        }

        public String getOperateType() {
            return this.operateType;
        }

        public void setOperateType(String operateType) {
            this.operateType = operateType;
        }

        public String getBrief() {
            return this.brief;
        }

        public void setBrief(String brief) {
            this.brief = brief;
        }

        public String getInvoiceType() {
            return this.invoiceType;
        }

        public void setInvoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
        }

        public Serviceitem getServiceItem() {
            return this.serviceItem;
        }

        public void setServiceItem(Serviceitem serviceItem) {
            this.serviceItem = serviceItem;
        }
    }

    public static class JumpInvoiceFilter {
        private Set<Long> companyIds = new HashSet<Long>();
        private Date date = new Date();
        private Set<String> opreateType = new HashSet<String>();

        public Set<Long> getCompanyIds() {
            return this.companyIds;
        }

        public Set<String> getOpreateType() {
            return this.opreateType;
        }

        public Date getDate() {
            return this.date;
        }
    }
}

