/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper.loanclear;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.field.writeoffmoney.WriteOffFields;

public class LoanClearServiceHelper {
    public static boolean validateCheckAmount(DynamicObject dynamicObject, WriteOffFields fields) {
        DynamicObjectCollection expenseEntry = dynamicObject.getDynamicObjectCollection(fields.entryKey);
        DynamicObjectCollection loanClearEntry = dynamicObject.getDynamicObjectCollection(fields.loanClearKey);
        Object writeOffType = ErCommonUtils.getLoanCheckType(Long.parseLong(dynamicObject.getDynamicObject("company").getPkValue().toString()));
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType)) {
            Map<String, BigDecimal> expeCurrcyAmount = AmountUtils.groupByCurrency(expenseEntry, fields.entryCurrencyKey, fields.approveAmtOriKey);
            Map<String, BigDecimal> loanClearCurrcyAmount = AmountUtils.groupByCurrency(loanClearEntry, fields.loanClearCurrencyKey, fields.checkAmtOriKey);
            for (Map.Entry<String, BigDecimal> entrySet : expeCurrcyAmount.entrySet()) {
                BigDecimal loanClearAmt = loanClearCurrcyAmount.get(entrySet.getKey());
                if (loanClearAmt == null || entrySet.getValue().compareTo(loanClearAmt) >= 0) continue;
                return false;
            }
        } else {
            BigDecimal approveAmtTotal = AmountUtils.getEntryAmount(expenseEntry, fields.approveAmtKey);
            BigDecimal checkAmtTotal = AmountUtils.getEntryAmount(loanClearEntry, fields.checkAmtKey);
            if (BigDecimal.ZERO.compareTo(checkAmtTotal) < 0 && approveAmtTotal.compareTo(checkAmtTotal) < 0) {
                return false;
            }
        }
        return true;
    }
}

