/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper.rule;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class BillSettingRuleInfo {
    private static Log logger = LogFactory.getLog(BillSettingRuleInfo.class);
    private static final String FIELDNUMBER = "fieldnumber";
    public static final String HEAD = "head";
    private DynamicObject billSetting;
    private Long companyid;
    private String billtype;
    private ILocaleString formTitle;
    private Map<String, ILocaleString> fieldCaptionMap;
    private ArrayListMultimap<String, String> hiddenMultiMap = ArrayListMultimap.create();
    private ArrayListMultimap<String, MustInputField> mustInputMultiMap = ArrayListMultimap.create();
    private Set<String> lockSets;
    private Map<String, LockConditionInfo> lockMap;
    private Map<String, Set<String>> indexMap = Maps.newHashMapWithExpectedSize((int)16);
    private Set<String> effictiveFields;
    private boolean hasInit = false;
    private static String selectedFields = "number,name,group,formtitle,reimbursetype,entryentity.fieldnumber,entryentity.diyname,entryentity.fieldtype,entryentity.mustinput,entryentity.hidden,entryentity.lock,entryentity.lockconditionexpr,entryentity.lockconditionexpr_tag,entryentity.lockconditionjson,entryentity.lockconditionjson_tag";

    @Deprecated
    public static BillSettingRuleInfo getInstance(String reimbursetype, Long companyid, String billtype) {
        return BillSettingRuleInfo.getInstance("reimbursetype", reimbursetype, companyid, billtype);
    }

    public static BillSettingRuleInfo getInstance(String controlField, Object value, Long companyid, String billtype) {
        BillSettingRuleInfo billSettingRuleInfo = new BillSettingRuleInfo(controlField, value, companyid, billtype);
        if (billSettingRuleInfo.hasInit) {
            return billSettingRuleInfo;
        }
        return null;
    }

    public static ArrayListMultimap<String, String> getAllHiddenMultiMap(Long companyid, String billtype) {
        Map<Object, DynamicObject> queryBillSetting = BillSettingRuleInfo.queryBillSetting(null, null, companyid, billtype);
        ArrayListMultimap allHiddenMultiMap = ArrayListMultimap.create();
        for (Map.Entry<Object, DynamicObject> billSettings : queryBillSetting.entrySet()) {
            DynamicObject billSetting = billSettings.getValue();
            DynamicObjectCollection entryentity = billSetting.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                BillSettingRuleInfo.initVisibleSets((ArrayListMultimap<String, String>)allHiddenMultiMap, entry);
            }
        }
        return allHiddenMultiMap;
    }

    private BillSettingRuleInfo(String controlField, Object value, Long companyid, String billtype) {
        Map<Object, DynamicObject> queryBaseDataFromCache;
        this.companyid = companyid;
        this.billtype = billtype;
        if (value != null && StringUtils.isNotBlank((CharSequence)value.toString()) && (queryBaseDataFromCache = BillSettingRuleInfo.queryBillSetting(controlField, value, companyid, billtype)).size() > 0) {
            this.billSetting = queryBaseDataFromCache.entrySet().iterator().next().getValue();
        }
        if (this.billSetting != null) {
            this.init();
            logger.info("billsettingrule: {}", this.billSetting.getPkValue());
        } else {
            logger.info("not exist rule: controlField {},value: {},companyid:{},billtype:{}", new Object[]{controlField, value, companyid, billtype});
        }
    }

    private static Map<Object, DynamicObject> queryBillSetting(String controlField, Object value, Long companyid, String billtype) {
        String filterStr = "enable = ? and group.number = ? ";
        String enable = "1";
        QFilter filter = null;
        if (value == null) {
            filter = QFilter.of((String)filterStr, (Object[])new Object[]{enable, billtype});
        } else {
            filterStr = filterStr.concat(String.format("and %1s = ?", controlField));
            filter = QFilter.of((String)filterStr, (Object[])new Object[]{enable, billtype, value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value});
        }
        Map<Object, DynamicObject> queryBaseDataFromCache = BaseDataServiceHelper.queryBaseDataFromCache((String)"er_bill_setting", (Long)companyid, (QFilter)filter, (String)selectedFields);
        if (queryBaseDataFromCache.size() > 0) {
            return queryBaseDataFromCache;
        }
        String srcBillType = null;
        if (ErEntityTypeUtils.isDailyApplyBill(billtype)) {
            srcBillType = "er_dailyapplybill";
        } else if (ErEntityTypeUtils.isDailyReimburseBill(billtype)) {
            srcBillType = "er_dailyreimbursebill";
        } else if (ErEntityTypeUtils.isPublicReimburseBill(billtype)) {
            srcBillType = "er_publicreimbursebill";
        }
        if (StringUtils.isNotBlank((CharSequence)srcBillType) && !billtype.equals(srcBillType) && (queryBaseDataFromCache = BillSettingRuleInfo.queryBillSetting(controlField, value, companyid, srcBillType)).size() > 0) {
            return BillSettingRuleInfo.queryBillSetting(controlField, value, companyid, srcBillType);
        }
        return Maps.newLinkedHashMapWithExpectedSize((int)0);
    }

    private void init() {
        this.formTitle = this.billSetting.getLocaleString("formtitle");
        DynamicObjectCollection entryentity = this.billSetting.getDynamicObjectCollection("entryentity");
        this.fieldCaptionMap = Maps.newHashMapWithExpectedSize((int)entryentity.size());
        this.lockSets = Sets.newHashSetWithExpectedSize((int)entryentity.size());
        this.lockMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject entry : entryentity) {
            this.initFieldCaptionMap(entry);
            BillSettingRuleInfo.initVisibleSets(this.hiddenMultiMap, entry);
            this.initMustInputSets(entry);
            this.initLock(entry);
        }
        this.effictiveFields = Sets.newHashSetWithExpectedSize((int)entryentity.size());
        this.lockMap.values().stream().forEach(v -> this.effictiveFields.addAll(v.getEffictiveFields()));
        this.hasInit = true;
    }

    private void initLock(DynamicObject entry) {
        if (entry.getBoolean("lock")) {
            String fieldKey = BillSettingRuleUtil.getRealFieldName(entry.getString(FIELDNUMBER));
            String lockconditionexpr = entry.getString("lockconditionexpr_tag");
            if (StringUtils.isNotBlank((CharSequence)lockconditionexpr)) {
                this.lockMap.put(fieldKey, new LockConditionInfo(fieldKey, lockconditionexpr, entry.getString("lockconditionjson_tag"), this.indexMap));
            } else {
                this.lockSets.add(fieldKey);
            }
        }
    }

    private void initMustInputSets(DynamicObject entry) {
        if (entry.getBoolean("mustinput")) {
            String fieldkey = entry.getString(FIELDNUMBER);
            this.mustInputMultiMap.put((Object)BillSettingRuleInfo.getEntryName(fieldkey), (Object)new MustInputField(BillSettingRuleUtil.getRealFieldName(fieldkey), entry.getString("diyname")));
        }
    }

    private static void initVisibleSets(ArrayListMultimap<String, String> hiddenMultiMap, DynamicObject entry) {
        if (entry.getBoolean("hidden")) {
            String fieldkey = entry.getString(FIELDNUMBER);
            hiddenMultiMap.put((Object)BillSettingRuleInfo.getEntryName(fieldkey), (Object)BillSettingRuleUtil.getRealFieldName(fieldkey));
        }
    }

    private void initFieldCaptionMap(DynamicObject entry) {
        ILocaleString diyname = entry.getLocaleString("diyname");
        if (diyname != null && StringUtils.isNotBlank((CharSequence)diyname.getLocaleValue())) {
            this.fieldCaptionMap.put(entry.getString(FIELDNUMBER), diyname);
        }
    }

    public ILocaleString getFormTitle() {
        return this.formTitle;
    }

    public Map<String, ILocaleString> getFieldCaption() {
        return this.fieldCaptionMap;
    }

    public ArrayListMultimap<String, String> getHiddenMultiMap() {
        return this.hiddenMultiMap;
    }

    public Map<String, LockConditionInfo> getLockMap() {
        return this.lockMap;
    }

    public ArrayListMultimap<String, MustInputField> getMustInputMultiMap() {
        return this.mustInputMultiMap;
    }

    public Set<String> getLockSets() {
        return this.lockSets;
    }

    public Set<String> getEffictiveFields() {
        return this.effictiveFields;
    }

    private static String getEntryName(String fieldname) {
        int indexOf = fieldname.indexOf(46);
        if (indexOf != -1) {
            return fieldname.substring(0, indexOf);
        }
        return HEAD;
    }

    @Deprecated
    public LockConditionInfo getLockConditionInfoByEffictiveField(String effictiveField) {
        return null;
    }

    public List<LockConditionInfo> getLockConditionInfosByEffictiveField(String effictiveField) {
        Set<String> fieldKeys = this.indexMap.get(effictiveField);
        if (fieldKeys != null && !fieldKeys.isEmpty()) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)fieldKeys.size());
            for (String fieldKey : fieldKeys) {
                list.add(this.lockMap.get(fieldKey));
            }
            return list;
        }
        return Lists.newLinkedList();
    }

    public Long getCompanyid() {
        return this.companyid;
    }

    public String getBilltype() {
        return this.billtype;
    }

    static class LockConditionInfo {
        private String fieldKey = null;
        private String lockconditionexpr = null;
        private String lockConditionJson = null;
        private List<String> effictiveFields;

        public LockConditionInfo(String fieldKey, String lockconditionexpr, String lockConditionJson, Map<String, Set<String>> indexMap) {
            this.fieldKey = fieldKey;
            this.lockconditionexpr = lockconditionexpr;
            this.lockConditionJson = lockConditionJson;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)lockConditionJson, FilterCondition.class);
            List filterRows = filterCondition.getFilterRow();
            this.effictiveFields = Lists.newArrayListWithExpectedSize((int)filterRows.size());
            for (SimpleFilterRow filterRow : filterRows) {
                this.effictiveFields.add(filterRow.getFieldName());
                HashSet fieldKeys = indexMap.get(filterRow.getFieldName());
                if (fieldKeys == null) {
                    fieldKeys = Sets.newHashSetWithExpectedSize((int)4);
                    indexMap.put(filterRow.getFieldName(), fieldKeys);
                }
                fieldKeys.add(this.fieldKey);
            }
        }

        public List<String> getEffictiveFields() {
            return this.effictiveFields;
        }

        public String getLockconditionexpr() {
            return this.lockconditionexpr;
        }

        public String getLockConditionJson() {
            return this.lockConditionJson;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }
    }

    static class MustInputField {
        private String field;
        private String diyname;

        public MustInputField(String field, String diyname) {
            this.field = field;
            this.diyname = diyname;
        }

        public String getField() {
            return this.field;
        }

        public String getDiyname() {
            return this.diyname;
        }
    }
}

