/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.share;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.er.business.utils.CollectorsUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class ErVerifyShareRuleHelper {
    public static String getVerifyShareRuleMsg(DynamicObject bill) {
        String msg = ErVerifyShareRuleHelper.verifyCommonRule(bill);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return msg;
        }
        msg = ErVerifyShareRuleHelper.verifyOrgRule(bill);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return msg;
        }
        msg = ErVerifyShareRuleHelper.verifyMonthRule(bill);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return msg;
        }
        return msg;
    }

    private static String verifyCommonRule(DynamicObject bill) {
        int index;
        String msg = "";
        Object shareRule = bill.get("sharerule");
        if (shareRule == null) {
            msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u644a\u89c4\u5219\u3002", (String)"ErVerifyShareRuleHelper_1", (String)"fi-er-business", (Object[])new Object[0]);
            return msg;
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
        if (entrys == null || entrys.isEmpty()) {
            msg = ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u5206\u644a\u660e\u7ec6\u3002", (String)"ErVerifyShareRuleHelper_16", (String)"fi-er-business", (Object[])new Object[0]);
            return msg;
        }
        if ("avg".equalsIgnoreCase(bill.getString("sharemethod")) && !StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)String.valueOf(shareRule))) {
            return msg;
        }
        if ("rate".equalsIgnoreCase(bill.getString("sharemethod")) && !StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)String.valueOf(shareRule))) {
            BigDecimal sumShareRate = BigDecimal.ZERO;
            index = 1;
            for (Object obj : entrys) {
                BigDecimal doing_shareRate = obj.getBigDecimal("sharerate_comrule");
                if (null == doing_shareRate || doing_shareRate.compareTo(BigDecimal.ZERO) == 0) {
                    msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u5206\u644a\u6bd4\u4f8b\u201d\u5b57\u6bb5\u3002", (String)"ErVerifyShareRuleHelper_31", (String)"fi-er-business", (Object[])new Object[0]), index);
                    return msg;
                }
                sumShareRate = sumShareRate.add(doing_shareRate);
                ++index;
            }
            BigDecimal shareRate = new BigDecimal(100);
            if (ErVerifyShareRuleHelper.isAllShare(bill) && sumShareRate.compareTo(shareRate) != 0) {
                msg = ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u5408\u8ba1\u4e0d\u7b49\u4e8e100%\uff0c\u8bf7\u5148\u4fee\u6539\u5206\u644a\u6bd4\u4f8b\u3002", (String)"ErVerifyShareRuleHelper_20", (String)"fi-er-business", (Object[])new Object[0]);
                return msg;
            }
            if (!ErVerifyShareRuleHelper.isAllShare(bill) && sumShareRate.compareTo(shareRate) > 0) {
                msg = ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u5408\u8ba1\u8d85\u8fc7100%\uff0c\u8bf7\u5148\u4fee\u6539\u5206\u644a\u6bd4\u4f8b\u3002", (String)"ErVerifyShareRuleHelper_21", (String)"fi-er-business", (Object[])new Object[0]);
                return msg;
            }
        }
        if ("amount".equalsIgnoreCase(bill.getString("sharemethod"))) {
            String entityTeye = bill.getDataEntityType().getName();
            if (!ErEntityTypeUtils.isTripReimburseBill(entityTeye)) {
                DynamicObjectCollection ruleEntrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
                int index2 = 1;
                for (DynamicObject obj : ruleEntrys) {
                    BigDecimal shareAmountComRule = obj.getBigDecimal("shareamount_comrule");
                    BigDecimal shareAppamountComrule = obj.getBigDecimal("shareappamount_comrule");
                    if (null == shareAmountComRule || shareAmountComRule.compareTo(BigDecimal.ZERO) == 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u644a\u91d1\u989d\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u5206\u644a\u91d1\u989d\u3002", (String)"ErVerifyShareRuleHelper_32", (String)"fi-er-business", (Object[])new Object[0]), index2);
                        return msg;
                    }
                    if (null == shareAppamountComrule || shareAppamountComrule.compareTo(BigDecimal.ZERO) == 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6838\u5b9a\u91d1\u989d\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u6838\u5b9a\u91d1\u989d\u3002", (String)"ErVerifyShareRuleHelper_33", (String)"fi-er-business", (Object[])new Object[0]), index2);
                        return msg;
                    }
                    ++index2;
                }
                Map<Long, BigDecimal> ruleEntryAmountMap = ruleEntrys.stream().collect(Collectors.groupingBy(ruleEntry -> ruleEntry.getLong("sharewaitid_comrule"), CollectorsUtil.summingBigDecimal(ruleEntry -> ruleEntry.getBigDecimal("shareamount_comrule"))));
                Map<Long, BigDecimal> ruleEntryApproveAmountMap = ruleEntrys.stream().collect(Collectors.groupingBy(ruleEntry -> ruleEntry.getLong("sharewaitid_comrule"), CollectorsUtil.summingBigDecimal(ruleEntry -> ruleEntry.getBigDecimal("shareappamount_comrule"))));
                DynamicObjectCollection expenEntrys = new DynamicObjectCollection();
                String amountProp = "";
                String approveAmountProp = "";
                if (ErEntityTypeUtils.isShareBill(entityTeye)) {
                    expenEntrys = bill.getDynamicObjectCollection("expenseentryentity_wait");
                    amountProp = "expenseamount_wait";
                    approveAmountProp = "expeapproveamount_wait";
                } else {
                    expenEntrys = bill.getDynamicObjectCollection("expenseentryentity");
                    amountProp = "expenseamount";
                    approveAmountProp = "expeapproveamount";
                }
                for (int i = 0; i < expenEntrys.size(); ++i) {
                    DynamicObject expenEntry = (DynamicObject)expenEntrys.get(i);
                    Long expenEntryId = ErCommonUtils.getPk(expenEntry.getPkValue());
                    BigDecimal amount = expenEntry.getBigDecimal(amountProp);
                    if (ruleEntryAmountMap.get(expenEntryId) != null && ruleEntryAmountMap.get(expenEntryId).compareTo(amount) != 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u8d39\u7528\u91d1\u989d\u4e0d\u7b49\u4e8e\u5206\u644a\u4fe1\u606f\u5206\u644a\u91d1\u989d\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ErVerifyShareRuleHelper_9", (String)"fi-er-business", (Object[])new Object[0]), i + 1);
                        return msg;
                    }
                    BigDecimal appAmount = expenEntry.getBigDecimal(approveAmountProp);
                    if (ruleEntryApproveAmountMap.get(expenEntryId) == null || ((BigDecimal)ruleEntryApproveAmountMap.get(expenEntryId)).compareTo(appAmount) == 0) continue;
                    msg = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u8d39\u7528\u91d1\u989d\u4e0d\u7b49\u4e8e\u5206\u644a\u4fe1\u606f\u6838\u5b9a\u91d1\u989d\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ErVerifyShareRuleHelper_10", (String)"fi-er-business", (Object[])new Object[0]), i + 1);
                    return msg;
                }
            } else {
                DynamicObjectCollection ruleEntrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
                BigDecimal totalshareAmountComRule = BigDecimal.ZERO;
                int index3 = 1;
                for (DynamicObject ruleEntry2 : ruleEntrys) {
                    BigDecimal shareAmountComRule = ruleEntry2.getBigDecimal("shareamount_comrule");
                    if (null == shareAmountComRule || shareAmountComRule.compareTo(BigDecimal.ZERO) == 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u644a\u91d1\u989d\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u5206\u644a\u91d1\u989d\u3002", (String)"ErVerifyShareRuleHelper_32", (String)"fi-er-business", (Object[])new Object[0]), index3);
                        return msg;
                    }
                    totalshareAmountComRule = totalshareAmountComRule.add(shareAmountComRule);
                    ++index3;
                }
                BigDecimal totalexpenseAmount = BigDecimal.ZERO;
                DynamicObjectCollection expenseEntrys = bill.getDynamicObjectCollection("tripentry");
                if (!expenseEntrys.isEmpty()) {
                    for (DynamicObject expenseEntry : expenseEntrys) {
                        DynamicObjectCollection tripDetailEntrys = expenseEntry.getDynamicObjectCollection("entryentity");
                        if (tripDetailEntrys.isEmpty()) continue;
                        for (DynamicObject tripDetailEntry : tripDetailEntrys) {
                            totalexpenseAmount = totalexpenseAmount.add(tripDetailEntry.getBigDecimal("entryappamount"));
                        }
                    }
                }
                if (totalshareAmountComRule.compareTo(totalexpenseAmount) != 0) {
                    msg = ResManager.loadKDString((String)"\u8d39\u7528\u6838\u5b9a\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u5206\u644a\u4fe1\u606f\u5206\u644a\u91d1\u989d\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ErVerifyShareRuleHelper_25", (String)"fi-er-business", (Object[])new Object[0]);
                    return msg;
                }
            }
        }
        if ("expenseitemrule".equalsIgnoreCase(shareRule.toString())) {
            DynamicObjectCollection ruleEntrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
            index = 1;
            for (DynamicObject obj : ruleEntrys) {
                DynamicObject entryExpenseItem = null;
                entryExpenseItem = ErEntityTypeUtils.isTripReimburseBill(bill.getDataEntityType().getName()) ? obj.getDynamicObject("entrytravelexpenseitem") : obj.getDynamicObject("entryexpenseitem");
                DynamicObject entrycostcompany = obj.getDynamicObject("entrycostcompany_orgrule");
                DynamicObject entrycostdept = obj.getDynamicObject("entrycostdept_orgrule");
                BigDecimal doing_shareRate = obj.getBigDecimal("sharerate_comrule");
                if (null == entrycostcompany) {
                    msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u3002", (String)"ErVerifyShareRuleHelper_34", (String)"fi-er-business", (Object[])new Object[0]), index);
                    return msg;
                }
                if (null == entrycostdept) {
                    msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u201d\u3002", (String)"ErVerifyShareRuleHelper_35", (String)"fi-er-business", (Object[])new Object[0]), index);
                    return msg;
                }
                if (null == entryExpenseItem) {
                    msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u8d39\u7528\u9879\u76ee\u201d\u3002", (String)"ErVerifyShareRuleHelper_36", (String)"fi-er-business", (Object[])new Object[0]), index);
                    return msg;
                }
                if ("rate".equalsIgnoreCase(bill.getString("sharemethod")) && (null == doing_shareRate || doing_shareRate.compareTo(BigDecimal.ZERO) == 0)) {
                    msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u5206\u644a\u6bd4\u4f8b\u201d\u3002", (String)"ErVerifyShareRuleHelper_37", (String)"fi-er-business", (Object[])new Object[0]), index);
                    return msg;
                }
                ++index;
            }
            Map<Long, BigDecimal> ruleEntryRateMap = ruleEntrys.stream().collect(Collectors.groupingBy(ruleEntry -> ruleEntry.getLong("sharewaitid_comrule"), CollectorsUtil.summingBigDecimal(ruleEntry -> ruleEntry.getBigDecimal("sharerate_comrule"))));
            DynamicObjectCollection expenEntrys = new DynamicObjectCollection();
            BigDecimal shareRate = new BigDecimal(100);
            String entityTeye = bill.getDataEntityType().getName();
            expenEntrys = ErEntityTypeUtils.isShareBill(entityTeye) ? bill.getDynamicObjectCollection("expenseentryentity_wait") : bill.getDynamicObjectCollection("expenseentryentity");
            for (int i = 0; i < expenEntrys.size(); ++i) {
                DynamicObject expenEntry = (DynamicObject)expenEntrys.get(i);
                Long expenEntryId = ErCommonUtils.getPk(expenEntry.getPkValue());
                if (!"rate".equalsIgnoreCase(bill.getString("sharemethod"))) continue;
                if (ruleEntryRateMap.get(expenEntryId) != null && ErVerifyShareRuleHelper.isAllShare(bill) && ruleEntryRateMap.get(expenEntryId).compareTo(shareRate) != 0) {
                    msg = String.format(ResManager.loadKDString((String)"\u201c\u5f85\u644a\u884c\u53f7\u201d%s\u5206\u644a\u6bd4\u4f8b\u5408\u8ba1\u4e0d\u7b49\u4e8e100%%\uff0c\u8bf7\u5148\u4fee\u6539\u5206\u644a\u6bd4\u4f8b\u3002", (String)"ErVerifyShareRuleHelper_38", (String)"fi-er-business", (Object[])new Object[0]), i + 1);
                    return msg;
                }
                if (ruleEntryRateMap.get(expenEntryId) == null || ErVerifyShareRuleHelper.isAllShare(bill) || ruleEntryRateMap.get(expenEntryId).compareTo(shareRate) <= 0) continue;
                msg = String.format(ResManager.loadKDString((String)"\u201c\u5f85\u644a\u884c\u53f7\u201d%s\u5206\u644a\u6bd4\u4f8b\u5408\u8ba1\u8d85\u8fc7100%%\uff0c\u8bf7\u5148\u4fee\u6539\u5206\u644a\u6bd4\u4f8b\u3002", (String)"ErVerifyShareRuleHelper_39", (String)"fi-er-business", (Object[])new Object[0]), i + 1);
                return msg;
            }
        }
        return msg;
    }

    private static boolean isAllShare(DynamicObject bill) {
        String entityTeye = bill.getDataEntityType().getName();
        if (!ErEntityTypeUtils.isShareBill(entityTeye)) {
            return true;
        }
        DynamicObject company = (DynamicObject)bill.get("company");
        if (company == null) {
            return false;
        }
        Long companyId = (Long)company.getPkValue();
        return SystemParamterUtil.isAllShare(companyId);
    }

    private static String verifyOrgRule(DynamicObject bill) {
        String msg = "";
        Object shareRule = bill.get("sharerule");
        if (!StringUtils.equals((CharSequence)"orgrule", (CharSequence)String.valueOf(shareRule))) {
            return msg;
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
        int index = 1;
        for (DynamicObject obj : entrys) {
            DynamicObject entryCostCompany = obj.getDynamicObject("entrycostcompany_orgrule");
            DynamicObject entryCostDept = obj.getDynamicObject("entrycostdept_orgrule");
            if (null == entryCostDept) {
                msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u201d\u3002", (String)"ErVerifyShareRuleHelper_35", (String)"fi-er-business", (Object[])new Object[0]), index);
                return msg;
            }
            if (null == entryCostCompany) {
                msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u3002", (String)"ErVerifyShareRuleHelper_34", (String)"fi-er-business", (Object[])new Object[0]), index);
                return msg;
            }
            ++index;
        }
        return msg;
    }

    private static String verifyMonthRule(DynamicObject bill) {
        String msg = "";
        Object shareRule = bill.get("sharerule");
        if (!StringUtils.equals((CharSequence)"monthrule", (CharSequence)String.valueOf(shareRule))) {
            return msg;
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
        HashSet<Date> allMonth = new HashSet<Date>(4);
        int index = 1;
        for (DynamicObject obj : entrys) {
            Date entryMonth = obj.getDate("entrymonth_monthrule");
            if (null == entryMonth) {
                msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u6708\u4efd\u201d\u5b57\u6bb5\u3002", (String)"ErVerifyShareRuleHelper_40", (String)"fi-er-business", (Object[])new Object[0]), index);
                return msg;
            }
            allMonth.add(entryMonth);
            ++index;
        }
        if (allMonth.size() != entrys.size() && !"amount".equalsIgnoreCase(bill.getString("sharemethod"))) {
            msg = ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u6708\u4efd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ErVerifyShareRuleHelper_14", (String)"fi-er-business", (Object[])new Object[0]);
            return msg;
        }
        return msg;
    }
}

