/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PayeerUpdateByUserTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter qfil = new QFilter("key", "=", (Object)"updateTime");
        qfil.and(new QFilter("desc", "=", (Object)ResManager.loadKDString((String)"\u8bb0\u5f55\u5b9a\u65f6\u4efb\u52a1\u6700\u65b0\u6267\u884c\u65f6\u95f4", (String)"PayeerUpdateByUserTask_0", (String)"fi-er-business", (Object[])new Object[0])));
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"er_stdconfig", (String)"key,value,desc", (QFilter[])new QFilter[]{qfil});
        QFilter[] qFilters = new QFilter[1];
        if (task != null) {
            Date newUpdateTime = task.getDate("value");
            QFilter qFilter = new QFilter("changetime", ">", (Object)newUpdateTime);
            qFilter.and(new QFilter("changetime", "<=", (Object)new Date()));
            qFilters[0] = qFilter;
        }
        DynamicObject[] userchanges = (DynamicObject[])QueryServiceHelper.query((String)"bos_userchange", (String)"user,name", (QFilter[])qFilters).toArray((Object[])new DynamicObject[0]);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)userchanges.length);
        for (DynamicObject userchange : userchanges) {
            ids.add(userchange.getLong("user"));
        }
        QFilter qf = new QFilter("payer.id", "in", (Object)ids);
        DynamicObject[] payeers = BusinessDataServiceHelper.load((String)"er_payeer", (String)"payer", (QFilter[])new QFilter[]{qf});
        if (payeers != null && payeers.length > 0) {
            for (DynamicObject payeer : payeers) {
                if (payeer.get("payer") == null) continue;
                payeer.set("outpayer", payeer.get("payer.name"));
            }
            SaveServiceHelper.save((DynamicObject[])payeers);
        }
        if (task == null) {
            task = BusinessDataServiceHelper.newDynamicObject((String)"er_stdconfig");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        task.set("value", (Object)sdf.format(new Date(System.currentTimeMillis())));
        task.set("key", (Object)"updateTime");
        task.set("desc", (Object)ResManager.loadKDString((String)"\u8bb0\u5f55\u5b9a\u65f6\u4efb\u52a1\u6700\u65b0\u6267\u884c\u65f6\u95f4", (String)"PayeerUpdateByUserTask_0", (String)"fi-er-business", (Object[])new Object[0]));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
    }
}

