/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task.datacheck;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.task.datacheck.common.ErDataCheckInfo;
import kd.fi.er.business.task.datacheck.util.ErDataCheckUtil;

public class LoanBillStatusCheckTask
implements FIDataCheckTask {
    private static final String TASKNAME = "erCheckLoanbillStatus";

    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        ErDataCheckInfo checkLoanBillStatus = this.checkLoanBillStatus();
        if (checkLoanBillStatus != null) {
            ErDataCheckUtil.saveResult(TASKNAME, false, checkLoanBillStatus, this);
            return false;
        }
        return true;
    }

    private ErDataCheckInfo checkLoanBillStatus() {
        ErDataCheckInfo dataCheckInfo = null;
        QFilter dateFilter = ErDataCheckUtil.getDateFilter(1);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"I");
        QFilter balanceFilter = new QFilter("balanceamount", ">", (Object)BigDecimal.ZERO);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.getEntityName(), (String)"billno,balanceamount", (QFilter[])new QFilter[]{dateFilter, statusFilter, balanceFilter});
        if (!collection.isEmpty()) {
            dataCheckInfo = new ErDataCheckInfo(this.getEntityName(), "yichangguanbi", collection.size());
            for (DynamicObject coll : collection) {
                dataCheckInfo.addCheckResult(coll.getString("billno"), coll.getString(String.format("balance has %1s but bill had closed", coll.get("balanceamount"))));
            }
        }
        return dataCheckInfo;
    }

    protected String getEntityName() {
        return "er_dailyloanbill";
    }
}

