/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task.datacheck;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.datacheck.validator.CommonAmountCheckCondition;
import kd.fi.er.business.task.datacheck.common.ErDataCheckInfo;
import kd.fi.er.business.task.datacheck.framework.CheckSourceInfo;
import kd.fi.er.business.task.datacheck.util.ErDataCheckUtil;
import kd.fi.er.common.EntityTypeEnum;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class PayAmountCheckTask
implements FIDataCheckTask {
    private static final Log logger = LogFactory.getLog(PayAmountCheckTask.class);
    private static final QFilter dateFilter = ErDataCheckUtil.getDateFilter(1);
    private static final QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C", "E", "F", "G", "I"});
    private static final QFilter qFilter = new QFilter("number", "=", (Object)"setting");
    private static final String[] entityTypes = new String[]{EntityTypeEnum.DAILYLOANBILL.toString(), EntityTypeEnum.DAILYREIMBURSEBILL.toString(), EntityTypeEnum.PREPAYBILL.toString(), EntityTypeEnum.PUBLICREIMBURSEBILL.toString(), EntityTypeEnum.TRIPREIMBURSEBILL.toString()};
    private static final QFilter entityTypeQF = new QFilter("entryentity.entitytype", "in", (Object)entityTypes);
    private static final String TASKNAME = "erPayAmountCheck";

    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        HashSet preparePropertys = Sets.newHashSetWithExpectedSize((int)32);
        ErDataCheckUtil.addPreparePropertys(preparePropertys);
        ArrayList checkSourceInfos = Lists.newArrayListWithExpectedSize((int)16);
        checkSourceInfos.add(new CheckSourceInfo("er_dailyreimbursebill", preparePropertys, new QFilter[]{dateFilter, statusFilter}));
        checkSourceInfos.add(new CheckSourceInfo("er_publicreimbursebill", preparePropertys, new QFilter[]{dateFilter, statusFilter}));
        checkSourceInfos.add(new CheckSourceInfo("er_tripreimbursebill", preparePropertys, new QFilter[]{dateFilter, statusFilter}));
        checkSourceInfos.add(new CheckSourceInfo("er_dailyloanbill", preparePropertys, new QFilter[]{dateFilter, statusFilter}));
        checkSourceInfos.add(new CheckSourceInfo("er_prepaybill", preparePropertys, new QFilter[]{dateFilter, statusFilter}));
        checkSourceInfos.add(new CheckSourceInfo("er_tripreqbill", preparePropertys, new QFilter[]{dateFilter, statusFilter, new QFilter("isloan", "=", (Object)true)}));
        this.addExtSourceInfo(checkSourceInfos, preparePropertys);
        for (CheckSourceInfo checkSourceInfo : checkSourceInfos) {
            ErDataCheckInfo checkInfo = null;
            try {
                checkInfo = this.checkData(checkSourceInfo);
            }
            catch (Exception e) {
                logger.error(String.format("\u3010%1s\u3011 \u6570\u636e\u68c0\u67e5\u51fa\u73b0\u5f02\u5e38", checkSourceInfo.getEntityName()), (Throwable)e);
                FIDataCheckUtil.saveResult((String)TASKNAME, (String)"er", (boolean)true, (String)String.format("\u3010%1s\u3011throw exception:\u3010%2s\u3011", checkSourceInfo.getEntityName(), e.getMessage()), (String)this.getClass().getSimpleName());
            }
            if (checkInfo == null) continue;
            ErDataCheckUtil.saveResult(TASKNAME, false, checkInfo, this);
        }
        return true;
    }

    private void addExtSourceInfo(List<CheckSourceInfo> checkSourceInfos, Set<String> preparePropertys) {
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((String)"er_entitytype_setting", (String)"id,entryentity.entitytype,entryentity.entityid", (QFilter[])new QFilter[]{qFilter, entityTypeQF});
        if (setting != null) {
            DynamicObjectCollection collection = setting.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject entry = (DynamicObject)collection.get(i);
                String entityName = entry.getString("entityid").replaceAll(" ", "");
                checkSourceInfos.add(new CheckSourceInfo(entityName, preparePropertys, new QFilter[]{dateFilter, statusFilter}));
            }
        }
    }

    private ErDataCheckInfo checkData(CheckSourceInfo checkSourceInfo) throws IllegalAccessException, InstantiationException {
        DynamicObject[] bills = ErDataCheckUtil.getBillData(checkSourceInfo);
        ErDataCheckInfo dataCheckInfo = null;
        ArrayListMultimap map = ArrayListMultimap.create();
        for (DynamicObject bill : bills) {
            Field[] fields;
            Class<CommonAmountCheckCondition> commonAmountCheckConditionClass = CommonAmountCheckCondition.class;
            CommonAmountCheckCondition commonAmountCheckCondition = (CommonAmountCheckCondition)commonAmountCheckConditionClass.newInstance();
            for (Field field : fields = commonAmountCheckCondition.getClass().getFields()) {
                String msg;
                Object validator;
                if (!ErDataCheckUtil.whetherExecuteValidator(field.getName()) || (validator = field.get(commonAmountCheckCondition)) == null || !StringUtils.isNotBlank((CharSequence)(msg = ErDataCheckUtil.assertCondition(bill, (Function)validator)))) continue;
                this.addResult((ArrayListMultimap<String, String>)map, bill, msg);
            }
        }
        if (!map.isEmpty()) {
            dataCheckInfo = new ErDataCheckInfo(checkSourceInfo.getEntityName(), "amounterror", map.size());
            for (Map.Entry entry : map.asMap().entrySet()) {
                dataCheckInfo.addCheckResult((String)entry.getKey(), StringUtils.join((Object[])((Collection)entry.getValue()).toArray(), (String)";"));
            }
        }
        return dataCheckInfo;
    }

    private void addResult(ArrayListMultimap<String, String> map, DynamicObject bill, String validatorStr) {
        if (StringUtils.isNotBlank((CharSequence)validatorStr)) {
            map.put((Object)bill.getString("billno"), (Object)validatorStr);
        }
    }
}

