/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.task.datacheck.common;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.fi.er.business.task.datacheck.common.DataCheckDetail;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class ErDataCheckInfo {
    private List<DataCheckDetail> checkResults = null;
    private String billtype;
    private String errorkey;

    public ErDataCheckInfo(String billtype, String errorkey, int estimatedSize) {
        this.checkResults = Lists.newArrayListWithExpectedSize((int)estimatedSize);
        this.billtype = billtype;
        this.errorkey = errorkey;
    }

    public void addCheckResult(String billno, String detail) {
        this.checkResults.add(new DataCheckDetail(billno, detail));
    }

    public List<DataCheckDetail> getCheckResults() {
        return this.checkResults;
    }

    public String getBilltype() {
        return this.billtype;
    }

    public String getErrorkey() {
        return this.errorkey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("billtype:[").append(this.billtype).append("]").append(",errorinfo:[").append(this.errorkey).append("],detailinfo:").append(System.lineSeparator()).append(ErDataCheckInfo.format(this.checkResults));
        return sb.toString();
    }

    private static String format(List<DataCheckDetail> checkResults) {
        StringBuilder sb = new StringBuilder();
        if (!checkResults.isEmpty()) {
            Map<String, List<DataCheckDetail>> map = checkResults.stream().collect(Collectors.groupingBy(v -> v.getDetail()));
            for (Map.Entry<String, List<DataCheckDetail>> entry : map.entrySet()) {
                String detail = entry.getKey();
                List<DataCheckDetail> list = entry.getValue();
                list.stream().forEach(v -> sb.append(v.getBillno()).append(","));
                sb.append(":").append(detail);
                sb.append(System.lineSeparator());
            }
        }
        return sb.toString();
    }
}

