/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.botp;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.TrialOrgServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.CarTypeEnum;

public class CheckingBillBOTPCheckingExpList
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(CheckingBillBOTPCheckingExpList.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        List pkLists = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        String selectProperties = "id";
        QFilter filter = new QFilter("pushcheckingexplist", "!=", (Object)"0");
        filter.and("id", "in", pkLists);
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)this.getSrcMainType().getName(), (String)selectProperties, (QFilter[])new QFilter[]{filter});
        if (sourceBills != null && sourceBills.size() > 0) {
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u65e0", (String)"CheckingBillBOTPCheckingPay_0", (String)"fi-er-business", (Object[])new Object[0]));
            e.setCustFilterExpression(" billstatus = '-1' ");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"-1");
            e.getCustQFilters().add(qFilter);
        }
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("period");
        e.addSrcField("totalamount");
        e.addSrcField("settledept");
        e.addSrcField("settlemain");
        e.addSrcField("currency");
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        super.afterCreateLink(e);
        BillEntityType targetEntityType = this.getTgtMainType();
        String targetEntityNumber = targetEntityType.getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map propMap = e.getFldProperties();
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObjectCollection entryentitys = targetBill.getDynamicObjectCollection("entryentity");
            BigDecimal checkingtotalamount = BigDecimal.ZERO;
            if (null != entryentitys && entryentitys.size() > 0) {
                Set orderNums = entryentitys.stream().filter(dynamicObject -> dynamicObject.get("ordernum") != null).map(dynamicObject -> dynamicObject.get("ordernum")).collect(Collectors.toSet());
                DynamicObject[] checkingBills = (DynamicObject[])QueryServiceHelper.query((String)"er_vehiclecheckingbill", (String)"ordernum,id,vehicletype", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", orderNums)}).toArray((Object[])new DynamicObject[0]);
                Map<Object, Object> orderNumMap = Arrays.stream(checkingBills).filter(Objects::nonNull).collect(Collectors.toMap(dynamicObject -> dynamicObject.get("ordernum"), dynamicObject -> dynamicObject.get("vehicletype")));
                for (DynamicObject entryentity : entryentitys) {
                    String vehicleType;
                    checkingtotalamount = checkingtotalamount.add(entryentity.getBigDecimal("totalamount"));
                    String string = vehicleType = orderNumMap.get(entryentity.get("ordernum")) == null ? "" : orderNumMap.get(entryentity.get("ordernum")).toString();
                    if (vehicleType.equals(CarTypeEnum.TRAVEL.getCode())) {
                        entryentity.set("vehicletype", (Object)CarTypeEnum.TRAVEL.getValue());
                    }
                    if (vehicleType.equals(CarTypeEnum.DAILY.getCode())) {
                        entryentity.set("vehicletype", (Object)CarTypeEnum.DAILY.getValue());
                    }
                    if (vehicleType.equals(CarTypeEnum.OVERTIME.getCode())) {
                        entryentity.set("vehicletype", (Object)CarTypeEnum.OVERTIME.getValue());
                    }
                    if (!vehicleType.equals(CarTypeEnum.HOVERTIME.getCode())) continue;
                    entryentity.set("vehicletype", (Object)CarTypeEnum.HOVERTIME.getValue());
                }
                String period = ((DynamicProperty)propMap.get("period")).getValue(srcRows.get(0)).toString().replace(".", "-");
                targetBill.set("period", (Object)TripCommonUtil.convertToDate(period));
            }
            targetBill.set("checkingtotalamount", (Object)checkingtotalamount);
            Long deptId = (Long)((DynamicProperty)propMap.get("settledept")).getValue(srcRows.get(0));
            Long companyId = (Long)((DynamicProperty)propMap.get("settlemain")).getValue(srcRows.get(0));
            Long currency = (Long)((DynamicProperty)propMap.get("currency")).getValue(srcRows.get(0));
            targetBill.set("costdept_id", (Object)deptId);
            targetBill.set("costcompany_id", (Object)companyId);
            targetBill.set("currency_id", (Object)currency);
            targetBill.set("currency", (Object)currency);
            Boolean trial = TrialOrgServiceHelper.getTrialControl(targetEntityNumber, deptId);
            targetBill.set("needsend", (Object)(trial != false ? "1" : "0"));
            targetBill.set("msgcount", (Object)"0");
            QFilter qA = new QFilter("entryentity.dpt", "=", (Object)deptId);
            QFilter qB = new QFilter("entryentity.isincharge", "=", (Object)"1");
            QFilter qC = new QFilter("enable", "=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{qA, qB, qC};
            Map users = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id", (QFilter[])qFilters);
            DynamicObjectCollection userColl = targetBill.getDynamicObjectCollection("user");
            if (userColl.size() > 0) {
                userColl.clear();
            }
            if (null == users || users.isEmpty()) continue;
            for (DynamicObject value : users.values()) {
                DynamicObject userTravler = userColl.addNew();
                userTravler.set("fbasedataid_id", value.get("id"));
            }
        }
    }
}

