/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.botp;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.pub.PublicUpBillUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.util.CheckingPayBillWriteOffMoneyUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class CheckingBillBOTPCheckingPay
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(CheckingBillBOTPCheckingPay.class);
    protected static final String CHECKINGENTRY = "entryentity";
    protected static final String CHECKINGENTRY_LK = "entryentity_lk";

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        List pkLists = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        String selectProperties = "id, ordernum, billstatus, isbalance, paybillnum, paybillid";
        QFilter filter = new QFilter("isbalance", "!=", (Object)"1");
        filter.or("billstatus", "!=", (Object)"C");
        filter.or("paybillid", "!=", (Object)0);
        filter.and("id", "in", pkLists);
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)this.getSrcMainType().getName(), (String)selectProperties, (QFilter[])new QFilter[]{filter});
        if (sourceBills != null && sourceBills.size() > 0) {
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u65e0", (String)"CheckingBillBOTPCheckingPay_0", (String)"fi-er-business", (Object[])new Object[0]));
            e.setCustFilterExpression(" billstatus = '-1' ");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"-1");
            e.getCustQFilters().add(qFilter);
        }
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("formid");
        e.addSrcField("id");
        e.addSrcField("settledept");
        e.addSrcField("sourcebookedid");
        e.addSrcField("totalamount");
        e.addSrcField("servicefee");
        e.addSrcField("serviceamounttax");
        e.addSrcField("servicedeductrate");
        e.addSrcField("orderamounttax");
        e.addSrcField("orderdeductrate");
        e.addSrcField("orderstatus");
        e.addSrcField("paybillnum");
        e.addSrcField("appliercompany");
        e.addSrcField("applierdept");
        e.addSrcField("applier");
        e.addSrcField("ticketnum");
        e.addSrcField("checkingbillnum");
        e.addSrcField("trainticketnum");
        e.addSrcField("ticketprice");
        e.addSrcField("airportprice");
        e.addSrcField("fuelprice");
        e.addSrcField("endorsementamount");
        e.addSrcField("otheramount");
        e.addSrcField("assuranceamount");
        e.addSrcField("refundamount");
        e.addSrcField("std_project");
        e.addSrcField("std_costcenter");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        BillEntityType targetEntityType = this.getTgtMainType();
        String targetEntityNumber = targetEntityType.getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            Long userId = CommonServiceHelper.getCurrentUserID();
            Map<String, Object> userMap = CoreBaseBillServiceHelper.createNewData(userId);
            Long appliercompanyId = (Long)userMap.get("company");
            Long applierdeptId = (Long)((DynamicObject)userMap.get("org")).getPkValue();
            targetBill.set("applier_id", (Object)userId);
            targetBill.set("appliercompany_id", (Object)appliercompanyId);
            targetBill.set("applierdept_id", (Object)applierdeptId);
        }
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterCreateLink(e);
        Long startTime = System.currentTimeMillis();
        EntryType checkingEntryType = (EntryType)this.getTgtMainType().getAllEntities().get(CHECKINGENTRY);
        Map propMap = e.getFldProperties();
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObjectCollection writeoffmoney;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            DynamicObjectCollection checkingEntrys = targetBill.getDynamicObjectCollection(CHECKINGENTRY);
            if (checkingEntrys == null || checkingEntrys.size() < 0) continue;
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Iterator iterator = checkingEntrys.iterator();
            block1: while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                if (null == next.get("checkingbillnum") || next.getString("checkingbillnum").trim().isEmpty()) {
                    iterator.remove();
                    continue;
                }
                for (DynamicObject srcRow : srcRows) {
                    String billNo = srcRow.getString("billno");
                    if (!next.getString("checkingbillnum").equals(billNo)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            for (DynamicObject srcRow : srcRows) {
                String billNo = srcRow.getString("billno");
                String formid = String.valueOf(((DynamicProperty)propMap.get("formid")).getValue((Object)srcRow));
                TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)formid, (String)formid);
                if (null == tableDefine) continue;
                Long sourceTableId = tableDefine.getTableId();
                Long billid = srcRow.getLong("id");
                Long costOrg = (Long)((DynamicProperty)propMap.get("settledept")).getValue((Object)srcRow);
                Long project = (Long)((DynamicProperty)propMap.get("std_project")).getValue((Object)srcRow);
                Long std_costcenter = (Long)((DynamicProperty)propMap.get("std_costcenter")).getValue((Object)srcRow);
                Long bookUser = this.getCheckingPayUser(propMap, srcRow);
                BigDecimal totalAmount = (BigDecimal)((DynamicProperty)propMap.get("totalamount")).getValue((Object)srcRow);
                BigDecimal servicefee = (BigDecimal)((DynamicProperty)propMap.get("servicefee")).getValue((Object)srcRow);
                BigDecimal servicefeeRate = (BigDecimal)((DynamicProperty)propMap.get("servicedeductrate")).getValue((Object)srcRow);
                BigDecimal servicefeeTax = (BigDecimal)((DynamicProperty)propMap.get("serviceamounttax")).getValue((Object)srcRow);
                BigDecimal ticketprice = BigDecimal.ZERO;
                if (null != propMap.get("ticketprice")) {
                    ticketprice = (BigDecimal)((DynamicProperty)propMap.get("ticketprice")).getValue((Object)srcRow);
                }
                BigDecimal airportprice = BigDecimal.ZERO;
                if (null != propMap.get("airportprice")) {
                    airportprice = (BigDecimal)((DynamicProperty)propMap.get("airportprice")).getValue((Object)srcRow);
                }
                BigDecimal fuelprice = BigDecimal.ZERO;
                if (null != propMap.get("fuelprice")) {
                    fuelprice = (BigDecimal)((DynamicProperty)propMap.get("fuelprice")).getValue((Object)srcRow);
                }
                BigDecimal endorsementamount = BigDecimal.ZERO;
                if (null != propMap.get("endorsementamount")) {
                    endorsementamount = (BigDecimal)((DynamicProperty)propMap.get("endorsementamount")).getValue((Object)srcRow);
                }
                BigDecimal refundamount = BigDecimal.ZERO;
                if (null != propMap.get("refundamount")) {
                    refundamount = (BigDecimal)((DynamicProperty)propMap.get("refundamount")).getValue((Object)srcRow);
                }
                BigDecimal otheramount = BigDecimal.ZERO;
                if (null != propMap.get("otheramount")) {
                    otheramount = (BigDecimal)((DynamicProperty)propMap.get("otheramount")).getValue((Object)srcRow);
                }
                BigDecimal assuranceamount = BigDecimal.ZERO;
                if (null != propMap.get("assuranceamount")) {
                    assuranceamount = (BigDecimal)((DynamicProperty)propMap.get("assuranceamount")).getValue((Object)srcRow);
                }
                BigDecimal servicefeeNotTax = servicefee.subtract(servicefeeTax);
                BigDecimal ticketAmount = totalAmount.subtract(servicefee);
                boolean refoundTickets = this.isRefound(propMap, srcRow);
                BigDecimal ticketRate = refoundTickets ? BigDecimal.ZERO : (BigDecimal)((DynamicProperty)propMap.get("orderdeductrate")).getValue((Object)srcRow);
                BigDecimal ticketTax = refoundTickets ? BigDecimal.ZERO : (BigDecimal)((DynamicProperty)propMap.get("orderamounttax")).getValue((Object)srcRow);
                BigDecimal ticketNotTax = totalAmount.subtract(servicefee).subtract(ticketTax);
                Object checkingBillNum = ((DynamicProperty)propMap.get("checkingbillnum")).getValue((Object)srcRow);
                if (ticketAmount.compareTo(BigDecimal.ZERO) != 0) {
                    DynamicObject checkingRowTicket = new DynamicObject((DynamicObjectType)checkingEntryType);
                    checkingRowTicket.set("seq", (Object)(checkingEntrys.size() + 1));
                    checkingRowTicket.set("checkingbillid", (Object)billid);
                    checkingRowTicket.set("checkingbillnum", (Object)billNo);
                    checkingRowTicket.set("dept_id", (Object)costOrg);
                    checkingRowTicket.set("user_id", (Object)bookUser);
                    checkingRowTicket.set("std_project_id", (Object)project);
                    checkingRowTicket.set("std_costcenter_id", (Object)std_costcenter);
                    checkingRowTicket.set("serviceitem", (Object)"TICKET");
                    checkingRowTicket.set("actentryamount", (Object)ticketAmount);
                    checkingRowTicket.set("taxrate", (Object)ticketRate);
                    checkingRowTicket.set("taxamount", (Object)ticketTax);
                    checkingRowTicket.set("notaxoriamount", (Object)ticketNotTax);
                    checkingRowTicket.set("entry_operationtype", (Object)this.perationtype(propMap, srcRow));
                    checkingRowTicket.set("checkingbillno", checkingBillNum);
                    if ("er_planecheckingbill".equals(formid)) {
                        checkingRowTicket.set("ticketprice", (Object)ticketprice);
                        checkingRowTicket.set("airportprice", (Object)airportprice);
                        checkingRowTicket.set("fuelprice", (Object)fuelprice);
                        checkingRowTicket.set("endorsementamount", (Object)endorsementamount);
                        checkingRowTicket.set("refundamount", (Object)refundamount);
                        checkingRowTicket.set("otheramount", (Object)otheramount);
                        checkingRowTicket.set("assuranceamount", (Object)assuranceamount);
                        if (null != propMap.get("fromcityname")) {
                            checkingRowTicket.set("fromcity", ((DynamicProperty)propMap.get("fromcityname")).getValue((Object)srcRow));
                        }
                        if (null != propMap.get("tocityname")) {
                            checkingRowTicket.set("tocity", ((DynamicProperty)propMap.get("tocityname")).getValue((Object)srcRow));
                        }
                        if (null != propMap.get("takeofftime")) {
                            checkingRowTicket.set("departtime", ((DynamicProperty)propMap.get("takeofftime")).getValue((Object)srcRow));
                        }
                        if (null != propMap.get("landingtime")) {
                            checkingRowTicket.set("arrivetime", ((DynamicProperty)propMap.get("landingtime")).getValue((Object)srcRow));
                        }
                        if (null != propMap.get("flightno")) {
                            checkingRowTicket.set("vendorname", ((DynamicProperty)propMap.get("flightno")).getValue((Object)srcRow));
                        }
                    }
                    if ("er_traincheckingbill".equals(formid)) {
                        checkingRowTicket.set("ticketprice", (Object)ticketprice);
                        checkingRowTicket.set("refundamount", (Object)refundamount);
                        if (null != propMap.get("departaddress")) {
                            checkingRowTicket.set("fromcity", ((DynamicProperty)propMap.get("departaddress")).getValue((Object)srcRow));
                        }
                        if (null != propMap.get("arriveaddress")) {
                            checkingRowTicket.set("tocity", ((DynamicProperty)propMap.get("arriveaddress")).getValue((Object)srcRow));
                        }
                        if (null != propMap.get("departtime")) {
                            checkingRowTicket.set("departtime", ((DynamicProperty)propMap.get("departtime")).getValue((Object)srcRow));
                        }
                        if (null != propMap.get("arrivetime")) {
                            checkingRowTicket.set("arrivetime", ((DynamicProperty)propMap.get("arrivetime")).getValue((Object)srcRow));
                        }
                        if (null != propMap.get("vendorname")) {
                            checkingRowTicket.set("vendorname", ((DynamicProperty)propMap.get("vendorname")).getValue((Object)srcRow));
                        }
                    }
                    this.setTicketNum(propMap, srcRow, checkingRowTicket);
                    this.buildLkEntry(sourceTableId, billid, checkingRowTicket);
                    checkingEntrys.add((Object)checkingRowTicket);
                }
                if (servicefee.compareTo(BigDecimal.ZERO) == 0) continue;
                DynamicObject checkingRowService = new DynamicObject((DynamicObjectType)checkingEntryType);
                checkingRowService.set("seq", (Object)(checkingEntrys.size() + 1));
                checkingRowService.set("checkingbillid", (Object)billid);
                checkingRowService.set("checkingbillnum", (Object)billNo);
                checkingRowService.set("dept_id", (Object)costOrg);
                checkingRowService.set("user_id", (Object)bookUser);
                checkingRowService.set("std_project_id", (Object)project);
                checkingRowService.set("std_costcenter_id", (Object)std_costcenter);
                checkingRowService.set("serviceitem", (Object)"SERVICE");
                checkingRowService.set("actentryamount", (Object)servicefee);
                checkingRowService.set("taxrate", (Object)servicefeeRate);
                checkingRowService.set("taxamount", (Object)servicefeeTax);
                checkingRowService.set("notaxoriamount", (Object)servicefeeNotTax);
                checkingRowService.set("entry_operationtype", (Object)this.perationtype(propMap, srcRow));
                checkingRowService.set("checkingbillno", checkingBillNum);
                this.buildLkEntry(sourceTableId, billid, checkingRowService);
                checkingEntrys.add((Object)checkingRowService);
            }
            BigDecimal planetotalamount = BigDecimal.ZERO;
            BigDecimal rplanetotalamount = BigDecimal.ZERO;
            BigDecimal hoteltotalamount = BigDecimal.ZERO;
            BigDecimal traintotalamount = BigDecimal.ZERO;
            BigDecimal rtraintotalamount = BigDecimal.ZERO;
            BigDecimal vehicletotalamount = BigDecimal.ZERO;
            BigDecimal mealtotalamount = BigDecimal.ZERO;
            BigDecimal servicetotalamount = BigDecimal.ZERO;
            for (DynamicObject checkingEntry : checkingEntrys) {
                String entry_operationtype = checkingEntry.getString("entry_operationtype");
                String serviceitem = checkingEntry.getString("serviceitem");
                BigDecimal ticketprice = checkingEntry.getBigDecimal("ticketprice");
                BigDecimal fuelprice = checkingEntry.getBigDecimal("fuelprice");
                BigDecimal endorsementamount = checkingEntry.getBigDecimal("endorsementamount");
                BigDecimal refundamount = checkingEntry.getBigDecimal("refundamount");
                BigDecimal actentryamount = checkingEntry.getBigDecimal("actentryamount");
                if ("TICKET".equals(serviceitem) && "2".equals(entry_operationtype)) {
                    planetotalamount = planetotalamount.add(ticketprice).add(fuelprice);
                    rplanetotalamount = rplanetotalamount.add(endorsementamount).add(refundamount);
                }
                if ("TICKET".equals(serviceitem) && "4".equals(entry_operationtype)) {
                    traintotalamount = traintotalamount.add(ticketprice);
                    rtraintotalamount = rtraintotalamount.add(refundamount);
                }
                if ("TICKET".equals(serviceitem) && "1".equals(entry_operationtype)) {
                    hoteltotalamount = hoteltotalamount.add(actentryamount);
                }
                if ("TICKET".equals(serviceitem) && "3".equals(entry_operationtype)) {
                    vehicletotalamount = vehicletotalamount.add(actentryamount);
                }
                if ("TICKET".equals(serviceitem) && "5".equals(entry_operationtype)) {
                    mealtotalamount = mealtotalamount.add(actentryamount);
                }
                if (!"SERVICE".equals(serviceitem)) continue;
                servicetotalamount = servicetotalamount.add(actentryamount);
            }
            targetBill.set("planetotalamount", (Object)planetotalamount);
            targetBill.set("rplanetotalamount", (Object)rplanetotalamount);
            targetBill.set("hoteltotalamount", (Object)hoteltotalamount);
            targetBill.set("traintotalamount", (Object)traintotalamount);
            targetBill.set("rtraintotalamount", (Object)rtraintotalamount);
            targetBill.set("vehicletotalamount", (Object)vehicletotalamount);
            targetBill.set("mealtotalamount", (Object)mealtotalamount);
            targetBill.set("servicetotalamount", (Object)servicetotalamount);
            Long companyId = targetBill.get("appliercompany_id") == null ? 0L : targetBill.getLong("appliercompany_id");
            Boolean autoDrawLoanBill = SystemParamterUtil.getAutoDrawLoanBill(companyId);
            if (!autoDrawLoanBill.booleanValue()) {
                CheckingPayBillWriteOffMoneyUtil.refreshCheckingPayHeadAmount(targetBill);
                continue;
            }
            Boolean drawchecking = (Boolean)ActionLocalCache.get().getDefaultIfNull("drawchecking", false);
            if (!drawchecking.booleanValue()) {
                this.setPayInfo(targetBill);
                logger.info("\u4e0a\u62c9\u8017\u8d39\u7ed3\u7b97\u5355\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
                Boolean isTripUpFilterBySupplier = SystemParamterUtil.getIsTripUpFilterBySupplier(companyId);
                DynamicObject currency = targetBill.getDynamicObject("currency");
                String payerType = targetBill.getString("payertype");
                DynamicObject payer = targetBill.getDynamicObject("payer");
                DynamicObject costcompany = targetBill.getDynamicObject("company");
                QFilter selectedEntryQfilter = new QFilter("expenseentryentity.entrycurrency", "=", (Object)ErCommonUtils.getPk(currency));
                selectedEntryQfilter.and("currency", "=", (Object)ErCommonUtils.getPk(currency));
                selectedEntryQfilter.and("billstatus", "=", (Object)"G");
                selectedEntryQfilter.and("expenseentryentity.orgiexpebalanceamount", ">", (Object)0);
                ActionLocalCache.get().put("setFilter.entityId", "er_checkingpaybill");
                QFilter qFilter = PublicUpBillUtil.getPublicUpBillQfilter(CommonServiceHelper.getCurrentUserID(), companyId, ErCommonUtils.getPk(costcompany), "costcompany");
                Optional.ofNullable(qFilter).ifPresent(arg_0 -> ((QFilter)selectedEntryQfilter).and(arg_0));
                logger.info(String.format("\u7ed3\u7b97\u5355\u4e0b\u63a8\u5546\u65c5\u4ed8\u6b3e\u7533\u8bf7\u5355\u81ea\u52a8\u5e26\u51fa\u501f\u6b3e\u5355companyId:%1$s,costcompany:%2$s,selectedEntryQfilter:%3$s", companyId, ErCommonUtils.getPk(costcompany), selectedEntryQfilter));
                this.drawBill(targetBill, "er_dailyloanbill", selectedEntryQfilter);
                logger.info("\u4e0a\u62c9\u8017\u8d39\u501f\u6b3e\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
                Set<Object> ids = new HashSet();
                if (isTripUpFilterBySupplier.booleanValue()) {
                    if (StringUtils.equalsAny((CharSequence)payerType, (CharSequence[])new CharSequence[]{"bd_supplier", "bd_customer"})) {
                        Long billpayer_masterid;
                        Long l = billpayer_masterid = payer != null ? (Long)payer.get("masterid") : null;
                        if (billpayer_masterid != null) {
                            ids = QueryServiceHelper.query((String)payerType, (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)billpayer_masterid)}).stream().filter(dynamicObject -> dynamicObject != null && dynamicObject.get("id") != null).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
                        }
                    }
                    selectedEntryQfilter.and("billpayerid", "in", ids);
                }
                this.drawBill(targetBill, "er_prepaybill", selectedEntryQfilter);
                logger.info("\u4e0a\u62c9\u8017\u8d39\u9884\u4ed8\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
            }
            if ((writeoffmoney = targetBill.getDynamicObjectCollection("writeoffmoney")) != null && writeoffmoney.size() > 0) {
                int precision = AmountUtils.getAmountFieldPrecision((DynamicObject)writeoffmoney.get(0), "curraccloanamount");
                DynamicObjectCollection entryentity = targetBill.getDynamicObjectCollection(CHECKINGENTRY);
                BigDecimal actentryamount = AmountUtils.getEntryAmount(entryentity, "actentryamount");
                for (int i = 0; i < writeoffmoney.size(); ++i) {
                    BigDecimal currLoanAmount;
                    DynamicObject entry = (DynamicObject)writeoffmoney.get(i);
                    BigDecimal loanamount = entry.getBigDecimal("loanamount");
                    if (actentryamount.compareTo(loanamount) > 0) {
                        entry.set("accloanamount", (Object)loanamount);
                        currLoanAmount = AmountUtils.getCurrencyAmount(loanamount, entry.getBigDecimal("loanexchangerate"), precision, entry.getString("writeoffquotetype"));
                        entry.set("curraccloanamount", (Object)currLoanAmount);
                        actentryamount = actentryamount.subtract(loanamount);
                        continue;
                    }
                    entry.set("accloanamount", (Object)actentryamount);
                    currLoanAmount = AmountUtils.getCurrencyAmount(actentryamount, entry.getBigDecimal("loanexchangerate"), precision, entry.getString("writeoffquotetype"));
                    entry.set("curraccloanamount", (Object)currLoanAmount);
                    actentryamount = BigDecimal.ZERO;
                }
            }
            CheckingPayBillWriteOffMoneyUtil.refreshCheckingPayHeadAmount(targetBill);
        }
    }

    private void drawBill(DynamicObject targetBill, String srcEntity, QFilter selectedEntryQfilter) {
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)srcEntity, (String)this.getBillSelectFileds(srcEntity), (QFilter[])new QFilter[]{selectedEntryQfilter});
        Long targetTableId = EntityMetadataCache.loadTableDefine((String)srcEntity, (String)"expenseentryentity").getTableId();
        logger.info("\u7ed3\u7b97\u5355\u4e0b\u63a8\u5546\u65c5\u4ed8\u6b3e\u7533\u8bf7\u5355\u81ea\u52a8\u5e26\u51fa\u501f\u6b3e\u5355billSize:{}", (Object)bills.length);
        DynamicObject currency = targetBill.getDynamicObject("currency");
        long currencyId = currency == null ? 0L : currency.getLong("id");
        for (DynamicObject bill : bills) {
            DynamicObjectCollection loanBillExpenses = bill.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject loanBillExpense : loanBillExpenses) {
                BigDecimal balanceAmount = loanBillExpense.getBigDecimal("orgiexpebalanceamount");
                if (balanceAmount == null || balanceAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    logger.info("\u7ed3\u7b97\u5355\u4e0b\u63a8\u5546\u65c5\u4ed8\u6b3e\u7533\u8bf7\u5355\u81ea\u52a8\u5e26\u51fa\u501f\u6b3e\u5355balanceAmount<=0,pk:" + loanBillExpense.getPkValue());
                    continue;
                }
                if (currencyId != ErCommonUtils.getPk(loanBillExpense.getDynamicObject("entrycurrency"))) {
                    logger.info("\u7ed3\u7b97\u5355\u4e0b\u63a8\u5546\u65c5\u4ed8\u6b3e\u7533\u8bf7\u5355\u81ea\u52a8\u5e26\u51fa\u501f\u6b3e\u5355\u5e01\u79cd\u4e0d\u4e00\u81f4,pk:" + loanBillExpense.getPkValue());
                    continue;
                }
                DynamicObjectCollection offRows = targetBill.getDynamicObjectCollection("writeoffmoney");
                DynamicObject offRow = this.createWriteOffLoanRow(loanBillExpense, targetTableId);
                offRow.set("seq", (Object)(offRows.size() + 1));
                offRows.add((Object)offRow);
            }
        }
    }

    private DynamicObject createWriteOffLoanRow(DynamicObject loanExpense, Long sTableId) {
        EntryType offEntryType = (EntryType)this.getTgtMainType().getAllEntities().get("writeoffmoney");
        DynamicObject loanBill = (DynamicObject)loanExpense.getParent();
        DynamicObject offRow = new DynamicObject((DynamicObjectType)offEntryType);
        String loanbillnov1 = loanBill.getString("billno");
        String loanperson = loanBill.getDynamicObject("applier").getString("name");
        Date loanapplydatev1 = loanBill.getDate("bizdate");
        String loandescriptionv1 = loanBill.getString("description");
        DynamicObject entrycostdept = loanExpense.getDynamicObject("entrycostdept");
        DynamicObject entrycostcompany = loanExpense.getDynamicObject("entrycostcompany");
        DynamicObject std_srcentrycostcenter = loanExpense.getDynamicObject("std_entrycostcenter");
        DynamicObject loancurrency = loanExpense.getDynamicObject("entrycurrency");
        DynamicObject expenseitem = loanExpense.getDynamicObject("expenseitem");
        BigDecimal loanexchangerate = loanExpense.getBigDecimal("exchangerate");
        BigDecimal loanamount = loanExpense.getBigDecimal("orgiexpebalanceamount");
        BigDecimal currloanamount = loanExpense.getBigDecimal("expebalanceamount");
        String expquotetype = loanExpense.getString("expquotetype");
        offRow.set("loanbillnov1", (Object)loanbillnov1);
        offRow.set("sourceentrycostdept", (Object)entrycostdept);
        offRow.set("sourceentrycostcompany", (Object)entrycostcompany);
        offRow.set("std_srcentrycostcenter", (Object)std_srcentrycostcenter);
        offRow.set("sourceexpenseitem", (Object)expenseitem);
        offRow.set("writeoffquotetype", (Object)expquotetype);
        offRow.set("loanperson", (Object)loanperson);
        offRow.set("loanapplydatev1", (Object)loanapplydatev1);
        offRow.set("loandescriptionv1", (Object)loandescriptionv1);
        offRow.set("loancurrency", (Object)loancurrency);
        offRow.set("loanexchangerate", (Object)loanexchangerate);
        offRow.set("loanamount", (Object)loanamount);
        offRow.set("currloanamount", (Object)currloanamount);
        offRow.set("accloanamount", (Object)loanamount);
        offRow.set("curraccloanamount", (Object)currloanamount);
        offRow.set("sourcebillid", loanBill.getPkValue());
        offRow.set("sourceentryid", loanExpense.getPkValue());
        offRow.set("srcbilltype", (Object)loanBill.getDataEntityType().getName());
        if (loanBill.getDataEntityType().getName().equals("er_prepaybill")) {
            offRow.set("loanprojectno", (Object)loanExpense.getString("entryprojectno"));
            offRow.set("loancontractno", (Object)loanExpense.getString("entrycontractno"));
            offRow.set("srcentrywltype", (Object)loanBill.getString("billpayertype"));
            offRow.set("srcentrywlunit", (Object)loanBill.getDynamicObject("billpayerid"));
        }
        DynamicObjectCollection offLinkRows = offRow.getDynamicObjectCollection("writeoffmoney_lk");
        DynamicObject offLinkRow = new DynamicObject(offLinkRows.getDynamicObjectType());
        offLinkRow.set("seq", (Object)1);
        offLinkRow.set("writeoffmoney_lk_stableid", (Object)sTableId);
        offLinkRow.set("writeoffmoney_lk_sbillid", loanBill.getPkValue());
        offLinkRow.set("writeoffmoney_lk_sid", loanExpense.getPkValue());
        offLinkRows.add((Object)offLinkRow);
        return offRow;
    }

    private void setTicketNum(Map<String, DynamicProperty> propMap, DynamicObject srcRow, DynamicObject checkingRowTicket) {
        if ("er_planecheckingbill".equals(propMap.get("formid").getValue((Object)srcRow)) && Arrays.asList("UNUSED", "USED", "CHANGED").contains(propMap.get("ticketstatus").getValue((Object)srcRow))) {
            checkingRowTicket.set("travelbill", (Object)true);
            checkingRowTicket.set("ticketnum", propMap.get("ticketnum").getValue((Object)srcRow));
        }
        if ("er_traincheckingbill".equals(propMap.get("formid").getValue((Object)srcRow)) && !"3".equals(propMap.get("orderstatus").getValue((Object)srcRow))) {
            checkingRowTicket.set("travelbill", (Object)true);
            checkingRowTicket.set("ticketnum", propMap.get("trainticketnum").getValue((Object)srcRow));
        }
    }

    protected boolean isRefound(Map<String, DynamicProperty> propMap, DynamicObject sourceBill) {
        return false;
    }

    protected Integer perationtype(Map<String, DynamicProperty> propMap, DynamicObject sourceBill) {
        return null;
    }

    protected void buildLkEntry(Long sourceTableId, Long billid, DynamicObject checkingRow) {
        DynamicObjectCollection checkingRowTicketLinkRows = checkingRow.getDynamicObjectCollection(CHECKINGENTRY_LK);
        DynamicObject offLinkRow = new DynamicObject(checkingRowTicketLinkRows.getDynamicObjectType());
        offLinkRow.set("seq", (Object)1);
        offLinkRow.set("entryentity_lk_stableid", (Object)sourceTableId);
        offLinkRow.set("entryentity_lk_sbillid", (Object)billid);
        offLinkRow.set("entryentity_lk_sid", (Object)billid);
        checkingRowTicketLinkRows.add((Object)offLinkRow);
    }

    private Long getCheckingPayUser(Map<String, DynamicProperty> propMap, DynamicObject srcRow) {
        Long passenger = this.getPassengerUser(propMap, srcRow);
        return passenger != 0L ? passenger : (Long)propMap.get("sourcebookedid").getValue((Object)srcRow);
    }

    protected Long getPassengerUser(Map<String, DynamicProperty> propMap, DynamicObject srcRow) {
        return 0L;
    }

    private void setPayInfo(DynamicObject targetBill) {
        String server = targetBill.getString("server");
        if (StringUtils.isBlank((CharSequence)server)) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)server)});
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        Object provider = dynamicObject.get("provider");
        if (Objects.isNull(provider)) {
            return;
        }
        List<AccountInfo> accountInfo = PublicReimbursePayerAcctUtils.getAccountInfoByPayerId(targetBill.getString("payertype"), ErCommonUtils.getPk(provider));
        if (CollectionUtils.isEmpty(accountInfo)) {
            return;
        }
        AccountInfo tmpAccountInfo = accountInfo.get(0);
        for (AccountInfo info : accountInfo) {
            if (!info.isDefault()) continue;
            tmpAccountInfo = info;
            break;
        }
        this.fillBankInfo(targetBill, tmpAccountInfo);
        targetBill.set("payer", provider);
    }

    private void fillBankInfo(DynamicObject targetBill, AccountInfo accountInfo) {
        if (accountInfo != null) {
            targetBill.set("payeraccount", (Object)accountInfo.getAccount());
            targetBill.set("payerbank_id", (Object)ErCommonUtils.getPk(accountInfo.getBeBank()));
            targetBill.set("payeraccountname", (Object)accountInfo.getAccountName());
        } else {
            targetBill.set("payeraccount", null);
            targetBill.set("payerbank", null);
            targetBill.set("payeraccountname", null);
        }
    }

    protected String getBillSelectFileds(String srcEntity) {
        if (ErEntityTypeUtils.isDailyLoanBill(srcEntity)) {
            return "id, billno, billstatus, applier, bizdate,description, expenseentryentity.entrycurrency, expenseentryentity.entrycostdept, expenseentryentity.entrycostcompany,expenseentryentity.std_entrycostcenter, expenseentryentity.exchangerate, expenseentryentity.orgiexpebalanceamount, expenseentryentity.expebalanceamount,expenseentryentity.expenseitem,expenseentryentity.expquotetype";
        }
        if (ErEntityTypeUtils.isPrePayBill(srcEntity)) {
            return "id, billno, billstatus, applier, bizdate,description, expenseentryentity.entrycurrency, expenseentryentity.entrycostdept, expenseentryentity.entrycostcompany,expenseentryentity.std_entrycostcenter,expenseentryentity.exchangerate, expenseentryentity.orgiexpebalanceamount, expenseentryentity.expebalanceamount,expenseentryentity.expenseitem,expenseentryentity.expquotetype,billpayertype,billpayerid,expenseentryentity.entryprojectno, expenseentryentity.entrycontractno";
        }
        return "id";
    }
}

