/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.botp;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.fi.er.business.trip.util.CheckingPayBillWriteOffMoneyUtil;
import kd.fi.er.business.utils.AmountUtils;

public class CheckingPayBillUpDrawLoanBill
extends AbstractConvertPlugIn {
    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterCreateLink(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            DynamicObjectCollection writeoffmoney = targetBill.getDynamicObjectCollection("writeoffmoney");
            if (writeoffmoney != null && writeoffmoney.size() > 0) {
                int precision = AmountUtils.getAmountFieldPrecision((DynamicObject)writeoffmoney.get(0), "curraccloanamount");
                DynamicObjectCollection entryentity = targetBill.getDynamicObjectCollection("entryentity");
                BigDecimal actentryamount = AmountUtils.getEntryAmount(entryentity, "actentryamount");
                for (int i = 0; i < writeoffmoney.size(); ++i) {
                    BigDecimal currLoanAmount;
                    DynamicObject entry = (DynamicObject)writeoffmoney.get(i);
                    BigDecimal loanamount = entry.getBigDecimal("loanamount");
                    if (actentryamount.compareTo(loanamount) > 0) {
                        entry.set("accloanamount", (Object)loanamount);
                        currLoanAmount = AmountUtils.getCurrencyAmount(loanamount, entry.getBigDecimal("loanexchangerate"), precision, entry.getString("writeoffquotetype"));
                        entry.set("curraccloanamount", (Object)currLoanAmount);
                        actentryamount = actentryamount.subtract(loanamount);
                        continue;
                    }
                    entry.set("accloanamount", (Object)actentryamount);
                    currLoanAmount = AmountUtils.getCurrencyAmount(actentryamount, entry.getBigDecimal("loanexchangerate"), precision, entry.getString("writeoffquotetype"));
                    entry.set("curraccloanamount", (Object)currLoanAmount);
                    actentryamount = BigDecimal.ZERO;
                }
            }
            CheckingPayBillWriteOffMoneyUtil.refreshCheckingPayHeadAmount(targetBill);
        }
    }
}

