/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dailybiz;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.sdk.fi.er.extpoint.trip.ITripCheckOrderUserStatusService;
import org.apache.commons.lang3.StringUtils;

public class TripNotReimbursedOrderUtil {
    private static final Log logger = LogFactory.getLog(TripNotReimbursedOrderUtil.class);
    static final Map<String, String> BUSSINESS_TYPE_MAP = Maps.newHashMapWithExpectedSize((int)4);
    private static final String[] planeOrderStatus;
    private static final String[] hotelOrderStatus;
    private static final String[] ehotelOrderStatus;
    private static final String[] carOrderStatus;
    private static final String[] trainOrderStatus;
    private static final String[] mealOrderStatus;
    private static final String[] planeTicketstatus;

    public static boolean checkAvailableOrder(DynamicObject orderBill) {
        PluginProxy tripCheckOrderUserStatusServicePluginProxy = PluginProxy.create(null, ITripCheckOrderUserStatusService.class, (String)"FI_ER_TRIP_CHECKORDERUSERSTATUS", null);
        AtomicReference[] callreplace = new AtomicReference[]{null};
        tripCheckOrderUserStatusServicePluginProxy.callReplace(p -> {
            callreplace[0] = new AtomicReference<Boolean>(p.checkOrderUserStatus(orderBill));
            return (Boolean)callreplace[0].get();
        });
        if (null != callreplace[0]) {
            return (Boolean)callreplace[0].get();
        }
        String orderFormId = orderBill.getDynamicObjectType().getName();
        String server = orderBill.getString("server");
        int paramValue = (Integer)ActionLocalCache.get().get("order_status_control", "order_status_control", () -> TripSyncConfigUtil.getIntValue("order_status_control", 0));
        if (paramValue == 1) {
            if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)orderFormId) && Arrays.asList(planeTicketstatus).contains(orderBill.getString("ticketstatus")) && orderBill.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_hotelbill", (CharSequence)orderFormId) && Arrays.asList(hotelOrderStatus).contains(orderBill.getString("orderstatus")) && orderBill.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_hotelbill", (CharSequence)orderFormId) && Arrays.asList(ehotelOrderStatus).contains(orderBill.getString("orderstatus")) && server.equals(Supplier.CHAILVYIHAO.getValue()) && orderBill.getDate("checkoutdate").before(new Date())) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_vehiclebill", (CharSequence)orderFormId) && Arrays.asList(carOrderStatus).contains(orderBill.getString("orderstatus")) && orderBill.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_trainbill", (CharSequence)orderFormId) && Arrays.asList(trainOrderStatus).contains(orderBill.getString("orderstatus")) && orderBill.getDate("departtime") != null && orderBill.getDate("departtime").before(new Date())) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_mealbill", (CharSequence)orderFormId) && Arrays.asList(mealOrderStatus).contains(orderBill.getString("orderstatus"))) {
                return true;
            }
        } else {
            if (StringUtils.equals((CharSequence)"er_planebill", (CharSequence)orderFormId) && (Arrays.asList(planeTicketstatus).contains(orderBill.getString("ticketstatus")) || orderBill.getDate("takeofftime") != null && orderBill.getDate("takeofftime").before(new Date())) && orderBill.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_hotelbill", (CharSequence)orderFormId) && (Arrays.asList(hotelOrderStatus).contains(orderBill.getString("orderstatus")) || orderBill.getDate("checkoutdate") != null && orderBill.getDate("checkoutdate").before(new Date())) && orderBill.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_hotelbill", (CharSequence)orderFormId) && (Arrays.asList(ehotelOrderStatus).contains(orderBill.getString("orderstatus")) || orderBill.getDate("checkoutdate") != null && orderBill.getDate("checkoutdate").before(new Date())) && server.equals(Supplier.CHAILVYIHAO.getValue())) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_vehiclebill", (CharSequence)orderFormId) && (Arrays.asList(carOrderStatus).contains(orderBill.getString("orderstatus")) || orderBill.getDate("usetime") != null && orderBill.getDate("usetime").before(new Date())) && orderBill.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_trainbill", (CharSequence)orderFormId) && Arrays.asList(trainOrderStatus).contains(orderBill.getString("orderstatus")) && orderBill.getDate("departtime") != null && orderBill.getDate("departtime").before(new Date())) {
                return true;
            }
            if (StringUtils.equals((CharSequence)"er_mealbill", (CharSequence)orderFormId) && (Arrays.asList(mealOrderStatus).contains(orderBill.getString("orderstatus")) || orderBill.getDate("mealtime") != null && orderBill.getDate("mealtime").before(new Date()))) {
                return true;
            }
        }
        return false;
    }

    public static String getNotUsedOrderWarningStrByReq(List<Object> reqBillList) {
        String orderWarningStr = "";
        if (reqBillList == null || reqBillList.isEmpty()) {
            return orderWarningStr;
        }
        ArrayList<Long> reqBillIds = new ArrayList<Long>();
        final ArrayList<String> reqBillNos = new ArrayList<String>();
        AtomicReference<Long> companyId = new AtomicReference<Long>(RequestContext.get().getOrgId());
        Object param = reqBillList.get(0);
        if (param instanceof DynamicObject) {
            reqBillList.stream().forEach(v -> {
                reqBillIds.add((Long)((DynamicObject)v).getPkValue());
                reqBillNos.add(((DynamicObject)v).getString("billno"));
                companyId.set((Long)((DynamicObject)v).getDynamicObject("company").getPkValue());
            });
        } else if (param instanceof Long || param instanceof String) {
            DynamicObjectCollection reqBills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"id,billno,company,tripentry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", reqBillList)});
            reqBills.stream().forEach(v -> {
                reqBillIds.add(v.getLong("id"));
                reqBillNos.add(v.getString("billno"));
                companyId.set(ErCommonUtils.getPk(v.get("company")));
            });
        } else {
            logger.info("\u5546\u65c5\u96c6\u6210,\u5224\u65ad\u662f\u5426\u6709\u672a\u4f7f\u7528\u7684\u5546\u65c5\u8ba2\u5355\u51fa\u9519,\u5b9e\u4f53\u7684\u7c7b\u578b\u4e0d\u6b63\u786e:" + JSON.toJSONString(reqBillList));
            return ResManager.loadKDString((String)"\u5224\u65ad\u662f\u5426\u6709\u672a\u4f7f\u7528\u7684\u5546\u65c5\u8ba2\u5355\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TripNotReimbursedOrderUtil_0", (String)"fi-er-business", (Object[])new Object[0]);
        }
        int reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam(companyId.get(), "reqbilltoreimbursecount");
        if (reqbilltoreimbursecount > 0) {
            return orderWarningStr;
        }
        List<DynamicObject> notReimbursedOrderList = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByReq(reqBillIds, reqBillNos, companyId.get());
        if (notReimbursedOrderList == null || notReimbursedOrderList.isEmpty()) {
            return orderWarningStr;
        }
        orderWarningStr = TripNotReimbursedOrderUtil.getNotUsedOrderWarningStr(notReimbursedOrderList);
        if (StringUtils.isNotEmpty((CharSequence)orderWarningStr)) {
            ThreadService.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    HashSet billNos = Sets.newHashSet((Iterable)reqBillNos);
                    TripNotReimbursedOrderUtil.updateOrderBillByReq(new ArrayList<String>(billNos));
                }
            }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
        }
        return orderWarningStr;
    }

    public static String getNotUsedOrderWarningStrByOrderNum(DynamicObject reimbursebill) {
        String orderWarningStr = "";
        Set<String> ordernums = TripNotReimbursedOrderUtil.getExistOrderNums(new DynamicObject[]{reimbursebill});
        if (ordernums == null || ordernums.isEmpty()) {
            return orderWarningStr;
        }
        List<DynamicObject> notReimbursedOrderList = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByOrderNum(ordernums, ErCommonUtils.getPk(reimbursebill.get("company")));
        if (notReimbursedOrderList == null || notReimbursedOrderList.isEmpty()) {
            return orderWarningStr;
        }
        orderWarningStr = TripNotReimbursedOrderUtil.getNotUsedOrderWarningStr(notReimbursedOrderList);
        return orderWarningStr;
    }

    private static String getNotUsedOrderWarningStr(List<DynamicObject> notReimbursedOrderList) {
        StringBuilder orderWarningStr = new StringBuilder();
        for (DynamicObject orderBill : notReimbursedOrderList) {
            String server = orderBill.getString("server");
            if (TripNotReimbursedOrderUtil.checkAvailableOrder(orderBill)) continue;
            orderWarningStr.append(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u5b58\u5728\u672a\u4f7f\u7528\u7684\u5546\u65c5\u8ba2\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u62a5\u9500\uff1b\u5982\u5b9e\u9645\u5df2\u4f7f\u7528\uff0c\u72b6\u6001\u66f4\u65b0\u4f1a\u6709\u5ef6\u8fdf\uff1b", (String)"TripNotReimbursedOrderUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
            orderWarningStr.append("\n");
            orderWarningStr.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u6b63\u5728\u4e3a\u60a8\u81ea\u52a8\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u7b49\u5f853-5\u79d2\u540e\u5c1d\u8bd5\u91cd\u65b0\u62a5\u9500\uff1b\u82e5\u4ecd\u62a5\u9500\u5931\u8d25\uff0c\u8bf7\u7b49\u5f851-2\u5929\u540e\u91cd\u8bd5\u3002", (String)"TripNotReimbursedOrderUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
            break;
        }
        return orderWarningStr.toString();
    }

    public static List<DynamicObject> queryNotReimbursedOrdersByReq(List<Long> reqBillIds, List<String> reqBillNos, Long companyId) {
        ArrayList<DynamicObject> notReimbursedOrderList = new ArrayList<DynamicObject>();
        if (reqBillIds == null || reqBillIds.isEmpty()) {
            return notReimbursedOrderList;
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])reqBillIds.toArray(new Long[reqBillIds.size()]));
        QFilter reimburFilter = new QFilter("id", "in", targetBills.get("er_tripreimbursebill")).and(new QFilter("billstatus", "!=", (Object)"H"));
        DynamicObject[] reimburseObjects = BusinessDataServiceHelper.load((String)"er_tripreimbursebill", (String)"id,tripentry,tripentry.entryentity,ordernum", (QFilter[])new QFilter[]{reimburFilter});
        Set<String> existOrderNums = TripNotReimbursedOrderUtil.getExistOrderNums(reimburseObjects);
        QFilter orderFilter = new QFilter("oabillnum", "in", reqBillNos);
        if (existOrderNums != null && !existOrderNums.isEmpty()) {
            orderFilter.and(new QFilter("ordernum", "not in", existOrderNums));
        }
        QFilter planeFilter = new QFilter("orderstatus", "!=", (Object)"30000").and(QFilter.of((String)"producttype !='2' or servicefeepaytype='1'", (Object[])new Object[0]));
        planeFilter.and(orderFilter);
        return TripNotReimbursedOrderUtil.queryNotReimbursedOrders(planeFilter, orderFilter, orderFilter, orderFilter, orderFilter, companyId, true);
    }

    public static List<DynamicObject> queryNotReimbursedOrdersByDailyApply(List<Long> applyBillIds, List<String> applyBillNos, Long companyId) {
        ArrayList<DynamicObject> notReimbursedOrderList = new ArrayList<DynamicObject>();
        if (applyBillIds == null || applyBillIds.isEmpty()) {
            return notReimbursedOrderList;
        }
        HashSet<String> existOrderNums = new HashSet<String>();
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_dailyapplybill", (Long[])applyBillIds.toArray(new Long[applyBillIds.size()]));
        QFilter reimburFilter = new QFilter("id", "in", targetBills.get("er_publicreimbursebill")).and(new QFilter("billstatus", "!=", (Object)"H"));
        DynamicObject[] publicReimburse = BusinessDataServiceHelper.load((String)"er_publicreimbursebill", (String)"orderentry,orderentry.ordernumber", (QFilter[])new QFilter[]{reimburFilter});
        TripNotReimbursedOrderUtil.getExistOrderNums(publicReimburse, existOrderNums);
        QFilter orderFilter = new QFilter("oabillnum", "in", applyBillNos);
        if (!existOrderNums.isEmpty()) {
            orderFilter.and(new QFilter("ordernum", "not in", existOrderNums));
        }
        QFilter planeFilter = QFilter.of((String)"producttype !='2' or servicefeepaytype='1'", (Object[])new Object[0]);
        planeFilter.and(orderFilter);
        return TripNotReimbursedOrderUtil.queryNotReimbursedOrders(planeFilter, orderFilter, orderFilter, orderFilter, orderFilter, companyId, false);
    }

    public static List<DynamicObject> queryNotReimbursedOrdersByOrderNum(Set<String> ordernums, Long companyId) {
        ArrayList<DynamicObject> notReimbursedOrderList = new ArrayList<DynamicObject>();
        if (ordernums == null || ordernums.isEmpty()) {
            return notReimbursedOrderList;
        }
        QFilter orderFilter = new QFilter("ordernum", "in", ordernums);
        QFilter planeFilter = new QFilter("orderstatus", "!=", (Object)"30000").and(QFilter.of((String)"producttype !='2' or servicefeepaytype='1'", (Object[])new Object[0]));
        planeFilter.and(orderFilter);
        return TripNotReimbursedOrderUtil.queryNotReimbursedOrders(planeFilter, orderFilter, orderFilter, orderFilter, orderFilter, companyId, true);
    }

    public static List<DynamicObject> queryNotReimbursedOrdersByOrderId(Set<Long> orderIds, Long companyId, Boolean isTripReim) {
        ArrayList<DynamicObject> notReimbursedOrderList = new ArrayList<DynamicObject>();
        if (orderIds == null || orderIds.isEmpty()) {
            return notReimbursedOrderList;
        }
        QFilter orderFilter = new QFilter("id", "in", orderIds);
        QFilter planeFilter = new QFilter("orderstatus", "!=", (Object)"30000").and(QFilter.of((String)"producttype !='2' or servicefeepaytype='1'", (Object[])new Object[0]));
        planeFilter.and(orderFilter);
        return TripNotReimbursedOrderUtil.queryNotReimbursedOrders(planeFilter, orderFilter, orderFilter, orderFilter, orderFilter, companyId, isTripReim);
    }

    private static List<DynamicObject> queryNotReimbursedOrders(QFilter planeOrderFilter, QFilter hotelOrderFilter, QFilter trainOrderFilter, QFilter vehicleOrderFilter, QFilter mealOrderFilter, Long companyId, Boolean isTripReim) {
        ArrayList<DynamicObject> notReimbursedOrderList = new ArrayList<DynamicObject>();
        int ordertripreimburse = SystemParamterUtil.getcheckparamDefaute(companyId, "ordertripreimburse");
        if (ordertripreimburse > 0 || !isTripReim.booleanValue()) {
            List planeBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_planebill", (QFilter[])new QFilter[]{planeOrderFilter, new QFilter("isreimburse", "=", (Object)"0")}, null, (int)-1);
            MainEntityType planeType = EntityMetadataCache.getDataEntityType((String)"er_planebill");
            DynamicObject[] planeBills = BusinessDataServiceHelper.load((Object[])planeBillIds.toArray(), (DynamicObjectType)planeType);
            List trainBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_trainbill", (QFilter[])new QFilter[]{trainOrderFilter, new QFilter("isreimburse", "=", (Object)"0")}, null, (int)-1);
            MainEntityType trainType = EntityMetadataCache.getDataEntityType((String)"er_trainbill");
            DynamicObject[] trainBills = BusinessDataServiceHelper.load((Object[])trainBillIds.toArray(), (DynamicObjectType)trainType);
            TripNotReimbursedOrderUtil.genMonthOrder(notReimbursedOrderList, trainBills);
            List hotelBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_hotelbill", (QFilter[])new QFilter[]{hotelOrderFilter, new QFilter("isreimburse", "=", (Object)"0")}, null, (int)-1);
            MainEntityType hotelType = EntityMetadataCache.getDataEntityType((String)"er_hotelbill");
            DynamicObject[] hotelBills = BusinessDataServiceHelper.load((Object[])hotelBillIds.toArray(), (DynamicObjectType)hotelType);
            TripNotReimbursedOrderUtil.genMonthOrder(notReimbursedOrderList, hotelBills);
            notReimbursedOrderList.addAll(Arrays.asList(planeBills));
        }
        if (SystemParamterUtil.getcheckparamDefaute(companyId, "carordertripreimburse") > 0 || !isTripReim.booleanValue()) {
            List carBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_vehiclebill", (QFilter[])new QFilter[]{vehicleOrderFilter, new QFilter("isreimburse", "=", (Object)"0")}, null, (int)-1);
            MainEntityType carType = EntityMetadataCache.getDataEntityType((String)"er_vehiclebill");
            DynamicObject[] carBills = BusinessDataServiceHelper.load((Object[])carBillIds.toArray(), (DynamicObjectType)carType);
            TripNotReimbursedOrderUtil.genMonthOrder(notReimbursedOrderList, carBills);
        }
        if (SystemParamterUtil.getcheckparamDefaute(companyId, "mealordertripreimburse") > 0 || !isTripReim.booleanValue()) {
            QFilter[] qfilters = new QFilter[]{mealOrderFilter, new QFilter("isreimburse", "=", (Object)"0")};
            if (isTripReim.booleanValue()) {
                qfilters = new QFilter[]{mealOrderFilter, new QFilter("isreimburse", "=", (Object)"0"), new QFilter("dinnerscene", "=", (Object)"3")};
            }
            List mealBillIds = QueryServiceHelper.queryPrimaryKeys((String)"er_mealbill", (QFilter[])qfilters, null, (int)-1);
            MainEntityType mealType = EntityMetadataCache.getDataEntityType((String)"er_mealbill");
            DynamicObject[] mealBills = BusinessDataServiceHelper.load((Object[])mealBillIds.toArray(), (DynamicObjectType)mealType);
            TripNotReimbursedOrderUtil.genMonthOrder(notReimbursedOrderList, mealBills);
        }
        return notReimbursedOrderList;
    }

    private static void genMonthOrder(List<DynamicObject> notReimbursedOrderList, DynamicObject[] orderBills) {
        Arrays.stream(orderBills).forEach(bill -> {
            if ("2".equalsIgnoreCase(bill.getString("producttype")) && ("2".equalsIgnoreCase(bill.getString("servicefeepaytype")) || "".equalsIgnoreCase(bill.getString("servicefeepaytype")))) {
                return;
            }
            notReimbursedOrderList.add((DynamicObject)bill);
        });
    }

    private static Set<String> getExistOrderNums(DynamicObject[] reimburseObjects) {
        HashSet<String> existOrderNums = new HashSet<String>();
        if (reimburseObjects.length == 0) {
            return existOrderNums;
        }
        for (DynamicObject reimburseObject : reimburseObjects) {
            DynamicObjectCollection tripentry = reimburseObject.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripsection : tripentry) {
                DynamicObjectCollection entrys = tripsection.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryObject : entrys) {
                    String ordernum = entryObject.getString("ordernum");
                    if (!StringUtils.isNotEmpty((CharSequence)ordernum)) continue;
                    existOrderNums.add(ordernum);
                }
            }
        }
        return existOrderNums;
    }

    private static Set<String> getExistOrderNums(DynamicObject[] reimburseObjects, Set<String> existOrderNums) {
        if (reimburseObjects != null && reimburseObjects.length > 0) {
            for (DynamicObject reimburseObject : reimburseObjects) {
                DynamicObjectCollection orderentry = reimburseObject.getDynamicObjectCollection("orderentry");
                for (DynamicObject dynamicObject : orderentry) {
                    String ordernum = dynamicObject.getString("ordernumber");
                    if (!StringUtils.isNotBlank((CharSequence)ordernum)) continue;
                    existOrderNums.add(ordernum);
                }
            }
        }
        return existOrderNums;
    }

    @Deprecated
    public static List<DynamicObject> queryNotReimbursedOrdersByUp(Long applier, Object[] tripUsers, Object[] existOrderNums, Object[] reqbillIds, Long companyId) {
        return TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByUp(applier, tripUsers, existOrderNums, reqbillIds, companyId, null);
    }

    @Deprecated
    public static List<DynamicObject> queryNotReimbursedOrdersByUp(Long applier, Object[] tripUsers, Object[] existOrderNums, Object[] reqbillIds, Long companyId, String search) {
        return TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByUp(applier, tripUsers, existOrderNums, reqbillIds, companyId, search, null);
    }

    public static List<DynamicObject> queryNotReimbursedOrdersByUp(Long applier, Object[] tripUsers, Object[] existOrderNums, Object[] reqbillIds, Long companyId, String search, Long creator) {
        QFilter planeQfilter = new QFilter("sourcebookedid", "=", (Object)applier).or(new QFilter("sourcebookedid", "=", (Object)creator));
        QFilter trainQfilter = new QFilter("sourcebookedid", "=", (Object)applier).or(new QFilter("sourcebookedid", "=", (Object)creator));
        QFilter mealOrderQFilter = new QFilter("isreimburse", "!=", (Object)"1");
        mealOrderQFilter.and(new QFilter("sourcebookedid", "=", (Object)applier)).or(new QFilter("sourcebookedid", "=", (Object)creator));
        if (tripUsers == null) {
            tripUsers = new Object[]{};
        }
        Set collect = Arrays.stream(tripUsers).collect(Collectors.toSet());
        if (null != creator) {
            collect.add(creator);
            collect.add(applier);
        }
        if ((tripUsers = collect.toArray()) != null && tripUsers.length > 0) {
            QFilter sourcetravelerQfilter = new QFilter("sourcetravelerid", "in", (Object)tripUsers);
            QFilter passegerQfilter = new QFilter("passeger", "in", (Object)tripUsers);
            QFilter mealQfilter = new QFilter("sourcebookedid", "in", (Object)tripUsers);
            planeQfilter.or(sourcetravelerQfilter);
            trainQfilter.or(passegerQfilter);
            mealOrderQFilter.or(mealQfilter);
        }
        planeQfilter.and("isreimburse", "!=", (Object)"1");
        trainQfilter.and("isreimburse", "!=", (Object)"1");
        QFilter vehicleQfilter = new QFilter("vehicletype", "=", (Object)"1");
        vehicleQfilter.and(trainQfilter);
        if (existOrderNums != null && existOrderNums.length > 0) {
            QFilter orderNums = new QFilter("ordernum", "not in", (Object)existOrderNums);
            planeQfilter.and(orderNums);
            trainQfilter.and(orderNums);
            mealOrderQFilter.and(orderNums);
        }
        if (reqbillIds != null && reqbillIds.length > 0) {
            List applybillnos;
            DynamicObject[] reqObjects = (DynamicObject[])QueryServiceHelper.query((String)"er_tripreqbill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)reqbillIds)}).toArray((Object[])new DynamicObject[0]);
            DynamicObject[] applyObjects = (DynamicObject[])QueryServiceHelper.query((String)"er_dailyapplybill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)reqbillIds)}).toArray((Object[])new DynamicObject[0]);
            List billnos = Arrays.stream(reqObjects).map(m -> m.getString("billno")).collect(Collectors.toList());
            if (billnos.size() > 0) {
                QFilter oabillNumQfliter = new QFilter("oabillnum", "in", billnos);
                trainQfilter.and(oabillNumQfliter);
                planeQfilter.and(oabillNumQfliter);
                mealOrderQFilter.and(oabillNumQfliter);
            }
            if ((applybillnos = Arrays.stream(applyObjects).map(m -> m.getString("billno")).collect(Collectors.toList())).size() > 0) {
                QFilter oabillNumQfliter = new QFilter("oabillnum", "in", applybillnos);
                trainQfilter.and(oabillNumQfliter);
                planeQfilter.and(oabillNumQfliter);
                mealOrderQFilter.and(oabillNumQfliter);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)search)) {
            QFilter searchQfilter = new QFilter("ordernum", "like", (Object)("%" + search + "%"));
            searchQfilter.or(new QFilter("oabillnum", "like", (Object)("%" + search + "%")));
            planeQfilter.and(searchQfilter);
            trainQfilter.and(searchQfilter);
        }
        return TripNotReimbursedOrderUtil.queryNotReimbursedOrders(planeQfilter, planeQfilter, trainQfilter, vehicleQfilter, mealOrderQFilter, companyId, true);
    }

    public static void updateOrderBillByReq(List<String> reqBillNums) {
        if (CollectionUtils.isEmpty(reqBillNums)) {
            return;
        }
        boolean travelNoOneIsEnable = QueryServiceHelper.exists((String)"er_biz_info", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)Supplier.CHAILVYIHAO.name()), new QFilter("enable", "=", (Object)"1")});
        boolean cTripIsEnable = QueryServiceHelper.exists((String)"er_biz_info", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)Supplier.XIECHENG.name()), new QFilter("enable", "=", (Object)"1")});
        if (!travelNoOneIsEnable && !cTripIsEnable) {
            return;
        }
        if (travelNoOneIsEnable) {
            TripNotReimbursedOrderUtil.callTravelNoOneFunction(reqBillNums);
        }
        if (cTripIsEnable) {
            TripNotReimbursedOrderUtil.callCtripFunction(reqBillNums);
        }
    }

    public static void callCtripFunction(List<String> reqBillNums) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        String service = TripCommonUtil.getStandtripname().get(Supplier.XIECHENG.name());
        ITripService tripService = TripServiceFactory.getTripService(service);
        try {
            for (String reqBillNum : reqBillNums) {
                paramMap.put("reqnum", reqBillNum);
                tripService.synOrderFromTrip(paramMap);
            }
            DynamicObjectCollection orderBills = QueryServiceHelper.query((String)"er_allorderbill", (String)"ordernum,orderformid", (QFilter[])new QFilter[]{new QFilter("oabillnum", "in", reqBillNums), new QFilter("server", "=", (Object)Supplier.XIECHENG.name())});
            if (CollectionUtils.isNotEmpty((Collection)orderBills)) {
                Map<String, List<DynamicObject>> typeMap = orderBills.stream().filter(order -> StringUtils.isNotEmpty((CharSequence)order.getString("ordernum"))).collect(Collectors.groupingBy(order -> order.getString("orderformid")));
                Set<Map.Entry<String, List<DynamicObject>>> entries = typeMap.entrySet();
                for (Map.Entry<String, List<DynamicObject>> entry : entries) {
                    String orderForm = entry.getKey();
                    String businessType = BUSSINESS_TYPE_MAP.get(orderForm);
                    List<DynamicObject> tmpOrderBills = entry.getValue();
                    Set<String> orderNums = tmpOrderBills.stream().filter(orderBill -> StringUtils.isNotEmpty((CharSequence)orderBill.getString("ordernum"))).map(orderBill -> orderBill.getString("ordernum")).collect(Collectors.toSet());
                    TripNotReimbursedOrderUtil.updateOrderBill(businessType, orderNums);
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u643a\u7a0b\u6839\u636e\u7533\u8bf7\u5355\u83b7\u53d6\u8ba2\u5355\u62a5\u9519", (Throwable)ex);
        }
    }

    public static void callTravelNoOneFunction(List<String> reqBillNums) {
        DynamicObjectCollection reqBills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"bizdate,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", reqBillNums)});
        Map<String, Date> billNoAndDateMap = reqBills.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("billno"), dynamicObject -> dynamicObject.getDate("bizdate")));
        if (billNoAndDateMap.isEmpty()) {
            return;
        }
        String service = TripCommonUtil.getStandtripname().get(Supplier.CHAILVYIHAO.name());
        ITripService tripService = TripServiceFactory.getTripService(service);
        Set<Map.Entry<String, Date>> entries = billNoAndDateMap.entrySet();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (Map.Entry<String, Date> entry : entries) {
                String billNo = entry.getKey();
                Date date = entry.getValue();
                paramMap.put("reqnum", billNo);
                paramMap.put("date", format.format(date));
                tripService.synOrderFromTrip(paramMap);
            }
        }
        catch (Exception ex) {
            logger.error("\u5dee\u65c5\u58f9\u53f7\u6839\u636e\u7533\u8bf7\u5355\u83b7\u53d6\u8ba2\u5355\u62a5\u9519", (Throwable)ex);
        }
    }

    public static void updateOrderBill(String businessType, Set<String> orderNums) throws Exception {
        Set<String> orderNumSet = TripCommonUtil.getOrderNums(orderNums);
        HashMap newParams = Maps.newHashMapWithExpectedSize((int)2);
        newParams.put("businessType", businessType);
        Iterator<String> iterator = orderNumSet.iterator();
        ITripService cTripService = TripServiceFactory.getTripService("CTripService");
        int requestCount = 0;
        long startTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            newParams.put("ordernum", iterator.next());
            cTripService.getOrderUpdateFromTripSettel(newParams);
            if (++requestCount < 10000 || System.currentTimeMillis() - startTime > 3600000L) continue;
            long usedTime = System.currentTimeMillis() - startTime;
            long sleepTime = 3600000L - usedTime;
            Thread.sleep(sleepTime + 1000L);
            requestCount = 0;
            startTime = System.currentTimeMillis();
        }
    }

    public static String getOrderExistReim(DynamicObject dynamicObject) {
        String message = null;
        HashSet<String> ordernums = new HashSet<String>();
        DynamicObjectCollection tripentries = dynamicObject.getDynamicObjectCollection("tripentry");
        for (DynamicObject tripentry : tripentries) {
            DynamicObjectCollection entryentities = tripentry.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentities) {
                String ordernum = (String)entryentity.get("ordernum");
                if (null == ordernum || ordernum.trim().isEmpty()) continue;
                ordernums.add(ordernum);
            }
        }
        if (ordernums.isEmpty()) {
            return message;
        }
        QFilter reimburFilter = new QFilter("tripentry.entryentity.ordernum", "in", ordernums).and(new QFilter("billstatus", "!=", (Object)"H"));
        DynamicObjectCollection isreimbOrders = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,billno,tripentry.entryentity.ordernum", (QFilter[])new QFilter[]{reimburFilter});
        if (null != isreimbOrders && !isreimbOrders.isEmpty()) {
            int tripIndex = 0;
            for (DynamicObject tripentry : tripentries) {
                ++tripIndex;
                DynamicObjectCollection entryentities = tripentry.getDynamicObjectCollection("entryentity");
                int entryIndex = 0;
                for (DynamicObject entryentity : entryentities) {
                    ++entryIndex;
                    String ordernum = entryentity.getString("ordernum");
                    if (null == ordernum || ordernum.trim().isEmpty()) continue;
                    for (DynamicObject isreimbOrder : isreimbOrders) {
                        if (!ordernum.equals(isreimbOrder.getString("tripentry.entryentity.ordernum")) || dynamicObject.get("billno").equals(isreimbOrder.getString("billno"))) continue;
                        message = ResManager.loadKDString((String)"\u7b2c%s\u6bb5\u884c\u7a0b\uff0c\u7b2c%d\u884c\u660e\u7ec6\u5546\u65c5\u8ba2\u5355\u5df2\u62a5\u9500\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TripReimburseSubmitValidator_23", (String)"fi-er-opplugin", (Object[])new Object[]{tripIndex, entryIndex});
                    }
                }
            }
        }
        return message;
    }

    static {
        BUSSINESS_TYPE_MAP.put("er_planebill", "PLANE");
        BUSSINESS_TYPE_MAP.put("er_hotelbill", "HOTEL");
        BUSSINESS_TYPE_MAP.put("er_trainbill", "TRAIN");
        BUSSINESS_TYPE_MAP.put("er_vehiclebill", "CAR");
        planeOrderStatus = new String[]{"40000", "50302", "50202", "55554", "55555", "30000"};
        hotelOrderStatus = new String[]{"7", "10", "14", "9999"};
        ehotelOrderStatus = new String[]{"5", "9999"};
        carOrderStatus = new String[]{"Successful", "Canceled", "Refunded", "PartialRefund", "9999"};
        trainOrderStatus = new String[]{"1", "2", "3", "9999"};
        mealOrderStatus = new String[]{"PAY", "9999"};
        planeTicketstatus = new String[]{"REFOUND", "USED", "CHANGED"};
    }
}

