/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.annotation.KDTripEntity;
import kd.fi.er.business.trip.dao.IDataHandleDao;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.CheckingBillExistDataModel;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.trip.model.IDataModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripFieldSetValueUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCheckingDetailDao
implements IDataHandleDao {
    private static final Log logger = LogFactory.getLog(AbstractCheckingDetailDao.class);
    private IErDao checingDetailDao = null;
    private IErDao allCheckDao = null;
    protected CheckingBillExistDataModel existData;

    @Override
    public void setExistDataModel(ExistDataModel existData) {
        this.existData = (CheckingBillExistDataModel)existData;
    }

    @Override
    public void generateData(IDataModel dataModel) throws TripException {
        AbstractOrderModel.OperationType operationType;
        String trainticketnum;
        String downloadlink;
        DynamicObject orderDetail;
        AbstractCheckingBillDetailModel checkingBillModel = null;
        if (!(dataModel instanceof AbstractCheckingBillDetailModel)) {
            throw new TripException(ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u7c7b\u578b\u9519\u8bef\u3002", (String)"AbstractCheckingDetailDao_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        checkingBillModel = (AbstractCheckingBillDetailModel)dataModel;
        Class<?> checkingModelClass = checkingBillModel.getClass();
        KDTripEntity entityName = checkingModelClass.getAnnotation(KDTripEntity.class);
        String orderNum = checkingBillModel.getOrderNum();
        if (this.checingDetailDao == null) {
            this.checingDetailDao = ErDaoFactory.getInstance(entityName.name());
        }
        DynamicObject checkingDynamic = this.existData.checkingbillDetailMapping.get(orderNum);
        Date now = new Date();
        String userId = RequestContext.get().getUserId();
        if (checkingDynamic == null) {
            checkingDynamic = this.checingDetailDao.getEmptyDynamicObject();
            checkingDynamic.set("creator", (Object)userId);
            checkingDynamic.set("createtime", (Object)now);
            checkingDynamic.set("billstatus", (Object)"A");
            checkingDynamic.set("hasinvoice", (Object)"0");
            this.existData.checkingbillDetailMapping.put(orderNum, checkingDynamic);
            orderDetail = this.existData.orderDetailMapping.get(orderNum);
            if (orderDetail == null || StringUtils.isBlank((String)orderDetail.getString("reimbursestatus"))) {
                checkingDynamic.set("reimbursestatus", (Object)"A");
            } else {
                checkingDynamic.set("reimbursestatus", (Object)orderDetail.getString("reimbursestatus"));
            }
            if (orderDetail != null) {
                if (orderDetail.containsProperty("downloadlink")) {
                    downloadlink = orderDetail.getString("downloadlink");
                    checkingDynamic.set("downloadlink", (Object)downloadlink);
                }
                if (orderDetail.containsProperty("kddownloadlink")) {
                    downloadlink = orderDetail.getString("kddownloadlink");
                    checkingDynamic.set("kddownloadlink", (Object)downloadlink);
                }
                if (orderDetail.containsProperty("trainticketnum")) {
                    trainticketnum = orderDetail.getString("trainticketnum");
                    checkingDynamic.set("trainticketnum", (Object)trainticketnum);
                }
                if (orderDetail.containsProperty("std_project") && checkingDynamic.containsProperty("std_project")) {
                    checkingDynamic.set("std_project", orderDetail.get("std_project"));
                }
            }
        } else {
            orderDetail = this.existData.orderDetailMapping.get(orderNum);
            if (orderDetail != null) {
                if (orderDetail.containsProperty("downloadlink")) {
                    downloadlink = orderDetail.getString("downloadlink");
                    checkingDynamic.set("downloadlink", (Object)downloadlink);
                }
                if (orderDetail.containsProperty("kddownloadlink")) {
                    String kddownloadlink = orderDetail.getString("kddownloadlink");
                    checkingDynamic.set("kddownloadlink", (Object)kddownloadlink);
                }
                if (orderDetail.containsProperty("trainticketnum")) {
                    trainticketnum = orderDetail.getString("trainticketnum");
                    checkingDynamic.set("trainticketnum", (Object)trainticketnum);
                }
            }
        }
        Boolean confirmed_data_modified = TripSyncConfigUtil.getBoolean("confirmed_data_modified");
        if (!confirmed_data_modified.booleanValue() && "C".equalsIgnoreCase(checkingDynamic.getString("billstatus"))) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u7ed3\u7b97\u5355\u4fdd\u5b58,\u5df2\u5ba1\u6838\u7684\u7ed3\u7b97\u5355,\u4e0d\u518d\u91cd\u65b0\u63a5\u6536,\u7ed3\u7b97\u5355\u7f16\u53f7:" + checkingDynamic.getString("ordernum"));
            return;
        }
        checkingDynamic.set("modifier", (Object)userId);
        checkingDynamic.set("modifytime", (Object)now);
        TripFieldSetValueUtil.getInstance().HandleAllClassField(checkingDynamic, checkingBillModel, checkingModelClass);
        AbstractOrderModel.ProductType productType = checkingBillModel.getProductType();
        if (productType != null) {
            checkingDynamic.set("producttype", (Object)productType.getKey());
        }
        if ((operationType = checkingBillModel.getOperationType()) != null) {
            checkingDynamic.set("operationtype", (Object)operationType.getKey());
        }
        if (checkingBillModel.getOrderType() != null) {
            checkingDynamic.set("ordertype", (Object)checkingBillModel.getOrderType().getKey());
        }
        if (checkingBillModel.getOrderNatrue() != null) {
            checkingDynamic.set("isbusiness", (Object)checkingBillModel.getOrderNatrue().getKey());
        }
        checkingDynamic.set("formid", (Object)entityName.name());
        checkingDynamic.set("checkingbillnum", (Object)checkingBillModel.getCheckingbillnum());
        checkingDynamic.set("settlementamount", (Object)checkingBillModel.getTotalAmount());
        if (checkingBillModel.getHappendDate() != null) {
            checkingDynamic.set("period", (Object)new SimpleDateFormat("yyyy.MM").format(checkingBillModel.getHappendDate()));
        }
        Map<Object, Object> invoiceSetMap = Maps.newHashMapWithExpectedSize((int)16);
        if (operationType != null) {
            invoiceSetMap = TripCommonUtil.getInvoiceInfoByOperation(checkingBillModel.getServer(), operationType.getKey());
        }
        if (!invoiceSetMap.isEmpty()) {
            checkingDynamic.set("isdeductible", (Object)Boolean.valueOf((String)invoiceSetMap.get("isdeductible")));
        }
        if (this.existData.getInvoiceSetting() != null && this.existData.getInvoiceSetting().size() > 0) {
            Map<Object, List<Map>> invoiceSetting = this.existData.getInvoiceSetting().stream().collect(Collectors.groupingBy(v -> (String)v.get("operationtype")));
            List<Map<String, String>> invoiceSetByOperation = null;
            if (operationType != null) {
                invoiceSetByOperation = invoiceSetting.get(operationType.getKey());
            }
            if (invoiceSetByOperation != null && (!Supplier.CHAILVYIHAO.name().equals(checkingBillModel.getServer()) || Supplier.CHAILVYIHAO.name().equals(checkingBillModel.getServer()) && !TripSyncConfigUtil.getBoolean("ttrip_Price&Tax_Separated"))) {
                for (Map map : invoiceSetByOperation) {
                    BigDecimal amount;
                    BigDecimal deductrate = new BigDecimal(map.getOrDefault("deductrate", "0"));
                    if (BigDecimal.ZERO.compareTo(deductrate) >= 0) continue;
                    Serviceitem serviceItem = Serviceitem.getItem((String)map.get("serviceitem"));
                    if (Serviceitem.TICKET.equals(serviceItem) || Serviceitem.ITINERARY.equals(serviceItem)) {
                        amount = this.getAmount(checkingDynamic);
                        if (!Supplier.CHAILVYIHAO.name().equals(checkingBillModel.getServer())) {
                            if (Supplier.XIECHENG.name().equals(checkingBillModel.getServer()) && AbstractOrderModel.ProductType.B == checkingBillModel.getProductType() && ("er_traincheckingbill".equals(entityName.name()) || "er_planecheckingbill".equals(entityName.name()))) {
                                checkingDynamic.set("orderamounttax", (Object)BigDecimal.ZERO);
                            } else {
                                checkingDynamic.set("orderamounttax", (Object)amount.multiply(deductrate).divide(BigDecimal.ONE.add(deductrate), 2, RoundingMode.HALF_UP));
                            }
                        }
                        if (entityName.name().equals("er_vehiclecheckingbill") && checkingDynamic.getBigDecimal("orderamounttax").compareTo(BigDecimal.ZERO) == 0) {
                            checkingDynamic.set("orderdeductrate", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        checkingDynamic.set("orderdeductrate", (Object)deductrate.multiply(new BigDecimal(100)));
                        continue;
                    }
                    if (!Serviceitem.SERVICE.equals(serviceItem)) continue;
                    amount = checkingDynamic.getBigDecimal("servicefee");
                    checkingDynamic.set("serviceamounttax", (Object)amount.multiply(deductrate).divide(BigDecimal.ONE.add(deductrate), 2, RoundingMode.HALF_UP));
                    checkingDynamic.set("servicedeductrate", (Object)deductrate.multiply(new BigDecimal(100)));
                }
                this.calcCheckingTaxAndRate(checkingDynamic, checkingBillModel, invoiceSetByOperation);
                Object totalTax = this.getTotalTax(checkingDynamic);
                checkingDynamic.set("totaltax", totalTax);
            } else if (Supplier.CHAILVYIHAO.name().equals(checkingBillModel.getServer()) && TripSyncConfigUtil.getBoolean("ttrip_Price&Tax_Separated")) {
                checkingDynamic.set("orderamounttax", (Object)checkingBillModel.getServeOughtPayMoney());
                checkingDynamic.set("orderdeductrate", (Object)checkingBillModel.getReceiptMoneyTotal().multiply(new BigDecimal(100)).setScale(0, RoundingMode.DOWN));
                checkingDynamic.set("serviceamounttax", (Object)checkingBillModel.getServeReceiptMoney());
                checkingDynamic.set("servicedeductrate", (Object)checkingBillModel.getServeActualPayMoney().multiply(new BigDecimal(100)).setScale(0, RoundingMode.DOWN));
                Object totalTax = this.getTotalTax(checkingDynamic);
                checkingDynamic.set("totaltax", totalTax);
                if (totalTax instanceof BigDecimal && ((BigDecimal)totalTax).compareTo(BigDecimal.ZERO) > 0) {
                    checkingDynamic.set("isdeductible", (Object)true);
                } else {
                    checkingDynamic.set("isdeductible", (Object)false);
                }
            }
        }
        if (Supplier.CHAILVYIHAO.name().equalsIgnoreCase(checkingBillModel.getServer()) && TripSyncConfigUtil.getBoolean("ttrip_period_value", Boolean.TRUE).booleanValue()) {
            checkingDynamic.set("period", (Object)new SimpleDateFormat("yyyy.MM").format(checkingBillModel.getBillPeriod()));
        }
        this.handleOrderCurrency(checkingDynamic);
        this.handleIndividrualData(checkingBillModel, checkingDynamic);
        this.handleReqbillRelectedField(checkingDynamic, checkingBillModel);
        this.handleAllCheckingBill(checkingDynamic, checkingBillModel, orderNum);
    }

    protected abstract void calcCheckingTaxAndRate(DynamicObject var1, AbstractCheckingBillDetailModel var2, List<Map<String, String>> var3);

    private void handleReqbillRelectedField(DynamicObject checkingDynamic, AbstractCheckingBillDetailModel checkingBillModel) {
        String oabillnum = checkingDynamic.getString("oabillnum");
        DynamicObject reqObject = null;
        if (null != oabillnum && !oabillnum.trim().isEmpty() && (reqObject = this.existData.getReqbillMapping().get(oabillnum)) != null) {
            this.firstSetDept(checkingDynamic, checkingBillModel, reqObject);
            return;
        }
        DynamicObject dailyObject = null;
        if (null != oabillnum && !oabillnum.trim().isEmpty() && (dailyObject = this.existData.getDailyApplybillMapping().get(oabillnum)) != null) {
            this.firstSetDept(checkingDynamic, checkingBillModel, dailyObject);
            return;
        }
        DynamicObject vehicleObject = null;
        if (checkingDynamic.getDataEntityType().getName().equals("er_vehiclecheckingbill") && null != oabillnum && !oabillnum.trim().isEmpty() && (vehicleObject = this.existData.getDailyVehicleBillMapping().get(oabillnum)) != null) {
            this.firstSetDept(checkingDynamic, checkingBillModel, vehicleObject);
            return;
        }
        DynamicObject mealObject = null;
        if (checkingDynamic.getDataEntityType().getName().equals("er_mealcheckingbill") && null != oabillnum && !oabillnum.trim().isEmpty() && (mealObject = this.existData.getMealApplyBillMapping().get(oabillnum)) != null) {
            this.firstSetDept(checkingDynamic, checkingBillModel, mealObject);
            return;
        }
        if (!TripSyncConfigUtil.getBoolean("trip_sync_orderbill_isverify_mustinput")) {
            if (checkingDynamic.get("sourcebookedid") == null) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u7ed3\u7b97\u5355\u6ca1\u6709\u51fa\u5dee\u7533\u8bf7\u5355\u65f6,\u9884\u8ba2\u4eba\u4e3a\u7a7a.");
                return;
            }
            logger.info("sourcebookedid = {}", checkingDynamic.get("sourcebookedid"));
            this.firstSetDept(checkingDynamic, checkingBillModel, null);
        } else if (TripSyncConfigUtil.getBoolean("trip_sync_orderbill_isverify_mustinput") && !checkingDynamic.getDataEntityType().getName().equals("er_vehiclecheckingbill")) {
            String orderNum = checkingBillModel.getOrderNum();
            this.existData.checkingbillDetailMapping.remove(orderNum);
            this.existData.allCheckingBillDynamicMapping.remove(orderNum);
        }
    }

    private void firstSetDept(DynamicObject checkingDynamic, AbstractCheckingBillDetailModel checkingBillModel, DynamicObject dynamicObject) {
        String server = checkingBillModel.getServer();
        if (null != dynamicObject) {
            checkingDynamic.set("org", (Object)dynamicObject.getDynamicObject("org"));
            checkingDynamic.set("company", (Object)dynamicObject.getDynamicObject("company"));
            if (!Supplier.CHAILVYIHAO.name().equals(server) || checkingDynamic.get("settlemain") == null) {
                checkingDynamic.set("settlemain", dynamicObject.get("costcompany"));
            }
            if (!Supplier.CHAILVYIHAO.name().equals(server) || checkingDynamic.get("settledept") == null) {
                checkingDynamic.set("settledept", dynamicObject.get("costdept"));
            }
            if (checkingDynamic.containsProperty("std_costcenter") && checkingDynamic.get("std_costcenter") == null && null != dynamicObject) {
                checkingDynamic.set("std_costcenter", dynamicObject.get("std_costcenter"));
            }
            if (Supplier.CHAILVYIHAO.name().equals(server) && checkingBillModel.getSettledept() != null) {
                checkingDynamic.set("settledept", (Object)checkingBillModel.getSettledept());
            }
            if (Supplier.CHAILVYIHAO.name().equals(server) && checkingBillModel.getSettlemain() != null) {
                checkingDynamic.set("settlemain", (Object)checkingBillModel.getSettlemain());
            }
        } else {
            DynamicObject std_costcenter;
            Object settlemain;
            if (checkingBillModel.getSettledept() != null) {
                checkingDynamic.set("settledept", (Object)checkingBillModel.getSettledept());
            }
            if (checkingBillModel.getSettlemain() != null) {
                checkingDynamic.set("settlemain", (Object)checkingBillModel.getSettlemain());
            }
            Long bookerId = null;
            DynamicProperty bookerProp = checkingDynamic.getDynamicObjectType().getProperty("sourcebookedid");
            bookerId = bookerProp instanceof BasedataProp ? (checkingDynamic.get("sourcebookedid") instanceof Long ? Long.valueOf(checkingDynamic.getLong("sourcebookedid")) : ErCommonUtils.getPk(checkingDynamic.getDynamicObject("sourcebookedid"))) : Long.valueOf(checkingDynamic.getLong("sourcebookedid"));
            DynamicObject dept = this.getDept(bookerId);
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u8ba2\u5355\u8d39\u7528\u627f\u62c5\u90e8\u95e8 IS_MUST_SIGN dept\uff1a{}", (Object)dept);
            if (null == dept) {
                return;
            }
            checkingDynamic.set("org", (Object)dept);
            Map companyfromOrg = OrgUnitServiceHelper.getCompanyfromOrg((Object)dept.getPkValue());
            if (null != companyfromOrg && null == checkingDynamic.get("company")) {
                checkingDynamic.set("company", companyfromOrg.get("id"));
            }
            if (checkingDynamic.get("settledept") == null) {
                checkingDynamic.set("settledept", dept.getPkValue());
            }
            if ((settlemain = checkingDynamic.get("settlemain")) == null) {
                Long accountId = CoreBaseBillServiceHelper.getAccountOrgId((Long)dept.getPkValue(), true);
                checkingDynamic.set("settlemain", (Object)accountId);
            }
            if (checkingDynamic.get("std_costcenter") == null && null != (std_costcenter = ErCostCenterUtil.getCostCenterByCostDept((Long)dept.getPkValue()))) {
                checkingDynamic.set("std_costcenter", (Object)std_costcenter);
            }
            if (Supplier.XIECHENG.name().equalsIgnoreCase(checkingBillModel.getServer()) && settlemain != null) {
                Long pk;
                if (settlemain instanceof Long) {
                    checkingBillModel.setSettlemain(String.valueOf(settlemain));
                } else if (settlemain instanceof DynamicObject && (pk = ErCommonUtils.getPk(settlemain)) != null) {
                    checkingBillModel.setSettlemain(pk.toString());
                }
            }
        }
    }

    private BigDecimal getAmount(DynamicObject checkingDynamic) {
        BigDecimal totalAmount = checkingDynamic.getBigDecimal("totalamount") == null ? BigDecimal.ZERO : checkingDynamic.getBigDecimal("totalamount");
        BigDecimal servicefee = checkingDynamic.getBigDecimal("servicefee") == null ? BigDecimal.ZERO : checkingDynamic.getBigDecimal("servicefee");
        BigDecimal assuranceamount = BigDecimal.ZERO;
        if (checkingDynamic.getDynamicObjectType().getProperties().containsKey((Object)"assuranceamount")) {
            assuranceamount = checkingDynamic.getBigDecimal("assuranceamount");
        }
        if (checkingDynamic.get("operationtype").equals("4")) {
            BigDecimal airportprice = checkingDynamic.getBigDecimal("airportprice") == null ? BigDecimal.ZERO : checkingDynamic.getBigDecimal("airportprice");
            return totalAmount.subtract(servicefee).subtract(assuranceamount).subtract(airportprice);
        }
        if (checkingDynamic.get("operationtype").equals("2")) {
            BigDecimal ticketprice = checkingDynamic.getBigDecimal("ticketprice") == null ? BigDecimal.ZERO : checkingDynamic.getBigDecimal("ticketprice");
            BigDecimal fuelprice = checkingDynamic.getBigDecimal("fuelprice") == null ? BigDecimal.ZERO : checkingDynamic.getBigDecimal("fuelprice");
            return ticketprice.add(fuelprice);
        }
        if (checkingDynamic.get("operationtype").equals("6")) {
            BigDecimal ticketprice = checkingDynamic.getBigDecimal("ticketprice") == null ? BigDecimal.ZERO : checkingDynamic.getBigDecimal("ticketprice");
            BigDecimal personalfee = checkingDynamic.getBigDecimal("personalfee") == null ? BigDecimal.ZERO : checkingDynamic.getBigDecimal("personalfee");
            return ticketprice.subtract(personalfee);
        }
        return totalAmount.subtract(servicefee).subtract(assuranceamount);
    }

    private Object getTotalTax(DynamicObject orderDynamic) {
        BigDecimal orderamounttax = orderDynamic.getBigDecimal("orderamounttax");
        BigDecimal serviceamounttax = orderDynamic.getBigDecimal("serviceamounttax");
        if (orderamounttax == null) {
            orderamounttax = BigDecimal.ZERO;
        }
        if (serviceamounttax == null) {
            serviceamounttax = BigDecimal.ZERO;
        }
        return orderamounttax.add(serviceamounttax);
    }

    protected abstract void handleIndividrualData(AbstractCheckingBillDetailModel var1, DynamicObject var2);

    private void handleAllCheckingBill(DynamicObject checkingDetailDynamic, AbstractCheckingBillDetailModel checkingBillModel, String orderNum) throws TripException {
        DynamicObject allCheckingbillDynamic;
        if (this.allCheckDao == null) {
            this.allCheckDao = ErDaoFactory.getInstance("er_allcheckingbill");
        }
        if ((allCheckingbillDynamic = this.existData.allCheckingBillDynamicMapping.get(orderNum)) == null) {
            allCheckingbillDynamic = this.allCheckDao.getEmptyDynamicObject();
            this.existData.allCheckingBillDynamicMapping.put(orderNum, allCheckingbillDynamic);
        }
        DynamicObjectType dynamicObjectType = checkingDetailDynamic.getDynamicObjectType();
        String formID = dynamicObjectType.getName();
        Long checkingDetailId = (Long)checkingDetailDynamic.getPkValue();
        if (checkingDetailId == null || checkingDetailId == 0L) {
            int index = this.existData.idIndexMap.get(formID);
            Long id = this.existData.idsMap.get(formID)[index];
            this.existData.idIndexMap.put(formID, ++index);
            checkingDetailDynamic.set("id", (Object)id);
            checkingDetailId = id;
        }
        DataEntityPropertyCollection orderProperties = dynamicObjectType.getProperties();
        DataEntityPropertyCollection allOrderProperties = allCheckingbillDynamic.getDynamicObjectType().getProperties();
        for (IDataEntityProperty orderProperty : orderProperties) {
            String orderPropName = orderProperty.getName();
            if ("id".equals(orderPropName) || allOrderProperties.get((Object)orderPropName) == null) continue;
            Object tempValue = checkingDetailDynamic.get(orderPropName);
            allCheckingbillDynamic.set(orderPropName, tempValue);
        }
        allCheckingbillDynamic.set("checkingformid", (Object)formID);
        allCheckingbillDynamic.set("checkingid", (Object)checkingDetailId);
        allCheckingbillDynamic.set("uniqueid", (Object)checkingBillModel.getUniqueId());
    }

    private void handleOrderCurrency(DynamicObject orderDynamic) {
        Object o = ActionLocalCache.get().get("AbstractCheckingDetailDao.currency", "currency", () -> {
            String server = orderDynamic.getString("server");
            DynamicObject erBizInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)"id, checkingcurrency", (QFilter[])new QFilter("number", "=", (Object)server).toArray());
            if (erBizInfo == null) {
                return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1L)});
            }
            return erBizInfo.getDynamicObject("checkingcurrency");
        });
        orderDynamic.set("currency", o == null ? BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1L)}) : o);
    }

    protected DynamicObject getDept(Long travelUserId) {
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(travelUserId);
        if (userMap != null && userMap.size() > 0) {
            DynamicObject dept = (DynamicObject)userMap.get("org");
            return dept;
        }
        return null;
    }

    protected void handleAccountOrg(DynamicObject travelUser, DynamicObject orderDynamic) {
        String oabillnum = orderDynamic.getString("oabillnum");
        DynamicObject reqObject = this.existData.getReqbillMapping().get(oabillnum);
        DynamicObject dept = this.getDept((Long)travelUser.getPkValue());
        if (null != dept && reqObject == null && orderDynamic.get("settledept") == null) {
            orderDynamic.set("settledept", dept.getPkValue());
        }
        if (null != dept && reqObject == null && orderDynamic.get("settlemain") == null) {
            Long accountId = CoreBaseBillServiceHelper.getAccountOrgId((Long)dept.getPkValue(), true);
            orderDynamic.set("settlemain", (Object)accountId);
        }
        if (reqObject == null && orderDynamic.get("std_costcenter") == null && dept != null) {
            DynamicObject std_costcenter = ErCostCenterUtil.getCostCenterByCostDept((Long)dept.getPkValue());
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u6ca1\u6709\u51fa\u5dee\u7533\u8bf7\u5355\uff0c\u4e14\u6210\u672c\u4e2d\u5fc3\u4e3a\u7a7a\uff0c\u5219\u4f18\u5148\u53d6\u4e58\u673a\u4eba\u6240\u5728\u90e8\u95e8\u6838\u7b97\u4e3b\u4f53 {}", orderDynamic.get("std_costcenter"));
            if (null != std_costcenter) {
                orderDynamic.set("std_costcenter", (Object)std_costcenter);
            }
        }
    }

    private boolean judgeOrder(DynamicObject checkingDynamic) {
        DynamicObjectType dynamicObjectType = checkingDynamic.getDynamicObjectType();
        String formID = dynamicObjectType.getName();
        if (StringUtils.isNotEmpty((String)formID) && !"er_vehiclecheckingbill".equalsIgnoreCase(formID)) {
            return true;
        }
        Map<String, DynamicObject> allOrders = this.existData.allOrderBillMapping;
        DynamicObject allOrder = allOrders.get(checkingDynamic.getString("ordernum"));
        if (allOrder == null) {
            return true;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"er_allorderbill", (String)"orderid,ordernum", (QFilter[])new QFilter[]{new QFilter("id", "=", allOrder.getPkValue())});
        if (dynamicObject == null) {
            return true;
        }
        DynamicObject vehicleBill = QueryServiceHelper.queryOne((String)"er_vehiclebill", (String)"orderstatus,id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getLong("orderid"))});
        if (vehicleBill == null) {
            return true;
        }
        String orderStatus = vehicleBill.getString("orderstatus");
        return !VehicleOrderModel.OrderStatus.F.getKey().equalsIgnoreCase(orderStatus);
    }
}

