/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.trip.annotation.KDTripEntity;
import kd.fi.er.business.trip.dao.IDataHandleDao;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.CheckingBillExistDataModel;
import kd.fi.er.business.trip.model.CheckingBillHeaderModel;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.trip.model.IDataModel;
import kd.fi.er.business.trip.util.TripFieldSetValueUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import org.apache.commons.lang3.StringUtils;

public class CheckingBillHeaderDao
implements IDataHandleDao {
    private static final Log logger = LogFactory.getLog(CheckingBillHeaderDao.class);
    private CheckingBillExistDataModel existData;
    private IErDao checingHeaderDao;

    @Override
    public void generateData(IDataModel dataModel) throws TripException {
        CheckingBillHeaderModel headerModel = (CheckingBillHeaderModel)dataModel;
        Class<?> checkingModelClass = headerModel.getClass();
        KDTripEntity entityName = checkingModelClass.getAnnotation(KDTripEntity.class);
        if (this.checingHeaderDao == null) {
            this.checingHeaderDao = ErDaoFactory.getInstance(entityName.name());
        }
        DynamicObject checkingDynamic = this.existData.checkingbill.get(headerModel.getBillNo());
        Date now = new Date();
        String userId = RequestContext.get().getUserId();
        String billstatusname = null;
        String settlemain = headerModel.getSettlemain();
        if (checkingDynamic == null) {
            checkingDynamic = this.checingHeaderDao.getEmptyDynamicObject();
            checkingDynamic.set("creator", (Object)userId);
            checkingDynamic.set("createtime", (Object)now);
            this.existData.checkingbill.put(headerModel.getBillNo(), checkingDynamic);
        } else {
            billstatusname = checkingDynamic.getString("billstatusname");
        }
        Boolean confirmed_data_modified = TripSyncConfigUtil.getBoolean("confirmed_data_modified");
        Boolean isDeleteEntry = (Boolean)ActionLocalCache.get().getDefaultIfNull("isJsonData", false);
        if (isDeleteEntry.booleanValue()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u7ed3\u7b97\u5355\u4fdd\u5b58,\u5546\u65c5\u96c6\u6210\u6d4b\u8bd5\u5bfc\u5165\u7684\u6708\u7ed3\u8d26\u5355,\u4e0d\u518d\u91cd\u65b0\u63a5\u6536,\u6708\u7ed3\u8d26\u5355\u7f16\u53f7:" + checkingDynamic.getString("billnum"));
            return;
        }
        if (!confirmed_data_modified.booleanValue() && ("2".equalsIgnoreCase(checkingDynamic.getString("billstatusname")) || "3".equalsIgnoreCase(checkingDynamic.getString("billstatusname")))) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u7ed3\u7b97\u5355\u4fdd\u5b58,\u5df2\u5ba1\u6838\u6216\u5df2\u786e\u8ba4\u7684\u6708\u7ed3\u8d26\u5355,\u4e0d\u518d\u91cd\u65b0\u63a5\u6536,\u6708\u7ed3\u8d26\u5355\u7f16\u53f7:" + checkingDynamic.getString("billnum"));
            return;
        }
        checkingDynamic.set("modifier", (Object)userId);
        checkingDynamic.set("modifytime", (Object)now);
        TripFieldSetValueUtil.getInstance().HandleAllClassField(checkingDynamic, headerModel, checkingModelClass);
        if (null != billstatusname) {
            checkingDynamic.set("billstatusname", (Object)billstatusname);
        }
        checkingDynamic.set("operationtype", (Object)(null == headerModel.getOperationType() ? AbstractOrderModel.OperationType.C.getKey() : headerModel.getOperationType().getKey()));
        checkingDynamic.set("billnum", (Object)headerModel.getBillNo());
        if (StringUtils.isNotEmpty((CharSequence)settlemain)) {
            checkingDynamic.set("settlemain", (Object)Long.parseLong(settlemain));
            checkingDynamic.set("settlemain_id", (Object)Long.parseLong(settlemain));
        } else {
            checkingDynamic.set("settlemain", (Object)0L);
            checkingDynamic.set("settlemain_id", (Object)0L);
        }
        if (this.existData.getReqbillMapping() != null && this.existData.getReqbillMapping().size() > 0) {
            DynamicObject request = this.existData.getReqbillMapping().values().toArray(new DynamicObject[0])[0];
            checkingDynamic.set("currency", request.get("currency"));
        }
    }

    @Override
    public void setExistDataModel(ExistDataModel existModel) {
        this.existData = (CheckingBillExistDataModel)existModel;
    }
}

