/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.dao.AbstractCheckingDetailDao;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.HotelCheckingBillDetailModel;
import kd.fi.er.business.trip.supplier.Supplier;
import org.apache.commons.lang3.StringUtils;

public class HotelCheckingDetailDao
extends AbstractCheckingDetailDao {
    @Override
    protected void calcCheckingTaxAndRate(DynamicObject checkingDynamic, AbstractCheckingBillDetailModel checkingBillModel, List<Map<String, String>> invoiceSetByOperation) {
        if (checkingBillModel == null || checkingDynamic == null) {
            return;
        }
        if (!Supplier.XIECHENG.name().equals(checkingBillModel.getServer())) {
            return;
        }
        boolean b = invoiceSetByOperation.stream().anyMatch(obj -> StringUtils.isEmpty((CharSequence)((CharSequence)obj.get("operationtype"))) || !((String)obj.get("operationtype")).equals("1"));
        if (b) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)Supplier.XIECHENG.name())});
        String billingAndTax = dynamicObject.getString("billingandtax");
        if (StringUtils.isEmpty((CharSequence)billingAndTax) || "0".equals(billingAndTax)) {
            return;
        }
        if ("1".equals(billingAndTax)) {
            int priceBillingType = checkingDynamic.getInt("pricebillingtype");
            switch (priceBillingType) {
                case 1: 
                case 9999: {
                    checkingDynamic.set("orderamounttax", (Object)BigDecimal.ZERO);
                    checkingDynamic.set("orderdeductrate", (Object)BigDecimal.ZERO);
                    break;
                }
                case 2: {
                    List specialInvoiceList = invoiceSetByOperation.stream().filter(invoiceSet -> StringUtils.equalsAny((CharSequence)((CharSequence)invoiceSet.get("invoicetype")), (CharSequence[])new CharSequence[]{"1", "6"}) && Serviceitem.TICKET.equals(Serviceitem.getItem((String)invoiceSet.get("serviceitem")))).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(specialInvoiceList)) {
                        checkingDynamic.set("orderamounttax", (Object)BigDecimal.ZERO);
                        checkingDynamic.set("orderdeductrate", (Object)BigDecimal.ZERO);
                        break;
                    }
                    Map invoiceSet2 = (Map)specialInvoiceList.get(0);
                    BigDecimal deductrate = new BigDecimal(invoiceSet2.getOrDefault("deductrate", "0"));
                    if (BigDecimal.ZERO.compareTo(deductrate) >= 0) break;
                    BigDecimal totalAmount = checkingDynamic.getBigDecimal("totalamount");
                    totalAmount = totalAmount == null ? BigDecimal.ZERO : totalAmount;
                    BigDecimal serviceFee = checkingDynamic.getBigDecimal("servicefee");
                    serviceFee = serviceFee == null ? BigDecimal.ZERO : serviceFee;
                    BigDecimal assuranceamount = BigDecimal.ZERO;
                    if (checkingDynamic.getDynamicObjectType().getProperties().containsKey((Object)"assuranceamount")) {
                        assuranceamount = checkingDynamic.getBigDecimal("assuranceamount");
                    }
                    BigDecimal amount = totalAmount.subtract(serviceFee).subtract(assuranceamount);
                    checkingDynamic.set("orderamounttax", (Object)amount.multiply(deductrate).divide(BigDecimal.ONE.add(deductrate), 2, RoundingMode.HALF_UP));
                    checkingDynamic.set("orderdeductrate", (Object)deductrate.multiply(new BigDecimal(100)));
                }
            }
        }
    }

    @Override
    protected void handleIndividrualData(AbstractCheckingBillDetailModel checkingModel, DynamicObject checkingDynamic) {
        DynamicObject travelUser;
        DynamicObject sourceUser;
        HotelCheckingBillDetailModel model = (HotelCheckingBillDetailModel)checkingModel;
        String oabillnum = model.getOaBillNum();
        DynamicObject reqBillDynamicObject = this.existData.getReqbillMapping().get(oabillnum);
        DynamicObject dailyApplyBillDynamicObject = this.existData.getDailyApplybillMapping().get(oabillnum);
        if (null != reqBillDynamicObject) {
            checkingDynamic.set("oabillformid", (Object)"er_tripreqbill");
        }
        if (null != dailyApplyBillDynamicObject) {
            checkingDynamic.set("oabillformid", (Object)"er_dailyapplybill");
        }
        if ((sourceUser = this.existData.getUserMapping().get(model.getSourceBookedId())) != null) {
            checkingDynamic.set("sourcebookedid", sourceUser.getPkValue());
        }
        if ((travelUser = this.existData.getTravelerMapping().get(model.getSourcetravelerid())) == null) {
            travelUser = this.existData.getUserMapping().get(model.getSourcetravelerid());
        }
        if (travelUser != null) {
            checkingDynamic.set("sourcetravelerid", travelUser.getPkValue());
            this.handleAccountOrg(travelUser, checkingDynamic);
        }
        checkingDynamic.set("orderstatus", (Object)model.getOrderStatus().getKey());
        checkingDynamic.set("ordersort", (Object)model.getOrderSort().getKey());
    }
}

