/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.dao.AbstractCheckingDetailDao;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.MealCheckingBillDetailModel;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang.StringUtils;

public class MealCheckingDetailDao
extends AbstractCheckingDetailDao {
    private static final Log logger = LogFactory.getLog(MealCheckingDetailDao.class);

    @Override
    protected void calcCheckingTaxAndRate(DynamicObject checkingDynamic, AbstractCheckingBillDetailModel checkingBillModel, List<Map<String, String>> invoiceSetByOperation) {
    }

    @Override
    protected void handleIndividrualData(AbstractCheckingBillDetailModel checkingModel, DynamicObject checkingDynamic) {
        MealCheckingBillDetailModel model = (MealCheckingBillDetailModel)checkingModel;
        DynamicObject sourceUser = this.existData.getUserMapping().get(model.getSourceBookedId());
        if (sourceUser != null) {
            checkingDynamic.set("sourcebookedid", sourceUser.getPkValue());
        }
        checkingDynamic.set("orderstatus", (Object)model.getOrderStatus().getKey());
        checkingDynamic.set("ordersort", (Object)AbstractOrderModel.OrderSort.A.getKey());
        String oaBillNum = checkingModel.getOaBillNum();
        if (!StringUtils.isBlank((String)oaBillNum)) {
            DynamicObject mealApplyBill = this.existData.getMealApplyBillMapping().get(oaBillNum);
            DynamicObject reqBillApplyBill = this.existData.getReqbillMapping().get(oaBillNum);
            DynamicObject dailyApplyBillDynamicObject = this.existData.getDailyApplybillMapping().get(oaBillNum);
            if (null != mealApplyBill) {
                checkingDynamic.set("dinnerscene", (Object)mealApplyBill.getString("dinnerscene"));
                checkingDynamic.set("oabillformid", (Object)"er_mealapplication_bill");
            } else if (reqBillApplyBill != null) {
                checkingDynamic.set("dinnerscene", (Object)"3");
                checkingDynamic.set("oabillformid", (Object)"er_tripreqbill");
            } else if (dailyApplyBillDynamicObject != null) {
                String dinnerscene = TripCommonUtil.getReimburseType(dailyApplyBillDynamicObject.getString("reimbursetype"));
                dinnerscene = StringUtils.isBlank((String)dinnerscene) ? "9" : dinnerscene;
                checkingDynamic.set("dinnerscene", (Object)dinnerscene);
                checkingDynamic.set("oabillformid", (Object)"er_dailyapplybill");
            }
        } else {
            checkingDynamic.set("dinnerscene", (Object)"9");
        }
    }
}

