/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.fileservice.ErFileServiceHelper;
import kd.fi.er.business.trip.dao.AbstractOrderDao;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.IDataModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import org.apache.commons.lang.StringUtils;

public class PlaneOrderDao
extends AbstractOrderDao {
    private static final Log logger = LogFactory.getLog(PlaneOrderDao.class);

    @Override
    public void generateData(IDataModel dataModel) throws TripException {
        super.generateData(dataModel);
        PlaneOrderModel orderModel = (PlaneOrderModel)dataModel;
        if (!Supplier.ZHONGXING.name().equalsIgnoreCase(orderModel.getServer())) {
            this.handleCheckingOrderStatus(orderModel, orderModel.getOrderNum());
        }
    }

    @Override
    protected void handleIndividrualData(AbstractOrderModel orderModel, DynamicObject orderDynamic) {
        DynamicObject travelUser;
        PlaneOrderModel planeOrderModel = (PlaneOrderModel)orderModel;
        String oabillnum = planeOrderModel.getOaBillNum();
        DynamicObject reqBillDynamicObject = this.existData.getReqbillMapping().get(oabillnum);
        DynamicObject dailyApplyBillDynamicObject = this.existData.getDailyApplybillMapping().get(oabillnum);
        if (null != reqBillDynamicObject) {
            orderDynamic.set("oabillformid", (Object)"er_tripreqbill");
        }
        if (null != dailyApplyBillDynamicObject) {
            orderDynamic.set("oabillformid", (Object)"er_dailyapplybill");
        }
        String ticketStatus = orderDynamic.getString("ticketstatus");
        DynamicObject sourceUser = this.existData.getUserMapping().get(planeOrderModel.getSourceBookedId());
        if (sourceUser != null) {
            orderDynamic.set("sourcebookedid", sourceUser.getPkValue());
        }
        if ((travelUser = this.existData.getTravelerMapping().get(planeOrderModel.getSourcetravelerid())) == null) {
            travelUser = this.existData.getUserMapping().get(planeOrderModel.getSourcetravelerid());
        }
        if (travelUser != null) {
            orderDynamic.set("sourcetravelerid", travelUser.getPkValue());
            orderDynamic.set("travelerdept", (Object)this.getDept((Long)travelUser.getPkValue()));
            this.handleAccountOrg(travelUser, orderDynamic);
        }
        orderDynamic.set("orderstatus", (Object)planeOrderModel.getOrderStatus().getKey());
        orderDynamic.set("ticketstatus", (Object)planeOrderModel.getTicketStatus().getKey());
        orderDynamic.set("ordersort", (Object)planeOrderModel.getOrderSort().getKey());
        if (!StringUtils.isEmpty((String)ticketStatus) && !"UNUSED".equals(ticketStatus) && Supplier.ZHONGXING.name().equalsIgnoreCase(orderModel.getServer())) {
            orderDynamic.set("ticketstatus", (Object)ticketStatus);
        }
        if (null != planeOrderModel.getDownloadlink() && !planeOrderModel.getDownloadlink().trim().isEmpty() && (null == orderDynamic.getString("kddownloadlink") || orderDynamic.getString("kddownloadlink").trim().isEmpty())) {
            String type = "pdf";
            String tempSuffixes = "jpeg|jpg|png|pdf|gif|ofd";
            Pattern pat = Pattern.compile("[\\w]+[\\.](" + tempSuffixes + ")");
            String ownloadlink = planeOrderModel.getDownloadlink();
            orderDynamic.set("downloadlink", (Object)ownloadlink);
            Matcher mc = pat.matcher(ownloadlink);
            while (mc.find()) {
                String name = mc.group();
                logger.info("ErFileServiceHelper_uploadFile>>> matchname{}", (Object)name);
                type = name.substring(name.lastIndexOf(".") + 1);
            }
            String path = ErFileServiceHelper.uploadFile(ownloadlink, this.existData.getServer() + "_" + planeOrderModel.getOrderNum() + "." + type, "/trip/plane/");
            logger.info("\u5546\u65c5\u96c6\u6210\uff0ckddownloadlink:{}", (Object)path);
            orderDynamic.set("kddownloadlink", (Object)path);
        }
    }

    protected void handleCheckingOrderStatus(AbstractOrderModel orderModel, String orderNum) {
        DynamicObject checkingOrder;
        if (this.existData.getCheckingOrderMapping() != null && (checkingOrder = this.existData.getCheckingOrderMapping().get(orderNum)) != null) {
            PlaneOrderModel planeOrderModel = (PlaneOrderModel)orderModel;
            String ticketstatus = null;
            if (!Supplier.XIECHENG.name().equalsIgnoreCase(orderModel.getServer()) || planeOrderModel.getTotalAmount().compareTo(ConvertUtil.getOrderAmountInit()) == 0) {
                ticketstatus = planeOrderModel.getTicketStatus().getKey();
                checkingOrder.set("ticketstatus", (Object)ticketstatus);
            }
            String itinerarynum = planeOrderModel.getItinerarynum();
            Date itinerarydate = planeOrderModel.getItinerarydate();
            String downloadlink = planeOrderModel.getDownloadlink();
            logger.info("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u4fdd\u5b58,handleCheckingOrderStatus ticketstatus:" + ticketstatus + "_orderNum:" + orderNum + "_itinerarynum:" + itinerarynum + "_itinerarydate:" + itinerarydate);
            checkingOrder.set("itinerarynum", (Object)itinerarynum);
            checkingOrder.set("itinerarydate", (Object)itinerarydate);
            checkingOrder.set("downloadlink", (Object)downloadlink);
        }
    }
}

