/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.dao.IErTripReqBillDao;
import kd.fi.er.business.dao.factory.ErTripReqBillDaoFactory;
import kd.fi.er.business.trip.model.JourneyModel;
import kd.fi.er.business.trip.model.MulwaytoModel;
import kd.fi.er.business.trip.model.TripReqbillModel;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang3.StringUtils;

public class TripReqbillDao {
    private static final Log logger = LogFactory.getLog(TripReqbillDao.class);

    public TripReqbillModel getTripReqbillByPk(Object pk) {
        IErTripReqBillDao billDao = ErTripReqBillDaoFactory.getInstance();
        DynamicObject reqbill = billDao.queryOne("tripentry.mulwayto,billno, applier.id,org,company,costcompany,costdept,applier.number, applier.name,applier.phone,auditor.number,auditor.name,creator.number,creator.name,description,currency,tripentry,tripentry.from, tripentry.to, tripentry.startdate, tripentry.enddate, tripentry.vehicle, tripentry.vehicles, tripentry.travelers,createtime,routetype", pk);
        if (reqbill == null) {
            logger.info("\u51fa\u5dee\u7533\u8bf7\u5355\u4e0d\u5b58\u5728:" + pk);
            return null;
        }
        TripReqbillModel reqbillModel = new TripReqbillModel();
        reqbillModel.setPk(Long.valueOf(pk + ""));
        reqbillModel.setBillNo(reqbill.getString("billno"));
        reqbillModel.setDesc(reqbill.getString("description"));
        DynamicObject applierDynamic = reqbill.getDynamicObject("applier");
        DynamicObject auditorDynamic = reqbill.getDynamicObject("auditor");
        DynamicObject creatorDynamic = reqbill.getDynamicObject("creator");
        DynamicObject costdeptDynamic = reqbill.getDynamicObject("costdept");
        reqbillModel.setApplyEmpNum(applierDynamic.getString("number"));
        reqbillModel.setApplyEmpName(applierDynamic.getString("name"));
        reqbillModel.setApplyEmpPhone(applierDynamic.getString("phone"));
        reqbillModel.setCurrency(reqbill.getDynamicObject("currency").getString("number"));
        reqbillModel.setCostCompany(reqbill.getDynamicObject("costcompany").getString("name"));
        reqbillModel.setCostCompanyNum(reqbill.getDynamicObject("costcompany").getString("number"));
        reqbillModel.setCostCompanyId(reqbill.getDynamicObject("costcompany").getLong("id"));
        reqbillModel.setCostdept(costdeptDynamic.getString("name"));
        reqbillModel.setCostdeptNum(costdeptDynamic.getString("number"));
        reqbillModel.setCostdeptId((Long)costdeptDynamic.getPkValue());
        reqbillModel.setCompany(reqbill.getDynamicObject("company").getString("name"));
        reqbillModel.setCompanyNum(reqbill.getDynamicObject("company").getString("number"));
        reqbillModel.setCompanyId(reqbill.getDynamicObject("company").getLong("id"));
        reqbillModel.setDept(reqbill.getDynamicObject("org").getString("name"));
        reqbillModel.setDeptNum(reqbill.getDynamicObject("org").getString("number"));
        reqbillModel.setDeptId(reqbill.getDynamicObject("org").getLong("id"));
        reqbillModel.setCreatEmpNum(creatorDynamic.getString("number"));
        reqbillModel.setCreatEmpName(creatorDynamic.getString("name"));
        reqbillModel.setCreatetime(reqbill.getDate("createtime"));
        reqbillModel.setRoutetype(reqbill.getString("routetype"));
        if (auditorDynamic != null) {
            reqbillModel.setAduitEmpNum(auditorDynamic.getString("number"));
            reqbillModel.setAduitEmpName(auditorDynamic.getString("name"));
        } else {
            reqbillModel.setAduitEmpNum(applierDynamic.getString("number"));
            reqbillModel.setAduitEmpName(applierDynamic.getString("name"));
        }
        Boolean ispasswaypush = TripSyncConfigUtil.getBoolean("ctrip_PassWay_Push");
        DynamicObjectCollection tripentry = reqbill.getDynamicObjectCollection("tripentry");
        ArrayList<JourneyModel> journeyList = new ArrayList<JourneyModel>();
        if (tripentry != null) {
            journeyList = new ArrayList(tripentry.size() * 10);
            int seqNo = 0;
            for (int i = 0; i < tripentry.size(); ++i) {
                DynamicObject trip = (DynamicObject)tripentry.get(i);
                JourneyModel journey = new JourneyModel();
                journey.setSeqNo(++seqNo);
                journey.setFromCity(trip.getDynamicObject("from").getString("name"));
                journey.setToCity(trip.getDynamicObject("to").getString("name"));
                journey.setFromCityID(trip.getDynamicObject("from").getLong("id"));
                journey.setToCityID(trip.getDynamicObject("to").getLong("id"));
                String vehicles = trip.getString("vehicles");
                List collect = Arrays.stream(vehicles.split(",")).filter(StringUtils::isNotBlank).map(Integer::parseInt).sorted().collect(Collectors.toList());
                String vehicle = ((Integer)collect.get(0)).toString();
                journey.setTrafficTool(vehicle);
                HashSet<DynamicObject> travelers = new HashSet<DynamicObject>();
                DynamicObjectCollection travelersDyn = trip.getDynamicObjectCollection("travelers");
                if (travelersDyn != null && travelersDyn.size() > 0) {
                    travelersDyn.forEach(v -> travelers.add(v.getDynamicObject("fbasedataid")));
                }
                journey.setTravelers(travelers);
                Date startDate = trip.getDate("startdate");
                Date endDate = trip.getDate("enddate");
                journey.setStartDate(startDate);
                journey.setEndDate(endDate);
                journeyList.add(journey);
                DynamicObjectCollection mulwaytos = trip.getDynamicObjectCollection("mulwayto");
                if (null == mulwaytos || mulwaytos.size() <= 0 || !ispasswaypush.booleanValue()) continue;
                HashSet<MulwaytoModel> mulwaytoList = new HashSet<MulwaytoModel>(mulwaytos.size());
                int mseqNo = 0;
                for (DynamicObject mulwayto : mulwaytos) {
                    MulwaytoModel journeyMulwayto = new MulwaytoModel();
                    journeyMulwayto.setTrafficTool(vehicle);
                    journeyMulwayto.setStartDate(startDate);
                    journeyMulwayto.setEndDate(endDate);
                    journeyMulwayto.setTravelers(travelers);
                    journeyMulwayto.setSeqNo(++mseqNo);
                    journeyMulwayto.setFromCity(journey.getToCity());
                    journeyMulwayto.setToCity(mulwayto.getDynamicObject("fbasedataid").getString("name"));
                    journeyMulwayto.setFromCityID(journey.getToCityID());
                    journeyMulwayto.setToCityID(mulwayto.getDynamicObject("fbasedataid").getLong("id"));
                    mulwaytoList.add(journeyMulwayto);
                }
                journey.setMulwaytos(mulwaytoList);
            }
        }
        reqbillModel.setJourneyModelList(journeyList);
        return reqbillModel;
    }
}

