/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.iscadmin;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.model.TripType;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.StringUtils;

public class TripSyncPullSelPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TripSyncPullSelPlugin.class);
    SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd");
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams || customParams.isEmpty()) {
            return;
        }
        if (null != customParams.get("number")) {
            model.setValue("number", customParams.get("number"));
        }
        if (null != customParams.get("opcode")) {
            model.setValue("opcode", customParams.get("opcode"));
            if (Supplier.GAODE.name().equals(customParams.get("number").toString())) {
                model.setValue("type", (Object)"CAR");
                model.setValue("type1", (Object)"CAR");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        if (key.equals(BTN_OK)) {
            String number = model.getDataEntity(true).getString("number");
            String service = TripCommonUtil.getStandtripname().get(number);
            ITripService tripService = TripServiceFactory.getTripService(service);
            String opcode = model.getDataEntity(true).getString("opcode");
            String type = model.getDataEntity(true).getString("type");
            String type1 = model.getDataEntity(true).getString("type1");
            Date startdate = model.getDataEntity(true).getDate("startdate");
            Date enddate = model.getDataEntity(true).getDate("enddate");
            String ordernums = model.getDataEntity(true).getString("ordernums");
            String reqnums = model.getDataEntity(true).getString("reqnums");
            String mealnums = model.getDataEntity(true).getString("mealnums");
            String checkingbillnums = model.getDataEntity(true).getString("checkingbillnums");
            Tab tab = (Tab)this.getControl("tabap");
            String tabkey = tab.getCurrentTab();
            Boolean success = false;
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5de5\u5177\uff0c\u9875\u7b7e\uff1a{} \uff0c\u64cd\u4f5c\uff1a{}", (Object)tabkey, (Object)opcode);
            switch (tabkey) {
                case "datetab": {
                    success = this.syncByDate(tripService, opcode, type, startdate, enddate, number);
                    break;
                }
                case "ordernumtab": {
                    success = this.syncByordernum(tripService, opcode, type1, ordernums);
                    break;
                }
                case "reqnumtab": {
                    success = this.syncByreq(tripService, type, opcode, reqnums);
                    break;
                }
                case "checkingbillnumtab": {
                    success = this.syncBycheckingbillnum(tripService, opcode, type, checkingbillnums);
                    break;
                }
                case "mealnumtab": {
                    success = this.syncByMeal(tripService, type, opcode, mealnums);
                }
            }
            if (success.booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u6839\u636e\u5546\u65c5\u96c6\u6210\u65e5\u5fd7\u786e\u8ba4\u6700\u7ec8\u7ed3\u679c\u3002", (String)"TripSyncPullSelPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
            return;
        }
    }

    private Boolean syncBycheckingbillnum(ITripService tripService, String opcode, String type, String checkingbillnums) {
        if (null == type) {
            type = "PLANE";
        }
        if (null == checkingbillnums) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6279\u6b21\u53f7\u3002", (String)"TripSyncPullSelPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (checkingbillnums.split(",").length > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\u3002", (String)"TripSyncPullSelPlugin_2", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        block8: for (String checkingbillnum : checkingbillnums.split(",")) {
            params.put("checkingbillnum", checkingbillnum);
            switch (opcode) {
                case "orderupdate": {
                    if (this.syncorderupdate(tripService, type, params).booleanValue()) continue block8;
                    return Boolean.FALSE;
                }
                case "checking": {
                    if (this.syncchecking(tripService, type, params).booleanValue()) continue block8;
                    return Boolean.FALSE;
                }
            }
        }
        return Boolean.TRUE;
    }

    private Boolean syncByreq(ITripService tripService, String type, String opcode, String reqnums) {
        if (null == type) {
            type = "PLANE";
        }
        if (null == reqnums) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u51fa\u5dee\u7533\u8bf7\u5355\u53f7\u3002", (String)"TripSyncPullSelPlugin_3", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (reqnums.split(",").length > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u53f7\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\u3002", (String)"TripSyncPullSelPlugin_4", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        block8: for (String req : reqnums.split(",")) {
            params.put("reqnum", req);
            QFilter qFilter = new QFilter("billno", "=", (Object)req);
            DynamicObject bill = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (null == bill) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u540c\u6b65\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"TripSyncPullSelPlugin_5", (String)"fi-er-business", (Object[])new Object[0]), req));
                continue;
            }
            switch (opcode) {
                case "order": {
                    if (this.syncorder(tripService, type, params).booleanValue()) continue block8;
                    return Boolean.FALSE;
                }
                case "orderupdate": {
                    if (this.syncorderupdate(tripService, type, params).booleanValue()) continue block8;
                    return Boolean.FALSE;
                }
            }
        }
        return Boolean.TRUE;
    }

    private Boolean syncByMeal(ITripService tripService, String type, String opcode, String mealNums) {
        if (null == mealNums) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7528\u9910\u7533\u8bf7\u5355\u53f7\u3002", (String)"TripSyncPullSelPlugin_8", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (mealNums.split(",").length > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u53f7\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\u3002", (String)"TripSyncPullSelPlugin_4", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        for (String meal : mealNums.split(",")) {
            params.put("mealNum", meal);
            QFilter qFilter = new QFilter("billno", "=", (Object)meal);
            DynamicObject bill = QueryServiceHelper.queryOne((String)"er_mealapplication_bill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (null == bill) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u540c\u6b65\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"TripSyncPullSelPlugin_5", (String)"fi-er-business", (Object[])new Object[0]), meal));
                return Boolean.FALSE;
            }
            if (this.syncorder(tripService, type, params).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean syncByordernum(ITripService tripService, String opcode, String type, String ordernums) {
        if (null == type) {
            type = "PLANE";
        }
        if (null == ordernums) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba2\u5355\u53f7\u3002", (String)"TripSyncPullSelPlugin_6", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (ordernums.split(",").length > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba2\u5355\u53f7\u4e0d\u5141\u8bb8\u8d85\u8fc710\u4e2a\u3002", (String)"TripSyncPullSelPlugin_7", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        block10: for (String ordernum : ordernums.split(",")) {
            params.put("ordernum", ordernum);
            switch (opcode) {
                case "order": {
                    if (this.syncorder(tripService, type, params).booleanValue()) continue block10;
                    return Boolean.FALSE;
                }
                case "checking": {
                    if (this.syncchecking(tripService, type, params).booleanValue()) continue block10;
                    return Boolean.FALSE;
                }
                case "orderupdate": {
                    if (this.syncorderupdate(tripService, type, params).booleanValue()) continue block10;
                    return Boolean.FALSE;
                }
            }
        }
        return Boolean.TRUE;
    }

    private Boolean syncorderupdate(ITripService tripService, String type, Map<String, Object> params) {
        try {
            params.put("businessType", type);
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5de5\u5177\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
            tripService.getOrderUpdateFromTripSettel(params);
        }
        catch (Exception e) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6t+2\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6t+2\u5f02\u5e38: %1$s %2$s", (String)"TripSyncPullSelPlugin_12", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(params), e.getMessage()));
            return Boolean.FALSE;
        }
        try {
            if (params.containsKey("serverNum")) {
                Set orderNums;
                String serverNum = params.get("serverNum").toString();
                logger.info("T+2\u8ba2\u5355\u8865\u507f\u66f4\u65b0\u8fdb\u5165");
                if (Supplier.XIECHENG.name().equals(serverNum) && params.containsKey("orderNums") && CollectionUtils.isNotEmpty((Collection)(orderNums = (Set)params.get("orderNums")))) {
                    TripNotReimbursedOrderUtil.updateOrderBill(type, orderNums);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u540e\u7eed\u6267\u884cT+2\u66f4\u65b0\u8ba2\u5355\u5931\u8d25:", (Throwable)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean syncchecking(ITripService tripService, String type, Map<String, Object> params) {
        try {
            List ls;
            Map result;
            String number = this.getModel().getDataEntity(true).getString("number");
            TripType tripType = TripType.getTripType(type);
            Object list = TripCommonUtil.invoke(number, tripType.getChecking(), null, null, params);
            if (list instanceof List && (null == (result = (Map)(ls = (List)list).get(0)) || !result.getOrDefault("success", Boolean.FALSE).booleanValue()) && tripService != null) {
                params.put("businessType", type);
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5de5\u5177\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
                tripService.synSettlementsFromTrip(params);
            }
        }
        catch (Exception e) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u7ed3\u7b97\u5355\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7ed3\u7b97\u5355\u5f02\u5e38: %1$s %2$s", (String)"TripSyncPullSelPlugin_16", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(params), e.getMessage()));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean syncorder(ITripService tripService, String type, Map<String, Object> params) {
        try {
            List ls;
            Map result;
            String number = this.getModel().getDataEntity(true).getString("number");
            TripType tripType = TripType.getTripType(type);
            if (Supplier.QICHENG.getValue().equals(number) && StringUtils.isNotBlank((CharSequence)((String)params.getOrDefault("reqnum", "")))) {
                List<String> typeList = Arrays.asList("PLANE", "HOTEL", "TRAIN");
                for (String s : typeList) {
                    TripCommonUtil.invoke(number, TripType.getTripType(s).getOrder(), null, null, params);
                }
                return Boolean.TRUE;
            }
            Object list = TripCommonUtil.invoke(number, tripType.getOrder(), null, null, params);
            if (list instanceof List && (null == (result = (Map)(ls = (List)list).get(0)) || !result.getOrDefault("success", Boolean.FALSE).booleanValue()) && tripService != null) {
                params.put("businessType", type);
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5de5\u5177\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
                tripService.synOrderFromTrip(params);
            }
        }
        catch (Exception e) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u8ba2\u5355\u5f02\u5e38\uff1a{}", (Object)ThrowableHelper.toString((Exception)e));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba2\u5355: %1$s %2$s", (String)"TripSyncPullSelPlugin_14", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(params), ThrowableHelper.toString((Exception)e)));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean syncByDate(ITripService tripService, String opcode, String type, Date startdate, Date enddate, String number) {
        if (null == startdate || null == enddate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4\u3002", (String)"TripSyncPullSelPlugin_11", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("beginDate", startdate);
        params.put("endDate", enddate);
        if (null == type) {
            type = "PLANE";
        }
        params.put("type", this.getCType(type));
        params.put("businessType", type);
        switch (opcode) {
            case "order": {
                if (this.syncorder(tripService, type, params).booleanValue()) break;
                return Boolean.FALSE;
            }
            case "checking": {
                if (this.syncchecking(tripService, type, params).booleanValue()) break;
                return Boolean.FALSE;
            }
            case "orderupdate": {
                params.put("serverNum", number);
                if (this.syncorderupdate(tripService, type, params).booleanValue()) break;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private String getCType(String type) {
        switch (type) {
            case "PLANE": {
                return "2";
            }
            case "HOTEL": {
                return "4";
            }
            case "CAR": {
                return "6";
            }
            case "TRAIN": {
                return "3";
            }
        }
        return "1";
    }
}

