/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.iscadmin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.server.gtrip.GtripFieldMappingInvoke;
import kd.fi.er.business.trip.v2.server.number.TripMappingNumber;
import kd.fi.er.business.utils.ActionLocalCache;

public class TripSyncPushSelPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TripSyncPushSelPlugin.class);
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("users");
        basedataEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                    ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setShowUsed(false);
                    ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setShowApproved(false);
                }
            }
        });
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("orgs");
        final String number = dataEntity.getString("number");
        if (orgEdit != null && (Supplier.DIDI.getValue().equals(number) || Supplier.ALI.getValue().equals(number))) {
            orgEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    int paramValue = TripSyncConfigUtil.getIntValue("budget_center_id", 1);
                    if (3 == paramValue || Supplier.ALI.getValue().equals(number)) {
                        evt.getFormShowParameter().setCustomParam("orgFuncId", (Object)"10");
                    }
                }
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams || customParams.isEmpty()) {
            return;
        }
        if (null != customParams.get("number")) {
            model.setValue("number", customParams.get("number"));
        }
        if (null != customParams.get("opcode")) {
            model.setValue("opcode", customParams.get("opcode"));
        }
        model.setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        IFormView view = this.getView();
        String number = dataEntity.getString("number");
        if (key.equals(BTN_OK)) {
            DynamicObject bill;
            String[] billArr;
            String billnos;
            String service = TripCommonUtil.getStandtripname().get(number);
            ITripService tripService = TripServiceFactory.getTripService(service);
            String opcode = dataEntity.getString("opcode");
            if (opcode.equals("user") || opcode.equals("org")) {
                QFilter qall;
                List<Object> ids = new ArrayList();
                DynamicObjectCollection dynamicObjects = dataEntity.getDynamicObjectCollection(opcode + "s");
                if (null == dynamicObjects || dynamicObjects.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u540c\u6b65\u6570\u636e\u3002", (String)"TripSyncPushSelPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
                    return;
                }
                ids = dynamicObjects.stream().map(v -> Long.parseLong(v.getDynamicObject("fbasedataid").getPkValue().toString())).collect(Collectors.toList());
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                try {
                    if (opcode.equals("user")) {
                        if (Supplier.TONGCHENG.name().equals(number)) {
                            qall = new QFilter("id", "in", ids);
                            params.put("qall", qall);
                            TripCommonUtil.invoke(number, "bos_user", null, TripMappingNumber.DTG_SYNC_USER.getCode(), params);
                        } else if (Supplier.ALI.name().equals(number)) {
                            qall = new QFilter("id", "in", ids);
                            params.put("qall", qall);
                            TripCommonUtil.invoke(number, "bos_user", null, TripMappingNumber.ALI_SYNC_USER.getCode(), params);
                        } else if (Supplier.QICHENG.name().equals(number)) {
                            qall = new QFilter("id", "in", ids);
                            params.put("qall", qall);
                            TripCommonUtil.invoke(number, "bos_user", null, TripMappingNumber.Q_SYNC_USER.getCode(), params);
                        } else if (Supplier.MEIYA.name().equals(number)) {
                            qall = new QFilter("id", "in", ids);
                            params.put("qall", qall);
                            TripCommonUtil.invoke(number, "bos_user", null, TripMappingNumber.M_SYNC_USER.getCode(), params);
                        } else if (Supplier.GAODE.name().equals(number)) {
                            qall = new QFilter("id", "in", ids);
                            params.put("qall", qall);
                            params.put("istool", true);
                            GtripFieldMappingInvoke.syncUser("G_SyncUser_BatchUpsert", params);
                        } else {
                            params.put("didi", "1");
                            params.put("userList", ids);
                            tripService.synUserToTrip(params);
                        }
                    }
                }
                catch (KDBizException e) {
                    logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u4eba\u5458\u540c\u6b65\u5f02\u5e38 \uff1a{} {}", (Object)JSON.toJSONString(params), (Object)e.getMessage());
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u4eba\u5458\u201c%s\u201d\u540c\u6b65\u5f02\u5e38\u3002", (String)"TripSyncPushSelPlugin_2", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(params)));
                    return;
                }
                try {
                    if (opcode.equals("org")) {
                        if (Supplier.ALI.name().equals(number)) {
                            qall = new QFilter("org.id", "in", ids);
                            qall.and(new QFilter("view.id", "=", (Object)10));
                            qall.and(new QFilter("isbizunit", "=", (Object)Character.valueOf('1')));
                            params.put("qall", qall);
                            TripCommonUtil.invoke(number, "bos_org_structure", null, null, params);
                        } else if (Supplier.QICHENG.name().equals(number)) {
                            qall = new QFilter("org.id", "in", ids);
                            qall.and(new QFilter("view.id", "=", (Object)1L));
                            params.put("qall", qall);
                            TripCommonUtil.invoke(number, "bos_org_structure", null, null, params);
                        } else if (Supplier.GAODE.name().equals(number)) {
                            qall = new QFilter("org.id", "in", ids);
                            params.put("qall", qall);
                            GtripFieldMappingInvoke.syncOrg("G_SyncOrg_New", params);
                        } else {
                            HashSet parentIdSet = new HashSet();
                            Map allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"01", ids);
                            for (List value : allSuperiorOrgs.values()) {
                                parentIdSet.addAll(value);
                            }
                            ids.addAll(new ArrayList(parentIdSet));
                            Collections.sort(ids, Long::compareTo);
                            params.put("orgList", ids);
                            tripService.synOrgToTrip(params);
                        }
                    }
                }
                catch (KDBizException e) {
                    logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u7ec4\u7ec7\u540c\u6b65\u5f02\u5e38 \uff1a{} {}", (Object)JSON.toJSONString(params), (Object)e.getMessage());
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u540c\u6b65\u5f02\u5e38\u3002", (String)"TripSyncPushSelPlugin_3", (String)"fi-er-business", (Object[])new Object[0]), JSON.toJSONString(params)));
                    return;
                }
            }
            if (opcode.equals("req") || opcode.equals("dailyvehicle") || opcode.equals("mealapply")) {
                billnos = dataEntity.getString(opcode + "s");
                if (null == billnos || billnos.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u540c\u6b65\u6570\u636e\u3002", (String)"TripSyncPushSelPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
                    return;
                }
                billArr = billnos.split(",");
                if (billArr.length > 10) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u540c\u6b65\u6570\u636e\u4e0d\u5141\u8bb8\u8d85\u8fc710\u6761\u3002", (String)"TripSyncPushSelPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
                    return;
                }
                for (String billno : billArr) {
                    QFilter qFilter = new QFilter("billno", "=", (Object)billno);
                    String formid = "";
                    if (opcode.equals("req")) {
                        formid = "er_tripreqbill";
                    }
                    if (opcode.equals("dailyvehicle")) {
                        formid = "er_dailyvehiclebill";
                    }
                    if (opcode.equals("mealapply")) {
                        formid = "er_mealapplication_bill";
                    }
                    if (null == (bill = QueryServiceHelper.queryOne((String)formid, (String)"id,billstatus,applier,org", (QFilter[])new QFilter[]{qFilter}))) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u540c\u6b65\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"TripSyncPushSelPlugin_4", (String)"fi-er-business", (Object[])new Object[0]), billno));
                        return;
                    }
                    try {
                        if (opcode.equals("req")) {
                            String billstatus = bill.getString("billstatus");
                            String syncstatus = "1";
                            if (!"B".equals(billstatus) && !"E".equals(billstatus)) {
                                syncstatus = "2";
                            }
                            if (number.equals(Supplier.XIECHENG.name())) {
                                boolean isReqPushSuccess = Boolean.FALSE;
                                if (TripCommonUtil.existsTripServicePlugin(number, "tripReqBillInvoke").booleanValue()) {
                                    String code = tripService.synReqbillToTrip(bill.getLong("id"), syncstatus);
                                    isReqPushSuccess = "200".equals(code);
                                } else {
                                    HashMap<String, Object> params = new HashMap<String, Object>(2);
                                    params.put("billno", billno);
                                    params.put("istool", true);
                                    if ("2".equals(syncstatus)) {
                                        params.put("status", "0");
                                    } else {
                                        params.put("status", syncstatus);
                                    }
                                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_trip_fieldmapping", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)TripMappingNumber.C_BUDGET.getCode())});
                                    Object list = TripCommonUtil.invoke(number, formid, null, null, params);
                                    if (null != list && list instanceof List) {
                                        List ls = (List)list;
                                        Map result = (Map)ls.get(0);
                                        if (null == result || !result.getOrDefault("success", Boolean.FALSE).booleanValue()) {
                                            String code = tripService.synReqbillToTrip(bill.getLong("id"), syncstatus);
                                            isReqPushSuccess = "200".equals(code) && (null == dynamicObject || !dynamicObject.getBoolean("enable"));
                                        } else {
                                            boolean bl = isReqPushSuccess = TripCommonUtil.checkCTripReqResult(result) && (null == dynamicObject || !dynamicObject.getBoolean("enable"));
                                        }
                                    }
                                }
                                if (isReqPushSuccess) {
                                    TripCommonUtil.tripBudgetPush(bill.getLong("id"), billno, number, syncstatus);
                                }
                            } else if (Supplier.TONGCHENG.name().equals(number) || Supplier.ALI.name().equals(number) || Supplier.QICHENG.name().equals(number) || Supplier.GAODE.name().equals(number)) {
                                TripCommonUtil.reqPush(billno, String.valueOf(bill.getLong("id")), number, syncstatus);
                            } else if (Supplier.MEIYA.name().equals(number)) {
                                boolean exists = QueryServiceHelper.exists((String)"er_tripsync_datamapping", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bill.getLong("id"))});
                                ActionLocalCache localCache = ActionLocalCache.get();
                                if (exists) {
                                    if ("B".equals(billstatus) || "E".equals(billstatus)) {
                                        localCache.put("SyncReq.operationType", "submit");
                                    } else if ("I".equals(billstatus)) {
                                        localCache.put("SyncReq.operationType", "closebill");
                                    } else {
                                        localCache.put("SyncReq.operationType", "unsubmit");
                                    }
                                } else if ("B".equals(billstatus) || "E".equals(billstatus)) {
                                    localCache.put("SyncReq.operationType", "submit");
                                } else {
                                    logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u7f8e\u4e9a\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\uff0c\u5173\u8054\u6570\u636e\u6620\u5c04\u4e2d\u4e0d\u5b58\u5728\u4e14\u5355\u636e\u72b6\u6001\u4e0d\u4e3aBE\uff0c\u65e0\u9700\u63a8\u9001\u3002");
                                    continue;
                                }
                                localCache.put("SyncReq.billType", "er_tripreqbill");
                                TripCommonUtil.reqPush(billno, String.valueOf(bill.getLong("id")), number, syncstatus);
                            } else {
                                tripService.synReqbillToTrip(bill.getLong("id"), syncstatus);
                            }
                        }
                        if (opcode.equals("dailyvehicle")) {
                            String syncstatus = "1";
                            String billstatus = bill.getString("billstatus");
                            if (!"B".equals(billstatus) && !"E".equals(billstatus)) {
                                syncstatus = "2";
                            }
                            if (Supplier.TONGCHENG.name().equals(number) || Supplier.GAODE.name().equals(number)) {
                                CommonServiceHelper.dailyVehicleBillPush(bill.getLong("applier"), billno, String.valueOf(bill.getLong("id")), number, syncstatus);
                            } else {
                                tripService.synDilyVehicleToTrip(bill.getLong("id"), syncstatus);
                            }
                        }
                        if (!opcode.equals("mealapply")) continue;
                        tripService.synMealApplicationBillToTrip(bill.getLong("id"), "1");
                    }
                    catch (KDBizException e) {
                        logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\u5f02\u5e38 \uff1a{} {}", (Object)billno, (Object)e.getMessage());
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u201c%s\u201d\u540c\u6b65\u5f02\u5e38\u3002", (String)"TripSyncPushSelPlugin_5", (String)"fi-er-business", (Object[])new Object[0]), billno));
                        return;
                    }
                }
            }
            if (opcode.equals("dailyapply")) {
                billnos = dataEntity.getString(opcode + "s");
                if (null == billnos || billnos.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u540c\u6b65\u6570\u636e\u3002", (String)"TripSyncPushSelPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
                    return;
                }
                billArr = billnos.split(",");
                if (billArr.length > 10) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u540c\u6b65\u6570\u636e\u4e0d\u5141\u8bb8\u8d85\u8fc710\u6761\u3002", (String)"TripSyncPushSelPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
                    return;
                }
                for (String billno : billArr) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    QFilter qFilter = new QFilter("billno", "=", (Object)billno);
                    bill = QueryServiceHelper.queryOne((String)"er_dailyapplybill", (String)"id,reimbursetype,billno", (QFilter[])new QFilter[]{qFilter});
                    if (null == bill) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u540c\u6b65\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"TripSyncPushSelPlugin_4", (String)"fi-er-business", (Object[])new Object[0]), billno));
                        return;
                    }
                    String reimbursetype = bill.getString("reimbursetype");
                    params.put("billno", bill.getString("billno"));
                    params.put("istool", true);
                    try {
                        if ("meetting".equals(reimbursetype) || "meetting_bill".equals(reimbursetype)) {
                            TripCommonUtil.invoke(Supplier.CHAILVYIHAO.getValue(), "er_dailyapplybill", null, "T_MettingApply", params);
                            continue;
                        }
                        if (!"entertainment".equals(reimbursetype) && !"entertainment_bill".equals(reimbursetype)) continue;
                        TripCommonUtil.invoke(Supplier.CHAILVYIHAO.getValue(), "er_dailyapplybill", null, "T_EntertainApply", params);
                    }
                    catch (Exception e) {
                        logger.error(String.format("\u5546\u65c5\u96c6\u6210\uff0c\u51fa\u5dee\u7533\u8bf7\u5355%s\u540c\u6b65\u5f02\u5e38 \uff1a", billno), (Throwable)e);
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u201c%s\u201d\u540c\u6b65\u5f02\u5e38\u3002", (String)"TripSyncPushSelPlugin_5", (String)"fi-er-business", (Object[])new Object[0]), billno));
                        return;
                    }
                }
            }
            view.showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u6839\u636e\u5546\u65c5\u96c6\u6210\u65e5\u5fd7\u786e\u8ba4\u6700\u7ec8\u7ed3\u679c\u3002", (String)"TripSyncPushSelPlugin_6", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
    }
}

