/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.invoice.Serviceitem;
import kd.fi.er.business.trip.annotation.KDTripField;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.trip.model.InvoiceModel;
import kd.fi.er.common.utils.TXUtils;

public class InvoiceExistDataModel
extends ExistDataModel {
    private static final Log logger = LogFactory.getLog(InvoiceExistDataModel.class);
    private Map<String, DynamicObject> invoiceMapping = Maps.newHashMap();
    private Map<Object, DynamicObject> allcheckingBillMapping = Maps.newHashMap();
    private Map<Object, DynamicObject> checkingBillMapping = Maps.newHashMap();
    private Map<Object, Object> invoiceOrderNumMap = Maps.newHashMap();
    private Map<Object, DynamicObject> invoiceSettleRelMaxMapping = Maps.newHashMap();
    private Map<String, BigDecimal> checkingBillMapping_ = Maps.newHashMap();
    protected Map<String, DynamicObject[]> needUpdateSettle = Maps.newHashMap();
    private Map<String, String> custInvSequenceInvoiceidRelMap = Maps.newHashMap();
    private Set<String> invoiceFilter = Sets.newHashSet();
    private IErDao invoiceDao = ErDaoFactory.getInstance("er_invoiceorderbill");

    @Override
    public void query() {
        QFilter filter = new QFilter("trdinvoiceid", "in", this.invoiceFilter).and(new QFilter("server", "=", (Object)this.getServer()));
        DynamicObject[] invoicesDynamicObjects = (DynamicObject[])QueryServiceHelper.query((String)"er_invoiceorderbill", (String)(this.getQueryField(InvoiceModel.class) + ",batchno,serviceitem,billno,settleamounttax,difftaxamount,invoicetype,settleamountwithtax,invoicetax,diffamountwithtax,taxamount,systemtaxrate,invoiceamount"), (QFilter[])new QFilter[]{filter}).toArray((Object[])new DynamicObject[0]);
        this.getInvoiceFilter().clear();
        Stream.of(invoicesDynamicObjects).forEach(v -> {
            this.custInvSequenceInvoiceidRelMap.put(v.getString("trdinvoiceid"), v.getString("id"));
            this.invoiceMapping.put(this.custInvSequenceInvoiceidRelMap.get(v.getString("trdinvoiceid")), (DynamicObject)v);
            this.getInvoiceFilter().add(this.custInvSequenceInvoiceidRelMap.get(v.getString("trdinvoiceid")));
        });
        this.queryCheckingbillAndRelInvoiceBill();
    }

    private void queryCheckingbillAndRelInvoiceBill() {
        IErDao invoiceSettleRelDao = ErDaoFactory.getInstance("er_invoicesettle_rel");
        DynamicObject[] invoiceSettleRelDyn = invoiceSettleRelDao.query("invoiceid, settleid, totalamount, taxamount, settleformid", new QFilter("invoiceid", "in", this.invoiceFilter.stream().map(v -> Long.valueOf(v)).collect(Collectors.toSet())));
        HashSet settleIds = new HashSet();
        Stream.of(invoiceSettleRelDyn).collect(Collectors.groupingBy(v -> v.getString("invoiceid"))).forEach((k, v) -> {
            if (v != null) {
                DynamicObject max = (DynamicObject)v.get(0);
                settleIds.add(((DynamicObject)v.get(0)).getLong("settleid"));
                for (int i = 1; i < v.size(); ++i) {
                    DynamicObject temp = (DynamicObject)v.get(i);
                    settleIds.add(temp.getLong("settleid"));
                    if (max.getBigDecimal("totalamount").compareTo(temp.getBigDecimal("totalamount")) >= 0) continue;
                    max = temp;
                }
                this.invoiceSettleRelMaxMapping.put(k, max);
            }
        });
        DynamicObject[] settleRelDyn = invoiceSettleRelDao.query("settleid, invoiceid, settleformid", new QFilter("settleid", "in", settleIds));
        HashSet invoiceIds = new HashSet();
        Map settleInvoiceRelMapping = Stream.of(settleRelDyn).filter(v -> !this.invoiceFilter.contains(v.getString("invoiceid"))).collect(Collectors.groupingBy(v -> v.getLong("settleid"), Collectors.mapping(v -> v.getLong("invoiceid"), Collectors.toSet())));
        settleInvoiceRelMapping.values().forEach(v -> invoiceIds.addAll(v));
        DynamicObject[] allInvoiceDyn = this.invoiceDao.query("id, invoicestatus", new QFilter("id", "in", invoiceIds));
        Map invoiceIdMapping = Stream.of(allInvoiceDyn).collect(Collectors.toMap(v -> v.getLong("id"), Function.identity()));
        Map settleFormAndIdMapping = Stream.of(settleRelDyn).collect(Collectors.groupingBy(v -> v.getString("settleformid"), Collectors.mapping(v -> v.getLong("settleid"), Collectors.toSet())));
        settleInvoiceRelMapping.forEach((k, v) -> {
            if (v != null) {
                v.forEach(invoiceid -> {
                    String status;
                    DynamicObject invoiceTemp = (DynamicObject)invoiceIdMapping.get(invoiceid);
                    if (invoiceTemp != null && !"3".equals(status = invoiceTemp.getString("invoicestatus")) && !"4".equals(status)) {
                        settleFormAndIdMapping.forEach((sk, sv) -> sv.remove(k));
                    }
                });
            }
        });
        settleFormAndIdMapping.forEach((sk, sv) -> {
            if (sv != null && sv.size() > 0) {
                DynamicObject[] settleTemps;
                IErDao settleDao = ErDaoFactory.getInstance(sk);
                for (DynamicObject settleTemp : settleTemps = settleDao.query("id, hasinvoice", new QFilter("id", "in", sv))) {
                    settleTemp.set("hasinvoice", (Object)"1");
                }
                this.needUpdateSettle.put((String)sk, settleTemps);
            }
        });
    }

    private <T> String getQueryField(Class<T> cls) {
        Field[] declaredFields = cls.getDeclaredFields();
        StringBuilder queryFields = new StringBuilder();
        for (Field field : declaredFields) {
            KDTripField fieldAnnotation = field.getAnnotation(KDTripField.class);
            if (fieldAnnotation != null && fieldAnnotation.ignore()) continue;
            queryFields.append(field.getName()).append(",");
        }
        int len = queryFields.length();
        if (len > 0) {
            return queryFields.substring(0, len - 1);
        }
        return queryFields.toString();
    }

    @Override
    public void save() throws TripException {
        Map settleDiffMapping = this.checkingBillMapping_.keySet().stream().collect(Collectors.groupingBy(v -> v.split("&")[0], Collectors.mapping(v -> Long.valueOf(v.split("&")[1]), Collectors.toSet())));
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        settleDiffMapping.forEach((arg_0, arg_1) -> this.lambda$save$17((Multimap)multiMap, arg_0, arg_1));
        TXUtils.executeWithTX(arg_0 -> this.lambda$save$20((Multimap)multiMap, arg_0));
    }

    public Map<String, DynamicObject> getInvoiceMapping() {
        return this.invoiceMapping;
    }

    public Map<Object, DynamicObject> getAllcheckingBillMapping() {
        return this.allcheckingBillMapping;
    }

    public Map<Object, DynamicObject> getCheckingBillMapping() {
        return this.checkingBillMapping;
    }

    public Map<Object, Object> getInvoiceOrderNumMap() {
        return this.invoiceOrderNumMap;
    }

    public Map<Object, DynamicObject> getInvoiceSettleRelMaxMapping() {
        return this.invoiceSettleRelMaxMapping;
    }

    public Map<String, BigDecimal> getCheckingBillMapping_() {
        return this.checkingBillMapping_;
    }

    public Map<String, DynamicObject[]> getNeedUpdateSettle() {
        return this.needUpdateSettle;
    }

    public Set<String> getInvoiceFilter() {
        return this.invoiceFilter;
    }

    public IErDao getInvoiceDao() {
        return this.invoiceDao;
    }

    public Map<String, String> getCustInvSequenceInvoiceidRelMap() {
        return this.custInvSequenceInvoiceidRelMap;
    }

    public void setCustInvSequenceInvoiceidRelMap(Map<String, String> custInvSequenceInvoiceidRelMap) {
        this.custInvSequenceInvoiceidRelMap = custInvSequenceInvoiceidRelMap;
    }

    private /* synthetic */ void lambda$save$20(Multimap multiMap, TXHandle txhandle) {
        if (!this.invoiceMapping.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.invoiceMapping.values().toArray(new DynamicObject[0]));
        }
        if (!this.invoiceSettleRelMaxMapping.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.invoiceSettleRelMaxMapping.values().toArray(new DynamicObject[0]));
        }
        if (this.needUpdateSettle != null) {
            this.needUpdateSettle.values().forEach(v -> SaveServiceHelper.save((DynamicObject[])v));
        }
        multiMap.keySet().forEach(v -> {
            Collection settles = multiMap.get(v);
            SaveServiceHelper.save((DynamicObject[])settles.toArray(new DynamicObject[settles.size()]));
        });
    }

    private /* synthetic */ void lambda$save$17(Multimap multiMap, String settleformid, Set settleidSet) {
        if (settleformid != null && settleidSet != null && settleidSet.size() > 0) {
            DynamicObject[] settleTemps;
            IErDao settleDao = ErDaoFactory.getInstance(settleformid);
            for (DynamicObject settleTemp : settleTemps = settleDao.query("id, totaltax, serviceamounttax, orderamounttax", new QFilter("id", "in", (Object)settleidSet))) {
                BigDecimal diffTaxAmount = this.checkingBillMapping_.get(settleformid + "&" + settleTemp.getLong("id"));
                if (diffTaxAmount == null) continue;
                if (null != this.invoiceMapping.get(settleTemp.getLong("id")) && null != this.invoiceMapping.get(settleTemp.getLong("id")).getString("serviceitem") && Serviceitem.SERVICE.getName().equals(this.invoiceMapping.get(settleTemp.getLong("id")).getString("serviceitem"))) {
                    settleTemp.set("serviceamounttax", (Object)settleTemp.getBigDecimal("serviceamounttax").add(diffTaxAmount));
                } else {
                    settleTemp.set("orderamounttax", (Object)settleTemp.getBigDecimal("orderamounttax").add(diffTaxAmount));
                }
                settleTemp.set("totaltax", (Object)settleTemp.getBigDecimal("totaltax").add(diffTaxAmount));
                multiMap.put((Object)settleformid, (Object)settleTemp);
            }
        }
    }
}

