/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class SyncDilyVehicleBillToTripConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(SyncDilyVehicleBillToTripConsumer.class);
    static final List<String> operationTypeList = new ArrayList<String>(2);
    static final List<String> syncStatusList = new ArrayList<String>(2);

    public void onMessage(Object msgBody, String msgId, boolean resend, MessageAcker ack) {
        if (msgBody == null) {
            ack.discard(msgId);
            return;
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u7533\u8bf7\u5355\u540c\u6b65,MQ\u6267\u884c\u5f00\u59cb:" + JSON.toJSONString((Object)msgBody));
        Map msgMap = (Map)msgBody;
        if (msgMap.get("billId") == null) {
            ack.discard(msgId);
            return;
        }
        Long paramBillId = (Long)msgMap.get("billId");
        String operationType = (String)msgMap.get("operationType");
        String syncStatus = (String)msgMap.get("syncStatus");
        HashSet<Long> vehicleBillIds = new HashSet<Long>();
        vehicleBillIds.add(paramBillId);
        QFilter qFilter = new QFilter("id", "in", vehicleBillIds);
        DynamicObjectCollection vehicleBills = QueryServiceHelper.query((String)"er_dailyvehiclebill", (String)"id,billno,applier,org,company", (QFilter[])new QFilter[]{qFilter});
        if (vehicleBills == null || vehicleBills.size() == 0) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u7533\u8bf7\u5355\u540c\u6b65,\u7528\u8f66\u7533\u8bf7\u5355\u4e0d\u5b58\u5728:" + JSON.toJSONString((Object)msgBody));
            return;
        }
        HashSet<String> serverSet = new HashSet<String>();
        for (Supplier key : Supplier.values()) {
            String server = key.name();
            if (!TripCommonUtil.isEnbleServer(server).booleanValue() || !operationTypeList.contains(operationType) || !syncStatusList.contains(syncStatus)) continue;
            serverSet.add(server);
        }
        if (serverSet.isEmpty()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u7533\u8bf7\u5355\u540c\u6b65,\u6ca1\u6709\u542f\u7528\u7684\u670d\u52a1\u5546");
            return;
        }
        HashMap orgIdAndCompanyIdMap = Maps.newHashMapWithExpectedSize((int)2);
        for (DynamicObject vehicle : vehicleBills) {
            Boolean isNoApprove;
            String billNo = vehicle.getString("billno");
            String billId = vehicle.getString("id");
            Long userId = vehicle.getLong("applier");
            Long orgId = vehicle.getLong("org");
            Long companyId = vehicle.getLong("company");
            Object paramValue = ErCommonUtils.getEMParameter(companyId, "syncvehiclebilltotrip");
            if ((paramValue == null || "0".equals(paramValue.toString())) && "submit".equals(operationType) && !(isNoApprove = Boolean.valueOf(CommonServiceHelper.noApprovaWhiteList(userId, "1"))).booleanValue()) continue;
            serverSet.forEach(v -> {
                String server = v;
                orgIdAndCompanyIdMap.put("orgId", orgId);
                orgIdAndCompanyIdMap.put("companyId", companyId);
                if (!TripCommonUtil.checkIsNeedBill(server, orgIdAndCompanyIdMap, "er_dailyvehiclebill")) {
                    logger.info("\u5f53\u524d\u7533\u8bf7\u5355{},\u670d\u52a1\u5546{},\u7533\u8bf7\u5355\u540c\u6b65\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42", (Object)billNo, (Object)server);
                    return;
                }
                try {
                    CommonServiceHelper.dailyVehicleBillPush(userId, billNo, billId, server, syncStatus);
                }
                catch (Exception e) {
                    logger.error("\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u7533\u8bf7\u5355\u540c\u6b65,MQ\u6267\u884c\u5931\u8d25,\u5f53\u524d\u670d\u52a1\u5546:" + server, (Throwable)e);
                }
            });
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u7528\u8f66\u7533\u8bf7\u5355\u540c\u6b65,MQ\u6267\u884c\u7ed3\u675f");
    }

    static {
        operationTypeList.add("audit");
        operationTypeList.add("unsubmit");
        operationTypeList.add("submit");
        operationTypeList.add("noapprive");
        syncStatusList.add("1");
        syncStatusList.add("2");
    }
}

