/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;

public class SyncReqBillToTripConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(SyncReqBillToTripConsumer.class);

    public void onMessage(Object msgBody, String msgId, boolean resend, MessageAcker ack) {
        if (msgBody == null) {
            ack.discard(msgId);
            return;
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,MQ\u6267\u884c\u5f00\u59cb:" + JSON.toJSONString((Object)msgBody));
        Map msgMap = (Map)msgBody;
        String billtype = (String)msgMap.get("billType");
        Long paramBillId = (Long)msgMap.get("billId");
        String operationType = (String)msgMap.get("operationType");
        String approveType = (String)msgMap.get("approveType");
        String syncStatus = (String)msgMap.get("syncStatus");
        ActionLocalCache localCache = ActionLocalCache.get();
        localCache.put("SyncReq.operationType", operationType);
        localCache.put("SyncReq.billType", billtype);
        Set<Long> reqBillIds = new HashSet<Long>();
        reqBillIds.add(paramBillId);
        if ("er_tripreimbursebill".equals(billtype)) {
            Map sourceBillMap = BFTrackerServiceHelper.findSourceBills((String)"er_tripreimbursebill", (Long[])new Long[]{paramBillId});
            if (sourceBillMap == null || sourceBillMap.size() < 1) {
                return;
            }
            reqBillIds = (Set)sourceBillMap.get("er_tripreqbill");
        }
        if (reqBillIds == null || reqBillIds.size() < 1) {
            return;
        }
        DynamicObject[] reqBills = (DynamicObject[])QueryServiceHelper.query((String)"er_tripreqbill", (String)String.join((CharSequence)",", "billno", "isloan", "id", "applier", "company", "org"), (QFilter[])new QFilter[]{new QFilter("id", "in", reqBillIds)}).toArray((Object[])new DynamicObject[0]);
        if (reqBills.length == 0) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u51fa\u5dee\u7533\u8bf7\u5355\u4e0d\u5b58\u5728:" + JSON.toJSONString((Object)msgBody));
            return;
        }
        HashSet<String> serverSet = new HashSet<String>();
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_biz_info", (QFilter[])new QFilter[]{qA});
        if (null == dynamicObjectMap || dynamicObjectMap.isEmpty()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u6ca1\u6709\u542f\u7528\u7684\u670d\u52a1\u5546\uff1a" + JSON.toJSONString((Object)msgBody));
            return;
        }
        for (Map.Entry next : dynamicObjectMap.entrySet()) {
            DynamicObject value = (DynamicObject)next.getValue();
            if (null == value) continue;
            String number = value.getString("number");
            if (Supplier.ZHONGXING.name().equals(number) && !"1".equals(syncStatus) || !value.getBoolean("enable")) continue;
            serverSet.add(number);
        }
        if (serverSet.isEmpty()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u6ca1\u6709\u542f\u7528\u7684\u670d\u52a1\u5546");
            return;
        }
        HashMap orgIdAndCompanyIdMap = Maps.newHashMapWithExpectedSize((int)2);
        for (DynamicObject reqBill : reqBills) {
            Long companyID;
            int reqbilltoreimbursecount;
            DynamicObject[] reimburese;
            String billNo = reqBill.getString("billno");
            if (reqBill.getBoolean("isloan")) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u540c\u6b65\u7684\u5355\u636e\u4e3a\u51fa\u5dee\u501f\u6b3e\u5355,\u51fa\u5dee\u5355\u7f16\u7801:" + billNo);
                continue;
            }
            String billId = reqBill.getString("id");
            Long userId = reqBill.getLong("applier");
            Boolean isSync = true;
            if ("er_tripreimbursebill".equals(billtype) && (reimburese = (DynamicObject[])QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"company", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)paramBillId)}).toArray((Object[])new DynamicObject[0])).length > 0 && reimburese[0] != null && (reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam(companyID = ErCommonUtils.getPk(reimburese[0].get("company")), "reqbilltoreimbursecount")) > 0) {
                isSync = false;
            }
            Long orgId = reqBill.getLong("org");
            Long companyId = reqBill.getLong("company");
            for (String server : serverSet) {
                if (ErEntityTypeUtils.isTripReimburseBill(billtype) && !isSync.booleanValue()) continue;
                orgIdAndCompanyIdMap.put("orgId", orgId);
                orgIdAndCompanyIdMap.put("companyId", companyId);
                if (!TripCommonUtil.checkIsNeedBill(server, orgIdAndCompanyIdMap, "er_tripreqbill")) {
                    logger.info("\u5f53\u524d\u7533\u8bf7\u5355{},\u670d\u52a1\u5546{},\u7533\u8bf7\u5355\u540c\u6b65\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42", (Object)billNo, (Object)server);
                    continue;
                }
                try {
                    if ("checkIsVip".equals(approveType)) {
                        CommonServiceHelper.noApprovalPush(userId, billNo, billId, server, syncStatus);
                        continue;
                    }
                    if (!"alreadyApproved".equals(approveType)) continue;
                    CommonServiceHelper.approvalAndCloseBillPush(userId, billNo, billId, server, syncStatus);
                }
                catch (Exception e) {
                    logger.error("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,MQ\u6267\u884c\u5931\u8d25,\u5f53\u524d\u670d\u52a1\u5546:" + server, (Throwable)e);
                }
            }
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,MQ\u6267\u884c\u7ed3\u675f");
    }
}

