/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.overtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.trip.overtime.AutoSubmitEntry;
import kd.fi.er.business.trip.overtime.OvertimeUtil;

public class AutoSubmit {
    private static final String ALGO = "kd.fi.er.business.trip.overtime.AutoSubmit";
    private static Log logger = LogFactory.getLog(AutoSubmit.class);
    private List<AutoSubmitEntry> entries = new ArrayList<AutoSubmitEntry>();

    void addEntry(AutoSubmitEntry entry) {
        this.entries.add(entry);
    }

    String[] getLog() {
        int totalCount = this.entries.size();
        List fails = this.entries.stream().filter(v -> v.getStatus() != 0).collect(Collectors.toList());
        int failCount = fails.size();
        String title = String.format(ResManager.loadKDString((String)"\u201c\u8d85\u671f\u81ea\u52a8\u63d0\u4ea4\u201d\u5171\u5904\u7406\u4e86%1$s\u6761\u8ba2\u5355\uff0c\u63d0\u4ea4\u5931\u8d25%2$s\u6761\uff0c\u6210\u529f%3$s\u6761\u3002", (String)"AutoSubmit_7", (String)"fi-er-business", (Object[])new Object[0]), totalCount, failCount, totalCount - failCount);
        ArrayList<String> detailLst = new ArrayList<String>();
        String detal_meta = OvertimeUtil.join(new String[]{ResManager.loadKDString((String)"\u8ba2\u5355\u53f7", (String)"AutoSubmit_1", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u53f7", (String)"AutoSubmit_2", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62a5\u9500\u5355\u53f7", (String)"AutoSubmit_3", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"AutoSubmit_4", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4fe1\u606f", (String)"AutoSubmit_5", (String)"fi-er-business", (Object[])new Object[0])}, "\t");
        detailLst.add(detal_meta);
        detailLst.addAll(this.entries.stream().map(v -> OvertimeUtil.join(v.getLog(), "\t")).collect(Collectors.toList()));
        return new String[]{title, OvertimeUtil.join(detailLst, "$NEWLINE$")};
    }

    public void submit() {
        try {
            Map<Boolean, List<AutoSubmitEntry>> has_orNo_reim = this.entries.stream().filter(v -> v.getReqBillPk() > 0L).collect(Collectors.partitioningBy(v -> v.getReimBillPk() > 0L));
            Set<Long> reimPks_exist = has_orNo_reim.get(Boolean.TRUE).stream().map(v -> v.getReimBillPk()).collect(Collectors.toSet());
            logger.info("\u63d0\u4ea4\u5df2\u5b58\u5728\u7684\u62a5\u9500\u5355");
            logger.info("\u62a5\u9500\u5355PK\uff1a" + OvertimeUtil.join(reimPks_exist));
            this.submitReimBill(reimPks_exist);
            logger.info("\u672a\u66fe\u4e0b\u63a8\u62a5\u9500\u5355\u7684\uff0c\u751f\u6210\u62a5\u9500\u5355");
            Set<Long> reqBillPks = has_orNo_reim.get(Boolean.FALSE).stream().map(v -> v.getReqBillPk()).collect(Collectors.toSet());
            logger.info("\u7533\u8bf7\u5355PK\uff1a" + OvertimeUtil.join(reqBillPks));
            this.pushReimBill(reqBillPks);
            logger.info("\u5c06\u65b0\u4e0b\u63a8\u7684\u62a5\u9500\u5355\u67e5\u51fa\u6765");
            Set<Long> reimPks_new = this.queryNewReimBill(reqBillPks);
            logger.info("\u63d0\u4ea4\u65b0\u4e0b\u63a8\u7684\u62a5\u9500\u5355");
            logger.info("\u62a5\u9500\u5355PK\uff1a" + OvertimeUtil.join(reimPks_new));
            this.submitReimBill(reimPks_new);
        }
        catch (Exception ex) {
            logger.error("\u81ea\u52a8\u63d0\u4ea4\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)ex);
        }
    }

    private Set<Long> queryNewReimBill(Set<Long> reqBillPks) {
        HashSet<Long> reimPks_new = new HashSet<Long>();
        if (reqBillPks.size() <= 0) {
            return reimPks_new;
        }
        String sql = "select fBillNo, fid, fSourceBillId from t_er_reimbursebill where fSourceBillId in (" + OvertimeUtil.join(reqBillPks, ",") + ")";
        try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.of((String)"er"), (String)sql);){
            for (Row row : ds) {
                String reimBillNo = row.getString("fBillNo");
                long reimBillId = row.getLong("fid");
                long reqBillId = row.getLong("fSourceBillId");
                Optional<AutoSubmitEntry> entryOptional = this.entries.stream().filter(v -> v.getReqBillPk() == reqBillId).findFirst();
                if (!entryOptional.isPresent()) continue;
                AutoSubmitEntry entry = entryOptional.get();
                entry.setReimBillNo(reimBillNo);
                entry.setReimBillPk(reimBillId);
                reimPks_new.add(reimBillId);
            }
        }
        return reimPks_new;
    }

    private void submitReimBill(Set<Long> reimPks) {
        Object[] reimPkArr = reimPks.toArray();
        DynamicObject[] reimBills = BusinessDataServiceHelper.load((Object[])reimPkArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_tripreimbursebill"));
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"er_tripreimbursebill", (DynamicObject[])reimBills, (OperateOption)OperateOption.create());
        this.handleOperationResult(false, submitResult);
    }

    private void pushReimBill(Set<Long> reqBillPks) {
        DynamicObject[] reqBills;
        Object[] reqPkArr = reqBillPks.toArray();
        for (DynamicObject reqBill : reqBills = BusinessDataServiceHelper.load((Object[])reqPkArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_tripreqbill"))) {
            try {
                OperationResult toReimObjectResult = OperationServiceHelper.executeOperate((String)"autoreimburse", (String)"er_tripreqbill", (DynamicObject[])new DynamicObject[]{reqBill}, (OperateOption)OperateOption.create());
                this.handleOperationResult(true, toReimObjectResult);
            }
            catch (Exception ex) {
                Optional<AutoSubmitEntry> entryOptional = this.entries.stream().filter(v -> this.matchReqBill((AutoSubmitEntry)v, reqBill.getLong("id"))).findFirst();
                if (!entryOptional.isPresent()) continue;
                AutoSubmitEntry autoSubmitEntry = entryOptional.get();
                autoSubmitEntry.setStatus(1);
                autoSubmitEntry.getErrMsgs().add(String.format(ResManager.loadKDString((String)"\u8c03\u7528BOTP\u4e0b\u63a8\u5dee\u65c5\u62a5\u9500\u5355\u5931\u8d25: %s", (String)"AutoSubmit_8", (String)"fi-er-business", (Object[])new Object[0]), ex));
                logger.error("\u8c03\u7528BOTP\u4e0b\u63a8\u5dee\u65c5\u62a5\u9500\u5355\u5931\u8d25\uff0c\u7533\u8bf7\u5355\u53f7\uff1a" + autoSubmitEntry.getReqBillNo(), (Throwable)ex);
            }
        }
    }

    private void handleOperationResult(boolean isCreate, OperationResult opResult) {
        ValidateResultCollection validateResults;
        if (!opResult.isSuccess() && (validateResults = opResult.getValidateResult()) != null && validateResults.errorSize() > 0) {
            List validateErrors = validateResults.getValidateErrors();
            for (ValidateResult validateResult : validateErrors) {
                List allErrorInfo = validateResult.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    if (operateErrorInfo.getPkValue() == null) continue;
                    long pk = Long.parseLong(operateErrorInfo.getPkValue().toString());
                    Optional<AutoSubmitEntry> entryOptional = this.entries.stream().filter(v -> isCreate ? this.matchReqBill((AutoSubmitEntry)v, pk) : this.matchReimBill((AutoSubmitEntry)v, pk)).findFirst();
                    if (!entryOptional.isPresent()) continue;
                    AutoSubmitEntry autoSubmitEntry = entryOptional.get();
                    autoSubmitEntry.setStatus(1);
                    autoSubmitEntry.getErrMsgs().add(operateErrorInfo.getMessage());
                }
            }
        }
        List successPkIds = opResult.getSuccessPkIds();
        for (Object opk : successPkIds) {
            long pk = (Long)opk;
            Optional<AutoSubmitEntry> entryOptional = this.entries.stream().filter(v -> isCreate ? this.matchReqBill((AutoSubmitEntry)v, pk) : this.matchReimBill((AutoSubmitEntry)v, pk)).findFirst();
            if (!entryOptional.isPresent()) continue;
            AutoSubmitEntry autoSubmitEntry = entryOptional.get();
            autoSubmitEntry.setStatus(0);
        }
    }

    private boolean matchReqBill(AutoSubmitEntry entry, long reqBillPk) {
        return entry.getReqBillPk() == reqBillPk;
    }

    private boolean matchReimBill(AutoSubmitEntry entry, long reimBillPk) {
        return entry.getReimBillPk() == reimBillPk;
    }

    public String toString() {
        return OvertimeUtil.join(this.getLog(), OvertimeUtil.CR);
    }
}

