/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.overtime;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.overtime.AutoSubmit;
import kd.fi.er.business.trip.overtime.AutoSubmitEntry;
import kd.fi.er.business.trip.overtime.OvertimeUtil;

public class TripOrderBillOvertimeHelper {
    private static final String ALGO_KEY = "kd.fi.er.business.trip.overtime.TripOrderBillOvertimeHelper";
    private static Log logger = LogFactory.getLog(TripOrderBillOvertimeHelper.class);

    private List<DynamicObject> getAllOvertimeOrderBill(boolean remind, Map<String, Object> filtersMap) {
        String actionDesc;
        String overdueDayField;
        String on_off;
        if (remind) {
            on_off = "remind";
            overdueDayField = "remindday";
            actionDesc = ResManager.loadKDString((String)"\u67e5\u8be2\u8d85\u671f\u63d0\u9192\u8ba2\u5355", (String)"TripOrderBillOvertimeHelper_0", (String)"fi-er-business", (Object[])new Object[0]);
        } else {
            on_off = "submit";
            overdueDayField = "submitday";
            actionDesc = ResManager.loadKDString((String)"\u67e5\u8be2\u8d85\u671f\u63d0\u4ea4\u8ba2\u5355", (String)"TripOrderBillOvertimeHelper_1", (String)"fi-er-business", (Object[])new Object[0]);
        }
        String sic = "sourcebookedid,server,happenddate,totalamount,oabillnum,ordernum";
        QFilter[] planeOrderBillsFilters = (QFilter[])filtersMap.get("planeOrderBillsFilters");
        QFilter[] hotelOrderBillsFilters = (QFilter[])filtersMap.get("hotelOrderBillsFilters");
        QFilter[] vehicleOrderBillsFilters = (QFilter[])filtersMap.get("vehicleOrderBillsFilters");
        QFilter[] trainOrderBillsFilters = (QFilter[])filtersMap.get("trainOrderBillsFilters");
        DynamicObject[] planeOrderBills = (DynamicObject[])QueryServiceHelper.query((String)"er_planebill", (String)sic, (QFilter[])planeOrderBillsFilters).toArray((Object[])new DynamicObject[0]);
        DynamicObject[] hotelOrderBills = (DynamicObject[])QueryServiceHelper.query((String)"er_hotelbill", (String)sic, (QFilter[])hotelOrderBillsFilters).toArray((Object[])new DynamicObject[0]);
        DynamicObject[] vehicleOrderBills = (DynamicObject[])QueryServiceHelper.query((String)"er_vehiclebill", (String)sic, (QFilter[])vehicleOrderBillsFilters).toArray((Object[])new DynamicObject[0]);
        DynamicObject[] trainOrderBills = (DynamicObject[])QueryServiceHelper.query((String)"er_trainbill", (String)sic, (QFilter[])trainOrderBillsFilters).toArray((Object[])new DynamicObject[0]);
        HashMap<String, DynamicObject[]> type_orders = new HashMap<String, DynamicObject[]>();
        type_orders.put(AbstractOrderModel.OperationType.A.getKey(), hotelOrderBills);
        type_orders.put(AbstractOrderModel.OperationType.B.getKey(), planeOrderBills);
        type_orders.put(AbstractOrderModel.OperationType.C.getKey(), vehicleOrderBills);
        type_orders.put(AbstractOrderModel.OperationType.F.getKey(), trainOrderBills);
        QFilter[] filters = new QFilter[]{new QFilter(on_off, "=", (Object)true)};
        sic = "isp,servicetype," + overdueDayField;
        ArrayList<DynamicObject> orderBillToDoAction = new ArrayList<DynamicObject>();
        String ordernums = "";
        try {
            DynamicObject[] settings;
            for (DynamicObject setting : settings = (DynamicObject[])QueryServiceHelper.query((String)"er_overtime_setting", (String)sic, (QFilter[])filters).toArray((Object[])new DynamicObject[0])) {
                DynamicObject[] orderBills = (DynamicObject[])type_orders.get(setting.getString("servicetype"));
                List needToDoAction = Stream.of(orderBills).filter(v -> this.match((DynamicObject)v, setting)).collect(Collectors.toList());
                ArrayList<String> orderNum_ofInvalidDate = new ArrayList<String>();
                for (int i = needToDoAction.size() - 1; i >= 0; --i) {
                    boolean invalid = false;
                    DynamicObject orderBill = (DynamicObject)needToDoAction.get(i);
                    Object happenddate = orderBill.get("happenddate");
                    if (happenddate == null || happenddate.toString().trim().equals("")) {
                        invalid = true;
                    } else {
                        try {
                            OvertimeUtil.stripTime(orderBill.getDate("happenddate")).getTime();
                        }
                        catch (Exception e) {
                            invalid = true;
                        }
                    }
                    if (!invalid) continue;
                    orderNum_ofInvalidDate.add(orderBill.getString("ordernum"));
                    needToDoAction.remove(i);
                }
                if (orderNum_ofInvalidDate.size() > 0) {
                    String errfmt = ResManager.loadKDString((String)"\u3010\u8d39\u7528\u53d1\u751f\u65e5\u671f\u4e0d\u5408\u6cd5\u7684\u8ba2\u5355\u3011\u8ba2\u5355\u53f7: %s", (String)"TripOrderBillOvertimeHelper_2", (String)"fi-er-business", (Object[])new Object[0]);
                    logger.info(String.format(errfmt, "'" + OvertimeUtil.join(orderNum_ofInvalidDate, "','") + "'"));
                }
                needToDoAction = needToDoAction.stream().filter(v -> TripOrderBillOvertimeHelper.checkNeedToDoAction(v, setting, overdueDayField)).collect(Collectors.toList());
                orderBillToDoAction.addAll(needToDoAction);
            }
            ordernums = orderBillToDoAction.stream().map(v -> v.getString("ordernum")).collect(Collectors.joining(","));
        }
        catch (Exception ex) {
            StackTraceElement[] stackTrace = ex.getStackTrace();
            String stackTraceStr = Stream.of(stackTrace).map(v -> v.toString()).collect(Collectors.joining(OvertimeUtil.CR));
            logger.info("\u8ddf\u8e2a\u4e00\u4e2a\u88ab\u5403\u6389\u7684\u5f02\u5e38" + OvertimeUtil.CR + stackTraceStr + ",exmsg:" + ex.getMessage());
            return new ArrayList<DynamicObject>();
        }
        String fmt = ResManager.loadKDString((String)"\u3010%1$s\u3011\u5f53\u524d\u65e5\u671f%2$s\uff0c\u8d85\u671f\u7684\u8ba2\u5355\u53f7\u6709: %3$s", (String)"TripOrderBillOvertimeHelper_6", (String)"fi-er-business", (Object[])new Object[0]);
        logger.info(String.format(fmt, actionDesc, new SimpleDateFormat("yyyy-MM-dd").format(new Date()), ordernums));
        return orderBillToDoAction;
    }

    public List<DynamicObject> getOrderToRemind(long userId) {
        HashMap<String, Object> filtersMap = new HashMap<String, Object>();
        QFilter filters = new QFilter("isreimburse", "!=", (Object)true).and(new QFilter("sourcebookedid", "=", (Object)userId));
        filters.and("totalamount", "!=", (Object)BigDecimal.ZERO);
        QFilter filterProducttype = new QFilter("producttype", "!=", (Object)"2");
        QFilter filterServicefeePaytype = new QFilter("servicefeepaytype", "!=", (Object)"2");
        filtersMap.put("planeOrderBillsFilters", new QFilter[]{filters, filterProducttype});
        filtersMap.put("trainOrderBillsFilters", new QFilter[]{filters, filterProducttype});
        filtersMap.put("hotelOrderBillsFilters", new QFilter[]{filters, filterProducttype, filterServicefeePaytype});
        filtersMap.put("vehicleOrderBillsFilters", new QFilter[]{filters, filterProducttype, filterServicefeePaytype, new QFilter("vehicletype", "=", (Object)"1")});
        return this.getAllOvertimeOrderBill(true, filtersMap);
    }

    public List<DynamicObject> getOrderToRemind() {
        HashMap<String, Object> filtersMap = new HashMap<String, Object>();
        QFilter filters = new QFilter("isreimburse", "!=", (Object)true).and("totalamount", "!=", (Object)BigDecimal.ZERO);
        QFilter filterProducttype = new QFilter("producttype", "!=", (Object)"2");
        QFilter filterServicefeePaytype = new QFilter("servicefeepaytype", "!=", (Object)"2");
        filtersMap.put("planeOrderBillsFilters", new QFilter[]{filters, filterProducttype});
        filtersMap.put("trainOrderBillsFilters", new QFilter[]{filters, filterProducttype});
        QFilter andFilter = filterProducttype.copy().and(filterServicefeePaytype);
        filtersMap.put("vehicleOrderBillsFilters", new QFilter[]{filters, andFilter, new QFilter("vehicletype", "=", (Object)"1")});
        filtersMap.put("hotelOrderBillsFilters", new QFilter[]{filters, andFilter});
        return this.getAllOvertimeOrderBill(true, filtersMap);
    }

    public List<DynamicObject> getOrderToAutoSubmit() {
        HashMap<String, Object> filtersMap = new HashMap<String, Object>();
        QFilter filters = new QFilter("isreimburse", "!=", (Object)true);
        QFilter[] qFilters = new QFilter[]{filters};
        filtersMap.put("planeOrderBillsFilters", qFilters);
        filtersMap.put("hotelOrderBillsFilters", qFilters);
        filtersMap.put("vehicleOrderBillsFilters", qFilters);
        filtersMap.put("trainOrderBillsFilters", qFilters);
        return this.getAllOvertimeOrderBill(false, filtersMap);
    }

    public static boolean checkNeedToDoAction(DynamicObject orderBill, DynamicObject setting, String actionType) {
        long orderTime = OvertimeUtil.stripTime(orderBill.getDate("happenddate")).getTime();
        long curTime = OvertimeUtil.stripTime(new Date()).getTime();
        int overDay = (int)((curTime - orderTime) / 86400000L);
        return overDay > setting.getInt(actionType);
    }

    public boolean match(DynamicObject orderBill, DynamicObject setting) {
        return orderBill.getString("server").equals(setting.getString("isp"));
    }

    public void autoSubmit() {
        List<DynamicObject> orders = this.getOrderToAutoSubmit();
        if (orders.size() == 0) {
            return;
        }
        this.autoSubmit(orders);
    }

    public void autoSubmit(List<DynamicObject> orders) {
        AutoSubmit autoSubmit = this.buildAutoSubmit(orders);
        autoSubmit.submit();
        logger.info(OvertimeUtil.join(autoSubmit.getLog(), "$NEWLINE$"));
    }

    public AutoSubmit buildAutoSubmit(List<DynamicObject> orders) {
        AutoSubmit autoSubmit = new AutoSubmit();
        List<AutoSubmitEntry> autoSubmitEntries = orders.stream().map(this::convertToSubmit).collect(Collectors.toList());
        autoSubmitEntries.forEach(autoSubmit::addEntry);
        Set reqNoSet = orders.stream().map(v -> v.getString("oabillnum")).collect(Collectors.toSet());
        String sqlfmt = "select t1.FBILLNO reqBillNo, t1.fid reqBillPk, t2.fBillNo reimBillNo, t2.fid reimBillPk" + OvertimeUtil.CR + "from t_er_reqbill t1" + OvertimeUtil.CR + "left outer join t_er_reimbursebill t2 on t1.fid = t2.FSOURCEBILLID" + OvertimeUtil.CR + "where t1.fBillno in ('%s')";
        String sql = String.format(sqlfmt, OvertimeUtil.join(reqNoSet, "','"));
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)"er"), (String)sql);){
            for (Row row : ds) {
                String reqBillNo = row.getString("reqBillNo");
                long reqBillPk = row.getLong("reqBillPk");
                String reimBillNo = row.getString("reimBillNo");
                long reimBillPk = row.getLong("reimBillPk");
                Optional<AutoSubmitEntry> optional = autoSubmitEntries.stream().filter(v -> v.getReqBillNo().equals(reqBillNo)).findFirst();
                if (!optional.isPresent()) continue;
                AutoSubmitEntry autoSubmitEntry = optional.get();
                if (reqBillPk == 0L) {
                    autoSubmitEntry.setStatus(1);
                    autoSubmitEntry.getErrMsgs().add(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"TripOrderBillOvertimeHelper_4", (String)"fi-er-business", (Object[])new Object[0]));
                } else {
                    autoSubmitEntry.setReqBillPk(reqBillPk);
                }
                if (reimBillPk <= 0L) continue;
                autoSubmitEntry.setReimBillNo(reimBillNo);
                autoSubmitEntry.setReimBillPk(reimBillPk);
            }
        }
        return autoSubmit;
    }

    private AutoSubmitEntry convertToSubmit(DynamicObject orderBill) {
        AutoSubmitEntry entry = new AutoSubmitEntry();
        entry.setOrdernum(orderBill.getString("ordernum"));
        entry.setReqBillNo(orderBill.getString("oabillnum"));
        if (entry.getReqBillNo() == null || entry.getReqBillNo().trim().equals("")) {
            entry.setReqBillNo(ResManager.loadKDString((String)"\u65e0", (String)"TripOrderBillOvertimeHelper_5", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return entry;
    }
}

